/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.core;

import cn.hangar.agp.platform.core.data.MobileDictionary;
import cn.hangar.agp.platform.core.rest.WebHelper;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.model.datasource.SelectResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class BaseJsonInterfaceService {
    private static final String[] emptyArray = new String[0];

    public static void addDefaultFieldHandler(List list, String dstFieldName, String jsonFieldName, Object isKey) {
        NormalKeyAbstractHandler handler = new NormalKeyAbstractHandler(jsonFieldName, dstFieldName, emptyArray, isKey);
        list.add(handler);
    }

    public static void addDefaultFieldHandler(List list, String dstFieldName, String jsonFieldName, String[] paths, Object isKey) {
        if (paths == null) {
            paths = emptyArray;
        }
        NormalKeyAbstractHandler handler = new NormalKeyAbstractHandler(jsonFieldName, dstFieldName, paths, isKey);
        list.add(handler);
    }

    public static void addConstantFieldHandler(List list, String dstFieldName, Object dv) {
        ConstantAbstractHandler handler = new ConstantAbstractHandler(dstFieldName, emptyArray, dv);
        list.add(handler);
    }

    public static void addConstantFieldHandler(List list, String dstFieldName, Object dv, String[] paths) {
        if (paths == null) {
            paths = emptyArray;
        }
        ConstantAbstractHandler handler = new ConstantAbstractHandler(dstFieldName, paths, dv);
        list.add(handler);
    }

    public static void addParentFieldHandler(List list, String dstFieldName, String parentField) {
        ParentAbstractHandler handler = new ParentAbstractHandler(dstFieldName, parentField, emptyArray);
        list.add(handler);
    }

    public static void addParentFieldHandler(List list, String dstFieldName, String parentField, String[] paths) {
        if (paths == null) {
            paths = emptyArray;
        }
        ParentAbstractHandler handler = new ParentAbstractHandler(dstFieldName, parentField, paths);
        list.add(handler);
    }

    public static void abstractJsonData(JSONObject o, JSONObject parent, List<AbstractJsonFieldHandler> fieldHandlers, SelectResult result) {
        if (o == null) {
            return;
        }
        MobileDictionary dict = new MobileDictionary();
        result.getResult().add(dict);
        for (AbstractJsonFieldHandler handler : fieldHandlers) {
            handler.handleValue((Map)dict, o, parent, fieldHandlers, result);
        }
    }

    public static void abstractJsonData(JSONArray o, JSONObject parent, List<AbstractJsonFieldHandler> fieldHandlers, SelectResult result) {
        if (o == null) {
            return;
        }
        for (Object json : o) {
            BaseJsonInterfaceService.abstractJsonData((JSONObject)json, parent, fieldHandlers, result);
        }
    }

    public static Object getPathObjectValueByKey(JSONArray array, String key, String ... paths) {
        Iterator iterator;
        if (array != null && (iterator = array.iterator()).hasNext()) {
            Object o = iterator.next();
            return BaseJsonInterfaceService.getPathObjectValueByKey((JSONObject)o, key, paths);
        }
        return null;
    }

    public static Object getPathObjectValueByKey(JSONObject o, String key, String ... paths) {
        if (paths == null || paths.length == 0) {
            return o.get((Object)key);
        }
        for (String p : paths) {
            Object tmp = o.get((Object)p);
            if (!(tmp instanceof JSONObject)) {
                return null;
            }
            o = (JSONObject)tmp;
        }
        return o.get((Object)key);
    }

    public static Object getPathObjectValueNoKey(JSONArray array, String ... paths) {
        Iterator iterator;
        if (array != null && (iterator = array.iterator()).hasNext()) {
            Object o = iterator.next();
            return BaseJsonInterfaceService.getPathObjectValueNoKey((JSONObject)o, paths);
        }
        return null;
    }

    public static Object getPathObjectValueNoKey(JSONObject o, String ... paths) {
        if (paths == null || paths.length == 0) {
            return null;
        }
        String key = paths[paths.length - 1];
        if (paths.length == 1) {
            return o.get((Object)key);
        }
        int len = paths.length - 1;
        for (int i = 0; i < len; ++i) {
            String p = paths[i];
            Object tmp = o.get((Object)p);
            if (!(tmp instanceof JSONObject)) {
                return null;
            }
            o = (JSONObject)tmp;
        }
        return o.get((Object)key);
    }

    protected Object doGet(String urlStr, Object input, Map header) throws Exception {
        StringBuilder sb = new StringBuilder(urlStr);
        if (input instanceof Map) {
            Map map = (Map)input;
            if (urlStr.contains("?")) {
                sb.append("&");
            } else {
                sb.append("?");
            }
            boolean first = true;
            for (Object key : map.keySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append("&");
                }
                Object value = map.get(key);
                sb.append(key).append("=").append((Object)(value == null ? "" : value));
            }
        }
        URL url = new URL(sb.toString());
        HttpURLConnection connection = this.createConnection(url, "GET");
        return this.doQuery(connection, input, header);
    }

    protected Object doPost(String urlStr, Object input, Map header) throws Exception {
        URL url = new URL(urlStr);
        HttpURLConnection connection = this.createConnection(url, "POST");
        connection.setRequestProperty("Content-Type", "application/json");
        return this.doQuery(connection, input, header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doQuery(HttpURLConnection connection, Object input, Map header) throws Exception {
        String setCookie;
        if (header != null) {
            Iterator iterator = header.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry ent = o = iterator.next();
                connection.setRequestProperty(ent.getKey().toString(), ent.getValue() == null ? "" : ent.getValue().toString());
            }
        }
        connection.setRequestProperty("Accept", "application/json, text/plain, */*");
        HttpServletRequest request = WebHelper.getCurrentRequest();
        if (request != null && StringUtils.isNotBlank((String)(setCookie = request.getHeader("Cookie")))) {
            connection.setRequestProperty("Cookie", setCookie);
        }
        try {
            JSONObject jSONObject;
            block25: {
                String result;
                InputStream inputStream;
                block23: {
                    JSONArray jSONArray;
                    block24: {
                        if (!"GET".equalsIgnoreCase(connection.getRequestMethod())) {
                            try (OutputStreamWriter outputStream = null;){
                                outputStream = new OutputStreamWriter(connection.getOutputStream());
                                outputStream.write(JSON.toJSONString((Object)input));
                                outputStream.flush();
                            }
                        }
                        StringBuilder output = new StringBuilder();
                        inputStream = connection.getInputStream();
                        try {
                            String line;
                            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                            while ((line = in.readLine()) != null) {
                                output.append(line);
                            }
                            result = output.toString();
                            if (!StringUtils.isNotBlank((String)result) || !result.startsWith("[") || !result.endsWith("]")) break block23;
                            jSONArray = JSON.parseArray((String)result);
                            if (inputStream == null) break block24;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                throw throwable;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                Object var6_7 = null;
                                return var6_7;
                            }
                        }
                        inputStream.close();
                    }
                    return jSONArray;
                }
                jSONObject = JSON.parseObject((String)result);
                if (inputStream == null) break block25;
                inputStream.close();
            }
            return jSONObject;
        }
        finally {
            connection.disconnect();
        }
    }

    protected HttpURLConnection createConnection(URL url, String method) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setReadTimeout(30000);
        connection.setConnectTimeout(10000);
        connection.setRequestProperty("Accept", "application/json, text/plain, */*");
        connection.setRequestProperty("token", "token_pc_admin_563814349110513664");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        return connection;
    }

    public static class ParentAbstractHandler
    implements AbstractJsonFieldHandler {
        private String fieldName;
        private String parentField;
        private String[] path;

        public ParentAbstractHandler(String fieldName, String parentField, String[] path) {
            this.fieldName = fieldName;
            this.parentField = parentField;
            this.path = path;
        }

        @Override
        public void handleValue(Map resultObject, JSONObject srcObject, JSONObject parentObject, List<AbstractJsonFieldHandler> fieldHandlers, SelectResult result) {
            if (this.path != null && this.path.length > 0) {
                for (String p : this.path) {
                    Object tmp = srcObject.get((Object)p);
                    if (!(tmp instanceof Map)) {
                        return;
                    }
                    srcObject = (JSONObject)tmp;
                }
            }
            if (srcObject != null && StringUtils.isNotBlank((String)this.fieldName) && StringUtils.isNotBlank((String)this.parentField) && parentObject != null) {
                resultObject.put(this.fieldName, parentObject.get((Object)this.parentField));
            }
        }

        @Override
        public void clearJsonValue(Map map) {
            map.remove(this.fieldName);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getParentField() {
            return this.parentField;
        }

        public String[] getPath() {
            return this.path;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setParentField(String parentField) {
            this.parentField = parentField;
        }

        public void setPath(String[] path) {
            this.path = path;
        }
    }

    public static class ConstantAbstractHandler
    implements AbstractJsonFieldHandler {
        private String fieldName;
        private Object defaultValue;
        private String[] path;

        public ConstantAbstractHandler(String jsonFieldName, String[] path, Object defaultValue) {
            this.fieldName = jsonFieldName;
            this.path = path;
            this.defaultValue = defaultValue;
        }

        @Override
        public void handleValue(Map resultObject, JSONObject srcObject, JSONObject parentObject, List<AbstractJsonFieldHandler> fieldHandlers, SelectResult result) {
            if (this.path != null && this.path.length > 0) {
                for (String p : this.path) {
                    Object tmp = srcObject.get((Object)p);
                    if (!(tmp instanceof Map)) {
                        return;
                    }
                    srcObject = (JSONObject)tmp;
                }
            }
            if (srcObject != null && !StringUtils.isBlank((String)this.fieldName)) {
                resultObject.put(this.fieldName, this.defaultValue);
            }
        }

        @Override
        public void clearJsonValue(Map map) {
            map.remove(this.fieldName);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String[] getPath() {
            return this.path;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setPath(String[] path) {
            this.path = path;
        }
    }

    public static class NormalKeyAbstractHandler
    implements AbstractJsonFieldHandler {
        private String fieldName;
        private String dstFieldName;
        private Object defaultValue;
        private String[] path;

        public NormalKeyAbstractHandler(String jsonFieldName, String dstFieldName, String[] path, Object defaultValue) {
            this.fieldName = jsonFieldName;
            this.dstFieldName = dstFieldName;
            this.defaultValue = defaultValue;
            this.path = path;
        }

        @Override
        public void handleValue(Map resultObject, JSONObject srcObject, JSONObject parentObject, List<AbstractJsonFieldHandler> fieldHandlers, SelectResult result) {
            Object val;
            if (this.path != null && this.path.length > 0) {
                for (String p : this.path) {
                    Object tmp = srcObject.get((Object)p);
                    if (!(tmp instanceof Map)) {
                        return;
                    }
                    srcObject = (JSONObject)tmp;
                }
            }
            if ((val = srcObject.get((Object)this.fieldName)) == null) {
                if (!StringUtils.isBlank((String)this.dstFieldName)) {
                    resultObject.put(this.dstFieldName, this.defaultValue);
                }
                return;
            }
            if (!StringUtils.isBlank((String)this.dstFieldName)) {
                if (this.defaultValue instanceof Boolean && ((Boolean)this.defaultValue).booleanValue()) {
                    resultObject.putAll(srcObject);
                }
                resultObject.put(this.dstFieldName, val);
                return;
            }
            if (val instanceof JSONObject) {
                BaseJsonInterfaceService.abstractJsonData((JSONObject)val, srcObject, fieldHandlers, result);
            } else if (val instanceof JSONArray) {
                BaseJsonInterfaceService.abstractJsonData((JSONArray)val, srcObject, fieldHandlers, result);
            }
        }

        @Override
        public void clearJsonValue(Map map) {
            if (this.fieldName.equalsIgnoreCase(this.dstFieldName)) {
                return;
            }
            map.remove(this.fieldName);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public String getDstFieldName() {
            return this.dstFieldName;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String[] getPath() {
            return this.path;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setDstFieldName(String dstFieldName) {
            this.dstFieldName = dstFieldName;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setPath(String[] path) {
            this.path = path;
        }
    }

    public static interface AbstractJsonFieldHandler {
        public void handleValue(Map var1, JSONObject var2, JSONObject var3, List<AbstractJsonFieldHandler> var4, SelectResult var5);

        public void clearJsonValue(Map var1);
    }
}

