/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.service.api;

import cn.hangar.agp.platform.core.app.Result;
import cn.hangar.agp.platform.core.config.ConfigManager;
import cn.hangar.agp.platform.core.ioc.ContextManager;
import cn.hangar.agp.platform.core.log.Logger;
import cn.hangar.agp.platform.core.log.LoggerFactory;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.api.IApiInvoker;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RestAspect {
    static final Logger log = LoggerFactory.getLogger(RestAspect.class);
    ThreadLocal<Long> beginTime = new ThreadLocal();

    @Pointcut(value="@within(cn.hangar.agp.service.api.RestApi)||@annotation(cn.hangar.agp.service.api.RestApi)")
    public void restService() {
    }

    @Around(value="restService()")
    public Object exec(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
            Method method = methodSignature.getMethod();
            Class<?> provide = method.getDeclaringClass().getInterfaces()[0];
            String apiInvokerName = ConfigManager.getProperty((String)"service.serviceApiInvoker");
            apiInvokerName = StringUtils.isEmpty((String)apiInvokerName) ? "restApiInvoker" : apiInvokerName;
            IApiInvoker apiInvoker = (IApiInvoker)ContextManager.find((String)apiInvokerName, IApiInvoker.class);
            if (joinPoint.getArgs().length <= 1) {
                return apiInvoker.invoke(provide.getSimpleName(), method.getName(), joinPoint.getArgs());
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (int i = 0; i < method.getParameters().length; ++i) {
                map.put(method.getParameters()[i].getName(), joinPoint.getArgs()[i]);
            }
            Object obj = apiInvoker.invoke(provide.getSimpleName(), method.getName(), map);
            if (!Result.class.isAssignableFrom(method.getReturnType()) && obj instanceof Result) {
                return ((Result)obj).getData();
            }
            return obj;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return joinPoint.proceed();
        }
    }

    @Before(value="restService()")
    public void doBefore(JoinPoint joinPoint) {
        this.beginTime.set(System.currentTimeMillis());
    }

    @After(value="restService()")
    public void doAfter(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        log.info("{} statistic time:{}, note:{}", (Object)method.getName(), (Object)(System.currentTimeMillis() - this.beginTime.get()));
    }
}

