/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.repository.core;

import cn.hangar.agp.platform.core.ioc.SpringUtil;
import cn.hangar.agp.service.model.datasource.DataSourceItemLoadArg;
import cn.hangar.agp.service.model.ruleengine.GetRuleValueArgument;
import cn.hangar.agp.service.model.ruleengine.GetRuleValueService;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;

public class LogicGetRuleValue {
    public static void calculateRulePackData(List resultItem, String resultFieldName, String packFieldName, String ruleIdFieldName, String judgeFieldName, DataSourceItemLoadArg arg) {
        if (resultItem != null && resultItem.size() > 0) {
            if (LogicGetRuleValue.isMapParams(resultItem)) {
                LogicGetRuleValue.handleMap(resultItem, resultFieldName, packFieldName, ruleIdFieldName, judgeFieldName, arg);
            } else {
                LogicGetRuleValue.handleObject(resultItem, resultFieldName, packFieldName, ruleIdFieldName, judgeFieldName, arg);
            }
        }
    }

    private static void handleMap(List resultItem, String resultFieldName, String packFieldName, String ruleIdFieldName, String judgeFieldName, DataSourceItemLoadArg arg) {
        GetRuleValueArgument argument = new GetRuleValueArgument();
        for (Object obj : resultItem) {
            Map m = (Map)obj;
            Object tmp = m.get(packFieldName);
            argument.setRulepackid(tmp != null ? tmp.toString() : "");
            tmp = m.get(ruleIdFieldName);
            argument.setRuleid(tmp != null ? tmp.toString() : "");
            tmp = m.get(judgeFieldName);
            argument.setJudgeobjid(tmp != null ? tmp.toString() : "");
            Object value = ((GetRuleValueService)SpringUtil.getBean(GetRuleValueService.class)).analysisGetRuleValue(argument);
            m.put(resultFieldName, value);
        }
    }

    private static void handleObject(List resultItem, String resultFieldName, String packFieldName, String ruleIdFieldName, String judgeFieldName, DataSourceItemLoadArg arg) {
        GetRuleValueArgument argument = new GetRuleValueArgument();
        Method packIdMethod = null;
        Method ruleIdMethod = null;
        Method judgeIdMethod = null;
        Method resultMethod = null;
        boolean isInit = false;
        for (Object obj : resultItem) {
            if (!isInit) {
                Method[] methods;
                for (Method m : methods = obj.getClass().getMethods()) {
                    if (LogicGetRuleValue.isEqMethod(m, packFieldName, false)) {
                        packIdMethod = m;
                        continue;
                    }
                    if (LogicGetRuleValue.isEqMethod(m, ruleIdFieldName, false)) {
                        ruleIdMethod = m;
                        continue;
                    }
                    if (LogicGetRuleValue.isEqMethod(m, judgeFieldName, false)) {
                        judgeIdMethod = m;
                        continue;
                    }
                    if (!LogicGetRuleValue.isEqMethod(m, resultFieldName, true) || Modifier.isPublic((resultMethod = m).getDeclaringClass().getModifiers())) continue;
                    resultMethod.setAccessible(true);
                }
                isInit = true;
            }
            if (resultMethod == null) {
                return;
            }
            argument.setRulepackid(LogicGetRuleValue.loadValueFromMethodOrParams(obj, packIdMethod, arg, packFieldName));
            argument.setRuleid(LogicGetRuleValue.loadValueFromMethodOrParams(obj, ruleIdMethod, arg, ruleIdFieldName));
            argument.setJudgeobjid(LogicGetRuleValue.loadValueFromMethodOrParams(obj, judgeIdMethod, arg, judgeFieldName));
            Object value = ((GetRuleValueService)SpringUtil.getBean(GetRuleValueService.class)).analysisGetRuleValue(argument);
            if (value == null) continue;
            try {
                LogicGetRuleValue.setFieldValue(resultMethod, obj, value);
            }
            catch (Exception exception) {}
        }
    }

    private static boolean isEqMethod(Method m, String fieldName, boolean isSet) {
        return m.getName().toUpperCase().equals(((isSet ? "set" : "get") + fieldName).toUpperCase());
    }

    private static String loadValueFromMethodOrParams(Object obj, Method m, DataSourceItemLoadArg arg, String field) {
        Object res = null;
        if (m != null) {
            try {
                res = m.invoke(obj, new Object[0]);
            }
            catch (Exception exception) {}
        } else {
            res = arg.getExtArgument().get(field);
        }
        return res != null ? res.toString() : null;
    }

    private static void setFieldValue(Method method, Object ref, Object v) {
        Class<?>[] params = method.getParameterTypes();
        if (v != null && params.length > 0) {
            Class<Number> fisrt = params[0];
            if (fisrt.isAssignableFrom(Long.class)) {
                v = Long.valueOf(v.toString());
            } else if (fisrt.isAssignableFrom(Double.class)) {
                v = Double.valueOf(v.toString());
            } else if (fisrt.isAssignableFrom(Integer.class)) {
                v = Integer.parseInt(v.toString());
            } else if (fisrt.isAssignableFrom(Float.class)) {
                v = Float.valueOf(Float.parseFloat(v.toString()));
            }
            try {
                method.invoke(ref, v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean isMapParams(List src) {
        return src.get(0) instanceof Map;
    }
}

