/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.repository.core;

import cn.hangar.agp.platform.core.app.AppContext;
import cn.hangar.agp.platform.core.app.AppException;
import cn.hangar.agp.platform.core.app.BaseController;
import cn.hangar.agp.platform.core.data.CaseMap;
import cn.hangar.agp.platform.core.data.DataType;
import cn.hangar.agp.platform.core.data.IColumnInfo;
import cn.hangar.agp.platform.core.data.IColumnInfoOwner;
import cn.hangar.agp.platform.core.data.IParamerValueResolver;
import cn.hangar.agp.platform.core.data.IResDataDict;
import cn.hangar.agp.platform.core.data.MobileDictionary;
import cn.hangar.agp.platform.core.data.PropertyValueHelper;
import cn.hangar.agp.platform.core.ioc.ContextManager;
import cn.hangar.agp.platform.core.log.Logger;
import cn.hangar.agp.platform.core.log.LoggerFactory;
import cn.hangar.agp.platform.core.sqlbuilder.FilterType;
import cn.hangar.agp.platform.core.util.ExecutorServcieHelperEx;
import cn.hangar.agp.platform.express.ExpressHelper;
import cn.hangar.agp.platform.utils.CollectionUtil;
import cn.hangar.agp.platform.utils.Convert;
import cn.hangar.agp.platform.utils.RefObject;
import cn.hangar.agp.platform.utils.ReflectUtils;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.repository.core.IOperatorProvider;
import cn.hangar.agp.repository.core.LogicGetRuleValue;
import cn.hangar.agp.repository.core.OperatorArg;
import cn.hangar.agp.repository.core.RealDataSourceName;
import cn.hangar.agp.service.core.AgpModelService;
import cn.hangar.agp.service.core.BaseViewService;
import cn.hangar.agp.service.core.DBService;
import cn.hangar.agp.service.core.DataSourceService;
import cn.hangar.agp.service.core.IAttachProvider;
import cn.hangar.agp.service.core.util.DbHelper;
import cn.hangar.agp.service.core.util.SysUserRangeUtils;
import cn.hangar.agp.service.model.datasource.DataSourceCheckDataExistArg;
import cn.hangar.agp.service.model.datasource.DataSourceItemLoadArg;
import cn.hangar.agp.service.model.datasource.DataSourceItemSaveArg;
import cn.hangar.agp.service.model.datasource.DataSourceSaveArg;
import cn.hangar.agp.service.model.datasource.GetUserRangeArgument;
import cn.hangar.agp.service.model.datasource.PageInitArg;
import cn.hangar.agp.service.model.datasource.ResDataDict;
import cn.hangar.agp.service.model.datasource.SelectResult;
import cn.hangar.agp.service.model.datasource.StatusGroup;
import cn.hangar.agp.service.model.datasource.StatusItem;
import cn.hangar.agp.service.model.datasource.SysUserRange;
import cn.hangar.agp.service.model.doc.AttachDeleteArgument;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public abstract class BaseViewReposiotry {
    private static Logger logger = LoggerFactory.getLogger(BaseViewReposiotry.class);
    protected static final Executor executor = ExecutorServcieHelperEx.newFixedThreadPool((int)3, (String)"view");

    protected Object resolveParamerValue(String exp, Object arg) {
        return ExpressHelper.calculateExpress((String)exp, (Object[])new Object[]{arg});
    }

    private String getServerUrl(String pageUrl) {
        return pageUrl.endsWith("/") ? pageUrl.substring(0, pageUrl.length() - 1) : pageUrl;
    }

    public SelectResult execSqlCmd(DataSourceItemLoadArg arg) {
        if (StringUtils.isBlank((String)arg.getPreActInsId()) || StringUtils.isBlank((String)arg.getPreSqlId())) {
            return null;
        }
        BaseViewService viewService = this.getBaseViewService(this.getServerUrl(arg.getPreActInsId()) + "/exeSqlComd");
        if (viewService == null && (viewService = this.getBaseViewService(this.getServerUrl(arg.getPreActInsId()) + "/exeSqlComD")) == null) {
            throw new AppException("\u672a\u77e5\u9875\u9762,actinsid:" + arg.getPreActInsId());
        }
        SelectResult result = (SelectResult)viewService.getViewReposiotry().invokeDs(arg.getPreSqlId(), "query", arg);
        return result;
    }

    public List execSqlCmdResult(DataSourceItemLoadArg arg) {
        SelectResult selectResult = this.execSqlCmd(arg);
        return selectResult == null ? null : selectResult.getResult();
    }

    private BaseViewService getBaseViewService(String match) {
        Object controller = BaseController.getControllerByRex((String)match);
        if (controller == null) {
            return null;
        }
        Object service = ReflectUtils.getFieldValue((Object)controller, (String)"service");
        return (BaseViewService)service;
    }

    public Object pageinit(PageInitArg arg) {
        return null;
    }

    public Object pageInIt(PageInitArg arg) {
        return null;
    }

    public void calculateVerifyData(SelectResult resultItem, String keyField) {
        if (resultItem == null) {
            return;
        }
        for (Object obj : resultItem.getResult()) {
            Map map;
            Object id;
            String sid;
            if (!(obj instanceof Map) || (sid = (id = (map = (Map)obj).get(keyField)) == null ? null : id.toString()) == null || !sid.endsWith("_Altered")) continue;
            map.put(keyField, sid.replace("_Altered", ""));
        }
    }

    public SelectResult queryDataSourceItem(DataSourceItemLoadArg arg) {
        return (SelectResult)this.invokeDs(arg.getSourceName(), "query", arg);
    }

    public SelectResult queryDataSourceItemRPT(List<DataSourceItemLoadArg> args) {
        return (SelectResult)this.invokeDs(args.get(0).getSourceName(), "query", args);
    }

    public Object invokeDs(String dsName, String prefix, Object ... args) {
        ArrayList mths = new ArrayList();
        ReflectUtils.getMethod(this.getClass(), RealDataSourceName.class, mths);
        for (Method mth : mths) {
            RealDataSourceName actm = mth.getAnnotation(RealDataSourceName.class);
            String name = actm.value();
            if (!CollectionUtil.toArrayList((Object[])name.split(",")).contains(dsName) || !(StringUtils.isNotBlank((String)actm.prefix()) ? prefix.equals(actm.prefix()) : mth.getName().startsWith(prefix))) continue;
            try {
                return mth.invoke((Object)this, args);
            }
            catch (AppException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target != null && target instanceof AppException) {
                    throw (AppException)target;
                }
                throw new AppException((Throwable)e);
            }
            catch (Exception e) {
                throw new AppException((Throwable)e);
            }
        }
        logger.error(String.format("\u672a\u627e\u5230\u6570\u636e\u6e90%s\u76f8\u5173\u65b9\u6cd5%s", dsName, prefix));
        return null;
    }

    public boolean saveDataSourceItem(IOperatorProvider operatorProvider, DataSourceItemSaveArg arg) {
        ArrayList mths = new ArrayList();
        ReflectUtils.getMethod(this.getClass(), RealDataSourceName.class, mths);
        for (Method mth : mths) {
            RealDataSourceName actm = mth.getAnnotation(RealDataSourceName.class);
            String name = actm.value();
            if (!CollectionUtil.toArrayList((Object[])name.split(",")).contains(arg.getSourceName()) || !(StringUtils.isNotBlank((String)actm.prefix()) ? "save".equals(actm.prefix()) : mth.getName().startsWith("save"))) continue;
            try {
                return (Boolean)mth.invoke((Object)this, operatorProvider, arg);
            }
            catch (AppException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AppException((Throwable)e);
            }
        }
        return false;
    }

    public boolean checkDataExist(DataSourceCheckDataExistArg arg) {
        return false;
    }

    public StatusGroup getStatusGroup(String id) {
        return AgpModelService.instance().fetchStatusGroup(id, true);
    }

    public IResDataDict getResDataDict(String entityClazz) {
        return ResDataDict.getResDataDict((String)entityClazz);
    }

    public static StringBuilder buildSql(DataSourceItemLoadArg arg, StringBuilder fieldSql, StringBuilder tableSql, StringBuilder filterSql, StringBuilder rowNumSqlFormat, StringBuilder groupbySql, StringBuilder orderbySql) {
        boolean haseGroupBy;
        fieldSql = new StringBuilder(fieldSql == null ? "" : fieldSql.toString());
        tableSql = new StringBuilder(tableSql == null ? "" : tableSql.toString());
        filterSql = new StringBuilder(filterSql == null ? "" : filterSql.toString());
        rowNumSqlFormat = new StringBuilder(rowNumSqlFormat == null ? "" : rowNumSqlFormat.toString());
        groupbySql = new StringBuilder(groupbySql == null ? "" : groupbySql.toString());
        orderbySql = new StringBuilder(orderbySql == null ? "" : orderbySql.toString());
        if (filterSql.length() > 0) {
            filterSql.insert(0, " where ");
        }
        if (orderbySql.length() > 0) {
            orderbySql.insert(0, " order by ");
        }
        if (groupbySql.length() > 0) {
            groupbySql.insert(0, " group by ");
        }
        boolean isCountSql = fieldSql.toString().equals("count(1)");
        boolean bl = haseGroupBy = groupbySql.length() > 0;
        boolean enablePage = arg != null ? arg.getPageSize() > 0 && rowNumSqlFormat.length() > 0 : false;
        String[] tables = tableSql.toString().split(";");
        StringBuilder builder = new StringBuilder();
        if (isCountSql && haseGroupBy) {
            builder.append("SELECT ");
            builder.append((CharSequence)fieldSql);
            builder.append(" from ");
            builder.append("(select 1 count1 from ");
            builder.append(tables[0]);
            builder.append((CharSequence)filterSql);
            builder.append((CharSequence)groupbySql);
            builder.append(") ir");
            return builder;
        }
        if (haseGroupBy) {
            if (enablePage) {
                builder.append("SELECT * FROM (");
            }
            builder.append("SELECT ");
            builder.append((CharSequence)fieldSql);
            String[] rowSqls = null;
            if (enablePage) {
                Integer pageSize = arg.getPageSize() == 0 ? 50 : arg.getPageSize();
                Integer pageStart = arg.getPageIndex() * pageSize;
                Integer pageEnd = pageStart + pageSize;
                Object[] objs = new Object[]{orderbySql, tableSql, filterSql, pageStart, pageEnd, "", "", pageSize};
                String rowNumSqls = String.format(rowNumSqlFormat.toString(), objs);
                rowSqls = rowNumSqls.split(";");
                builder.append(rowSqls[0]);
            }
            builder.append(" from ");
            builder.append(tables[0]);
            if (enablePage) {
                builder.append((String)rowSqls[1]);
            }
            builder.append((CharSequence)filterSql);
            builder.append((CharSequence)groupbySql);
            if (!enablePage) {
                builder.append((CharSequence)orderbySql);
            }
            if (enablePage) {
                builder.append(")");
                builder.append((String)rowSqls[2]);
            }
        } else if (!enablePage) {
            builder.append("SELECT ");
            builder.append((CharSequence)fieldSql);
            builder.append(" from ");
            builder.append(tables[0]);
            builder.append((CharSequence)filterSql);
            builder.append((CharSequence)groupbySql);
            builder.append((CharSequence)orderbySql);
        } else {
            Integer pageEnd;
            builder.append("SELECT ");
            builder.append((CharSequence)fieldSql);
            builder.append(" from ");
            String tablePart1 = tables.length > 1 && StringUtils.isEmpty((String)tables[1]) ? tables[1] : tables[0];
            String tablePart2 = tables.length > 2 && StringUtils.isEmpty((String)tables[2]) ? tables[2] : tables[0];
            builder.append(tablePart1);
            String[] rowSqls = rowNumSqlFormat.toString().split(";");
            if (orderbySql.length() < 1) {
                orderbySql.append("order by ").append(rowSqls.length > 1 ? rowSqls[1] : Integer.valueOf(1));
            }
            Integer pageSize = arg.getPageSize() == 0 ? new Integer(50).intValue() : arg.getPageSize();
            Integer pageStart = arg.getPageIndex() == 0 ? new Integer(0) : arg.getPageIndex() * pageSize;
            Object[] objs = new Object[]{orderbySql, tablePart2, filterSql, pageStart, pageEnd = Integer.valueOf(pageStart + pageSize), "", "", pageSize};
            String rowNumSql = String.format(rowSqls[0], objs);
            if (rowNumSql.contains("PAM_ROWNUMBER")) {
                builder.append(", ");
            }
            builder.append(rowNumSql);
        }
        return builder;
    }

    public boolean saveDataSourceForEntity(IOperatorProvider operatorProvider, String entityClazz, DataSourceItemSaveArg arg) {
        return BaseViewReposiotry.doSaveDataSourceForEntity(operatorProvider, entityClazz, arg);
    }

    public static boolean doSaveDataSourceForEntity(IOperatorProvider operatorProvider, String entityClazz, DataSourceItemSaveArg arg) {
        Object map;
        int i;
        DataSourceService dataSourceService = (DataSourceService)ContextManager.find(DataSourceService.class);
        SysUserRange userRange = BaseViewReposiotry.getCurrentUserRange(arg.getResId() != null ? arg.getResId() : entityClazz, arg.getDataSourceId());
        if (arg.getAddItems() != null && arg.getAddItems().size() > 0 && userRange != null) {
            SysUserRangeUtils.checkAddPower(entityClazz, userRange, arg.getAddItems());
        }
        if (arg.getUpdateItems() != null && arg.getUpdateItems().size() > 0 & userRange != null) {
            SysUserRangeUtils.checkUpdatePower(entityClazz, userRange, arg.getUpdateItems());
        }
        if (arg.getDeleteItems() != null && arg.getDeleteItems().size() > 0 && userRange != null) {
            SysUserRangeUtils.checkDeletePower(entityClazz, userRange, arg.getDeleteItems());
        }
        boolean needValidate = arg.isValidate();
        List delItems = arg.getDeleteItems();
        ArrayList canDeleteItems = new ArrayList();
        if (delItems != null) {
            for (i = 0; i < delItems.size(); ++i) {
                map = delItems.get(i);
                canDeleteItems.add(map);
            }
            for (i = 0; i < canDeleteItems.size(); ++i) {
                map = canDeleteItems.get(i);
                dataSourceService.deleteEntity(operatorProvider, entityClazz, map);
            }
            if (StringUtils.isNotBlank((String)arg.getRelateDocIds())) {
                IAttachProvider provider = IAttachProvider.getInstance();
                AttachDeleteArgument attachDeleteArgument = new AttachDeleteArgument();
                attachDeleteArgument.setPointid(arg.getRelateDocIds());
                try {
                    provider.deleteAttach(attachDeleteArgument);
                }
                catch (Exception e) {
                    logger.warn("\u5173\u8054\u9644\u4ef6\u5220\u9664\u5931\u8d25", (Throwable)e);
                }
            }
        }
        if (arg.getAddItems() != null) {
            for (i = 0; i < arg.getAddItems().size(); ++i) {
                map = arg.getAddItems().get(i);
                dataSourceService.updateEntity(operatorProvider, entityClazz, map, null, needValidate);
            }
        }
        if (arg.getUpdateItems() != null) {
            for (i = 0; i < arg.getUpdateItems().size(); ++i) {
                map = arg.getUpdateItems().get(i);
                dataSourceService.updateEntity(operatorProvider, entityClazz, map, null, needValidate, true);
            }
        }
        return true;
    }

    public void sqlAppendField(StringBuilder fieldsb, Object field) {
        if (fieldsb.length() > 0) {
            fieldsb.append(",");
        }
        fieldsb.append(field);
    }

    public void sqlAppendFilter(StringBuilder fieldsb, Object filter) {
        if (fieldsb.length() > 0) {
            fieldsb.append(" and ");
        }
        fieldsb.append(filter);
    }

    public void sqlAppendFilter(StringBuilder fieldsb, Object field, int filterType, Object value) {
        DbHelper.toFilterSql(FilterType.valueOf((Integer)filterType), field, value);
    }

    public void sqlAppendFilter(StringBuilder fieldsb, Object field, int filterType, Object value, int valueType) {
        DbHelper.toFilterSql(FilterType.valueOf((Integer)filterType), field, value, DataType.valueOf((Integer)valueType));
    }

    void fillToMap(Object arg, MobileDictionary dictionary) {
        if (arg instanceof Map) {
            for (Map.Entry ent : ((Map)arg).entrySet()) {
                if (ent.getValue() == null) continue;
                Object old = dictionary.get((String)ent.getKey());
                if (old == null) {
                    dictionary.add((String)ent.getKey(), this.tranceValue(ent.getValue()));
                    continue;
                }
                String oldStr = old.toString();
                if (oldStr.isEmpty()) {
                    dictionary.add((String)ent.getKey(), this.tranceValue(ent.getValue()));
                    continue;
                }
                String newStr = ent.getValue().toString();
                if (newStr.isEmpty()) continue;
                newStr = oldStr + "," + newStr;
                dictionary.add((String)ent.getKey(), (Object)newStr);
            }
        }
    }

    Object tranceValue(Object obj) {
        if (obj == null) {
            return obj;
        }
        if ("weblogic.jdbc.wrapper.Clob_oracle_sql_CLOB".equals(obj.getClass().getName())) {
            try {
                Method method = obj.getClass().getMethod("getVendorObj", new Class[0]);
                Clob clob = (Clob)method.invoke(obj, new Object[0]);
                Logger.info(this.getClass(), (String)("\u8f49\u63db\u7279\u6b8a\u5c0d\u8c61:" + obj));
                return clob.getSubString(1L, (int)clob.length());
            }
            catch (Exception e) {
                Logger.warn(this.getClass(), (Exception)e);
            }
        }
        return obj;
    }

    public Map putAll(Map map, Map mapParam) {
        if (map == null) {
            map = mapParam;
        } else if (mapParam != null) {
            map.putAll(mapParam);
        }
        return map;
    }

    public MobileDictionary toSingleMap(Object arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof MobileDictionary) {
            return (MobileDictionary)arg;
        }
        MobileDictionary dictionary = new MobileDictionary();
        if (arg instanceof Iterable) {
            for (Object o : (Iterable)arg) {
                this.fillToMap(o, dictionary);
            }
        } else {
            this.fillToMap(arg, dictionary);
        }
        return dictionary;
    }

    public Map<String, Object> toMap(DataSourceItemLoadArg arg) {
        return BaseViewReposiotry.toMapFromLoadArg(arg);
    }

    public static Map<String, Object> toMapFromLoadArg(DataSourceItemLoadArg arg) {
        return new QueryArg(arg);
    }

    protected SysUserRange addUserRange(Map arg, String resId) {
        Object value = arg.get("dataSourceId");
        SysUserRange userRange = BaseViewReposiotry.getCurrentUserRange(resId, value == null ? null : value.toString());
        if (userRange != null) {
            String range = userRange.getPermitLook();
            RefObject rangeObj = new RefObject();
            if (!StringUtils.isBlank((String)range) && ExpressHelper.isExpress((String)range) && ExpressHelper.replace((String)range, (RefObject)rangeObj, (Object[])new Object[]{arg})) {
                userRange.setPermitLook((String)rangeObj.getArgValue());
            }
            if (!StringUtils.isBlank((String)(range = userRange.getLookPowerRange())) && ExpressHelper.isExpress((String)range) && ExpressHelper.replace((String)range, (RefObject)rangeObj, (Object[])new Object[]{arg})) {
                userRange.setLookPowerRange((String)rangeObj.getArgValue());
            }
            if (StringUtils.isNotEmpty((String)(range = userRange.getUpdatePowerRange())) && StringUtils.isNotEmpty((String)userRange.getPermitUpd())) {
                if (ExpressHelper.isExpress((String)range) && ExpressHelper.replace((String)range, (RefObject)rangeObj, (Object[])new Object[]{arg})) {
                    range = (String)rangeObj.getArgValue();
                }
                if (!"1".equals(range) && !"0".equals(range)) {
                    userRange.setPermitUpd(String.format("(CASE WHEN %s THEN %s ELSE 0 END) ", range, userRange.getPermitUpd()));
                } else if ("0".equals(range)) {
                    userRange.setPermitUpd("0");
                }
            } else if (StringUtils.isEmpty((String)userRange.getPermitUpd())) {
                userRange.setPermitUpd("1");
            }
            range = userRange.getDeletePowerRange();
            if (StringUtils.isNotEmpty((String)range) && StringUtils.isNotEmpty((String)userRange.getPermitDelete())) {
                if (ExpressHelper.isExpress((String)range) && ExpressHelper.replace((String)range, (RefObject)rangeObj, (Object[])new Object[]{arg})) {
                    range = (String)rangeObj.getArgValue();
                }
                if (!"1".equals(range) && !"0".equals(range)) {
                    userRange.setPermitDelete(String.format("(CASE WHEN %s THEN %s ELSE 0 END) ", range, userRange.getPermitDelete()));
                } else if ("0".equals(range)) {
                    userRange.setPermitDelete("0");
                }
            } else if (StringUtils.isEmpty((String)userRange.getPermitDelete())) {
                userRange.setPermitDelete("1");
            }
            range = userRange.getLayerRange();
            if (!StringUtils.isBlank((String)range) && ExpressHelper.isExpress((String)range) && ExpressHelper.replace((String)range, (RefObject)rangeObj, (Object[])new Object[]{arg})) {
                userRange.setLayerRange((String)rangeObj.getArgValue());
            }
            arg.put("_userRange", userRange);
        }
        return userRange;
    }

    private static SysUserRange getCurrentUserRange(String resId, String dataSrcId) {
        String userId = AppContext.getCurrentUser() != null ? AppContext.getCurrentUser().getId() : null;
        GetUserRangeArgument garg = new GetUserRangeArgument();
        garg.setUserId(userId);
        garg.setResId(resId);
        garg.setDataSrcId(dataSrcId);
        return DataSourceService.instance().getUserRange(garg);
    }

    public Map<String, Object> toMap(PageInitArg arg) {
        return new QueryArg(arg);
    }

    public Map<String, Object> toMap(IParamerValueResolver arg) {
        return new QueryArg(arg);
    }

    public static Map<String, Object> toMap(Object arg) {
        return new QueryArg(arg);
    }

    public Object getMapValue(Map map, String key) {
        return map.get(key);
    }

    public SelectResult wrapResult(DataSourceItemLoadArg arg, String keyField, int count, List resultItem) {
        return this.wrapResult(arg, keyField, count, resultItem, null);
    }

    public SelectResult wrapResult(DataSourceItemLoadArg arg, String keyField, int count, List resultItem, String pwdFields) {
        return this.wrapResult(arg, keyField, count, resultItem, pwdFields, null);
    }

    public SelectResult wrapResult(DataSourceItemLoadArg arg, String keyField, int count, List resultItem, String pwdFields, List sums) {
        SelectResult result = new SelectResult();
        result.setUniqueId(arg.getUniqueId());
        result.setCanAdd(1);
        if (arg.isRetrieveTotalRowCount()) {
            result.setTotalCount(count);
        }
        resultItem = this.tranceofResult(resultItem, pwdFields);
        result.setSum(sums != null && sums.size() > 0 ? sums.get(0) : null);
        result.setResult(resultItem);
        result.setKeyFieldName(keyField);
        result.setSourceName(arg.getSourceName());
        return result;
    }

    public boolean wrapValidateResult(DataSourceItemLoadArg arg, List resultItem, RefObject<SelectResult> refObject) {
        refObject.setArgValue((Object)this.wrapResult(arg, "", 1, resultItem));
        if (resultItem == null || resultItem.size() < 1) {
            return true;
        }
        Object item = resultItem.get(0);
        if (item instanceof Map) {
            Map map = (Map)item;
            Object code = null;
            if (map.containsKey("RetCode")) {
                code = map.get("RetCode");
            } else {
                Object[] rets = map.values().toArray();
                if (rets.length > 0) {
                    code = rets[0];
                }
            }
            return BaseViewReposiotry.isValidateOk(code);
        }
        return BaseViewReposiotry.isValidateOk(item);
    }

    protected List tranceofResult(List resultItem, String pwdFields) {
        if (resultItem != null) {
            for (Object obj : resultItem) {
                ArrayList tempKeys = new ArrayList();
                if (!(obj instanceof Map)) continue;
                Map m = (Map)obj;
                if (m.containsKey("ROWID") && m.get("ROWID") != null && m.get("ROWID").getClass().getName().equals("oracle.sql.ROWID")) {
                    m.remove("ROWID");
                }
                tempKeys.forEach(k -> m.put(k, this.tranceValue(m.get(k))));
                this.tranceofResult(m);
            }
        }
        if (!StringUtils.isEmpty((String)pwdFields)) {
            String[] pwdFs = pwdFields.split(",");
            resultItem = DBService.instance().handleResultData(resultItem, pwdFs);
        }
        return resultItem;
    }

    private void tranceofResult(Map map) {
        for (Object key : new HashSet(map.keySet())) {
            Object v = map.get(key);
            if (!(v instanceof Map)) continue;
            this.tranceofResult((Map)v);
            for (Object k : ((Map)v).keySet()) {
                map.put(key + "." + k, ((Map)v).get(k));
            }
            map.remove(key);
        }
    }

    public SelectResult wrapGroupResult(DataSourceItemLoadArg arg, IColumnInfoOwner ds, StatusGroup group) {
        ArrayList list = new ArrayList();
        List statuss = group.getItems();
        for (int i = 0; i < statuss.size(); ++i) {
            StatusItem gpItem = (StatusItem)statuss.get(i);
            HashMap<String, String> map = new HashMap<String, String>();
            int j = 0;
            while (i < ds.getColumns().size()) {
                IColumnInfo column = (IColumnInfo)ds.getColumns().get(j);
                String name = column.getColumnName();
                if ("STATUSID".equalsIgnoreCase(name)) {
                    map.put("STATUSID", gpItem.getStatusvalue());
                } else if ("STATUSNAME".equalsIgnoreCase(name)) {
                    map.put("STATUSNAME", gpItem.getStatusname());
                } else {
                    String exp = column.getColumnExpress();
                    if (StringUtils.isBlank((String)exp)) {
                        exp = (String)column.getDefaultValue();
                    }
                    if (StringUtils.isBlank((String)exp)) {
                        exp = column.getSumExpress();
                    }
                    map.put(name, exp);
                }
                ++j;
            }
            list.add(map);
        }
        return this.wrapResult(arg, "statgroup", list.size(), list);
    }

    public boolean handleValidateMsg(List resultItem, RefObject result) {
        result.setArgValue(null);
        if (resultItem == null || resultItem.size() < 1) {
            return true;
        }
        for (Object item : resultItem) {
            result.setArgValue(item);
            if (item instanceof Map) {
                Map map = (Map)item;
                Object code = null;
                Object[] rets = map.values().toArray();
                if (rets.length > 0) {
                    code = rets[0];
                }
                if (BaseViewReposiotry.isValidateOk(code)) continue;
                return false;
            }
            if (BaseViewReposiotry.isValidateOk(item)) continue;
            return false;
        }
        return true;
    }

    public Object handleMsg(List list, Object msgError) {
        Integer result = null;
        if (list != null) {
            Object msg = msgError;
            for (Object ress : list) {
                Object[] resss;
                if (ress instanceof String) {
                    msg = ress;
                    result = BaseViewReposiotry.isValidateOk(msg) ? Integer.valueOf(1) : Integer.valueOf(0);
                } else if (ress instanceof Map) {
                    resss = ((Map)ress).values().toArray();
                    if (resss.length > 1) {
                        result = BaseViewReposiotry.isValidateOk(resss[0]) ? 1 : 0;
                        msg = resss[1];
                    } else if (resss.length > 0) {
                        if (resss[0] == null) {
                            result = 1;
                        } else if (BaseViewReposiotry.isValidateOk(resss[0])) {
                            result = 1;
                        } else {
                            msg = resss[0];
                        }
                    }
                } else {
                    resss = (Object[])ress;
                    result = BaseViewReposiotry.isValidateOk(resss[0]) ? 1 : 0;
                    msg = resss[1];
                }
                if (result == null) {
                    throw new AppException(msg.toString());
                }
                if (result > 0) continue;
                throw new AppException(msg.toString());
            }
        }
        return result;
    }

    public Object handleApiMsg(Object result) {
        if (result != null) {
            Object retCode = PropertyValueHelper.getValue((Object)result, (String)"RetCode");
            Object retMsg = PropertyValueHelper.getValue((Object)result, (String)"RetMsg");
            if (retCode != null && !StringUtils.equalsIgnoreCase((String)"ok", (String)retCode.toString()) && !Convert.toBoolean((Object)retCode)) {
                throw new RuntimeException(retMsg.toString());
            }
        }
        return result;
    }

    public Object handleExpressMsg(Object value) {
        String message = null;
        if (value != null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            message = value.toString();
            if ("ok".equalsIgnoreCase(message) || Convert.toBoolean((Object)message)) {
                result.put("RetCode", value);
                return result;
            }
        }
        throw new RuntimeException(message);
    }

    public Map transOpeArgToMap(OperatorArg arg) {
        CaseMap result = new CaseMap();
        Object obj = arg.getArgument();
        if (obj != null && obj instanceof DataSourceSaveArg) {
            DataSourceSaveArg arg1 = (DataSourceSaveArg)obj;
            if (arg1.getExtArg() != null) {
                result.putAll(arg1.getExtArg());
            }
            if (arg1.getItems() != null && arg1.getItems().size() == 1) {
                List upds = ((DataSourceItemSaveArg)arg1.getItems().get(0)).getUpdateItems();
                if (upds != null && !upds.isEmpty()) {
                    result.putAll((Map)upds.get(0));
                } else {
                    List adds = ((DataSourceItemSaveArg)arg1.getItems().get(0)).getAddItems();
                    if (adds != null && !adds.isEmpty()) {
                        result.putAll((Map)adds.get(0));
                    }
                }
            }
        }
        if ((obj = arg.getEntity()) != null && obj instanceof Map) {
            result.putAll((Map)obj);
        }
        return result;
    }

    public void calculateRulePackData(List resultItem, String resultFieldName, String packFieldName, String ruleIdFieldName, String judgeFieldName, DataSourceItemLoadArg arg) {
        if (resultItem != null && resultItem.size() > 0) {
            LogicGetRuleValue.calculateRulePackData(resultItem, resultFieldName, packFieldName, ruleIdFieldName, judgeFieldName, arg);
        }
    }

    private static boolean isValidateOk(Object ret) {
        return ret != null && ("ok".equalsIgnoreCase(ret.toString()) || Convert.toBoolean((Object)ret));
    }

    protected void executeAsync(Object repository, String funName, Object ... args) {
        executor.execute(() -> {
            try {
                ReflectUtils.invoke((Object)repository, (String)funName, (Object[])args);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        });
    }

    protected List<Map<String, Object>> setPreValues(List<Map<String, Object>> result, List<Map<String, Object>> preValues) {
        if (result != null && preValues != null && preValues.size() > 0) {
            for (int i = 0; i < result.size(); ++i) {
                Map<String, Object> resultMap = result.get(i);
                Map<String, Object> preValue = preValues.size() > i ? preValues.get(i) : preValues.get(0);
                resultMap.putAll(preValue);
            }
        }
        return result;
    }

    private static class QueryArg
    extends CaseMap<String, Object> {
        private static final long serialVersionUID = 1L;
        private static final String _P = "_p_";
        Object arg;
        RefObject<Object> refObject = new RefObject();

        public QueryArg(Object arg) {
            this.arg = arg;
        }

        public QueryArg(DataSourceItemLoadArg arg) {
            this.arg = arg;
            this.put("uniqueId", arg.getUniqueId());
            this.put("dataSourceId", arg.getDataSourceId());
            this.put("sourceName", arg.getSourceName());
            this.put("retrieveTotalRowCount", arg.isRetrieveTotalRowCount());
            this.put("pageIndex", arg.getPageIndex());
            this.put("pageSize", arg.getPageSize());
            this.put("firstLoad", arg.isFirstLoad());
            this.put("extArgument", arg.getExtArgument());
            this.put("queryData", arg.getQueryData());
            this.put("queryBox", arg.getQueryBox());
            this.put("extFilter", arg.getExtFilter());
            this.put("filters", arg.getFilters());
            this.put("isSortAppend", arg.isSortAppend());
            this.put("isGroupAppend", arg.isGroupAppend());
            this.put("isFilterAppend", arg.isFilterAppend());
            this.put("filterIds", arg.getFilterIds());
            this.put("groupFields", arg.getGroupFields());
            this.put("selectFields", arg.getSelectFields());
            this.put("extArg", arg.getExtArg());
            this.put("noPage", arg.isNoPage());
            this.put("noPower", arg.isNoPower());
            this.put("sortExpression", this.buildSortExpression(arg));
            this.put("dynamicFields", arg.getDynamicFields() == null || arg.getDynamicFields().isEmpty() ? null : arg.getDynamicFields());
            this.put("logicResult", arg.getLogicResult());
            if (arg.getExtArgument() != null) {
                Map map = null;
                for (Map.Entry en : arg.getExtArgument().entrySet()) {
                    int id = ((String)en.getKey()).indexOf(".");
                    if (id <= 0) continue;
                    String key = ((String)en.getKey()).substring(0, id);
                    key = _P + key;
                    String subkey = ((String)en.getKey()).substring(id + 1);
                    Object obj = this.get(key);
                    if (obj instanceof Map) {
                        map = (Map)obj;
                    } else {
                        map = new CaseMap();
                        this.put(key, map);
                    }
                    map.put(subkey, en.getValue());
                }
            }
        }

        public Object get(Object key) {
            if (key.equals("arg")) {
                return this.arg;
            }
            this.refObject.setArgValue(null);
            if (this.arg instanceof IParamerValueResolver && ((IParamerValueResolver)this.arg).resolveParamerValue(key.toString(), null, this.refObject)) {
                return this.refObject.argValue;
            }
            Object obj = super.get(key);
            if (obj == null) {
                obj = super.get((Object)(_P + key));
            }
            return obj;
        }

        public boolean containsKey(Object key) {
            if (key.equals("arg")) {
                return true;
            }
            this.refObject.setArgValue(null);
            if (this.arg instanceof IParamerValueResolver && ((IParamerValueResolver)this.arg).resolveParamerValue(key.toString(), null, this.refObject)) {
                return true;
            }
            return super.containsKey(key);
        }

        private List<DataSourceItemLoadArg.SortField> buildSortExpression(DataSourceItemLoadArg arg) {
            ArrayList<DataSourceItemLoadArg.SortField> sortFields = new ArrayList<DataSourceItemLoadArg.SortField>();
            if (arg.getSortExpression() != null) {
                arg.getSortExpression().forEach(field -> {
                    if ("PAM_ROWNUMBER".equalsIgnoreCase(field.getField())) {
                        return;
                    }
                    sortFields.add((DataSourceItemLoadArg.SortField)field);
                });
            }
            return sortFields.isEmpty() ? null : sortFields;
        }
    }
}

