/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.repository.core;

import cn.hangar.agp.platform.core.app.AppException;
import cn.hangar.agp.platform.core.data.BeanHelper;
import cn.hangar.agp.platform.core.db.IDB;
import cn.hangar.agp.platform.utils.Convert;
import cn.hangar.agp.repository.core.AgpReposiotry;
import cn.hangar.agp.service.core.DBService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;

public abstract class AbstractEntityRepository
implements AgpReposiotry {
    protected IDB getDb() {
        return DBService.createDB(null);
    }

    @Override
    public boolean hasTable() {
        String tableName = BeanHelper.getTableName((Class)this.getEntityClass());
        return this.getDb().hasTable(tableName);
    }

    public Object save(Object entity) {
        Object id = BeanHelper.getId((Object)entity);
        this.getDb().update(entity);
        return this.findById(id);
    }

    public Iterable saveAll(Iterable entities) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : entities) {
            list.add(this.save(obj));
        }
        return list;
    }

    public Optional findById(Object o) {
        try {
            return Optional.ofNullable(this.getDb().findFirst(this.getEntityClass(), o));
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
    }

    public boolean existsById(Object o) {
        Object v = this.getDb().findFirst(this.getEntityClass(), o);
        return v != null;
    }

    public Iterable findAll() {
        String tableName = BeanHelper.getTableName((Class)this.getEntityClass());
        String sql = "select t from " + tableName + " t";
        return this.getDb().select(sql, null, this.getEntityClass());
    }

    public Iterable findAllById(Iterable iterable) {
        String tableName = BeanHelper.getTableName((Class)this.getEntityClass());
        String idName = BeanHelper.getKeyName((Class)this.getEntityClass());
        String sql = "select *from " + tableName + " t where " + idName + " in (" + this.getValueInStr(iterable) + ")";
        return this.getDb().select(sql, null, this.getEntityClass());
    }

    private String getValueInStr(Iterable iterable) {
        StringBuilder sb = new StringBuilder();
        boolean isNum = false;
        for (Object obj : iterable) {
            if (sb.length() > 0) {
                sb.append(",");
            } else {
                isNum = Convert.isBaseNum(obj);
            }
            if (!isNum && !obj.toString().startsWith("'")) {
                sb.append("'");
            }
            sb.append(obj);
            if (isNum || obj.toString().endsWith("'")) continue;
            sb.append("'");
        }
        return sb.toString();
    }

    @Override
    public long count() {
        String tableName = BeanHelper.getTableName((Class)this.getEntityClass());
        String sql = "select count(1) from " + tableName + " t";
        Object obj = this.getDb().executeScalar(sql, null);
        return Convert.toInt((Object)obj);
    }

    public void deleteById(Object o) {
        String idName = BeanHelper.getKeyName((Class)this.getEntityClass());
        String sql = "delete from " + this.getEntityClass().getSimpleName() + " p where p." + idName + " = ?1";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", idName);
        this.getDb().executeUpdate(sql, map);
    }

    public void delete(Object entity) {
        this.getDb().delete(entity);
    }

    public void deleteAll(Iterable entities) {
        for (Object obj : entities) {
            this.delete(obj);
        }
    }

    @Override
    public void deleteAll() {
        String sql = "delete from " + this.getEntityClass().getSimpleName();
        this.getDb().executeUpdate(sql, null);
    }

    @Override
    public Object doGetLastInsert() {
        int vender = this.getDb().getDbVendor();
        if (vender == 1) {
            String sql = "SELECT LAST_INSERT_ID() as id ";
            return this.getDb().executeScalar(sql, null);
        }
        if (vender == 3) {
            String sql = "SELECT SCOPE_IDENTITY() as id";
            return this.getDb().executeScalar(sql, null);
        }
        return null;
    }
}

