/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.module.doc.utils;

import cn.hangar.agp.module.doc.office.util.word.analysis.AnalyzeResult;
import cn.hangar.agp.module.doc.office.util.word.converter.HtmlConverter;
import cn.hangar.agp.module.doc.office.util.word.converter.WordConverter03;
import cn.hangar.agp.module.doc.office.util.word.converter.WordConverter07;
import cn.hangar.agp.module.doc.office.util.word.export.HtmlToWordOutput;
import cn.hangar.agp.module.doc.office.util.word.model.WordDoc;
import cn.hangar.agp.module.doc.utils.RuleAnalyze;
import cn.hangar.agp.platform.core.log.Logger;
import cn.hangar.agp.platform.core.log.LoggerFactory;
import cn.hangar.agp.platform.utils.FileUtil;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.model.doc.AttachDissectRules;
import cn.hangar.agp.service.model.doc.SysDocItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class WordUtil {
    static Logger logger = LoggerFactory.getLogger(WordUtil.class);

    private WordUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static WordDoc extractWordFile(String filePath) {
        if (StringUtils.isBlank((String)filePath)) {
            return null;
        }
        String extend = FileUtil.getExtension((String)filePath);
        if (extend != null) {
            extend = extend.toLowerCase();
        }
        HWPFDocument book03 = null;
        XWPFDocument book07 = null;
        try (FileInputStream inputStream = new FileInputStream(new File(filePath));){
            if ("doc".equals(extend)) {
                book03 = new HWPFDocument((InputStream)inputStream);
            } else if ("docx".equals(extend)) {
                book07 = new XWPFDocument((InputStream)inputStream);
            } else if ("wps".equals(extend)) {
                book03 = WordUtil.tryOpen03Document(inputStream);
                if (book03 == null) {
                    book07 = WordUtil.tryOpen07Document(inputStream);
                }
            } else {
                logger.error("invalid file format(." + extend + ") to be converted");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        WordConverter03 converter = null;
        if (book03 != null) {
            converter = new WordConverter03(book03);
        } else if (book07 != null) {
            converter = new WordConverter07(book07);
        }
        if (converter != null) {
            return converter.doConvert();
        }
        return null;
    }

    public static AnalyzeResult analyzeWordFile(String filePath, List<AttachDissectRules> rules) {
        WordDoc doc = WordUtil.extractWordFile(filePath);
        AnalyzeResult result = new AnalyzeResult();
        if (doc != null) {
            RuleAnalyze analyze = new RuleAnalyze(result);
            analyze.analyze(doc, rules);
        }
        return result;
    }

    public static void save(String filePath, List<SysDocItem> contents) {
        HtmlToWordOutput output = new HtmlToWordOutput();
        output.setContent(contents);
        output.save(filePath);
    }

    public static WordDoc extractHtml(String html) {
        HtmlConverter converter = new HtmlConverter(html);
        return converter.doConvert();
    }

    static HWPFDocument tryOpen03Document(InputStream inputStream) {
        try {
            return new HWPFDocument(inputStream);
        }
        catch (Exception e) {
            logger.error("invalid wps format.");
            return null;
        }
    }

    static XWPFDocument tryOpen07Document(InputStream inputStream) {
        try {
            return new XWPFDocument(inputStream);
        }
        catch (Exception e1) {
            logger.error("invalid wps format.");
            return null;
        }
    }
}

