/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.module.doc.utils;

import cn.hangar.agp.module.doc.office.util.word.analysis.AnalyzeResult;
import cn.hangar.agp.module.doc.office.util.word.analysis.Category;
import cn.hangar.agp.module.doc.office.util.word.analysis.ContentItem;
import cn.hangar.agp.module.doc.office.util.word.analysis.PageRefs;
import cn.hangar.agp.module.doc.office.util.word.model.Consts;
import cn.hangar.agp.module.doc.office.util.word.model.ParagraphConvertResult;
import cn.hangar.agp.module.doc.office.util.word.model.WordDoc;
import cn.hangar.agp.module.doc.office.util.word.model.WordParagraph;
import cn.hangar.agp.module.doc.office.util.word.model.WordSection;
import cn.hangar.agp.platform.utils.CollectionUtil;
import cn.hangar.agp.platform.utils.RefObject;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.model.doc.AttachDissectRules;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RuleAnalyze {
    private static final int COVERFONTSIZE = 20;
    AnalyzeResult result;
    Map<String, AttachDissectRules> rules;
    List<Pattern> currentRules;
    Map<String, Pattern> ruleKeyPatterns;
    ContentItem currentItem;
    boolean coverStart = false;
    boolean coverFinished = false;
    boolean pageRefStart = false;
    boolean pageRefFinished = false;
    Map<String, String> pageRefMarkIds;
    Map<String, ContentItem> pageRefContents;
    Map<String, ContentItem> pageRefItems;
    WordDoc doc;

    public RuleAnalyze() {
        this(new AnalyzeResult());
    }

    public RuleAnalyze(AnalyzeResult result) {
        this.result = result;
    }

    void prepareRules(List<AttachDissectRules> rules) {
        if (rules != null && !rules.isEmpty()) {
            this.rules = RuleAnalyze.convertRules(rules);
            this.ruleKeyPatterns = new HashMap<String, Pattern>();
            for (String key : this.rules.keySet()) {
                String patternContent = key;
                if (!patternContent.startsWith("^")) {
                    patternContent = "^" + patternContent;
                }
                this.ruleKeyPatterns.put(key, Pattern.compile(patternContent));
            }
        }
    }

    public AnalyzeResult analyze(WordDoc document, List<AttachDissectRules> rules) {
        this.doc = document;
        this.prepareRules(rules);
        this.processHeader(document);
        Iterator<WordParagraph> paragraphs = document.getParagraphes().iterator();
        LinkedList<WordParagraph> unhandled = new LinkedList<WordParagraph>();
        RefObject sectionId = new RefObject((Object)-1);
        while (paragraphs.hasNext()) {
            WordParagraph paragraph = (WordParagraph)paragraphs.next();
            this.handleSection(document, paragraph, (RefObject<Integer>)sectionId);
            if (paragraph.isPageBreak() && !this.result.isPageBreak()) {
                this.processPageBreak(paragraph);
                continue;
            }
            if (paragraph.isEmpty()) {
                if (this.currentItem == null) {
                    unhandled.add(paragraph);
                    continue;
                }
                this.currentItem.addParagraph(paragraph);
                continue;
            }
            if (this.handleCover(paragraphs, paragraph, unhandled, (RefObject<Integer>)sectionId) || this.handlePageRef(document, paragraphs, paragraph, unhandled, (RefObject<Integer>)sectionId)) continue;
            this.processParagraph(paragraph, unhandled);
        }
        return this.result;
    }

    void handleSection(WordDoc document, WordParagraph paragraph, RefObject<Integer> sectionId) {
        int sId = (Integer)sectionId.getArgValue();
        if (sId == -1 || sId != paragraph.getSectionId()) {
            sectionId.setArgValue((Object)paragraph.getSectionId());
            this.processSection(document, (Integer)sectionId.getArgValue());
            if (sId > -1 && !paragraph.isPageBreak() && !this.result.isPageBreak()) {
                this.processPageBreak(null);
            }
        }
    }

    boolean handleCover(Iterator<WordParagraph> paragraphs, WordParagraph paragraph, List<WordParagraph> unhandled, RefObject<Integer> sectionId) {
        if (!this.coverStart && this.isCover(paragraph)) {
            this.coverStart = true;
            WordParagraph next = this.processCover(paragraphs, paragraph, unhandled);
            this.coverFinished = true;
            this.currentItem = null;
            unhandled.clear();
            if (next == null) {
                return true;
            }
            paragraph = next;
            sectionId.setArgValue((Object)next.getSectionId());
            if (paragraph.isEmpty()) {
                unhandled.add(paragraph);
                return true;
            }
            this.processParagraph(paragraph, unhandled);
            return true;
        }
        return false;
    }

    boolean handlePageRef(WordDoc document, Iterator<WordParagraph> paragraphs, WordParagraph paragraph, List<WordParagraph> unhandled, RefObject<Integer> sectionId) {
        if (this.pageRefStart || !this.isPageRef(paragraph)) {
            return false;
        }
        this.pageRefStart = true;
        WordParagraph next = this.processPageref(paragraphs, paragraph, unhandled);
        this.pageRefFinished = true;
        this.currentItem = null;
        unhandled.clear();
        if (next == null) {
            return true;
        }
        paragraph = next;
        if (((Integer)sectionId.getArgValue()).intValue() != paragraph.getSectionId()) {
            sectionId.setArgValue((Object)paragraph.getSectionId());
            if (!(this.processSection(document, (Integer)sectionId.getArgValue()) || paragraph.isPageBreak() || this.result.isPageBreak())) {
                this.processPageBreak(null);
            }
        }
        if (paragraph.isEmpty()) {
            unhandled.add(paragraph);
            return true;
        }
        return false;
    }

    ContentItem beginContent() {
        this.currentItem = new ContentItem();
        this.result.addContent(this.currentItem);
        return this.currentItem;
    }

    boolean isPageRef(WordParagraph paragraph) {
        String text = paragraph.getText();
        Matcher matcher = Consts.PATTERN_PAGEREF.matcher(text);
        return matcher.find();
    }

    boolean isCover(WordParagraph paragraph) {
        return paragraph.getFontSize() >= 20;
    }

    void processHeader(WordDoc document) {
        List paragraphs = document.getHeaders();
        if (paragraphs.isEmpty()) {
            return;
        }
        ContentItem item = null;
        for (WordParagraph p : paragraphs) {
            if (p.isEmpty()) continue;
            if (item == null) {
                item = this.beginContent();
                item.setCategoryName("page_header");
            }
            item.addParagraph(p);
        }
        this.currentItem = null;
    }

    void processPageBreak(WordParagraph paragraph) {
        ContentItem item = this.beginContent();
        item.setPageBreak(true);
        item.setCategoryName("page_break");
        item.addParagraph(paragraph);
        this.currentItem = null;
    }

    boolean processSection(WordDoc document, int sectionId) {
        WordSection section = document.getContentSection(sectionId);
        if (section != null && StringUtils.isNotBlank((String)section.getSettings())) {
            this.result.clearPageBreak();
            ContentItem item = this.beginContent();
            item.setPageBreak(true);
            item.setCategoryName("page_break");
            item.setSectionStyle(section.getSettings());
            this.currentItem = null;
            return true;
        }
        return false;
    }

    WordParagraph processCover(Iterator<WordParagraph> paragraphs, WordParagraph paragraph, List<WordParagraph> unhandled) {
        ContentItem contentItem = this.beginContent();
        contentItem.setCategoryName("cover");
        if (unhandled != null) {
            for (WordParagraph p : unhandled) {
                contentItem.addParagraph(p);
            }
        }
        contentItem.addParagraph(paragraph, true);
        int currentSectionId = paragraph.getSectionId();
        while (paragraphs.hasNext()) {
            WordParagraph next = paragraphs.next();
            if (next.isPageBreak()) {
                this.processPageBreak(next);
                return null;
            }
            if (currentSectionId != next.getSectionId()) {
                this.processSection(this.doc, currentSectionId);
                return next;
            }
            if (next.getBookMarks() != null && !next.getBookMarks().isEmpty()) {
                this.processPageBreak(null);
                return next;
            }
            if (!next.isEmpty() && !this.getRules(next.getText()).isEmpty()) {
                return next;
            }
            contentItem.addParagraph(next);
        }
        return null;
    }

    WordParagraph createRefs(Iterator<WordParagraph> paragraphs, WordParagraph paragraph, PageRefs refs) {
        int currentSectionId = paragraph.getSectionId();
        RefObject categoryLevel = new RefObject((Object)1);
        int indent = paragraph.getIndent();
        RefObject parentCateogry = new RefObject();
        Category preCategory = null;
        boolean loop = true;
        while (loop) {
            RefObject canBreak;
            RefObject paragraphRefObject = new RefObject((Object)paragraph);
            RefObject beContinue = new RefObject((Object)false);
            if (this.handleRefBreak(paragraphs, (RefObject<WordParagraph>)paragraphRefObject, (RefObject<Boolean>)beContinue) || this.handleRefSection((RefObject<WordParagraph>)paragraphRefObject, currentSectionId)) {
                if (((Boolean)beContinue.getArgValue()).booleanValue()) continue;
                return (WordParagraph)paragraphRefObject.getArgValue();
            }
            paragraph = (WordParagraph)paragraphRefObject.getArgValue();
            Category category = this.createCategory(paragraph, (RefObject<Boolean>)(canBreak = new RefObject((Object)false)));
            if (category != null) {
                refs.addCategory(category);
                this.processParentCategory(category, (RefObject<Category>)parentCateogry, preCategory, (RefObject<Integer>)categoryLevel, indent, paragraph.getIndent(), refs);
                indent = paragraph.getIndent();
                preCategory = category;
            }
            if (((Boolean)canBreak.getArgValue()).booleanValue() || !paragraphs.hasNext()) {
                loop = false;
                continue;
            }
            paragraph = paragraphs.next();
        }
        return null;
    }

    boolean handleRefBreak(Iterator<WordParagraph> paragraphs, RefObject<WordParagraph> paragraphRefObject, RefObject<Boolean> beContinue) {
        WordParagraph paragraph = (WordParagraph)paragraphRefObject.getArgValue();
        if (!paragraph.isPageBreak()) {
            return false;
        }
        boolean canBreak = true;
        if (paragraphs.hasNext()) {
            paragraph = paragraphs.next();
            paragraphRefObject.setArgValue((Object)paragraph);
            String text = paragraph.getText();
            if (StringUtils.isNotBlank((String)text)) {
                Matcher matcher = Consts.PATTERN_PAGEREF.matcher(text);
                if (matcher.find()) {
                    canBreak = false;
                }
            } else {
                beContinue.setArgValue((Object)true);
            }
        }
        return canBreak;
    }

    boolean handleRefSection(RefObject<WordParagraph> paragraphRefObject, int sectionId) {
        Matcher matcher;
        WordParagraph paragraph = (WordParagraph)paragraphRefObject.getArgValue();
        if (sectionId == paragraph.getSectionId()) {
            return false;
        }
        boolean canBreak = true;
        String text = paragraph.getText();
        if (StringUtils.isNotBlank((String)text) && (matcher = Consts.PATTERN_PAGEREF.matcher(text)).find()) {
            canBreak = false;
        }
        return canBreak;
    }

    Category createCategory(WordParagraph paragraph, RefObject<Boolean> canBreak) {
        String text = paragraph.getText();
        if (StringUtils.isNotBlank((String)text)) {
            Matcher matcher = Consts.PATTERN_PAGEREF.matcher(text);
            if (matcher.find()) {
                String refId = matcher.group(1);
                String content = matcher.group(2);
                Category category = new Category();
                category.setRefMarkId(refId);
                category.setText(content);
                category.setParagraph(paragraph);
                return category;
            }
            canBreak.setArgValue((Object)true);
        }
        return null;
    }

    void processParentCategory(Category category, RefObject<Category> parentCateogry, Category preCategory, RefObject<Integer> refCategoryLevel, int indent, int newIndent, PageRefs refs) {
        String categoryText = category.getText().trim();
        Matcher matcherItem = Consts.PATTERN_Category_Level_2.matcher(categoryText);
        int categoryLevel = (Integer)refCategoryLevel.getArgValue();
        if (matcherItem.find()) {
            categoryLevel = 2;
            parentCateogry.setArgValue((Object)refs.findParentCategory(categoryLevel - 1));
        } else if (newIndent > indent) {
            ++categoryLevel;
            parentCateogry.setArgValue((Object)preCategory);
        } else if (newIndent < indent && categoryLevel > 1) {
            if (--categoryLevel == 1) {
                parentCateogry.setArgValue(null);
            } else {
                parentCateogry.setArgValue((Object)refs.findParentCategory(categoryLevel));
            }
        }
        category.setLevel(categoryLevel);
        if (parentCateogry.getArgValue() != null && categoryLevel > 1) {
            category.setParent((Category)parentCateogry.getArgValue());
        }
        refCategoryLevel.setArgValue((Object)categoryLevel);
    }

    WordParagraph processPageref(Iterator<WordParagraph> paragraphs, WordParagraph paragraph, List<WordParagraph> unhandled) {
        PageRefs refs = new PageRefs();
        WordParagraph nextParagraph = this.createRefs(paragraphs, paragraph, refs);
        ContentItem preItem = this.currentItem;
        ContentItem parentItem = null;
        if (preItem != null && preItem.getSectionId() == paragraph.getSectionId()) {
            parentItem = preItem;
        }
        if (this.pageRefMarkIds == null) {
            this.pageRefMarkIds = new HashMap<String, String>();
            this.pageRefContents = new HashMap<String, ContentItem>();
            this.pageRefItems = new HashMap<String, ContentItem>();
        }
        for (Category category : refs.getCategories()) {
            ContentItem contentItem = this.beginContent();
            contentItem.setCategoryName("page_ref");
            contentItem.setParentContentItem(parentItem);
            if (unhandled != null) {
                for (WordParagraph p : unhandled) {
                    contentItem.addParagraph(p);
                }
                unhandled.clear();
            }
            contentItem.addParagraph(category.getParagraph(), true);
            contentItem.setText(category.getText());
            contentItem.setFullText(category.getParagraph().getText());
            if (category.getParent() != null) {
                String parentRefMarkId = category.getParent().getRefMarkId();
                this.pageRefMarkIds.put(category.getRefMarkId(), parentRefMarkId);
                ContentItem categoryParentItem = this.pageRefItems.get(parentRefMarkId);
                if (categoryParentItem != null) {
                    contentItem.setParentContentItem(categoryParentItem);
                }
            } else {
                this.pageRefMarkIds.put(category.getRefMarkId(), null);
            }
            this.pageRefItems.put(category.getRefMarkId(), contentItem);
        }
        return nextParagraph;
    }

    private ContentItem getPreItem() {
        ContentItem preItem = this.currentItem;
        if (preItem == null && !this.result.getContents().isEmpty()) {
            for (int i = this.result.getContents().size() - 1; i >= 0; --i) {
                ContentItem item = (ContentItem)this.result.getContents().get(i);
                if (item.isPageBreak()) continue;
                return item;
            }
        }
        return preItem;
    }

    private void processUnhandeled(ContentItem contentItem, List<WordParagraph> unhandled) {
        if (unhandled != null) {
            for (WordParagraph p : unhandled) {
                contentItem.addParagraph(p);
            }
            unhandled.clear();
        }
    }

    void processParagraph(WordParagraph paragraph, List<WordParagraph> unhandled) {
        ContentItem preItem = this.getPreItem();
        String text = paragraph.getText();
        if (text != null) {
            text = text.trim();
        }
        this.resetRules(text);
        ParagraphConvertResult convertResult = this.convertContentParagraph(preItem, text);
        if (convertResult.createNewItem) {
            ContentItem pageRefItem;
            String bookMark;
            ContentItem contentItem = this.beginContent();
            this.processUnhandeled(contentItem, unhandled);
            contentItem.addParagraph(paragraph, true);
            if (convertResult.code != null) {
                contentItem.setCode(convertResult.code);
            }
            if (convertResult.parentItem != null) {
                contentItem.setParentContentItem(convertResult.parentItem);
            }
            if ((bookMark = this.getBookMarkIdInPageRef(paragraph)) != null && (pageRefItem = this.pageRefItems.get(bookMark)) != null) {
                pageRefItem.setRefId(contentItem.getId());
                contentItem.setTitle(pageRefItem.getText());
            }
        } else {
            this.processUnhandeled(this.currentItem, unhandled);
            this.currentItem.addParagraph(paragraph);
        }
    }

    ParagraphConvertResult convertContentParagraph(ContentItem preItem, String paragraphText) {
        ParagraphConvertResult convertResult = new ParagraphConvertResult();
        List<Pattern> rule = this.currentRules;
        if (preItem == null || this.currentItem == null) {
            convertResult.createNewItem = true;
        }
        if (rule == null || rule.isEmpty()) {
            return convertResult;
        }
        int ruleLen = rule.size();
        boolean newByRule = false;
        for (int i = 0; i < ruleLen; ++i) {
            Pattern rulePattern = rule.get(i);
            Matcher matcher = rulePattern.matcher(paragraphText);
            if (!matcher.find()) continue;
            convertResult.createNewItem = true;
            newByRule = true;
            this.setConvertResultWithNewRule(convertResult, i, matcher.group(0), preItem, i == ruleLen - 1);
            break;
        }
        if (!newByRule && this.currentItem == null && preItem != null) {
            convertResult.parentItem = preItem;
        }
        return convertResult;
    }

    void setConvertResultWithNewRule(ParagraphConvertResult convertResult, int level, String code, ContentItem preItem, boolean isLast) {
        if (isLast && code != null) {
            convertResult.code = code;
            int codeLevel = RuleAnalyze.getCodeLevel(code);
            level = level + codeLevel - 1;
        }
        if (preItem != null) {
            convertResult.parentItem = RuleAnalyze.findParentItem(preItem, level);
        }
    }

    void resetRules(String text) {
        List<Pattern> rule = this.getRules(text);
        if (rule != null && !rule.isEmpty()) {
            this.currentRules = rule;
        }
    }

    List<Pattern> getRules(String text) {
        if (this.rules == null || text == null) {
            return new ArrayList<Pattern>();
        }
        for (Map.Entry<String, AttachDissectRules> kv : this.rules.entrySet()) {
            String key = kv.getKey();
            Pattern pattern = this.ruleKeyPatterns.get(key);
            if (pattern == null || !pattern.matcher(text).find()) continue;
            return CollectionUtil.select((Collection)this.rules.get(key).getRules(), RuleAnalyze::compileRule);
        }
        return new ArrayList<Pattern>();
    }

    String getBookMarkIdInPageRef(WordParagraph paragraph) {
        if (paragraph.getBookMarks() != null && this.pageRefMarkIds != null && this.pageRefMarkIds.size() > 0) {
            for (String bookMark : paragraph.getBookMarks()) {
                if (!this.pageRefMarkIds.containsKey(bookMark)) continue;
                return bookMark;
            }
        }
        return null;
    }

    static Map<String, AttachDissectRules> convertRules(List<AttachDissectRules> rules) {
        HashMap<String, AttachDissectRules> convertResult = new HashMap<String, AttachDissectRules>();
        for (AttachDissectRules rule : rules) {
            convertResult.put(rule.getText(), rule);
        }
        return convertResult;
    }

    static List<String> convertJsonToArray(JSONArray array) {
        LinkedList<String> list = new LinkedList<String>();
        array.forEach(arr -> {
            if (arr instanceof String) {
                list.add(arr.toString());
            }
        });
        return list;
    }

    static ContentItem findParentItem(ContentItem preItem, int level) {
        if (level == 0) {
            return null;
        }
        for (ContentItem parent = preItem; parent != null; parent = parent.getParentContentItem()) {
            if (parent.getLevel() != level) continue;
            return parent;
        }
        return null;
    }

    static int getCodeLevel(String code) {
        if (StringUtils.isNotBlank((String)code)) {
            String codes = code;
            if (!codes.endsWith(".")) {
                codes = codes + ".";
            }
            return codes.split("\\.").length;
        }
        return 0;
    }

    static Pattern compileRule(String rule) {
        return Pattern.compile(rule);
    }
}

