/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.module.doc.utils;

import cn.hangar.agp.platform.utils.Convert;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.model.doc.SysDocItem;
import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.Patch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;

public class DocDiffHelper {
    static final String htmlTags = "(p|span|a|img|table|tr|td|tbody|thead|br|font)";
    static final Pattern htmlPattern = Pattern.compile("((<(p|span|a|img|table|tr|td|tbody|thead|br|font)((\\s+[^>]*)|(\\s*/?))>)|(</(p|span|a|img|table|tr|td|tbody|thead|br|font)>))");
    static final Pattern numberDotPattern = Pattern.compile("^\\d+(\\.\\d+)*\\s?");
    static final Pattern chnNumberPattern = Pattern.compile("^[\\u4e00\\u4e8c\\u4e09\\u56db\\u4e94\\u516d\\u4e03\\u516b\\u4e5d\\u5341\\u767e\\u5343]+\\u3001");
    static final Pattern chnOrderPattern = Pattern.compile("^\\u7bc2[\\u4e00\\u4e8c\\u4e09\\u56db\\u4e94\\u516d\\u4e03\\u516b\\u4e5d\\u5341\\u767e\\u5343]+");
    static final Pattern notChnEngPattern = Pattern.compile("[^\\u4e00-\\u9fa5\\x20-\\x7E\\u3002\\uff1b\\uff0c\\uff1a\\u201c\\u201d\\uff08\\uff09\\u3001\\uff1f\\u300a\\u300b]");

    public static List<ItemDifference> generateDifferences(List<SysDocItem> from, List<SysDocItem> to, boolean matched) {
        List<ItemDifference> diffs;
        List<SysDocItemEx> fromList = DocDiffHelper.initItemList(from);
        List<SysDocItemEx> toList = DocDiffHelper.initItemList(to);
        if (fromList.size() == toList.size() && matched) {
            diffs = new ArrayList<ItemDifference>();
            for (int i = 0; i < to.size(); ++i) {
                diffs.add(new ItemDifference(fromList.get(i), toList.get(i)));
            }
        } else {
            diffs = DocDiffHelper.matchItems(fromList, toList);
        }
        DocDiffHelper.generateInnerDifferences(diffs);
        return diffs;
    }

    private static void generateInnerDifferences(List<ItemDifference> diffs) {
        if (diffs == null) {
            return;
        }
        for (ItemDifference diff : diffs) {
            SysDocItem sourceItem = diff.getSource();
            SysDocItem targetItem = diff.getTarget();
            if (sourceItem == null) {
                diff.setType(ItemDiffType.inserted);
                diff.addDifference(new ItemInnerDifference(ItemDiffType.inserted));
                continue;
            }
            if (targetItem == null) {
                diff.setType(ItemDiffType.deleted);
                diff.addDifference(new ItemInnerDifference(ItemDiffType.deleted));
                continue;
            }
            String fromContent = sourceItem.getItemHtml();
            String toContent = targetItem.getItemHtml();
            if (StringUtils.isEmpty((String)fromContent) && StringUtils.isEmpty((String)toContent) || StringUtils.equals((String)fromContent, (String)toContent)) continue;
            if (StringUtils.isEmpty((String)fromContent)) {
                diff.setType(ItemDiffType.inserted);
                continue;
            }
            if (StringUtils.isEmpty((String)toContent)) {
                diff.setType(ItemDiffType.deleted);
                continue;
            }
            List<int[]> fromTagIndexes = DocDiffHelper.getHtmlTagIndexes(fromContent);
            List<int[]> toTagIndexes = DocDiffHelper.getHtmlTagIndexes(toContent);
            List<CharacterEx> fromCharacters = DocDiffHelper.getComparableCharacters(fromContent, fromTagIndexes);
            List<CharacterEx> toCharacters = DocDiffHelper.getComparableCharacters(toContent, toTagIndexes);
            if (fromCharacters.isEmpty() && toCharacters.isEmpty()) continue;
            Patch patch = DiffUtils.diff(fromCharacters, toCharacters, CharacterEx::equals);
            for (AbstractDelta delta : patch.getDeltas()) {
                Chunk sourceChunk = delta.getSource();
                Chunk targetChunk = delta.getTarget();
                CharacterEx fromStartCha = sourceChunk.getPosition() < fromCharacters.size() ? fromCharacters.get(sourceChunk.getPosition()) : fromCharacters.get(fromCharacters.size() - 1);
                CharacterEx toStartCha = targetChunk.getPosition() < toCharacters.size() ? toCharacters.get(targetChunk.getPosition()) : toCharacters.get(toCharacters.size() - 1);
                CharacterEx fromEndCha = sourceChunk.size() == 0 ? null : (CharacterEx)sourceChunk.getLines().get(sourceChunk.size() - 1);
                CharacterEx toEndCha = targetChunk.size() == 0 ? null : (CharacterEx)targetChunk.getLines().get(targetChunk.size() - 1);
                int sourceIdx = fromStartCha.getIndex();
                int targetIdx = toStartCha.getIndex();
                int sourceLen = fromEndCha == null ? 0 : fromEndCha.getIndex() - fromStartCha.getIndex() + 1;
                int targetLen = toEndCha == null ? 0 : toEndCha.getIndex() - toStartCha.getIndex() + 1;
                List<int[]> fromLimits = DocDiffHelper.limitRange(fromTagIndexes, sourceIdx, sourceLen);
                List<int[]> toLimits = DocDiffHelper.limitRange(toTagIndexes, targetIdx, targetLen);
                int max = Math.max(fromLimits.size(), toLimits.size());
                ItemDiffType type = delta.getType() == DeltaType.DELETE ? ItemDiffType.deleted : (delta.getType() == DeltaType.INSERT ? ItemDiffType.inserted : ItemDiffType.changed);
                for (int i = 0; i < max; ++i) {
                    int[] fromLimit = i < fromLimits.size() ? fromLimits.get(i) : fromLimits.get(fromLimits.size() - 1);
                    int[] toLimit = i < toLimits.size() ? toLimits.get(i) : toLimits.get(toLimits.size() - 1);
                    sourceIdx = fromLimit[0];
                    sourceLen = i < fromLimits.size() ? fromLimit[1] - fromLimit[0] : 0;
                    targetIdx = toLimit[0];
                    int n = targetLen = i < toLimits.size() ? toLimit[1] - toLimit[0] : 0;
                    if (sourceLen == 0 && targetLen == 0) continue;
                    diff.addDifference(new ItemInnerDifference(sourceIdx, sourceLen, targetIdx, targetLen, type));
                }
                diff.setType(ItemDiffType.changed);
            }
        }
    }

    public static List<SysDocItemEx> initItemList(List<SysDocItem> inputList) {
        List<SysDocItemEx> result = inputList.stream().sorted(Comparator.comparingInt(SysDocItem::getSeqOrder)).map(SysDocItemEx::new).collect(Collectors.toList());
        Map<String, SysDocItemEx> itemMap = result.stream().collect(Collectors.toMap(i -> i.getData().getDocItemID(), i -> i));
        for (int i2 = 0; i2 < result.size(); ++i2) {
            SysDocItemEx it = result.get(i2);
            SysDocItemEx p = itemMap.get(it.getData().getPDocItemID());
            if (p != null) {
                p.addChild(it);
            }
            it.setIndex(i2);
            it.generateCode();
        }
        return result;
    }

    private static List<int[]> getHtmlTagIndexes(String html) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        Matcher matcher = htmlPattern.matcher(html);
        while (matcher.find()) {
            int[] last;
            boolean newRange = true;
            int start = matcher.start();
            int end = matcher.end();
            if (result.size() > 0 && (last = (int[])result.get(result.size() - 1))[1] == start) {
                last[1] = end;
                newRange = false;
            }
            if (!newRange) continue;
            result.add(new int[]{start, end});
        }
        return result;
    }

    private static boolean isInRange(List<int[]> ranges, int from, int len) {
        for (int[] range : ranges) {
            int start = range[0];
            int end = range[1];
            if (from < start || from + len > end) continue;
            return true;
        }
        return false;
    }

    private static boolean isInRange(List<int[]> ranges, int from) {
        return DocDiffHelper.isInRange(ranges, from, 1);
    }

    private static List<int[]> limitRange(List<int[]> ranges, int from, int len) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        int a = from;
        int b = from + len;
        for (int[] range : ranges) {
            int start = range[0];
            int end = range[1];
            if (a < start && b > start) {
                result.add(new int[]{a, start});
                a = end;
                if (a < b) continue;
                break;
            }
            if (a >= end || b <= end) continue;
            result.add(new int[]{end, b});
            a = end;
        }
        if (result.isEmpty()) {
            result.add(new int[]{a, b});
        }
        return result;
    }

    private static List<CharacterEx> getComparableCharacters(String content, List<int[]> htmlRanges) {
        ArrayList<CharacterEx> result = new ArrayList<CharacterEx>();
        ArrayList<CharacterEx> endBlanks = new ArrayList<CharacterEx>();
        boolean startBlank = true;
        int len = content.length();
        for (int i = 0; i < len; ++i) {
            char c = content.charAt(i);
            if (DocDiffHelper.isInRange(htmlRanges, i) || Character.isWhitespace(c) && startBlank) continue;
            CharacterEx characterEx = new CharacterEx(c, i);
            if (Character.isWhitespace(c)) {
                endBlanks.add(characterEx);
                continue;
            }
            startBlank = false;
            result.addAll(endBlanks);
            result.add(characterEx);
            endBlanks.clear();
        }
        return result;
    }

    private static List<ItemDifference> matchItems(List<SysDocItemEx> fromItems, List<SysDocItemEx> toItems) {
        ArrayList<ItemDifference> diffs = new ArrayList<ItemDifference>();
        int lastToIdx = 0;
        block0: for (SysDocItemEx from : fromItems) {
            String fromCode = from.getData().getItemCode();
            boolean hasCode = StringUtils.isNotBlank((String)fromCode);
            String fromContent = from.getData().getItemContent();
            if (!hasCode && !StringUtils.isNotBlank((String)fromContent)) continue;
            for (int i = lastToIdx; i < toItems.size(); ++i) {
                SysDocItemEx to = toItems.get(i);
                String toCode = to.getData().getItemCode();
                String toContent = to.getData().getItemContent();
                boolean match = false;
                if (hasCode) {
                    match = fromCode.equals(toCode) || DocDiffHelper.getSimilarityRatio(fromContent, toContent) > 0.9;
                } else if (StringUtils.isNotBlank((String)toCode)) {
                    boolean bl = match = from.getCode().equals(to.getCode()) || DocDiffHelper.getSimilarityRatio(fromContent, toContent) > 0.9;
                }
                if (match && StringUtils.isNotBlank((String)from.getData().getItemType())) {
                    match = from.getData().getItemType().equals(to.getData().getItemType());
                }
                if (!match) continue;
                lastToIdx = to.getIndex() + 1;
                diffs.add(new ItemDifference(from, to));
                continue block0;
            }
        }
        return DocDiffHelper.matchItemsBySimilarity(fromItems, toItems, diffs);
    }

    private static List<ItemDifference> matchItemsBySimilarity(List<SysDocItemEx> fromItems, List<SysDocItemEx> toItems, List<ItemDifference> diffs) {
        if (diffs == null || diffs.isEmpty()) {
            if (fromItems.isEmpty()) {
                return toItems.stream().map(s -> new ItemDifference(null, (SysDocItemEx)s)).collect(Collectors.toList());
            }
            if (toItems.isEmpty()) {
                return fromItems.stream().map(s -> new ItemDifference((SysDocItemEx)s, null)).collect(Collectors.toList());
            }
            diffs = new ArrayList<ItemDifference>();
            int lastToIdx = 0;
            for (SysDocItemEx from : fromItems) {
                SysDocItemEx matchTo = null;
                double rate = 0.0;
                for (int i = 0; i < toItems.size(); ++i) {
                    double r;
                    SysDocItemEx to = toItems.get(i);
                    if (to.getIndex() < lastToIdx || !((r = DocDiffHelper.getSimilarityRatio(from.getData().getItemContent(), to.getData().getItemContent())) > rate) || !(r > 0.6)) continue;
                    matchTo = to;
                    rate = r;
                }
                if (matchTo == null) continue;
                boolean match = true;
                if (StringUtils.isNotBlank((String)from.getData().getItemType())) {
                    match = from.getData().getItemType().equals(matchTo.getData().getItemType());
                }
                if (!match) continue;
                lastToIdx = matchTo.getIndex() + 1;
                ItemDifference diff = new ItemDifference(from, matchTo);
                diffs.add(diff);
            }
        }
        ArrayList<ItemDifference> result = new ArrayList<ItemDifference>();
        int len = diffs.size();
        if (len < 1) {
            result.addAll(fromItems.stream().map(s -> new ItemDifference((SysDocItemEx)s, null)).collect(Collectors.toList()));
            result.addAll(toItems.stream().map(s -> new ItemDifference(null, (SysDocItemEx)s)).collect(Collectors.toList()));
        } else {
            for (int i = 0; i < len; ++i) {
                List<ItemDifference> newDiffs;
                ItemDifference curDiff = diffs.get(i);
                int curSource = curDiff.getSourceIdx();
                int curTarget = curDiff.getTargetIdx();
                if (curSource < 0 || curTarget < 0) continue;
                if (i == 0) {
                    List<SysDocItemEx> prevFromList = DocDiffHelper.subList(fromItems, 0, curSource);
                    List<SysDocItemEx> prevToList = DocDiffHelper.subList(toItems, 0, curTarget);
                    newDiffs = DocDiffHelper.matchItemsBySimilarity(prevFromList, prevToList, null);
                    result.addAll(newDiffs);
                    result.add(curDiff);
                    continue;
                }
                ItemDifference prev = diffs.get(i - 1);
                int prevSource = prev.getSourceIdx();
                int prevTarget = prev.getTargetIdx();
                if (prevSource >= 0 && prevTarget >= 0) {
                    List<SysDocItemEx> prevFromList = DocDiffHelper.subList(fromItems, prevSource + 1, curSource);
                    List<SysDocItemEx> prevToList = DocDiffHelper.subList(toItems, prevTarget + 1, curTarget);
                    newDiffs = DocDiffHelper.matchItemsBySimilarity(prevFromList, prevToList, null);
                    result.addAll(newDiffs);
                }
                result.add(curDiff);
                if (i != len - 1) continue;
                List<SysDocItemEx> nextFromList = DocDiffHelper.subList(fromItems, curSource + 1, fromItems.size());
                List<SysDocItemEx> nextToList = DocDiffHelper.subList(toItems, curTarget + 1, toItems.size());
                newDiffs = DocDiffHelper.matchItemsBySimilarity(nextFromList, nextToList, null);
                result.addAll(newDiffs);
            }
        }
        return result;
    }

    private static List<SysDocItemEx> subList(List<SysDocItemEx> list, int start, int end) {
        ArrayList<SysDocItemEx> result = new ArrayList<SysDocItemEx>();
        if (start < end) {
            for (SysDocItemEx sysDocItem : list) {
                if (sysDocItem.getIndex() < start || sysDocItem.getIndex() >= end) continue;
                result.add(sysDocItem);
            }
        }
        return result;
    }

    public static double getSimilarityRatio(String src, String dst) {
        if (StringUtils.isNotBlank((String)src) && StringUtils.isNotBlank((String)dst)) {
            int i;
            src = notChnEngPattern.matcher(src).replaceAll("");
            dst = notChnEngPattern.matcher(dst).replaceAll("");
            int n = src.length();
            int m = dst.length();
            int[][] d = new int[n + 1][m + 1];
            for (i = 0; i <= n; ++i) {
                d[i][0] = i;
            }
            for (i = 0; i <= m; ++i) {
                d[0][i] = i;
            }
            for (i = 0; i < n; ++i) {
                char ch1 = src.charAt(i);
                for (int j = 0; j < m; ++j) {
                    int temp = 1;
                    char ch2 = dst.charAt(j);
                    if (ch1 == ch2 || ch1 == ch2 + 32 || ch1 + 32 == ch2) {
                        temp = 0;
                    }
                    d[i + 1][j + 1] = Math.min(Math.min(d[i][j + 1] + 1, d[i + 1][j] + 1), d[i][j] + temp);
                }
            }
            return 1.0 - (double)d[n][m] / (double)Math.max(src.length(), dst.length());
        }
        return 0.0;
    }

    public static SysDocItem createItem(String html) {
        Matcher matcher;
        SysDocItem item = new SysDocItem();
        String content = DocDiffHelper.getNoHtmlContent(html);
        item.setDocItemID(UUID.randomUUID().toString());
        item.setItemContent(content);
        item.setItemHtml(html);
        if (content != null && (matcher = numberDotPattern.matcher(content)).find()) {
            item.setItemCode(matcher.group().trim());
        }
        item.setRecDate(new Date());
        return item;
    }

    public static String getNoHtmlContent(String html) {
        if (StringUtils.isNotBlank((String)html)) {
            html = htmlPattern.matcher(html).replaceAll("");
            html = StringEscapeUtils.unescapeHtml4((String)html);
            html = notChnEngPattern.matcher(html).replaceAll("");
        }
        return html;
    }

    public static int getSiblingOrder(SysDocItem item) {
        String content;
        Matcher matcher;
        String code = item.getItemCode();
        if (StringUtils.isBlank((String)code) && (matcher = chnNumberPattern.matcher(content = DocDiffHelper.getNoHtmlContent(item.getItemContent()))).find()) {
            code = matcher.group().trim();
        }
        if (StringUtils.isNotBlank((String)code)) {
            code = StringUtils.trimStartAndEnd((String)code, (char)'.');
            String[] splits = code.split("\\.");
            return Convert.toInt((Object)splits[splits.length - 1]);
        }
        return 0;
    }

    public static String getCodeString(String code, boolean sub) {
        if (StringUtils.isNotBlank((String)code)) {
            Matcher matcher = numberDotPattern.matcher(code = DocDiffHelper.getNoHtmlContent(code));
            if (matcher.find()) {
                return matcher.group().trim();
            }
            matcher = chnNumberPattern.matcher(code);
            if (matcher.find()) {
                return matcher.group();
            }
            matcher = chnOrderPattern.matcher(code);
            if (matcher.find()) {
                return matcher.group();
            }
            if (sub) {
                return code.length() > 4 ? code.substring(0, 4) : code;
            }
        }
        return "";
    }

    public static class SysDocItemEx {
        private SysDocItem data;
        private SysDocItemEx parent;
        private List<SysDocItemEx> children;
        private String code;
        private int index;

        public SysDocItemEx(SysDocItem data) {
            this.data = data;
        }

        public void addChild(SysDocItemEx item) {
            if (this.data.getSeqOrder() == 1) {
                return;
            }
            if (this.children == null) {
                this.children = new ArrayList<SysDocItemEx>();
            }
            this.children.add(item);
            item.setParent(this);
        }

        public void generateCode() {
            StringBuilder c = new StringBuilder();
            if (StringUtils.isNotBlank((String)this.data.getItemCode())) {
                c.append(this.data.getItemCode().trim());
            } else {
                c.append(DocDiffHelper.getCodeString(this.data.getItemContent(), true));
            }
            if (this.parent != null) {
                c.insert(0, this.parent.getCode() + ",");
            }
            this.code = c.toString();
        }

        public SysDocItem getData() {
            return this.data;
        }

        public SysDocItemEx getParent() {
            return this.parent;
        }

        public List<SysDocItemEx> getChildren() {
            return this.children;
        }

        public String getCode() {
            return this.code;
        }

        public int getIndex() {
            return this.index;
        }

        public void setData(SysDocItem data) {
            this.data = data;
        }

        public void setParent(SysDocItemEx parent) {
            this.parent = parent;
        }

        public void setChildren(List<SysDocItemEx> children) {
            this.children = children;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }

    private static class CharacterEx {
        char code;
        int index;

        public CharacterEx(char code, int index) {
            this.code = code;
            this.index = index;
        }

        public boolean equals(CharacterEx to) {
            return this.code == to.getCode();
        }

        public String toString() {
            return this.index + ": " + this.code;
        }

        public char getCode() {
            return this.code;
        }

        public int getIndex() {
            return this.index;
        }

        public void setCode(char code) {
            this.code = code;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }

    private static enum ItemDiffType {
        changed,
        inserted,
        deleted;

    }

    private static class ItemInnerDifference
    implements Serializable {
        int sourceIdx;
        int sourceLen;
        int targetIdx;
        int targetLen;
        ItemDiffType type;

        public ItemInnerDifference(int sourceIdx, int sourceLen, int targetIdx, int targetLen, ItemDiffType type) {
            this.sourceIdx = sourceIdx;
            this.sourceLen = sourceLen;
            this.targetIdx = targetIdx;
            this.targetLen = targetLen;
            this.type = type;
        }

        public ItemInnerDifference(ItemDiffType type) {
            this.type = type;
        }

        public int getSourceIdx() {
            return this.sourceIdx;
        }

        public int getSourceLen() {
            return this.sourceLen;
        }

        public int getTargetIdx() {
            return this.targetIdx;
        }

        public int getTargetLen() {
            return this.targetLen;
        }

        public ItemDiffType getType() {
            return this.type;
        }

        public void setSourceIdx(int sourceIdx) {
            this.sourceIdx = sourceIdx;
        }

        public void setSourceLen(int sourceLen) {
            this.sourceLen = sourceLen;
        }

        public void setTargetIdx(int targetIdx) {
            this.targetIdx = targetIdx;
        }

        public void setTargetLen(int targetLen) {
            this.targetLen = targetLen;
        }

        public void setType(ItemDiffType type) {
            this.type = type;
        }
    }

    private static class ItemDifference
    implements Serializable {
        SysDocItem source;
        SysDocItem target;
        int sourceIdx;
        int targetIdx;
        ItemDiffType type;
        List<ItemInnerDifference> diffs;

        public ItemDifference(SysDocItemEx sourceEx, SysDocItemEx targetEx) {
            this.source = sourceEx == null ? null : sourceEx.getData();
            this.target = targetEx == null ? null : targetEx.getData();
            this.sourceIdx = sourceEx == null ? -1 : sourceEx.getIndex();
            this.targetIdx = targetEx == null ? -1 : targetEx.getIndex();
        }

        public void addDifference(ItemInnerDifference diff) {
            if (this.diffs == null) {
                this.diffs = new ArrayList<ItemInnerDifference>();
            }
            this.diffs.add(diff);
        }

        public SysDocItem getSource() {
            return this.source;
        }

        public SysDocItem getTarget() {
            return this.target;
        }

        public int getSourceIdx() {
            return this.sourceIdx;
        }

        public int getTargetIdx() {
            return this.targetIdx;
        }

        public ItemDiffType getType() {
            return this.type;
        }

        public List<ItemInnerDifference> getDiffs() {
            return this.diffs;
        }

        public void setSource(SysDocItem source) {
            this.source = source;
        }

        public void setTarget(SysDocItem target) {
            this.target = target;
        }

        public void setSourceIdx(int sourceIdx) {
            this.sourceIdx = sourceIdx;
        }

        public void setTargetIdx(int targetIdx) {
            this.targetIdx = targetIdx;
        }

        public void setType(ItemDiffType type) {
            this.type = type;
        }

        public void setDiffs(List<ItemInnerDifference> diffs) {
            this.diffs = diffs;
        }
    }
}

