/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.module.doc.dissectFileModel;

import cn.hangar.agp.module.doc.office.util.word.analysis.AnalyzeResult;
import cn.hangar.agp.module.doc.office.util.word.analysis.ContentItem;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.model.doc.SysDocItem;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class DissectFileResult {
    private String ID;
    private String FILENAME;
    private List<SysDocItem> docItems;
    private static Pattern notChnEngPattern = Pattern.compile("[^\\u4e00-\\u9fa5\\x20-\\x7E\\u3002\\uff1b\\uff0c\\uff1a\\u201c\\u201d\\uff08\\uff09\\u3001\\uff1f\\u300a\\u300b\\s\\r\\t\\n]");

    public DissectFileResult(String fileName, AnalyzeResult anaResult, String resId, String docId) {
        this.setID(docId);
        this.FILENAME = fileName;
        this.Init(anaResult, resId, docId);
    }

    private void Init(AnalyzeResult anaResult, String resId, String docId) {
        this.docItems = new ArrayList<SysDocItem>();
        if (anaResult == null) {
            return;
        }
        int i = 1;
        for (ContentItem item : anaResult.getContents()) {
            String text;
            SysDocItem docItem = new SysDocItem(resId, docId);
            docItem.setDocItemID(item.getId());
            docItem.setItemCode(item.getCode());
            docItem.setItemType(item.getCategoryName());
            docItem.setLinkDocItemID(item.getRefId());
            if (StringUtils.isNotBlank((String)item.getTitle())) {
                String title = item.getTitle();
                title = notChnEngPattern.matcher(title).replaceAll("").trim();
                docItem.setItemTitle(title);
            }
            if ((text = item.getText()) != null) {
                if (text.indexOf("TOC") >= 0) {
                    text = text.replaceAll("TOC[\\d,\\w,\\s,\\\\\"-]*\\s", "");
                } else if (text.indexOf("HYPERLINK") >= 0) {
                    text = text.replaceAll("HYPERLINK[\\w\\s_\\\\\"]*[\\s\"]", "");
                }
                text = notChnEngPattern.matcher(text).replaceAll("").trim();
                text = text.replaceAll("\\r", "").replaceAll("\\t", "");
            }
            docItem.setItemContent(text);
            String html = item.getHtml();
            if (html != null && html.indexOf("TOC") >= 0 || html.indexOf("HYPERLINK") >= 0) {
                html = html.replaceAll("<span [^>]*>\\s?TOC[\\d,\\w,\\s,\\\\\"-]*</span>", "");
                html = html.replaceAll("<span>HYPERLINK[\\d,\\w,\\s,\\\\\"-]*</span>", "");
                html = html.replaceAll("TOC[\\w\\s\\\\\"-]*\\s", "");
                html = html.replaceAll("HYPERLINK[\\w\\s_\\\\\"]*[\\s\"]", "");
            }
            docItem.setItemHtml(html);
            docItem.setItemFormat(item.getFullText());
            docItem.setPDocItemID(item.getParentContentItemId());
            this.SetParents(docItem, item);
            docItem.setSeqOrder(Integer.valueOf(i));
            this.docItems.add(docItem);
            ++i;
        }
    }

    private void SetParents(SysDocItem docItem, ContentItem item) {
        ArrayList<String> parents = new ArrayList<String>();
        this.GetParents(parents, item);
        int len = parents.size();
        for (int i = 0; i < len; ++i) {
            String parentText = (String)parents.get(len - i - 1);
            if (i == 0) {
                docItem.setCat1ItemID(parentText);
                continue;
            }
            if (i == 1) {
                docItem.setCat2ItemID(parentText);
                continue;
            }
            if (i != 2) continue;
            docItem.setCat3ItemID(parentText);
        }
    }

    private void GetParents(List<String> parents, ContentItem item) {
        ContentItem parentItem = item.getParentContentItem();
        if (parentItem != null) {
            parents.add(parentItem.getId());
            this.GetParents(parents, parentItem);
        }
    }

    private void SetOrder(List<SysDocItem> items, SysDocItem parent) {
        int i = 1;
        for (SysDocItem item : items) {
            boolean ischild = false;
            if (parent == null) {
                if (item.getPDocItemID() == null) {
                    ischild = true;
                }
            } else if (item.getPDocItemID() != null && parent.getDocItemID().equals(item.getPDocItemID())) {
                ischild = true;
            }
            if (!ischild) continue;
            item.setSeqOrder(Integer.valueOf(i));
            ++i;
            this.SetOrder(items, item);
        }
    }

    public String getID() {
        return this.ID;
    }

    public String getFILENAME() {
        return this.FILENAME;
    }

    public List<SysDocItem> getDocItems() {
        return this.docItems;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public void setFILENAME(String FILENAME) {
        this.FILENAME = FILENAME;
    }

    public void setDocItems(List<SysDocItem> docItems) {
        this.docItems = docItems;
    }
}

