/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.module.doc.attach;

import cn.hangar.agp.module.doc.attach.AttachProvider;
import cn.hangar.agp.module.doc.attach.dao.IFileInfoRepository;
import cn.hangar.agp.platform.core.app.AppContext;
import cn.hangar.agp.platform.core.app.AppException;
import cn.hangar.agp.platform.core.app.PathFileHelper;
import cn.hangar.agp.platform.core.data.MobileBoolean;
import cn.hangar.agp.platform.core.data.MobileString;
import cn.hangar.agp.platform.utils.Convert;
import cn.hangar.agp.platform.utils.DateUtil;
import cn.hangar.agp.platform.utils.FileUtil;
import cn.hangar.agp.service.core.util.AttachHelper;
import cn.hangar.agp.service.model.doc.AttachAddArgument;
import cn.hangar.agp.service.model.doc.AttachDeleteArgument;
import cn.hangar.agp.service.model.doc.AttachFetchArgument;
import cn.hangar.agp.service.model.doc.AttachFetchResult;
import cn.hangar.agp.service.model.doc.AttachInfo;
import cn.hangar.agp.service.model.doc.AttachUpdateArgument;
import cn.hangar.agp.service.model.doc.SysResDoc;
import cn.hangar.agp.service.model.sys.SysAppCfg;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileOutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="share_file_attach")
@Scope(value="prototype")
public class MoreShareFileAttachProvider
extends AttachProvider {
    private static final Lock lockObj = new ReentrantLock();
    private static Integer shareFileCount;
    private static Map<String, String> nameToIpMap;
    private static String priorityServerName;
    private String currentServerName;
    private String currentFileServerUrl;
    private static long spareSpace;
    @Autowired
    IFileInfoRepository fileInfoRepository;

    @Override
    protected IFileInfoRepository getFileInfoRepository() {
        return this.fileInfoRepository;
    }

    private void init(Map<String, String> properties) {
        if (shareFileCount == null) {
            shareFileCount = Convert.toInt((Object)this.getProperty(properties, "shareFileServer_count"));
        }
        if (nameToIpMap == null) {
            nameToIpMap = new HashMap<String, String>();
            for (int i = 1; i <= shareFileCount; ++i) {
                nameToIpMap.put("shareFileServer" + i, this.getProperty(properties, "shareFileServer" + i));
            }
        }
        if (priorityServerName == null) {
            priorityServerName = this.getProperty(properties, "priority_server_name");
        }
    }

    protected String getUrl() {
        String srcUrl = this.getRealServerUrl(priorityServerName);
        if (srcUrl == null) {
            this.log.error("\u65e0\u53ef\u7528\u6587\u4ef6\u670d\u52a1\uff01\u6216\u78c1\u76d8\u5df2\u6ee1\uff01");
            return null;
        }
        String appId = SysAppCfg.getParentAppId((String)AppContext.getCurrentAppId());
        String url = srcUrl + appId + "/";
        this.currentFileServerUrl = this.currentServerName + "/" + appId + "/";
        return url;
    }

    public String getRealServerUrl(String shareFileServerName) {
        String url = "smb://guest:@" + nameToIpMap.get(shareFileServerName) + "/";
        try {
            SmbFile file = new SmbFile(url);
            if (file != null && file.getDiskFreeSpace() > spareSpace) {
                this.currentServerName = shareFileServerName;
                return url;
            }
            for (int i = 1; i <= shareFileCount; ++i) {
                url = "smb://guest:@" + nameToIpMap.get("shareFileServer" + i) + "/";
                file = new SmbFile(url);
                if (file == null || file.getDiskFreeSpace() <= spareSpace) continue;
                priorityServerName = nameToIpMap.get("shareFileServer" + i);
                this.currentServerName = nameToIpMap.get("shareFileServer" + i);
                return url;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MobileBoolean updateAttach(AttachUpdateArgument arg) {
        this.init(arg.getProperties());
        String fileName = null;
        String bakFileName = null;
        AttachInfo map = this.getAttachInfo(arg.getPointId());
        if (map == null) {
            return null;
        }
        String phyPath = map.getPhyAddress();
        String serverName = phyPath.substring(0, phyPath.indexOf("/"));
        String uri = phyPath.replace(serverName, nameToIpMap.get(serverName));
        fileName = "smb://guest:@" + uri + arg.getPointId();
        bakFileName = uri + arg.getPointId() + "_bak";
        try {
            this.reNameTo(fileName, bakFileName);
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
        OutputStream outs = null;
        try {
            SmbFile file = new SmbFile(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            outs = new SmbFileOutputStream(file, true);
            outs.write(arg.getData());
            if (this.checkExist(fileName)) {
                byte[] thumb = this.generateThumbnail(fileName, this.wrapExt(FileUtil.getExtension((String)arg.getFileName()), false));
                this.updateFileInfo(map, arg, thumb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MobileBoolean mobileBoolean = new MobileBoolean(false);
            return mobileBoolean;
        }
        finally {
            try {
                outs.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new MobileBoolean(true);
    }

    public boolean createNewFile(String filePath) {
        try {
            SmbFile file = new SmbFile(filePath);
            file.createNewFile();
            return true;
        }
        catch (Exception e) {
            this.log.error("\u65b0\u5efa\u6587\u4ef6:" + filePath + "\u5931\u8d25\u3002");
            return false;
        }
    }

    public MobileString addAttach(AttachAddArgument arg) throws Exception {
        this.init(arg.getProperties());
        String dateDir = DateUtil.formatDate((Date)new Date(), (String)"yyyyMM") + "/";
        String uri = this.getUrl() + dateDir;
        arg.setPhyadoress(this.currentFileServerUrl + dateDir);
        this.createDir(uri);
        String fileName = uri + arg.getPointId();
        String path = PathFileHelper.getApplicationWritablePath((String)arg.getAppId(), (boolean)true, (String[])new String[]{"upload", arg.getPointId()});
        try {
            lockObj.lock();
            String tempFile = path + arg.getPackageNumber();
            FileUtil.writeFile((String)tempFile, (byte[])arg.getData());
            if (FileUtil.getFiles((String)path).length == arg.getPackageCount()) {
                try {
                    SmbFile file = new SmbFile(fileName);
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    try (OutputStream outs = null;){
                        outs = new SmbFileOutputStream(file, true);
                        for (int i = 0; i < arg.getPackageCount(); ++i) {
                            Files.copy(Paths.get(path + i, new String[0]), outs);
                        }
                    }
                    if (this.checkExist(fileName)) {
                        byte[] thumb = this.generateThumbnail(fileName, this.wrapExt(FileUtil.getExtension((String)arg.getFileName()), false));
                        this.insertFileInfo(arg, thumb);
                        if (arg.isInsertDoc()) {
                            this.insertResDoc(arg);
                        }
                    }
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    FileUtil.deleteDir((String)path);
                }
            }
            MobileString mobileString = new MobileString(arg.getPointId());
            return mobileString;
        }
        catch (Exception e) {
            if (FileUtil.checkExist((String)fileName)) {
                FileUtil.deleteFile((String)fileName);
            }
            FileUtil.deleteDir((String)path);
            throw e;
        }
        finally {
            lockObj.unlock();
        }
    }

    public MobileString addTempFile(AttachAddArgument arg) {
        this.init(arg.getProperties());
        try {
            String path = PathFileHelper.getApplicationWritablePath((String)arg.getAppId(), (boolean)true, (String[])new String[]{"upload", arg.getPointId()});
            String tempFile = path + arg.getPackageNumber();
            FileUtil.writeFile((String)tempFile, (byte[])arg.getData());
            String destPath = PathFileHelper.getApplicationWritablePath((String)arg.getAppId(), (boolean)true, (String[])new String[]{"temp"});
            String ftpFileName = destPath + arg.getPointId() + FileUtil.getExtension((String)arg.getFileName());
            if (FileUtil.getFiles((String)path).length == arg.getPackageCount()) {
                FileUtil.writeFile((String)ftpFileName, out -> {
                    try {
                        for (int i = 0; i < arg.getPackageCount(); ++i) {
                            Files.copy(Paths.get(path + i, new String[0]), out);
                        }
                    }
                    catch (IOException e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                this.log.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                });
                FileUtil.deleteDir((String)path);
            }
            return new MobileString(arg.getPointId() + FileUtil.getExtension((String)arg.getFileName()));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<SysResDoc> getSysResDocInfo(String resId, String resinsId) {
        return null;
    }

    public AttachFetchResult loadAttach(AttachFetchArgument arg) {
        this.init(arg.getProperties());
        AttachInfo map = this.getAttachInfo(arg.getPointId());
        if (map == null) {
            return null;
        }
        String phyPath = map.getPhyAddress();
        String docName = map.getDocName();
        String extName = map.getExtName();
        String serverName = phyPath.substring(0, phyPath.indexOf("/"));
        String uri = "smb://guest:@" + phyPath.replace(serverName, nameToIpMap.get(serverName));
        String fileName = uri + arg.getPointId();
        AttachFetchResult result = new AttachFetchResult();
        result.setPointId(arg.getPointId());
        result.setFileName(docName);
        result.setPackageCount(Integer.valueOf(1));
        result.setExttype(this.wrapExt(extName, false));
        if (!this.checkExist(fileName) && !this.checkExist(fileName = fileName + this.wrapExt(extName, true))) {
            throw new RuntimeException("\u6ca1\u6709\u5728\u9644\u4ef6\u5e93\u4e2d\u627e\u5230\u6b64\u6587\u4ef6\u3002");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.readFile(fileName, out);
        result.setData(out.toByteArray());
        return result;
    }

    private void readFile(String fileName, OutputStream out) {
        try {
            InputStream is = null;
            SmbFile file = new SmbFile(fileName);
            if (!file.exists()) {
                return;
            }
            is = file.getInputStream();
            int bufferSize = 20480;
            byte[] buffer = new byte[bufferSize];
            try {
                int readCount = is.read(buffer, 0, bufferSize);
                while (readCount > 0) {
                    out.write(buffer, 0, readCount);
                    readCount = is.read(buffer, 0, bufferSize);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            this.log.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25");
        }
    }

    private void deleteFile(String fileName) throws MalformedURLException, SmbException {
        try {
            SmbFile file = new SmbFile(fileName);
            file.delete();
        }
        catch (Exception e) {
            this.log.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25");
            throw e;
        }
    }

    public MobileBoolean deleteAttach(AttachDeleteArgument arg) throws Exception {
        this.init(arg.getProperties());
        AttachInfo map = this.getAttachInfo(arg.getPointid());
        if (map == null) {
            return new MobileBoolean(false);
        }
        String phyPath = map.getPhyAddress();
        String extName = map.getExtName();
        String serverName = phyPath.substring(0, phyPath.indexOf("/"));
        String uri = "smb://guest:@" + phyPath.replace(serverName, nameToIpMap.get(serverName));
        String fileName = uri + arg.getPointid();
        if (!this.checkExist(fileName) && !this.checkExist(fileName = fileName + this.wrapExt(extName, true))) {
            return new MobileBoolean(true);
        }
        this.deleteFile(fileName);
        this.deleteOtherInfo(arg.getPointid());
        this.deleteInfo(new String[]{arg.getPointid()});
        return new MobileBoolean(true);
    }

    public MobileString getAttachPath(String pointId) {
        AttachFetchArgument arg = new AttachFetchArgument();
        arg.setPointId(pointId);
        arg.setFetchAll(true);
        AttachFetchResult result = this.loadAttach(arg);
        String tempFile = "temp" + File.separator + pointId + "." + result.getExttype();
        String filePath = null;
        try {
            filePath = PathFileHelper.getApplicationWritablePath((String)AppContext.getCurrentAppId(), (boolean)true) + tempFile;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file = new File(filePath);
        if (file.exists() && file.length() == (long)result.getFileSize().intValue()) {
            return new MobileString(tempFile);
        }
        try {
            FileUtil.writeFile((File)file, (byte[])result.getData());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new MobileString(tempFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] generateThumbnail(String fileName, String extType) {
        byte[] fileBytes;
        block9: {
            if (AttachHelper.isVideo((String)extType)) {
                return null;
            }
            fileBytes = null;
            try {
                SmbFile file = new SmbFile(fileName);
                InputStream inputStream = file.getInputStream();
                if (!file.exists()) break block9;
                long fileLength = file.length();
                fileBytes = new byte[(int)fileLength];
                try {
                    inputStream.read(fileBytes);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                this.log.error("\u8bfb\u53d6\u8fdc\u7a0b\u6587\u4ef6\u51fa\u9519\u3002", (Throwable)e);
            }
        }
        try {
            if (AttachHelper.isImage((String)extType)) {
                return this.generateImageThumbnail(fileBytes, 110, 110);
            }
        }
        catch (IOException e) {
            this.log.error("\u751f\u6210\u7f29\u7565\u56fe\u51fa\u9519\u3002", (Throwable)e);
        }
        return null;
    }

    protected String reNameTo(String srcFileName, String descFileName) throws MalformedURLException, SmbException {
        this.deleteFile(descFileName);
        try {
            SmbFile file = new SmbFile(srcFileName);
            if (file.exists()) {
                file.renameTo(new SmbFile(descFileName));
            }
        }
        catch (Exception e) {
            this.log.error("\u8bfb\u53d6\u8fdc\u7a0b\u6587\u4ef6\u51fa\u9519\u3002", (Throwable)e);
            return null;
        }
        return descFileName;
    }

    private boolean createDir(String filePath) {
        try {
            SmbFile file = new SmbFile(filePath);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception e) {
            this.log.error("\u521b\u5efa\u6587\u4ef6\u5939" + filePath + "\u5931\u8d25", (Throwable)e);
        }
        return true;
    }

    private boolean checkExist(String fileName) {
        SmbFile file = null;
        try {
            file = new SmbFile(fileName);
            return file.exists();
        }
        catch (Exception e) {
            this.log.error("\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b58\u5728\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    static {
        spareSpace = 0x40000000L;
    }
}

