/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.module.doc.attach;

import cn.hangar.agp.platform.core.ioc.ContextManager;
import cn.hangar.agp.platform.core.log.Logger;
import cn.hangar.agp.service.core.IAttachProvider;
import cn.hangar.agp.service.model.doc.AttachAddArgument;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpHelper {
    private static void connect(FTPClient ftpClient, String hostname, int port, String username, String password) throws Exception {
        Logger.info(FtpHelper.class, (String)("hostname:" + hostname + " port:" + port + " username:" + username + " password:" + password));
        if (port > 0) {
            ftpClient.connect(hostname, port);
        } else {
            ftpClient.connect(hostname);
        }
        if (username != null && !username.isEmpty()) {
            ftpClient.login(username, password);
        }
    }

    public static boolean uploadFile(String hostname, int port, String pathname, String fileName, Consumer<OutputStream> fun) {
        return FtpHelper.uploadFile(hostname, port, null, null, pathname, fileName, fun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uploadFile(String hostname, int port, String username, String password, String pathname, String fileName, Consumer<OutputStream> fun) {
        boolean flag = false;
        FTPClient ftpClient = new FTPClient();
        ftpClient.setControlEncoding("UTF-8");
        try {
            String[] dirs;
            FtpHelper.connect(ftpClient, hostname, port, username, password);
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                boolean bl = flag;
                return bl;
            }
            ftpClient.setFileType(2);
            for (String path : dirs = pathname.split("/")) {
                ftpClient.makeDirectory(path);
                ftpClient.changeWorkingDirectory(path);
            }
            OutputStream out = ftpClient.storeFileStream(fileName);
            if (fun != null) {
                fun.accept(out);
            }
            out.close();
            ftpClient.logout();
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uploadFile(String hostname, int port, String username, String password, String pathname, String fileName, InputStream inputStream) {
        boolean flag = false;
        FTPClient ftpClient = new FTPClient();
        ftpClient.setControlEncoding("UTF-8");
        try {
            String[] dirs;
            FtpHelper.connect(ftpClient, hostname, port, username, password);
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                boolean bl = flag;
                return bl;
            }
            ftpClient.setFileType(2);
            for (String path : dirs = pathname.split("/")) {
                ftpClient.makeDirectory(path);
                ftpClient.changeWorkingDirectory(path);
            }
            ftpClient.storeFile(fileName, inputStream);
            inputStream.close();
            ftpClient.logout();
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    public static boolean uploadFileFromProduction(String hostname, int port, String username, String password, String pathname, String filename, String originfilename) {
        boolean flag = false;
        try {
            FileInputStream inputStream = new FileInputStream(new File(originfilename));
            flag = FtpHelper.uploadFile(hostname, port, username, password, pathname, filename, inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean uploadFileFromProduction(String hostname, int port, String username, String password, String pathname, String originfilename) {
        boolean flag = false;
        try {
            String fileName = new File(originfilename).getName();
            FileInputStream inputStream = new FileInputStream(new File(originfilename));
            flag = FtpHelper.uploadFile(hostname, port, username, password, pathname, fileName, inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean deleteFile(String hostname, int port, String pathname, String filename) {
        return FtpHelper.deleteFile(hostname, port, null, null, pathname, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteFile(String hostname, int port, String username, String password, String pathname, String filename) {
        boolean flag = false;
        FTPClient ftpClient = new FTPClient();
        try {
            String[] dirs;
            FtpHelper.connect(ftpClient, hostname, port, username, password);
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                boolean bl = flag;
                return bl;
            }
            for (String path : dirs = pathname.split("/")) {
                ftpClient.changeWorkingDirectory(path);
            }
            ftpClient.dele(filename);
            ftpClient.logout();
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.logout();
                }
                catch (IOException iOException) {}
            }
        }
        return flag;
    }

    public static void main(String[] args) {
        FtpHelper.downloadFile("192.168.1.18", 21, "admin", "admin", "/", "test", "D:\\");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadFile(String hostname, int port, String username, String password, String pathname, String filename, String localpath) {
        boolean flag = false;
        FTPClient ftpClient = new FTPClient();
        try {
            FTPFile[] ftpFiles;
            String[] dirs;
            FtpHelper.connect(ftpClient, hostname, port, username, password);
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                boolean bl = flag;
                return bl;
            }
            for (String path : dirs = pathname.split("/")) {
                ftpClient.changeWorkingDirectory(path);
            }
            ftpClient.enterLocalPassiveMode();
            for (FTPFile file : ftpFiles = ftpClient.listFiles()) {
                if (!filename.equalsIgnoreCase(file.getName())) continue;
                File localFile = new File(localpath + "/" + file.getName());
                FileOutputStream os = new FileOutputStream(localFile);
                ftpClient.retrieveFile(file.getName(), (OutputStream)os);
                ((OutputStream)os).close();
                break;
            }
            ftpClient.logout();
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.logout();
                }
                catch (IOException iOException) {}
            }
        }
        return flag;
    }

    public static boolean downloadFile(String hostname, int port, String pathname, String filename, Consumer<InputStream> fun) {
        return FtpHelper.downloadFile(hostname, port, null, null, pathname, filename, fun);
    }

    public static Map<String, String> downloadFileAndAddAttach(String hostname, String port, String username, String password, String pathname, String filename) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        int temp = Integer.parseInt(port);
        FtpHelper.downloadFile(hostname, temp, username, password, pathname, filename, (InputStream in) -> {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int bufferSize = 20480;
            byte[] buffer = new byte[bufferSize];
            try {
                int readCount = in.read(buffer, 0, bufferSize);
                while (readCount > 0) {
                    out.write(buffer, 0, readCount);
                    readCount = in.read(buffer, 0, bufferSize);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            IAttachProvider attachProvider = (IAttachProvider)ContextManager.find((String)"file_attach", IAttachProvider.class);
            AttachAddArgument attachAddArgument = new AttachAddArgument();
            attachAddArgument.setFileName(filename);
            attachAddArgument.setData(out.toByteArray());
            attachAddArgument.setFileSize(out.size());
            attachAddArgument.setPointId(UUID.randomUUID().toString());
            attachAddArgument.setPackageCount(1);
            try {
                String pointId = attachProvider.addAttach(attachAddArgument).getData();
                resultMap.put("documentId", pointId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadFile(String hostname, int port, String username, String password, String pathname, String filename, Consumer<InputStream> fun) {
        boolean flag = false;
        FTPClient ftpClient = new FTPClient();
        try {
            FTPFile[] ftpFiles;
            FtpHelper.connect(ftpClient, hostname, port, username, password);
            int replyCode = ftpClient.getReplyCode();
            Logger.info(FtpHelper.class, (String)("replyCode:" + replyCode));
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                boolean bl = flag;
                return bl;
            }
            ftpClient.changeWorkingDirectory(pathname);
            ftpClient.enterLocalPassiveMode();
            for (FTPFile file : ftpFiles = ftpClient.listFiles()) {
                Logger.info(FtpHelper.class, (String)("\u67e5\u8be2\u5230\u6587\u4ef6:" + file.getName()));
                if (!filename.equalsIgnoreCase(file.getName())) continue;
                InputStream ins = ftpClient.retrieveFileStream(file.getName());
                if (fun != null) {
                    fun.accept(ins);
                }
                ins.close();
                break;
            }
            ftpClient.logout();
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.logout();
                }
                catch (IOException iOException) {}
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkFileExit(String hostname, int port, String username, String password, String pathname, String filename) {
        boolean flag = false;
        FTPClient ftpClient = new FTPClient();
        try {
            FTPFile[] ftpFiles;
            String[] dirs;
            FtpHelper.connect(ftpClient, hostname, port, username, password);
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                boolean bl = flag;
                return bl;
            }
            for (String path : dirs = pathname.split("/")) {
                ftpClient.changeWorkingDirectory(path);
            }
            ftpClient.enterLocalPassiveMode();
            for (FTPFile file : ftpFiles = ftpClient.listFiles()) {
                if (!filename.equalsIgnoreCase(file.getName())) continue;
                flag = true;
                break;
            }
            ftpClient.logout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.logout();
                }
                catch (IOException iOException) {}
            }
        }
        return flag;
    }
}

