/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.module.doc.attach;

import cn.hangar.agp.module.doc.attach.AttachProvider;
import cn.hangar.agp.module.doc.attach.FtpHelper;
import cn.hangar.agp.module.doc.attach.dao.IFileInfoRepository;
import cn.hangar.agp.platform.core.app.PathFileHelper;
import cn.hangar.agp.platform.core.app.SysException;
import cn.hangar.agp.platform.core.data.MobileBoolean;
import cn.hangar.agp.platform.core.data.MobileString;
import cn.hangar.agp.platform.utils.Convert;
import cn.hangar.agp.platform.utils.DateUtil;
import cn.hangar.agp.platform.utils.FileUtil;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.util.AppHelper;
import cn.hangar.agp.service.model.doc.AttachAddArgument;
import cn.hangar.agp.service.model.doc.AttachDeleteArgument;
import cn.hangar.agp.service.model.doc.AttachFetchArgument;
import cn.hangar.agp.service.model.doc.AttachFetchImageArgument;
import cn.hangar.agp.service.model.doc.AttachFetchResult;
import cn.hangar.agp.service.model.doc.AttachInfo;
import cn.hangar.agp.service.model.doc.AttachUpdateArgument;
import cn.hangar.agp.service.model.doc.SysAttach;
import cn.hangar.agp.service.model.doc.SysResDoc;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="ftp_attach")
@Scope(value="prototype")
public class FtpAttachProvider
extends AttachProvider {
    @Autowired
    IFileInfoRepository fileInfoRepository;

    @Override
    protected IFileInfoRepository getFileInfoRepository() {
        return this.fileInfoRepository;
    }

    public MobileString addAttach(AttachAddArgument arg) throws Exception {
        try {
            String path = PathFileHelper.getApplicationWritablePath((String)arg.getAppId(), (boolean)true, (String[])new String[]{"upload", arg.getPointId()});
            String tempFile = path + arg.getPackageNumber();
            FileUtil.writeFile((String)tempFile, (byte[])arg.getData());
            String ftpFileName = arg.getPointId();
            if (FileUtil.getFiles((String)path).length == arg.getPackageCount()) {
                String desPath = arg.getPappid() + "/" + DateUtil.formatDate((Date)new Date(), (String)"yyyyMM");
                FtpHelper.uploadFile(this.getFtpHost(arg.getProperties()), this.getFtpPort(arg.getProperties()), this.getUserName(arg.getProperties()), this.getPassword(arg.getProperties()), desPath, ftpFileName, out -> {
                    try {
                        for (int i = 0; i < arg.getPackageCount(); ++i) {
                            Files.copy(Paths.get(path + i, new String[0]), out);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                FileUtil.deleteDir((String)path);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FtpHelper.downloadFile(this.getFtpHost(arg.getProperties()), this.getFtpPort(arg.getProperties()), this.getUserName(arg.getProperties()), this.getPassword(arg.getProperties()), desPath, ftpFileName, in -> {
                    int bufferSize = 20480;
                    byte[] buffer = new byte[bufferSize];
                    try {
                        int readCount = in.read(buffer, 0, bufferSize);
                        while (readCount > 0) {
                            baos.write(buffer, 0, readCount);
                            readCount = in.read(buffer, 0, bufferSize);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                byte[] thumb = this.generateThumbnail(baos.toByteArray(), this.wrapExt(FileUtil.getExtension((String)arg.getFileName()), false));
                this.insertFileInfo(arg, thumb);
                if (arg.isInsertDoc()) {
                    this.insertResDoc(arg);
                }
            }
            return new MobileString(arg.getPointId());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public MobileBoolean updateAttach(AttachUpdateArgument arg) {
        throw SysException.unsupportedProvd();
    }

    public MobileString addTempFile(AttachAddArgument arg) {
        throw SysException.unsupportedProvd();
    }

    public MobileString getAttachPath(String pointId) {
        throw SysException.unsupportedProvd();
    }

    public List<SysResDoc> getSysResDocInfo(String resId, String resinsId) {
        return null;
    }

    public AttachFetchResult loadAttach(AttachFetchArgument arg) {
        AttachInfo attachInfo = this.getAttachInfo(arg.getPointId());
        if (attachInfo == null) {
            return null;
        }
        String pathName = arg.getPappid();
        if (!StringUtils.isEmpty((String)attachInfo.getCatlog()) && attachInfo.getCatlog().trim().length() == 6) {
            pathName = pathName + "/" + attachInfo.getCatlog().trim();
        }
        String ftpFileName = arg.getPointId();
        if (!FtpHelper.checkFileExit(this.getFtpHost(arg.getProperties()), this.getFtpPort(arg.getProperties()), this.getUserName(arg.getProperties()), this.getPassword(arg.getProperties()), pathName, ftpFileName)) {
            ftpFileName = ftpFileName + this.wrapExt(attachInfo.getExtName(), true);
        }
        AttachFetchResult result = new AttachFetchResult();
        result.setPointId(arg.getPointId());
        result.setFileName(attachInfo.getDocName());
        result.setPackageCount(Integer.valueOf(1));
        result.setExttype(this.wrapExt(attachInfo.getExtName(), false));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FtpHelper.downloadFile(this.getFtpHost(arg.getProperties()), this.getFtpPort(arg.getProperties()), this.getUserName(arg.getProperties()), this.getPassword(arg.getProperties()), pathName, ftpFileName, in -> {
            int bufferSize = 20480;
            byte[] buffer = new byte[bufferSize];
            try {
                int readCount = in.read(buffer, 0, bufferSize);
                while (readCount > 0) {
                    out.write(buffer, 0, readCount);
                    readCount = in.read(buffer, 0, bufferSize);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        result.setData(out.toByteArray());
        return result;
    }

    @Override
    public AttachFetchResult loadAttachImage(AttachFetchImageArgument argument) {
        AttachFetchArgument arg = new AttachFetchArgument();
        arg.setPointId(argument.getPointId());
        arg.setPackageNumber(-1);
        arg.setRefId(argument.getRefId());
        arg.setRefAId(argument.getRefAId());
        arg.setPappid(AppHelper.getParentAppIdWithBrh((String)argument.getAppid()));
        arg.setAttachType(argument.getAttachType());
        arg.setProperties(argument.getProperties());
        AttachFetchResult result = this.loadAttach(arg);
        if (result != null && !SysAttach.canGenerateThumbnail((String)result.getExttype().toLowerCase())) {
            result.setData(null);
        }
        return result;
    }

    public MobileBoolean deleteAttach(AttachDeleteArgument arg) throws Exception {
        AttachInfo attachInfo = this.getAttachInfo(arg.getPointid());
        if (attachInfo == null) {
            return null;
        }
        String pathName = arg.getPappid();
        if (!StringUtils.isEmpty((String)attachInfo.getCatlog()) && attachInfo.getCatlog().trim().length() == 6) {
            pathName = pathName + "/" + attachInfo.getCatlog().trim();
        }
        String ftpFileName = arg.getPointid();
        if (!FtpHelper.checkFileExit(this.getFtpHost(arg.getProperties()), this.getFtpPort(arg.getProperties()), this.getUserName(arg.getProperties()), this.getPassword(arg.getProperties()), pathName, ftpFileName)) {
            ftpFileName = ftpFileName + this.wrapExt(attachInfo.getExtName(), true);
        }
        FtpHelper.deleteFile(this.getFtpHost(arg.getProperties()), this.getFtpPort(arg.getProperties()), this.getUserName(arg.getProperties()), this.getPassword(arg.getProperties()), pathName, ftpFileName);
        this.deleteOtherInfo(arg.getPointid());
        return new MobileBoolean(true);
    }

    private String getFtpHost(Map<String, String> properties) {
        String host = this.getProperty(properties, "ftp.attach.host");
        return host;
    }

    private int getFtpPort(Map<String, String> properties) {
        String port = this.getProperty(properties, "ftp.attach.port");
        return Convert.toInt((Object)port);
    }

    private String getUserName(Map<String, String> properties) {
        String userName = this.getProperty(properties, "ftp.attach.username");
        return userName;
    }

    private String getPassword(Map<String, String> properties) {
        String password = this.getProperty(properties, "ftp.attach.password");
        return password;
    }
}

