/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.module.doc.attach;

import cn.hangar.agp.module.doc.attach.AttachProvider;
import cn.hangar.agp.module.doc.attach.dao.IFileInfoRepository;
import cn.hangar.agp.platform.core.app.AppContext;
import cn.hangar.agp.platform.core.app.AppException;
import cn.hangar.agp.platform.core.app.PathFileHelper;
import cn.hangar.agp.platform.core.data.FileItem;
import cn.hangar.agp.platform.core.data.MobileBoolean;
import cn.hangar.agp.platform.core.data.MobileString;
import cn.hangar.agp.platform.core.ioc.ContextManager;
import cn.hangar.agp.platform.utils.DateUtil;
import cn.hangar.agp.platform.utils.FileUtil;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.VideoService;
import cn.hangar.agp.service.core.util.AppHelper;
import cn.hangar.agp.service.core.util.AttachHelper;
import cn.hangar.agp.service.model.doc.AttachAddArgument;
import cn.hangar.agp.service.model.doc.AttachDeleteArgument;
import cn.hangar.agp.service.model.doc.AttachFetchArgument;
import cn.hangar.agp.service.model.doc.AttachFetchResult;
import cn.hangar.agp.service.model.doc.AttachInfo;
import cn.hangar.agp.service.model.doc.AttachUpdateArgument;
import cn.hangar.agp.service.model.doc.SysAttach;
import cn.hangar.agp.service.model.doc.SysResDoc;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileOutputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="file_attach")
@Scope(value="prototype")
public class FileAttachProvider
extends AttachProvider {
    private static final Lock lockObj = new ReentrantLock();
    @Autowired
    IFileInfoRepository fileInfoRepository;

    @Override
    protected IFileInfoRepository getFileInfoRepository() {
        return this.fileInfoRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MobileBoolean updateAttach(AttachUpdateArgument arg) {
        AttachInfo attachInfo = this.getAttachInfo(arg.getPointId());
        String fileName = null;
        String bakFileName = null;
        if (!StringUtils.isEmpty((String)attachInfo.getCatlog()) && attachInfo.getCatlog().trim().length() == 6) {
            fileName = AttachHelper.getUrl(null, (String)arg.getPappid(), (Map)arg.getProperties()) + attachInfo.getCatlog() + "/" + arg.getPointId();
            bakFileName = AttachHelper.getUrl(null, (String)arg.getPappid(), (Map)arg.getProperties()) + attachInfo.getCatlog() + "/" + arg.getPointId() + "_bak";
        } else {
            fileName = AttachHelper.getUrl(null, (String)arg.getPappid(), (Map)arg.getProperties()) + arg.getPointId();
            bakFileName = AttachHelper.getUrl(null, (String)arg.getPappid(), (Map)arg.getProperties()) + arg.getPointId() + "_bak";
        }
        this.reNameTo(fileName, bakFileName);
        OutputStream outs = null;
        try {
            if (fileName.startsWith("smb:")) {
                SmbFile file = new SmbFile(fileName);
                if (!file.exists()) {
                    file.createNewFile();
                }
                outs = new SmbFileOutputStream(file, true);
            } else {
                outs = new FileOutputStream(fileName, true);
            }
            outs.write(arg.getData());
            if (this.checkExist(fileName)) {
                byte[] thumb = this.generateThumbnail(fileName, this.wrapExt(FileUtil.getExtension((String)arg.getFileName()), false));
                this.updateFileInfo(attachInfo, arg, thumb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MobileBoolean mobileBoolean = new MobileBoolean(false);
            return mobileBoolean;
        }
        finally {
            try {
                outs.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new MobileBoolean(true);
    }

    public boolean createNewFile(String filePath) {
        if (filePath.startsWith("smb:")) {
            try {
                SmbFile file = new SmbFile(filePath);
                file.createNewFile();
                return true;
            }
            catch (Exception e) {
                this.log.error("\u65b0\u5efa\u6587\u4ef6:" + filePath + "\u5931\u8d25\u3002");
            }
        }
        FileUtil.createFile((String)filePath);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MobileString addAttach(final AttachAddArgument arg) throws Exception {
        if (StringUtils.isNotBlank((String)arg.getFilePath())) {
            arg.setFilePath(URLDecoder.decode(arg.getFilePath(), "UTF-8"));
        }
        String uri = AttachHelper.getUrl((String)arg.getRefId(), (String)arg.getPappid(), (Map)arg.getProperties()) + DateUtil.formatDate((Date)new Date(), (String)"yyyyMM") + "/";
        String ftpFileName = uri + this.getFileSubPath(arg.getFilePath());
        this.createDir(ftpFileName);
        ftpFileName = ftpFileName + arg.getPointId();
        String path = PathFileHelper.getApplicationWritablePath((String)arg.getAppId(), (boolean)true, (String[])new String[]{"upload", arg.getPointId()});
        try {
            lockObj.lock();
            String tempFile = path + arg.getPackageNumber();
            if (!FileUtil.checkExist((String)tempFile)) {
                if (StringUtils.isBlank((String)arg.getTempFilePath())) {
                    FileUtil.writeFile((String)tempFile, (byte[])arg.getData());
                } else {
                    FileUtil.copyFile((String)arg.getTempFilePath(), (String)tempFile);
                }
            }
            if (FileUtil.getFiles((String)path).length == arg.getPackageCount()) {
                try {
                    if (ftpFileName.startsWith("smb:")) {
                        SmbFile file = new SmbFile(ftpFileName);
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        try (OutputStream outs = null;){
                            outs = new SmbFileOutputStream(file, true);
                            for (int i = 0; i < arg.getPackageCount(); ++i) {
                                Files.copy(Paths.get(path + i, new String[0]), outs);
                            }
                        }
                    }
                    try (FileOutputStream fos = null;){
                        fos = new FileOutputStream(ftpFileName, true);
                        for (int i = 0; i < arg.getPackageCount(); ++i) {
                            Files.copy(Paths.get(path + i, new String[0]), fos);
                        }
                    }
                    if (this.checkExist(ftpFileName)) {
                        byte[] thumb = this.generateThumbnail(ftpFileName, this.wrapExt(FileUtil.getExtension((String)arg.getFileName()), false));
                        boolean fileInsertReusutl = this.insertFileInfo(arg, thumb);
                        if (fileInsertReusutl && arg.isInsertDoc()) {
                            this.log.info("\u5f00\u59cb\u63d2\u5165doc\u8868:" + arg.getFileName());
                            this.insertResDoc(arg);
                        } else {
                            this.log.info("\u65e0\u63d2\u5165doc\u8868:" + arg.getFileName() + " " + fileInsertReusutl + " " + arg.isInsertDoc());
                        }
                        if (FileItem.isvideo((String)arg.getFileName())) {
                            final AppContext appContext = AppContext.Current();
                            executor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    AppContext.setCurrent((AppContext)appContext);
                                    try {
                                        FileAttachProvider.this.transVideo(arg);
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                        } else {
                            FileUtil.deleteDir((String)path);
                        }
                    } else {
                        FileUtil.deleteDir((String)path);
                    }
                }
                catch (Exception e) {
                    if (FileUtil.checkExist((String)ftpFileName)) {
                        FileUtil.deleteFile((String)ftpFileName);
                    }
                    FileUtil.deleteDir((String)path);
                    this.log.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            MobileString mobileString = new MobileString(arg.getPointId());
            return mobileString;
        }
        catch (Exception e) {
            if (FileUtil.checkExist((String)ftpFileName)) {
                FileUtil.deleteFile((String)ftpFileName);
            }
            FileUtil.deleteDir((String)path);
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            lockObj.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transVideo(AttachAddArgument arg) throws IOException {
        String path = PathFileHelper.getApplicationWritablePath((String)arg.getAppId(), (boolean)true, (String[])new String[]{"upload", arg.getPointId()});
        String tempPath = path + "temp";
        if (!FileUtil.checkExist((String)tempPath)) {
            FileUtil.createFile((String)tempPath);
            try (FileOutputStream fos = null;){
                fos = new FileOutputStream(tempPath, true);
                for (int i = 0; i < arg.getPackageCount(); ++i) {
                    Files.copy(Paths.get(path + i, new String[0]), fos);
                }
            }
        }
        AttachInfo attachInfo = new AttachInfo();
        attachInfo.setDocId(arg.getPointId());
        attachInfo.setFileStatus(1);
        this.fileInfoRepository.updateAttachStatus(attachInfo);
        VideoService videoService = (VideoService)ContextManager.find(VideoService.class);
        String resultPath = videoService.transMedia(arg.getPointId(), tempPath);
        if (StringUtils.isNotBlank((String)resultPath)) {
            FileOutputStream fos = null;
            OutputStream outs = null;
            try {
                File sourceFile = new File(resultPath);
                File[] files = sourceFile.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    String mediaPath = AttachHelper.getUrl((String)arg.getRefId(), (String)arg.getPappid(), (Map)arg.getProperties()) + "media/" + arg.getPointId() + "/";
                    this.createDir(mediaPath);
                    mediaPath = mediaPath + files[i].getName();
                    if (mediaPath.startsWith("smb:")) {
                        SmbFile file1 = new SmbFile(mediaPath);
                        if (!file1.exists()) {
                            file1.createNewFile();
                        }
                        outs = new SmbFileOutputStream(file1, true);
                        Files.copy(Paths.get(files[i].getPath(), new String[0]), outs);
                        continue;
                    }
                    fos = new FileOutputStream(mediaPath, true);
                    Files.copy(Paths.get(files[i].getPath(), new String[0]), fos);
                }
                attachInfo.setFileStatus(2);
                this.fileInfoRepository.updateAttachStatus(attachInfo);
            }
            catch (IOException e) {
                attachInfo.setFileStatus(-1);
                this.fileInfoRepository.updateAttachStatus(attachInfo);
                e.printStackTrace();
            }
            finally {
                FileUtil.deleteDir((String)path);
                if (fos != null) {
                    fos.close();
                }
                if (outs != null) {
                    outs.close();
                }
            }
        }
    }

    public MobileString addTempFile(AttachAddArgument arg) {
        try {
            String path = PathFileHelper.getApplicationWritablePath((String)arg.getAppId(), (boolean)true, (String[])new String[]{"upload", arg.getPointId()});
            String tempFile = path + arg.getPackageNumber();
            FileUtil.writeFile((String)tempFile, (byte[])arg.getData());
            String destPath = PathFileHelper.getApplicationWritablePath((String)arg.getAppId(), (boolean)true, (String[])new String[]{"temp"});
            String ftpFileName = destPath + arg.getPointId() + "." + FileUtil.getExtension((String)arg.getFileName());
            if (FileUtil.getFiles((String)path).length == arg.getPackageCount()) {
                FileUtil.writeFile((String)ftpFileName, out -> {
                    try {
                        for (int i = 0; i < arg.getPackageCount(); ++i) {
                            Files.copy(Paths.get(path + i, new String[0]), out);
                        }
                    }
                    catch (IOException e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                this.log.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                });
                FileUtil.deleteDir((String)path);
            }
            return new MobileString(arg.getPointId() + "." + FileUtil.getExtension((String)arg.getFileName()));
        }
        catch (IOException e) {
            throw new AppException((Throwable)e);
        }
    }

    public List<SysResDoc> getSysResDocInfo(String resId, String resinsId) {
        SysResDoc sysResDoc = new SysResDoc();
        sysResDoc.setResId(resId);
        sysResDoc.setResInsId(resinsId);
        return this.fileInfoRepository.getSysResDocById(sysResDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttachFetchResult loadAttach(AttachFetchArgument arg) {
        String appid = arg.getPappid() == null ? AppHelper.getParentAppIdWithBrh((String)AppContext.getCurrentAppId()) : arg.getPappid();
        String uri = AttachHelper.getUrl((String)arg.getRefId(), (String)appid, (Map)arg.getProperties());
        AttachInfo attachInfo = this.getAttachInfo(arg.getPointId());
        if (attachInfo == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)attachInfo.getCatlog()) && attachInfo.getCatlog().trim().length() == 6) {
            uri = uri + attachInfo.getCatlog().trim() + "/";
        }
        String ftpFileName = uri + this.getFileSubPath(attachInfo.getFullPath()) + arg.getPointId();
        AttachFetchResult result = new AttachFetchResult();
        result.setPointId(arg.getPointId());
        result.setFileName(attachInfo.getDocName());
        result.setPackageCount(Integer.valueOf(1));
        result.setExttype(this.wrapExt(attachInfo.getExtName(), false));
        if (!this.checkExist(ftpFileName)) {
            if (StringUtils.isNotBlank((String)arg.getFilePath()) && !arg.getFilePath().equals(attachInfo.getFullPath())) {
                ftpFileName = uri + this.getFileSubPath(arg.getFilePath()) + arg.getPointId();
            }
            if (!this.checkExist(ftpFileName) && !this.checkExist(ftpFileName = ftpFileName + this.wrapExt(attachInfo.getExtName(), true))) {
                throw new AppException("\u9644\u4ef6\u5e93\u65e0\u6b64\u6587\u4ef6\u3002" + ftpFileName);
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.readFile(ftpFileName, out);
            result.setData(out.toByteArray());
            result.setFileSize(Integer.valueOf(out.size()));
            result.setFullPath(attachInfo.getFullPath());
        }
        finally {
            FileUtil.close((Closeable)out);
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private void readFile(String fileName, OutputStream out) {
        block8: {
            is = null;
            if (!fileName.startsWith("smb:")) ** GOTO lbl12
            file = new SmbFile(fileName);
            if (file.exists()) break block8;
            FileUtil.close((Closeable)is);
            return;
        }
        try {
            block10: {
                is = file.getInputStream();
                break block10;
lbl12:
                // 1 sources

                is = new FileInputStream(fileName);
            }
            bufferSize = 20480;
            buffer = new byte[bufferSize];
            try {
                readCount = is.read(buffer, 0, bufferSize);
                while (readCount > 0) {
                    out.write(buffer, 0, readCount);
                    readCount = is.read(buffer, 0, bufferSize);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            try {
                throw new AppException((Throwable)e);
            }
            catch (Throwable var8_10) {
                FileUtil.close(is);
                throw var8_10;
            }
        }
        FileUtil.close((Closeable)is);
    }

    private void deleteFile(String fileName) {
        try {
            if (fileName.startsWith("smb:")) {
                SmbFile file = new SmbFile(fileName);
                if (file.exists()) {
                    file.delete();
                }
            } else {
                FileUtil.deleteFile((String)fileName);
            }
            this.log.info("\u5df2\u5220\u9664\u9644\u4ef6: " + fileName);
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
    }

    public MobileBoolean deleteAttach(AttachDeleteArgument arg) {
        if (StringUtils.isBlank((String)arg.getPointid())) {
            return MobileBoolean.TRUE;
        }
        String[] pointIds = arg.getPointid().split(",");
        List<AttachInfo> attachInfos = this.getAttachInfo(pointIds);
        if (attachInfos == null || attachInfos.size() < 1) {
            return MobileBoolean.TRUE;
        }
        String tempUrl = AttachHelper.getUrl((String)arg.getRefId(), (String)arg.getPappid(), (Map)arg.getProperties());
        for (AttachInfo attachInfo : attachInfos) {
            String ftpFileName;
            String pointId = attachInfo.getDocId();
            String uri = tempUrl;
            if (!StringUtils.isEmpty((String)attachInfo.getCatlog()) && attachInfo.getCatlog().trim().length() == 6) {
                uri = uri + attachInfo.getCatlog().trim() + "/";
            }
            if (!this.checkExist(ftpFileName = uri + pointId + this.wrapExt(attachInfo.getExtName(), true))) {
                ftpFileName = uri + pointId;
            }
            this.deleteFile(ftpFileName);
        }
        this.deleteInfo(pointIds);
        return new MobileBoolean(true);
    }

    public MobileString getAttachPath(String pointId) {
        AttachFetchArgument arg = new AttachFetchArgument();
        arg.setPointId(pointId);
        arg.setFetchAll(true);
        AttachFetchResult result = this.loadAttach(arg);
        String tempFile = "temp" + File.separator + pointId + "." + result.getExttype();
        String filePath = null;
        try {
            filePath = PathFileHelper.getApplicationWritablePath((String)AppContext.getCurrentAppId(), (boolean)true) + tempFile;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file = new File(filePath);
        if (file.exists() && file.length() == (long)result.getFileSize().intValue()) {
            return new MobileString(tempFile);
        }
        try {
            String tempPath = PathFileHelper.getApplicationWritablePath((String)AppContext.getCurrentAppId(), (boolean)true) + "temp";
            if (!FileUtil.checkDirExist((String)tempPath)) {
                FileUtil.createDirectory((String)tempPath);
            }
            FileUtil.writeFile((File)file, (byte[])result.getData());
        }
        catch (IOException e) {
            throw new AppException((Throwable)e);
        }
        return new MobileString(tempFile);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public byte[] generateThumbnail(String fileName, String extType) {
        if (!SysAttach.isImage((String)extType)) {
            return null;
        }
        fileBytes = null;
        if (fileName.startsWith("smb:")) {
            is = null;
            try {
                file = new SmbFile(fileName);
                if (!file.exists()) ** GOTO lbl25
                fileLength = file.length();
                fileBytes = new byte[(int)fileLength];
                is = file.getInputStream();
                is.read(fileBytes);
            }
            catch (Exception e) {
                throw new AppException((Throwable)e);
            }
            finally {
                FileUtil.close(is);
            }
        } else {
            try {
                fileBytes = Files.readAllBytes(Paths.get(fileName, new String[0]));
            }
            catch (IOException e) {
                throw new AppException((Throwable)e);
            }
        }
lbl25:
        // 3 sources

        try {
            return this.generateImageThumbnail(fileBytes, 110, 110);
        }
        catch (IOException e) {
            throw new AppException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String reNameTo(String srcFileName, String descFileName) {
        this.deleteFile(descFileName);
        if (srcFileName.startsWith("smb:")) {
            try {
                SmbFile file = new SmbFile(srcFileName);
                if (!file.exists()) return descFileName;
                file.renameTo(new SmbFile(descFileName));
                return descFileName;
            }
            catch (Exception e) {
                throw new AppException((Throwable)e);
            }
        }
        try {
            File file = new File(srcFileName);
            file.renameTo(new File(descFileName));
            return descFileName;
        }
        catch (Exception e) {
            throw new AppException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean createDir(String filePath) {
        if (filePath.startsWith("smb:")) {
            try {
                SmbFile file = new SmbFile(filePath);
                if (file.exists()) return true;
                file.mkdirs();
                return true;
            }
            catch (Exception e) {
                throw new AppException((Throwable)e);
            }
        } else {
            if (FileUtil.checkExist((String)filePath)) return true;
            FileUtil.createDirectory((String)filePath);
        }
        return true;
    }

    private boolean checkExist(String fileName) {
        if (fileName.startsWith("smb:")) {
            try {
                SmbFile file = new SmbFile(fileName);
                return file.exists();
            }
            catch (Exception e) {
                this.log.error("\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u5b58\u5728\u51fa\u9519", (Throwable)e);
            }
        } else {
            return FileUtil.checkExist((String)fileName);
        }
        return false;
    }

    protected String getFileSubPath(String path) {
        if (StringUtils.isNotBlank((String)path)) {
            String subPath;
            try {
                subPath = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                subPath = path;
            }
            if (subPath.startsWith("/")) {
                subPath = subPath.substring(1);
            }
            if (!subPath.endsWith("/")) {
                subPath = subPath + "/";
            }
            return subPath;
        }
        return "";
    }
}

