/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.module.doc.attach;

import cn.hangar.agp.module.doc.attach.AttachProvider;
import cn.hangar.agp.module.doc.attach.dao.IFileInfoRepository;
import cn.hangar.agp.module.doc.attach.dao.ISysAttachRepository;
import cn.hangar.agp.platform.core.app.AppContext;
import cn.hangar.agp.platform.core.app.AppException;
import cn.hangar.agp.platform.core.app.PathFileHelper;
import cn.hangar.agp.platform.core.app.SysException;
import cn.hangar.agp.platform.core.data.MobileBoolean;
import cn.hangar.agp.platform.core.data.MobileString;
import cn.hangar.agp.platform.core.db.transaction.DataSourceTransactionScope;
import cn.hangar.agp.platform.utils.CollectionUtil;
import cn.hangar.agp.platform.utils.FileUtil;
import cn.hangar.agp.platform.utils.GeneralUtil;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.util.DbHelper;
import cn.hangar.agp.service.model.doc.AttachAddArgument;
import cn.hangar.agp.service.model.doc.AttachDeleteArgument;
import cn.hangar.agp.service.model.doc.AttachFetchArgument;
import cn.hangar.agp.service.model.doc.AttachFetchResult;
import cn.hangar.agp.service.model.doc.AttachInfo;
import cn.hangar.agp.service.model.doc.AttachUpdateArgument;
import cn.hangar.agp.service.model.doc.SysAttach;
import cn.hangar.agp.service.model.doc.SysAttachChunk;
import cn.hangar.agp.service.model.doc.SysResDoc;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="db_attach")
@Scope(value="prototype")
public class DbAttachProvider
extends AttachProvider {
    private Map<String, TempFileInfo> fileSizeMap = new ConcurrentHashMap<String, TempFileInfo>();
    private Lock lock = new ReentrantLock();
    @Autowired
    IFileInfoRepository fileInfoRepository;
    @Autowired
    ISysAttachRepository attachRepository;

    @Override
    protected IFileInfoRepository getFileInfoRepository() {
        return this.fileInfoRepository;
    }

    @Override
    public AttachInfo getAttachInfo(String pointId) {
        SysAttach attach = this.attachRepository.getAttachInfoById(pointId);
        if (attach != null) {
            AttachInfo info = new AttachInfo();
            info.setDocName(attach.getFileName());
            info.setDocId(attach.getPointId());
            info.setDocSize(attach.getFileSize().intValue());
            info.setExtName(attach.getExttype());
            info.setThumbnail(attach.getThumbnail());
            return info;
        }
        return null;
    }

    public List<SysResDoc> getSysResDocInfo(String resId, String resinsId) {
        return null;
    }

    public AttachFetchResult loadAttach(AttachFetchArgument arg) {
        if (arg.isOnlyInfo()) {
            AttachInfo attachInfo = this.getAttachInfo(arg.getPointId());
            if (attachInfo == null) {
                return null;
            }
            return this.generateOnlyAttachInfoResult(arg, attachInfo);
        }
        AttachFetchResult result = new AttachFetchResult();
        result.setPointId(arg.getPointId());
        result.setPackageNumber(Integer.valueOf(arg.getPackageNumber()));
        if (arg.getPackageNumber() == -1 || arg.isFetchAll()) {
            SysAttach attachInfo = this.attachRepository.getAttachInfoById(arg.getPointId());
            if (attachInfo == null) {
                return null;
            }
            result.setFileName(attachInfo.getFileName());
            result.setFileSize(attachInfo.getFileSize());
            result.setExttype(attachInfo.getExttype());
            result.setData(attachInfo.getFileBody());
            result.setPackageCount(Integer.valueOf(attachInfo.getChunks()));
            if (arg.isFetchAll() && result.getPackageCount() > 1) {
                result.setData(new byte[result.getFileSize().intValue()]);
                List<Object> list = this.attachRepository.getAttachChunkData(arg.getPointId());
                int readLength = 0;
                for (Object obj : list) {
                    byte[] bts = DbHelper.bolbToBytes((Object)obj);
                    if (bts == null) continue;
                    CollectionUtil.arraycopy((byte[])bts, (int)0, (byte[])result.getData(), (int)readLength, (int)bts.length);
                    readLength += bts.length;
                }
            }
        } else {
            Object obj = this.attachRepository.getAttachChunkDataByOrder(arg.getPointId(), arg.getPackageNumber());
            result.setData(DbHelper.bolbToBytes((Object)obj));
        }
        return result;
    }

    @Override
    public SysAttach loadAttachThumbnail(String pointId) {
        return this.attachRepository.getAttachInfoById(pointId);
    }

    public synchronized MobileString addAttach(AttachAddArgument arg) throws Exception {
        try (DataSourceTransactionScope scope = new DataSourceTransactionScope();){
            String extType = FileUtil.getExtension((String)arg.getFileName());
            if (!StringUtils.isEmpty((String)extType)) {
                extType = StringUtils.trimStart((String)extType, (char)'.');
            }
            byte[] thumb = null;
            boolean complete = false;
            if (arg.getPackageCount() > 1) {
                if (this.fileSizeMap.get(arg.getPointId()) == null) {
                    this.fileSizeMap.put(arg.getPointId(), new TempFileInfo());
                }
                TempFileInfo info = this.fileSizeMap.get(arg.getPointId());
                info.plus();
                info.addSize(arg.getFileSize());
                String path = null;
                try {
                    path = PathFileHelper.getApplicationWritablePath((String)arg.getAppId(), (boolean)true, (String[])new String[]{"upload", arg.getPointId()});
                    String pathFile = path + arg.getPackageNumber();
                    Files.write(Paths.get(pathFile, new String[0]), arg.getData(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                }
                catch (IOException e) {
                    throw new AppException((Throwable)e);
                }
                if (info.getNum() == arg.getPackageCount()) {
                    String fileName = path + arg.getPointId();
                    if (!FileUtil.checkExist((String)fileName)) {
                        FileUtil.createFile((String)fileName);
                    }
                    FileUtil.combineFile((String)path, (int)arg.getPackageCount(), (String)fileName);
                    if (FileUtil.checkExist((String)fileName)) {
                        thumb = this.generateThumbnail(fileName, extType);
                        FileUtil.deleteFile((String)fileName);
                    }
                    FileUtil.deleteDir((String)path);
                    this.fileSizeMap.remove(arg.getPointId());
                    SysAttach attach = new SysAttach();
                    attach.setPointId(arg.getPointId());
                    attach.setFileName(arg.getFileName());
                    attach.setFileSize(Integer.valueOf(info.getFileSize()));
                    attach.setExttype(extType);
                    attach.setChunks(arg.getPackageCount());
                    attach.setThumbnail(thumb);
                    this.attachRepository.insertAttachInfo(attach);
                    complete = true;
                }
                SysAttachChunk chunk = new SysAttachChunk();
                chunk.setChunkId(GeneralUtil.UUID());
                chunk.setPointId(arg.getPointId());
                chunk.setFileBody(arg.getData());
                chunk.setChunkOrder(arg.getPackageNumber());
                this.attachRepository.insertAttachChunk(chunk);
            } else {
                String path = null;
                String tempFile = null;
                try {
                    path = PathFileHelper.getApplicationWritablePath((String)arg.getAppId(), (boolean)true, (String[])new String[]{"upload", arg.getPointId()});
                    tempFile = path + arg.getPointId();
                    Files.write(Paths.get(tempFile, new String[0]), arg.getData(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                thumb = this.generateThumbnail(tempFile, extType);
                FileUtil.deleteDir(path);
                SysAttach attach = new SysAttach();
                attach.setPointId(arg.getPointId());
                attach.setFileName(arg.getFileName());
                attach.setFileSize(Integer.valueOf(arg.getFileSize()));
                attach.setFileBody(arg.getData());
                attach.setExttype(extType);
                attach.setThumbnail(thumb);
                attach.setChunks(arg.getPackageCount());
                this.attachRepository.insertAttachInfo(attach);
                complete = true;
            }
            if (!"ctl".equals(arg.getSource()) && complete && !arg.isInsertDoc()) {
                this.insertFileInfo(arg, thumb);
            }
            if (arg.isInsertDoc() && complete) {
                this.insertResDoc(arg);
            }
            scope.commit();
        }
        return new MobileString(arg.getPointId());
    }

    @Override
    public String getIDByFileName(String fileName) {
        return this.attachRepository.getIDByFileName(fileName);
    }

    public MobileBoolean updateAttach(AttachUpdateArgument arg) throws Exception {
        SysAttach attach = new SysAttach();
        attach.setPointId(arg.getPointId());
        attach.setFileBody(arg.getData());
        attach.setFileSize(Integer.valueOf(arg.getFileSize()));
        this.attachRepository.updateAttachInfo(attach);
        return new MobileBoolean(true);
    }

    public MobileBoolean deleteAttach(AttachDeleteArgument arg) throws Exception {
        String[] pointIds;
        for (String pointId : pointIds = arg.getPointid().split(",")) {
            this.attachRepository.deleteAttachChunk(pointId);
            this.attachRepository.deleteAttach(pointId);
        }
        this.deleteOtherInfo(arg.getPointid());
        this.deleteInfo(pointIds);
        return new MobileBoolean(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MobileString getAttachPath(String pointId) {
        AttachFetchResult result = null;
        SysAttach attach = this.attachRepository.getAttachInfoById(pointId);
        if (attach == null) {
            return null;
        }
        result = new AttachFetchResult();
        result.setFileSize(attach.getFileSize());
        result.setExttype(attach.getExttype());
        result.setData(attach.getFileBody());
        result.setPackageCount(Integer.valueOf(attach.getChunks()));
        String tempFile = "temp" + File.separator + pointId + "." + result.getExttype();
        String filePath = null;
        try {
            filePath = PathFileHelper.getApplicationWritablePath((String)AppContext.getCurrentAppId(), (boolean)true) + tempFile;
        }
        catch (IOException e) {
            this.log.warn((Throwable)e);
        }
        File file = new File(filePath);
        if (file.exists() && file.length() == (long)result.getFileSize().intValue()) {
            return new MobileString(tempFile);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file, true);){
            this.lock.lock();
            if (result.getPackageCount() > 1) {
                result.setData(new byte[result.getFileSize().intValue()]);
                List<Object> list = this.attachRepository.getAttachChunkData(pointId);
                for (Object obj : list) {
                    byte[] bts = (byte[])obj;
                    if (bts == null) continue;
                    fileOutputStream.write(bts, 0, bts.length);
                }
            } else {
                fileOutputStream.write(result.getData(), 0, result.getData().length);
            }
            fileOutputStream.flush();
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
        return new MobileString(tempFile);
    }

    public MobileString addTempFile(AttachAddArgument arg) {
        throw SysException.unsupportedProvd();
    }

    class TempFileInfo {
        int fileSize;
        int num;

        TempFileInfo() {
        }

        public int getFileSize() {
            return this.fileSize;
        }

        public int getNum() {
            return this.num;
        }

        public void setFileSize(int fileSize) {
            this.fileSize = fileSize;
        }

        public void setNum(int num) {
            this.num = num;
        }

        public void plus() {
            ++this.num;
        }

        public void addSize(int newFileSize) {
            this.fileSize += newFileSize;
        }
    }
}

