/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.module.doc.attach;

import cn.hangar.agp.module.doc.attach.dao.IFileInfoRepository;
import cn.hangar.agp.platform.core.app.AppContext;
import cn.hangar.agp.platform.core.app.PathFileHelper;
import cn.hangar.agp.platform.core.config.ConfigManager;
import cn.hangar.agp.platform.core.data.MobileDictionary;
import cn.hangar.agp.platform.core.data.MobileString;
import cn.hangar.agp.platform.core.log.Logger;
import cn.hangar.agp.platform.core.log.LoggerFactory;
import cn.hangar.agp.platform.core.serialize.SerializeFactory;
import cn.hangar.agp.platform.core.util.ExecutorServcieHelperEx;
import cn.hangar.agp.platform.core.util.ZipUtil;
import cn.hangar.agp.platform.utils.DateUtil;
import cn.hangar.agp.platform.utils.FileUtil;
import cn.hangar.agp.platform.utils.GeneralUtil;
import cn.hangar.agp.platform.utils.ImageUtil;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.IAttachProvider;
import cn.hangar.agp.service.model.doc.AttachAddArgument;
import cn.hangar.agp.service.model.doc.AttachDownloadArgument;
import cn.hangar.agp.service.model.doc.AttachFetchArgument;
import cn.hangar.agp.service.model.doc.AttachFetchImageArgument;
import cn.hangar.agp.service.model.doc.AttachFetchResult;
import cn.hangar.agp.service.model.doc.AttachInfo;
import cn.hangar.agp.service.model.doc.AttachUpdateArgument;
import cn.hangar.agp.service.model.doc.FileResult;
import cn.hangar.agp.service.model.doc.PreviewFileResult;
import cn.hangar.agp.service.model.doc.SaveSysImageRemarksArgument;
import cn.hangar.agp.service.model.doc.SysAttach;
import cn.hangar.agp.service.model.doc.SysImageRemarks;
import cn.hangar.agp.service.model.doc.SysResDoc;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;

public abstract class AttachProvider
implements IAttachProvider {
    public static final int ThumbnailWidth = 110;
    public static final int ThumbnailHeight = 110;
    protected static final String FULLPATH = "FULLPATH";
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final Executor executor = ExecutorServcieHelperEx.newFixedThreadPool((int)3, (String)"attach");
    private static final HashSet<String> EXTENSIONS = new HashSet<String>(){
        {
            this.add("doc");
            this.add("docx");
            this.add("xls");
            this.add("xlsx");
            this.add("ppt");
            this.add("pptx");
            this.add("txt");
        }
    };

    protected abstract IFileInfoRepository getFileInfoRepository();

    public AttachInfo getAttachInfo(String pointId) {
        List<AttachInfo> attachs = this.getFileInfoRepository().getAttachInfoById(pointId);
        return attachs != null && attachs.size() > 0 ? attachs.get(0) : null;
    }

    public List<AttachInfo> getAttachInfo(String[] pointIds) {
        return this.getFileInfoRepository().getAttachInfoByIds(pointIds);
    }

    public MobileString getAttachName(String pointId) {
        AttachInfo attach = this.getAttachInfo(pointId);
        if (attach != null) {
            return new MobileString(attach.getDocName());
        }
        return null;
    }

    public PreviewFileResult createTempAttach(AttachInfo attachInfo, String pointId) {
        String tempPath = PathFileHelper.getTempPath();
        PreviewFileResult result = new PreviewFileResult();
        File tempFile = new File(tempPath);
        if (!tempFile.exists()) {
            tempFile.mkdirs();
        }
        File srcFile = null;
        if (this.isPdf(attachInfo.getExtName())) {
            String srcFilePath;
            String returnValue;
            block13: {
                returnValue = "/temp/" + pointId + "/" + attachInfo.getDocName();
                srcFilePath = tempPath + pointId + "/" + attachInfo.getDocName();
                srcFile = new File(srcFilePath);
                if (srcFile.exists()) {
                    result.setHtmlFile(returnValue);
                    return result;
                }
                if (!srcFile.exists()) break block13;
                result.setHtmlFile(returnValue);
                PreviewFileResult previewFileResult = result;
                return previewFileResult;
            }
            if (!this.createTempFile(attachInfo, srcFilePath)) {
                PreviewFileResult previewFileResult = null;
                return previewFileResult;
            }
            result.setHtmlFile(returnValue);
            return result;
        }
        if (!this.canToHtml(attachInfo.getExtName())) {
            return null;
        }
        String destFile = tempPath + pointId + ".html";
        String returnValue = "/temp/" + pointId + ".html";
        File dstFile = new File(destFile);
        if (dstFile.exists()) {
            result.setHtmlFile(returnValue);
            return result;
        }
        String srcFilePath = tempPath + pointId + "." + FileUtil.getExtension((String)attachInfo.getDocName());
        if (dstFile.exists()) {
            result.setHtmlFile(returnValue);
            return result;
        }
        if (!(null != srcFile && srcFile.exists() || this.createTempFile(attachInfo))) {
            return null;
        }
        result.setHtmlFile(returnValue);
        result.setSrcFile(srcFilePath);
        result.setNeedMKPreFile(true);
        return result;
    }

    public boolean createTempFile(AttachInfo attachInfo, String fileName) {
        AttachFetchArgument arg = new AttachFetchArgument();
        arg.setPointId(attachInfo.getDocId());
        arg.setFetchAll(true);
        AttachFetchResult rt = this.loadAttach(arg);
        if (rt == null || rt.getData() == null) {
            return false;
        }
        if (StringUtils.isBlank((String)fileName)) {
            String destPath = PathFileHelper.getTempPath();
            File file = new File(destPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            fileName = destPath + arg.getPointId() + "." + FileUtil.getExtension((String)attachInfo.getDocName());
        } else {
            FileUtil.mkParentDirs((File)new File(fileName));
        }
        try (FileOutputStream outputStream = new FileOutputStream(fileName);){
            ((OutputStream)outputStream).write(rt.getData());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public SysAttach loadAttachThumbnail(String pointId) {
        AttachInfo attach = this.getAttachInfo(pointId);
        if (attach != null) {
            SysAttach sysAttach = new SysAttach();
            sysAttach.setThumbnail(attach.getThumbnail());
            sysAttach.setPointId(attach.getDocId());
            sysAttach.setExttype(attach.getExtName());
            return sysAttach;
        }
        return null;
    }

    protected AttachFetchResult generateOnlyAttachInfoResult(AttachFetchArgument arg, AttachInfo attachInfo) {
        if (arg.isOnlyInfo()) {
            AttachFetchResult result = new AttachFetchResult();
            result.setPointId(attachInfo.getDocId());
            result.setFileName(attachInfo.getDocName());
            result.setPackageCount(Integer.valueOf(1));
            result.setExttype(this.wrapExt(attachInfo.getExtName(), false));
            return result;
        }
        return null;
    }

    protected String wrapExt(String ext, boolean dot) {
        if (StringUtils.isBlank((String)ext)) {
            return "";
        }
        if ((ext = ext.trim()).startsWith(".") && !dot) {
            return StringUtils.trimStart((String)ext, (char)'.');
        }
        if (!ext.startsWith(".") && dot) {
            return "." + ext;
        }
        return ext;
    }

    public AttachFetchResult loadAttachImage(AttachFetchImageArgument argument) {
        AttachFetchArgument arg = new AttachFetchArgument();
        arg.setPointId(argument.getPointId());
        arg.setFetchAll(false);
        arg.setPackageNumber(-1);
        arg.setAttachType(argument.getAttachType());
        arg.setProperties(argument.getProperties());
        arg.setFilePath(argument.getFilePath());
        AttachFetchResult result = this.loadAttach(arg);
        if (result == null) {
            return null;
        }
        if (SysAttach.isImage((String)result.getExttype().toLowerCase())) {
            if (result.getPackageCount() > 1) {
                arg.setFetchAll(true);
                result = this.loadAttach(arg);
            }
        } else {
            result.setData(null);
        }
        return result;
    }

    public byte[] generateThumbnail(String fileName, String extType) {
        try {
            if (SysAttach.isImage((String)extType)) {
                return this.generateImageThumbnail(Files.readAllBytes(Paths.get(fileName, new String[0])), 110, 110);
            }
            if (SysAttach.isVideo((String)extType)) {
                return this.generateVideoThumbnail(Files.readAllBytes(Paths.get(fileName, new String[0])), 110, 110);
            }
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
        return null;
    }

    public byte[] generateThumbnail(byte[] bytes, String extType) {
        try {
            if (SysAttach.isImage((String)extType)) {
                return this.generateImageThumbnail(bytes, 110, 110);
            }
            if (SysAttach.isVideo((String)extType)) {
                return this.generateVideoThumbnail(bytes, 110, 110);
            }
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
        return null;
    }

    public String getIDByFileName(String fileName) {
        return this.getFileInfoRepository().getIDByFileName(fileName);
    }

    private byte[] generateVideoThumbnail(byte[] bytes, int thumbnailwidth2, int thumbnailheight2) {
        return null;
    }

    protected byte[] generateImageThumbnail(byte[] fileBytes, int width, int height) throws IOException {
        BufferedImage original = ImageUtil.readMemoryImage((byte[])fileBytes);
        BufferedImage thumbnail = ImageUtil.changeImageSize((Image)original, (int)width, (int)height, (int)2);
        return ImageUtil.imageToPng((Image)thumbnail);
    }

    protected boolean insertFileInfo(AttachAddArgument arg, byte[] thumb) {
        AttachInfo attach = new AttachInfo();
        attach.setDocId(arg.getPointId());
        attach.setCatlog(DateUtil.formatDate((Date)new Date(), (String)"yyyyMM"));
        attach.setThumbnail(thumb);
        attach.setDocName(arg.getFileName());
        attach.setExtName(arg.getFileName().contains(".") ? this.wrapExt(FileUtil.getExtension((String)arg.getFileName()), false) : "");
        attach.setDocSize(arg.getFileSize());
        attach.setRecDate(new Date());
        attach.setAppId(arg.getAppId());
        attach.setPhyAddress(arg.getPhyadoress());
        if (AppContext.getCurrentUser() != null) {
            attach.setRecuserid(AppContext.getCurrentUser().getId());
        }
        attach.setFullPath(arg.getFilePath());
        int i = this.getFileInfoRepository().insertAttachInfo(attach);
        return i > 0;
    }

    protected void updateFileInfo(AttachInfo attach, AttachUpdateArgument arg, byte[] thumb) {
        if (attach == null) {
            return;
        }
        attach.setDocId(arg.getPointId());
        attach.setThumbnail(thumb);
        attach.setDocName(arg.getFileName());
        attach.setExtName(arg.getFileName().contains(".") ? this.wrapExt(FileUtil.getExtension((String)arg.getFileName()), false) : "");
        attach.setDocSize(arg.getFileSize());
        attach.setAppId(arg.getAppId());
        if (AppContext.getCurrentUser() != null) {
            attach.setRecuserid(AppContext.getCurrentUser().getId());
        }
        this.getFileInfoRepository().updateAttachInfo(attach);
    }

    protected void insertResDoc(AttachAddArgument arg) throws SQLException {
        String value;
        SysResDoc resDoc = new SysResDoc();
        resDoc.setRecId(UUID.randomUUID().toString());
        resDoc.setResId(arg.getRefId());
        resDoc.setResInsId(arg.getRefAId());
        resDoc.setDocId(arg.getPointId());
        resDoc.setDocName(arg.getFileName());
        resDoc.setDocOrder(arg.getDocOrder());
        resDoc.setExtName(arg.getFileName().contains(".") ? this.wrapExt(FileUtil.getExtension((String)arg.getFileName()), false) : "");
        resDoc.setDocSize((long)arg.getFileSize());
        resDoc.setAppId(AppContext.getCurrentAppId());
        resDoc.setRecDate(new Date());
        if (AppContext.getCurrentUser() != null) {
            resDoc.setRecuserid(AppContext.getCurrentUser().getId());
        }
        if (arg.getProperties() != null && (value = (String)arg.getProperties().get("DOCTYPE")) != null) {
            resDoc.setDocType(value);
        }
        this.getFileInfoRepository().insertResDoc(resDoc);
    }

    protected boolean deleteInfo(String[] pointIds) {
        if (pointIds == null || pointIds.length == 0) {
            return false;
        }
        this.getFileInfoRepository().deleteAttachInfoByIds(pointIds);
        this.getFileInfoRepository().deleteResDocByIds(pointIds);
        return true;
    }

    protected boolean deleteOneInfo(String pointId) {
        this.getFileInfoRepository().deleteAttachInfo(pointId);
        this.getFileInfoRepository().deleteResDoc(pointId);
        return true;
    }

    protected void deleteOtherInfo(String pointid) {
    }

    public FileResult batchDownloadAttach(AttachDownloadArgument arg) {
        if (StringUtils.isNotBlank((String)arg.getPointIds())) {
            return this.batchDownloadFiles(arg.getPointIds().split(","), arg.getRootpath() == null ? "" : arg.getRootpath());
        }
        return null;
    }

    protected FileResult batchDownloadFiles(String[] pointIds, String fullPath) {
        String taskid;
        block6: {
            if (pointIds == null || pointIds.length == 0) {
                return null;
            }
            ArrayList<String> fileList = new ArrayList<String>();
            taskid = GeneralUtil.UUID();
            try {
                String filePath = PathFileHelper.getApplicationWritablePath((String)AppContext.getCurrentAppId(), (boolean)false, (String[])new String[]{taskid});
                for (String pointId : pointIds) {
                    AttachFetchArgument fetchArg = new AttachFetchArgument();
                    fetchArg.setPointId(pointId);
                    fetchArg.setFetchAll(true);
                    fetchArg.setPackageNumber(-1);
                    AttachFetchResult ret = this.loadAttach(fetchArg);
                    if (ret == null || ret.getData() == null) continue;
                    String pathFile = null;
                    pathFile = StringUtils.isNotBlank((String)ret.getFullPath()) ? filePath + ret.getFullPath().replace(fullPath, "") + "/" + ret.getFileName() : filePath + ret.getFileName();
                    FileUtil.writeFile((String)pathFile, (byte[])ret.getData());
                    if (fileList.contains(pathFile)) continue;
                    fileList.add(pathFile);
                }
                if (fileList.isEmpty()) break block6;
                String zipfile = PathFileHelper.getApplicationWritablePath((String)AppContext.getCurrentAppId(), (boolean)true) + taskid + ".zip";
                try {
                    ZipUtil.zip((String)filePath, (String)zipfile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                FileUtil.deleteDir((String)filePath);
            }
            catch (IOException e) {
                this.log.warn((Throwable)e);
            }
        }
        FileResult fr = new FileResult();
        fr.setFilePath(String.format("%s/%s", AppContext.getCurrentAppId(), taskid + ".zip"));
        return fr;
    }

    protected String getProperty(Map<String, String> properties, String name) {
        String value;
        String string = value = properties != null && properties.containsKey(name) ? properties.get(name) : null;
        if (!StringUtils.isBlank(value)) {
            return value;
        }
        value = ConfigManager.getProperty((String)name);
        return value;
    }

    protected boolean isPdf(String ext) {
        if (StringUtils.isEmpty((String)ext)) {
            return false;
        }
        ext = StringUtils.trimStart((String)ext.trim(), (char)'.').toLowerCase();
        return "pdf".equals(ext);
    }

    private boolean canToHtml(String ext) {
        if (StringUtils.isEmpty((String)ext)) {
            return false;
        }
        ext = StringUtils.trimStart((String)ext.trim(), (char)'.').toLowerCase();
        return EXTENSIONS.contains(ext);
    }

    public List<SysImageRemarks> loadImageRemarks(String imageId) {
        return this.getFileInfoRepository().getImageRemarks(imageId);
    }

    public int saveImageRemarks(SaveSysImageRemarksArgument argument) {
        IFileInfoRepository repository = this.getFileInfoRepository();
        String imageId = argument.getImageId();
        String appId = AppContext.getCurrentAppId();
        List markers = argument.getMarkers();
        int count = repository.deleteImageRemarks(imageId);
        if (markers != null && markers.size() > 0) {
            ArrayList<SysImageRemarks> remarks = new ArrayList<SysImageRemarks>();
            for (MobileDictionary marker : markers) {
                SysImageRemarks remark = new SysImageRemarks();
                remark.setRemarkId(GeneralUtil.UUID());
                remark.setImageId(imageId);
                remark.setFontStyle(SerializeFactory.toJson((Object)marker));
                remark.setAppId(appId);
                remarks.add(remark);
            }
            count += repository.insertImageRemarks(remarks);
        }
        return count;
    }
}

