/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.module.doc.attach;

import cn.hangar.agp.module.doc.attach.dao.IAboutDocRepository;
import cn.hangar.agp.module.doc.dissectFileModel.DissectFileResult;
import cn.hangar.agp.module.doc.dissectFileModel.DissectInfo;
import cn.hangar.agp.module.doc.utils.DocDiffHelper;
import cn.hangar.agp.platform.core.app.AppException;
import cn.hangar.agp.platform.core.db.IDB;
import cn.hangar.agp.platform.core.db.IDBFactory;
import cn.hangar.agp.platform.core.db.transaction.DataSourceTransactionScope;
import cn.hangar.agp.platform.core.log.Logger;
import cn.hangar.agp.platform.core.log.LoggerFactory;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.model.doc.AttachDissectArgument;
import cn.hangar.agp.service.model.doc.AttachSaveAlterRedItem;
import cn.hangar.agp.service.model.doc.AttachSaveAlterRedItemArgument;
import cn.hangar.agp.service.model.doc.SaveSysDocItemHtmlArgument;
import cn.hangar.agp.service.model.doc.SaveSysDocItemsArgument;
import cn.hangar.agp.service.model.doc.SysDocItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AboutDocProvider {
    private static Logger logger = LoggerFactory.getLogger(AboutDocProvider.class);
    @Autowired
    IAboutDocRepository aboutDocRepository;

    public Map queryMainTbObj(DissectInfo info) {
        return this.aboutDocRepository.queryMainTbObj(info);
    }

    public List<SysDocItem> queryItemsByDocId(String docId) {
        return this.aboutDocRepository.queryItemsByDocId(docId);
    }

    public void SaveDissectMainTb(AttachDissectArgument argument, DissectFileResult result) {
        DissectInfo info = new DissectInfo();
        info.setTableName(argument.getResId());
        info.setKeyField(argument.getKeyField());
        info.setNameField(argument.getNameField());
        info.setKeyValue(result.getID());
        info.setNameValue(result.getFILENAME());
        this.aboutDocRepository.insertDissectFileMainTb(info);
    }

    public void SaveDissectResults(DissectFileResult result) {
        List<SysDocItem> items = result.getDocItems();
        try {
            ArrayList<Object> temp = new ArrayList<SysDocItem>();
            for (int i = 0; i < items.size(); ++i) {
                temp.add(items.get(i));
                if (i % 100 != 99 && i != items.size() - 1) continue;
                this.aboutDocRepository.insertDissectResult(temp);
                temp = new ArrayList();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int saveAlteRedItem(AttachSaveAlterRedItemArgument argument) {
        if (argument != null && argument.getData() != null && argument.getData().size() > 0) {
            AttachSaveAlterRedItem item = (AttachSaveAlterRedItem)argument.getData().get(0);
            this.aboutDocRepository.deleteAlteRedItem(item.getSrcDocId(), item.getDstDocId());
            return this.aboutDocRepository.insertAlteRedItem(argument.getData());
        }
        return 0;
    }

    public void saveSysDocItems(SaveSysDocItemsArgument argument) {
        List items = argument.getItems();
        if (items == null || items.isEmpty()) {
            return;
        }
        try (DataSourceTransactionScope scope = new DataSourceTransactionScope();){
            IDB db = IDBFactory.createDataBase();
            List<SysDocItem> oldItems = this.aboutDocRepository.queryItemsByDocId(((SysDocItem)items.get(0)).getDocID());
            Map<String, SysDocItem> oldItemMap = oldItems.stream().collect(Collectors.toMap(SysDocItem::getDocItemID, i -> i));
            ArrayList<Object> allItems = new ArrayList<Object>();
            ArrayList<Object> inserts = new ArrayList<Object>();
            ArrayList<Object> deletes = new ArrayList<Object>();
            ArrayList<Object> updates = new ArrayList<Object>();
            int lastIndex = 0;
            for (Object item : items) {
                SysDocItem oldItem = oldItemMap.remove(item.getDocItemID());
                if (oldItem != null) {
                    if (lastIndex < oldItem.getSeqOrder()) {
                        List<SysDocItem> subList = oldItems.subList(lastIndex, oldItem.getSeqOrder() - 1);
                        for (SysDocItem subItem : subList) {
                            if (!oldItemMap.containsKey(subItem.getDocItemID())) continue;
                            allItems.add(subItem);
                        }
                        lastIndex = oldItem.getSeqOrder();
                    }
                    if (item.getFlag() != null && item.getFlag() == 2) {
                        deletes.add(item);
                        continue;
                    }
                    updates.add(item);
                    allItems.add(item);
                    continue;
                }
                if (item.getFlag() != null && item.getFlag() != 1) continue;
                inserts.add(item);
                allItems.add(item);
            }
            List<SysDocItem> subList = oldItems.subList(lastIndex, oldItems.size());
            for (SysDocItem subItem : subList) {
                if (!oldItemMap.containsKey(subItem.getDocItemID())) continue;
                allItems.add(subItem);
            }
            for (int i2 = 0; i2 < allItems.size(); ++i2) {
                ((SysDocItem)allItems.get(i2)).setSeqOrder(Integer.valueOf(i2 + 1));
            }
            db.delete(deletes, "SYS_DOCITEM");
            db.insert(inserts, "SYS_DOCITEM");
            db.update(updates, "SYS_DOCITEM");
            if (oldItemMap.size() > 0) {
                AboutDocProvider.updateItemsOrder(db, oldItemMap.values());
            }
            scope.commit();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    private static void updateItemsOrder(IDB db, Collection<SysDocItem> items) {
        db.executeBatch(String.format("update %s set SEQORDER=%s where DOCITEMID=%s", "SYS_DOCITEM", db.buildParamHolder("SEQORDER"), db.buildParamHolder("DOCITEMID")), items.stream().map(i -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(db.buildParameterName("DOCITEMID"), i.getDocItemID());
            map.put(db.buildParameterName("SEQORDER"), i.getSeqOrder());
            return map;
        }).collect(Collectors.toList()));
    }

    public void saveSysDocItemHtml(SaveSysDocItemHtmlArgument argument, Map<String, Object> docs) {
        if (StringUtils.isNotBlank((String)argument.getDocIds())) {
            String[] docIds = argument.getDocIds().split(",");
            LinkedHashMap<String, List> output = new LinkedHashMap<String, List>();
            try (DataSourceTransactionScope scope = new DataSourceTransactionScope();){
                IDB db = IDBFactory.createDataBase();
                for (String docId : docIds) {
                    Map doc = (Map)docs.get(docId);
                    List<SysDocItem> docItems = this.queryItemsByDocId(docId);
                    SaveItemHtmlResult result = this.saveSysDocItemHtml(db, docItems, argument);
                    if (result == SaveItemHtmlResult.success) continue;
                    String docName = "";
                    if (doc != null) {
                        for (Object value : doc.values()) {
                            if (docId.equals(value)) continue;
                            docName = value.toString();
                            break;
                        }
                    }
                    List docNames = output.computeIfAbsent(result.getMsg(), i -> new ArrayList());
                    docNames.add(docName);
                }
                if (output.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    for (String key : output.keySet()) {
                        List docNames = (List)output.get(key);
                        for (int i2 = 0; i2 < docNames.size(); ++i2) {
                            sb.append("\u3010").append((String)docNames.get(i2)).append("\u3011");
                        }
                        sb.append(key).append("\n");
                    }
                    throw new AppException(sb.toString());
                }
                scope.commit();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SaveItemHtmlResult saveSysDocItemHtml(IDB db, List<SysDocItem> items, SaveSysDocItemHtmlArgument argument) {
        String html = argument.getContent();
        int type = argument.getModifyType() == null ? 0 : argument.getModifyType();
        List<DocDiffHelper.SysDocItemEx> itemList = DocDiffHelper.initItemList(items);
        DocDiffHelper.SysDocItemEx parentEx = AboutDocProvider.findMatchItemParent(itemList, argument);
        if (type == 1) {
            DocDiffHelper.SysDocItemEx targetEx = AboutDocProvider.findMatchItem(parentEx != null ? parentEx.getChildren() : itemList, argument.getOldContent());
            if (targetEx == null) return SaveItemHtmlResult.notExists;
            SysDocItem target = targetEx.getData();
            String newContent = DocDiffHelper.getNoHtmlContent(html);
            target.setItemContent(newContent);
            target.setItemHtml(html);
            db.update((Object)target, "SYS_DOCITEM");
            return SaveItemHtmlResult.success;
        } else if (type == 2) {
            DocDiffHelper.SysDocItemEx targetEx = AboutDocProvider.findMatchItem(parentEx != null ? parentEx.getChildren() : itemList, argument.getOldContent());
            if (targetEx == null) return SaveItemHtmlResult.notExists;
            SysDocItem target = targetEx.getData();
            db.delete((Object)target, "SYS_DOCITEM");
            for (SysDocItem item : items) {
                if (item.getSeqOrder() <= target.getSeqOrder()) continue;
                item.setSeqOrder(Integer.valueOf(item.getSeqOrder() - 1));
            }
            AboutDocProvider.updateItemsOrder(db, items);
            return SaveItemHtmlResult.success;
        } else {
            DocDiffHelper.SysDocItemEx targetEx = AboutDocProvider.findMatchItem(parentEx != null ? parentEx.getChildren() : itemList, argument.getContent());
            if (targetEx != null) {
                return SaveItemHtmlResult.exists;
            }
            if (html == null) {
                return SaveItemHtmlResult.empty;
            }
            SysDocItem target = DocDiffHelper.createItem(html);
            if (parentEx != null) {
                DocDiffHelper.SysDocItemEx cat1Ex;
                DocDiffHelper.SysDocItemEx cat2Ex;
                DocDiffHelper.SysDocItemEx cat3Ex;
                SysDocItem parent = parentEx.getData();
                target.setDocID(parent.getDocID());
                target.setDocResID(parent.getDocResID());
                DocDiffHelper.SysDocItemEx sysDocItemEx = cat3Ex = StringUtils.isBlank((String)argument.getCat3()) ? null : parentEx;
                DocDiffHelper.SysDocItemEx sysDocItemEx2 = StringUtils.isBlank((String)argument.getCat2()) ? null : (cat2Ex = cat3Ex == null ? parentEx : parentEx.getParent());
                DocDiffHelper.SysDocItemEx sysDocItemEx3 = StringUtils.isBlank((String)argument.getCat1()) ? null : (cat1Ex = cat2Ex == null ? parentEx : parentEx.getParent());
                if (cat1Ex == null && cat2Ex != null) {
                    cat1Ex = cat2Ex;
                    cat2Ex = null;
                }
                if (cat2Ex == null && cat3Ex != null) {
                    cat2Ex = cat3Ex;
                    cat3Ex = null;
                }
                target.setPDocItemID(parent.getDocItemID());
                target.setCat1ItemID(cat1Ex == null ? null : cat1Ex.getData().getDocItemID());
                target.setCat2ItemID(cat2Ex == null ? null : cat2Ex.getData().getDocItemID());
                target.setCat3ItemID(cat3Ex == null ? null : cat3Ex.getData().getDocItemID());
                List<DocDiffHelper.SysDocItemEx> siblingsEx = parentEx.getChildren();
                SysDocItem prevSibling = null;
                if (siblingsEx == null || siblingsEx.isEmpty()) {
                    prevSibling = parent;
                } else if (StringUtils.isBlank((String)target.getItemCode())) {
                    prevSibling = siblingsEx.get(siblingsEx.size() - 1).getData();
                } else {
                    int order = DocDiffHelper.getSiblingOrder(target);
                    for (DocDiffHelper.SysDocItemEx sibling : siblingsEx) {
                        int siblingOrder = DocDiffHelper.getSiblingOrder(sibling.getData());
                        if (order < siblingOrder) continue;
                        prevSibling = sibling.getData();
                    }
                }
                items.add(items.indexOf(prevSibling) + 1, target);
                for (int i = 0; i < items.size(); ++i) {
                    items.get(i).setSeqOrder(Integer.valueOf(i + 1));
                }
                AboutDocProvider.updateItemsOrder(db, items);
            } else {
                target.setSeqOrder(Integer.valueOf(items.size() + 1));
                if (items.size() > 0) {
                    target.setDocID(items.get(0).getDocID());
                    target.setDocResID(items.get(0).getDocResID());
                }
            }
            db.insert((Object)target, "SYS_DOCITEM");
        }
        return SaveItemHtmlResult.success;
    }

    private static DocDiffHelper.SysDocItemEx findMatchItem(List<DocDiffHelper.SysDocItemEx> items, String argContent) {
        if (items != null) {
            String content = DocDiffHelper.getNoHtmlContent(argContent);
            String code = DocDiffHelper.getCodeString(argContent, false);
            return items.stream().filter(i -> {
                String itemContent;
                if (StringUtils.isNotBlank((String)code)) {
                    if (code.equals(i.getData().getItemCode())) {
                        return true;
                    }
                    String itemCode = DocDiffHelper.getCodeString(i.getData().getItemContent(), false);
                    if (code.equals(itemCode)) {
                        return true;
                    }
                }
                return DocDiffHelper.getSimilarityRatio(itemContent = DocDiffHelper.getNoHtmlContent(i.getData().getItemContent()), content) > 0.9;
            }).findFirst().orElse(null);
        }
        return null;
    }

    private static DocDiffHelper.SysDocItemEx findMatchItemParent(List<DocDiffHelper.SysDocItemEx> items, SaveSysDocItemHtmlArgument argument) {
        ArrayList<DocDiffHelper.SysDocItemEx> temps = new ArrayList<DocDiffHelper.SysDocItemEx>();
        AboutDocProvider.filterByCat(items, temps, argument.getCat1());
        if (temps.isEmpty()) {
            return null;
        }
        ArrayList<DocDiffHelper.SysDocItemEx> targets = new ArrayList<DocDiffHelper.SysDocItemEx>(temps);
        temps.clear();
        for (DocDiffHelper.SysDocItemEx target : targets) {
            AboutDocProvider.filterByCat(target.getChildren(), temps, argument.getCat2());
        }
        if (temps.isEmpty()) {
            return (DocDiffHelper.SysDocItemEx)targets.get(0);
        }
        targets.clear();
        targets.addAll(temps);
        temps.clear();
        for (DocDiffHelper.SysDocItemEx target : targets) {
            AboutDocProvider.filterByCat(target.getChildren(), temps, argument.getCat3());
        }
        if (temps.isEmpty()) {
            return (DocDiffHelper.SysDocItemEx)targets.get(0);
        }
        return (DocDiffHelper.SysDocItemEx)temps.get(0);
    }

    private static void filterByCat(List<DocDiffHelper.SysDocItemEx> toFilter, List<DocDiffHelper.SysDocItemEx> result, String cat) {
        if (StringUtils.isBlank((String)cat)) {
            return;
        }
        String testStr = cat.trim().replace(" ", "");
        if (toFilter != null) {
            for (DocDiffHelper.SysDocItemEx temp : toFilter) {
                String content;
                if ("page_ref".equals(temp.getData().getItemType()) || (content = DocDiffHelper.getNoHtmlContent(temp.getData().getItemContent())) == null || !content.trim().replace(" ", "").startsWith(testStr)) continue;
                result.add(temp);
            }
        }
    }

    private static enum SaveItemHtmlResult {
        success(""),
        notExists("\u8bb0\u5f55\u4e0d\u5b58\u5728"),
        notMatch("\u8bb0\u5f55\u4e0d\u4e00\u81f4"),
        exists("\u8bb0\u5f55\u5df2\u5b58\u5728"),
        empty("\u5185\u5bb9\u4e3a\u7a7a");

        String msg;

        private SaveItemHtmlResult(String msg) {
            this.msg = msg;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

