/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.module.doc;

import cn.hangar.agp.module.doc.attach.AboutDocProvider;
import cn.hangar.agp.module.doc.dissectFileModel.DissectFileResult;
import cn.hangar.agp.module.doc.dissectFileModel.DissectInfo;
import cn.hangar.agp.module.doc.dissectFileModel.DownloadTarget;
import cn.hangar.agp.module.doc.office.util.word.WordUtil;
import cn.hangar.agp.module.doc.office.util.word.analysis.AnalyzeResult;
import cn.hangar.agp.platform.core.app.AppContext;
import cn.hangar.agp.platform.core.app.PathFileHelper;
import cn.hangar.agp.platform.core.ioc.ContextManager;
import cn.hangar.agp.platform.utils.FileUtil;
import cn.hangar.agp.platform.utils.StringUtils;
import cn.hangar.agp.service.core.IAttachProvider;
import cn.hangar.agp.service.core.util.AttachHelper;
import cn.hangar.agp.service.model.doc.AttachBuildFromDBArgument;
import cn.hangar.agp.service.model.doc.AttachDissectArgument;
import cn.hangar.agp.service.model.doc.AttachFetchArgument;
import cn.hangar.agp.service.model.doc.AttachFetchResult;
import cn.hangar.agp.service.model.doc.SysDocItem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SysDocItemUtils {
    public static Map buildDocFromDb(AttachBuildFromDBArgument arg) {
        AboutDocProvider aboutDocProvider = (AboutDocProvider)ContextManager.find(AboutDocProvider.class);
        HashMap result = new HashMap();
        String[] docIds = arg.getDocIds().split(",");
        ArrayList<DownloadTarget> paths = new ArrayList<DownloadTarget>();
        for (int index = 0; index < docIds.length; ++index) {
            String id = docIds[index];
            DissectInfo info = new DissectInfo();
            info.setTableName(arg.getResId());
            info.setKeyField(arg.getKeyField());
            info.setNameField(arg.getNameField());
            info.setKeyValue(id);
            Map mainObj = aboutDocProvider.queryMainTbObj(info);
            List<SysDocItem> docItems = aboutDocProvider.queryItemsByDocId(id);
            for (int docIndex = 0; docIndex < docItems.size(); ++docIndex) {
                SysDocItem item = docItems.get(docIndex);
                if (item.getItemFormat() == null) continue;
                item.setItemContent(item.getItemFormat());
            }
            if (mainObj == null) continue;
            String path = SysDocItemUtils.buildDocFromDb(mainObj, id);
            String name = mainObj.get(arg.getNameField()).toString();
            if ("100".equals(arg.getFileType()) && name.indexOf(".doc") == -1) {
                name = name + ".doc";
            } else if ("010".equals(arg.getFileType()) && name.indexOf(".wps") == -1) {
                name = name + ".wps";
            } else if ("001".equals(arg.getFileType()) && name.indexOf(".pdf") == -1) {
                name = name + ".pdf";
            }
            paths.add(new DownloadTarget(path, name));
        }
        result.put("PAM_PATHS", paths);
        return result;
    }

    public static String buildDocFromDb(Map<String, Object> mainObj, String id) {
        if (mainObj != null) {
            AboutDocProvider aboutDocProvider = (AboutDocProvider)ContextManager.find(AboutDocProvider.class);
            List<SysDocItem> docItems = aboutDocProvider.queryItemsByDocId(id);
            return SysDocItemUtils.buildDocFromDb(mainObj, id, docItems);
        }
        return null;
    }

    public static String buildDocFromDb(Map<String, Object> mainObj, String id, List<SysDocItem> docItems) {
        if (mainObj != null && docItems != null) {
            for (SysDocItem docItem : docItems) {
                if (docItem.getItemFormat() == null) continue;
                docItem.setItemContent(docItem.getItemFormat());
            }
            String path = "";
            try {
                String tempDir = PathFileHelper.getApplicationWritablePath((String)AppContext.getCurrentAppId(), (boolean)true, (String[])new String[]{"temp"});
                path = tempDir + id + ".wps";
                docItems.sort(Comparator.comparingInt(SysDocItem::getSeqOrder));
                WordUtil.save((String)path, docItems);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return path;
        }
        return null;
    }

    public static Map dissectFile(AttachDissectArgument argument) {
        if (argument.getPointIds() == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        ArrayList<String> list = new ArrayList<String>();
        for (String pointId : argument.getPointIds()) {
            DissectFileResult currentResult = SysDocItemUtils.dissectFile(pointId, argument);
            if (currentResult == null) continue;
            list.add(currentResult.getID());
            SysDocItemUtils.SaveDocData(argument, currentResult);
        }
        result.put("PAM_DOCIDS", String.join((CharSequence)",", list));
        return result;
    }

    public static DissectFileResult dissectFile(String pointId, AttachDissectArgument argument) {
        String resId = argument.getResId();
        IAttachProvider provider = AttachHelper.getAttachProvider();
        File file = null;
        String fileName = "";
        try {
            String tempDir = PathFileHelper.getApplicationWritablePath((String)AppContext.getCurrentAppId(), (boolean)true, (String[])new String[]{"temp"});
            String filePath = tempDir + pointId;
            if (FileUtil.checkExist((String)filePath)) {
                file = new File(filePath);
            } else {
                AttachFetchArgument a = new AttachFetchArgument();
                a.setPointId(pointId);
                AttachFetchResult result = provider.loadAttach(a);
                if (result != null && result.getData() != null) {
                    FileUtil.writeFile((String)filePath, (byte[])result.getData());
                    file = new File(filePath);
                    fileName = result.getFileName().replace("." + result.getExttype(), "");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (file != null) {
            String filePath = file.getPath();
            String extension = FileUtil.getExtension((String)filePath);
            String rules = "[\n\t{\n\t\t\"text\": \"\u7b2c\u4e00\u90e8\u5206\",\n\t\t\"rules\": [\n\t\t\t\"^\u7b2c[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]{1,10}\u90e8\u5206\",\n\t\t\t\"^([\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]{1,10}\u3001)|^\u7b7e\\\\s{0,}\u7f72\\\\s{0,}\u9875|^(\u9644\u4ef6[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]{1,10})\"\n\t\t]\n\t},\n\t{\n\t\t\"text\": \"\u7b2c\u4e8c\u90e8\u5206\",\n\t\t\"rules\": [\n\t\t\t\"^\u7b2c[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]{1,10}\u90e8\u5206\",\n\t\t\t\"^(\\\\d{1,2}\\\\.)(\\\\d{1,2}\\\\.?){0,10}\"\n\t\t]\n\t},\n\t{\n\t\t\"text\": \"\u7b2c\u56db\u90e8\u5206\",\n\t\t\"rules\": [\n\t\t\t\"^\u7b2c[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341]{1,10}\u90e8\u5206\",\n\t\t\t\"^\u9644\u4ef6\\\\d{1,10}\u3001\"\n\t\t]\n\t}\n]";
            AnalyzeResult anaResult = WordUtil.analyzeWordFile((String)filePath, (List)argument.getRules());
            if (extension.endsWith("wps") || extension.endsWith("doc") || extension.endsWith("docx")) {
                String docId = UUID.randomUUID().toString();
                if ("SYS_FILEINFO".equalsIgnoreCase(resId)) {
                    docId = file.getName();
                }
                return new DissectFileResult(fileName, anaResult, resId, docId);
            }
        }
        return null;
    }

    private static void SaveDocData(AttachDissectArgument argument, DissectFileResult result) {
        AboutDocProvider aboutDocProvider = (AboutDocProvider)ContextManager.find(AboutDocProvider.class);
        if (StringUtils.isNotBlank((String)argument.getResId())) {
            aboutDocProvider.SaveDissectMainTb(argument, result);
        }
        if (result == null || result.getDocItems() == null) {
            return;
        }
        aboutDocProvider.SaveDissectResults(result);
    }
}

