/*
 * Decompiled with CFR 0.152.
 */
package cn.hangar.agp.module.doc;

import cn.hangar.agp.module.doc.SysDocItemUtils;
import cn.hangar.agp.module.doc.attach.AboutDocProvider;
import cn.hangar.agp.module.doc.utils.DocDiffHelper;
import cn.hangar.agp.platform.core.app.AppException;
import cn.hangar.agp.platform.core.data.BeanHelper;
import cn.hangar.agp.platform.core.data.MobileBoolean;
import cn.hangar.agp.platform.utils.GeneralUtil;
import cn.hangar.agp.service.core.AttachService;
import cn.hangar.agp.service.core.IAttachProvider;
import cn.hangar.agp.service.core.util.AttachHelper;
import cn.hangar.agp.service.model.datasource.SelectResult;
import cn.hangar.agp.service.model.doc.AttachBuildFromDBArgument;
import cn.hangar.agp.service.model.doc.AttachDissectArgument;
import cn.hangar.agp.service.model.doc.AttachFetchImageArgument;
import cn.hangar.agp.service.model.doc.AttachFetchResult;
import cn.hangar.agp.service.model.doc.AttachSaveAlterRedItemArgument;
import cn.hangar.agp.service.model.doc.DocDiffArgument;
import cn.hangar.agp.service.model.doc.SaveSysDocItemHtmlArgument;
import cn.hangar.agp.service.model.doc.SaveSysDocItemsArgument;
import cn.hangar.agp.service.model.doc.SaveSysImageRemarksArgument;
import cn.hangar.agp.service.model.doc.SysAttach;
import cn.hangar.agp.service.model.doc.SysDocItem;
import cn.hangar.agp.service.model.doc.SysImageRemarks;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AttachServiceImpl
implements AttachService {
    private static Boolean isUseShareFileServer;
    @Autowired
    private AboutDocProvider aboutDocProvider;
    private static final HashSet<String> EXTENSIONS;

    private IAttachProvider getProvide(String refId, String attachType) {
        return AttachHelper.getAttachProvide((String)refId, (String)attachType);
    }

    public SysAttach fetchAttachThumbnail(String pointId) {
        IAttachProvider provd = this.getProvide(null, null);
        return provd.loadAttachThumbnail(pointId);
    }

    public AttachFetchResult fetchAttachImage(AttachFetchImageArgument arg) {
        IAttachProvider provd = this.getProvide(arg.getRefId(), arg.getAttachType());
        AttachFetchResult result = provd.loadAttachImage(arg);
        if (result != null && result.getData() != null && arg.isCompress()) {
            try (ByteArrayInputStream in = new ByteArrayInputStream(result.getData());
                 ByteArrayOutputStream out = new ByteArrayOutputStream();){
                BufferedImage image = ImageIO.read(in);
                Thumbnails.of((BufferedImage[])new BufferedImage[]{image}).outputFormat(result.getExttype() == null ? "JPEG" : result.getExttype()).scale(1.0).outputQuality(0.5f).toOutputStream((OutputStream)out);
                result.setData(out.toByteArray());
            }
            catch (Exception ee) {
                throw new AppException((Throwable)ee);
            }
        }
        return result;
    }

    public List<SysImageRemarks> loadImageRemarks(String imageId) {
        IAttachProvider provider = this.getProvide(null, null);
        return provider.loadImageRemarks(imageId);
    }

    public MobileBoolean saveImageRemarks(SaveSysImageRemarksArgument argument) {
        IAttachProvider provider = this.getProvide(null, null);
        return new MobileBoolean(provider.saveImageRemarks(argument) > 0);
    }

    public Map dissectFile(AttachDissectArgument argument) {
        return SysDocItemUtils.dissectFile(argument);
    }

    public Map buildDocFromDb(AttachBuildFromDBArgument arg) {
        return SysDocItemUtils.buildDocFromDb(arg);
    }

    public Integer saveAlteRedItem(AttachSaveAlterRedItemArgument arguments) {
        int court = this.aboutDocProvider.saveAlteRedItem(arguments);
        return court;
    }

    public Integer saveSysDocItems(SaveSysDocItemsArgument argument) {
        this.aboutDocProvider.saveSysDocItems(argument);
        return 1;
    }

    public MobileBoolean saveSysDocItemHtml(SaveSysDocItemHtmlArgument argument, Map<String, Object> docs) {
        this.aboutDocProvider.saveSysDocItemHtml(argument, docs);
        return MobileBoolean.TRUE;
    }

    public Object docDiff(DocDiffArgument argument) {
        ArrayList<SysDocItem> from = new ArrayList<SysDocItem>();
        ArrayList<SysDocItem> to = new ArrayList<SysDocItem>();
        boolean matched = false;
        if (argument.getDiffTexts() != null && argument.getDiffTexts().size() > 0) {
            matched = true;
            String sourceId = GeneralUtil.javaUUID();
            String targetId = GeneralUtil.javaUUID();
            for (int i = 0; i < argument.getDiffTexts().size(); ++i) {
                String sourceHtml = ((DocDiffArgument.DiffText)argument.getDiffTexts().get(i)).getLeft();
                String targetHtml = ((DocDiffArgument.DiffText)argument.getDiffTexts().get(i)).getRight();
                from.add(SysDocItem.builder().docItemID(GeneralUtil.javaUUID()).docID(sourceId).itemHtml(sourceHtml).seqOrder(Integer.valueOf(i + 1)).build());
                to.add(SysDocItem.builder().docItemID(GeneralUtil.javaUUID()).docID(targetId).itemHtml(targetHtml).seqOrder(Integer.valueOf(i + 1)).build());
            }
        } else {
            SelectResult sourceItems = argument.getSourceItems();
            SelectResult targetItems = argument.getTargetItems();
            if (sourceItems != null && sourceItems.getResult() != null) {
                for (Object o : sourceItems.getResult()) {
                    from.add((SysDocItem)BeanHelper.mapToEntity((Map)((Map)o), SysDocItem.class));
                }
            }
            if (targetItems != null && targetItems.getResult() != null) {
                for (Object o : targetItems.getResult()) {
                    to.add((SysDocItem)BeanHelper.mapToEntity((Map)((Map)o), SysDocItem.class));
                }
            } else {
                return from;
            }
        }
        return DocDiffHelper.generateDifferences(from, to, matched);
    }

    static {
        EXTENSIONS = new HashSet<String>(){
            {
                this.add("doc");
                this.add("docx");
                this.add("xls");
                this.add("xlsx");
                this.add("ppt");
                this.add("pptx");
                this.add("txt");
            }
        };
    }
}

