/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.ResultSet;

public class ResultWrapper {
    private final ResultSet rs;
    private final long updateCount;
    private final long insertOID;
    private ResultWrapper next;

    public ResultWrapper(ResultSet rs) {
        this.rs = rs;
        this.updateCount = -1L;
        this.insertOID = -1L;
    }

    public ResultWrapper(long updateCount, long insertOID) {
        this.rs = null;
        this.updateCount = updateCount;
        this.insertOID = insertOID;
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public long getUpdateCount() {
        return this.updateCount;
    }

    public long getInsertOID() {
        return this.insertOID;
    }

    public ResultWrapper getNext() {
        return this.next;
    }

    public ResultWrapper getLast() {
        return this.getNext() == null ? this : this.getNext().getLast();
    }

    public void append(ResultWrapper newResult) {
        ResultWrapper tail = this;
        while (tail.next != null) {
            tail = tail.next;
        }
        tail.next = newResult;
    }

    public void popLast() {
        ResultWrapper tail = this;
        while (tail.next != null && tail.next.next != null) {
            tail = tail.next;
        }
        tail.next = null;
    }
}

