/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveshow.ui;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.livebase.models.LPJoinCodeEnterRoomModel;
import com.baijiayun.livebase.models.LPSignEnterRoomModel;
import com.baijiayun.liveshow.ui.LiveShowActivity;
import java.io.Serializable;

public class LiveShowSDKWithUI {
    public static void enterRoom(@NonNull Context context, LPJoinCodeEnterRoomModel lpJoinCodeEnterRoomModel) {
        if (lpJoinCodeEnterRoomModel == null) {
            LPLogger.e((String)"lpJoinCodeEnterRoomModel is null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)lpJoinCodeEnterRoomModel.userName)) {
            LPLogger.e((String)"name is empty");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)lpJoinCodeEnterRoomModel.joinCode)) {
            LPLogger.e((String)"code is empty");
            return;
        }
        Intent intent = new Intent(context, LiveShowActivity.class);
        intent.putExtra("code", (Serializable)lpJoinCodeEnterRoomModel);
        context.startActivity(intent);
    }

    public static void enterRoom(@NonNull Context context, LPSignEnterRoomModel lpSignEnterRoomModel) {
        if (lpSignEnterRoomModel == null) {
            LPLogger.e((String)"lpSignEnterRoomModel is null");
            return;
        }
        if (lpSignEnterRoomModel.roomId <= 0L) {
            LPLogger.e((String)"roomId is wrong");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)lpSignEnterRoomModel.sign)) {
            LPLogger.e((String)"sign is empty");
            return;
        }
        Intent intent = new Intent(context, LiveShowActivity.class);
        intent.putExtra("sign", (Serializable)lpSignEnterRoomModel);
        context.startActivity(intent);
    }

    public static void setShopFragment(Fragment shopFragment) {
        LiveShowActivity.setLiveShowShopFragment(shopFragment);
    }
}

