/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.utils;

import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.livebase.context.LPError;

public class LPSDKTaskQueue {
    private LPTaskQueueListener listener;
    private TaskItem<Object> taskQueue;
    private TaskItem pointTaskItem;
    private TaskQueueState state;
    private int mTaskCount;

    public LPSDKTaskQueue(LPTaskQueueListener object) {
        TaskItem<Object> taskItem;
        LPSDKTaskQueue lPSDKTaskQueue = this;
        this.state = TaskQueueState.Initial;
        lPSDKTaskQueue.listener = object;
        object = taskItem;
        lPSDKTaskQueue.taskQueue = new TaskItem<Object>(null){

            @Override
            public void run() {
            }

            @Override
            public String getTaskName() {
                return "Header of taskQueue";
            }
        };
        lPSDKTaskQueue.pointTaskItem = object;
    }

    private void runTaskItem(TaskItem object) {
        if (object == null) {
            this.state = TaskQueueState.Completed;
            object = this.listener;
            if (object != null) {
                object.onTaskQueueFinished(this);
            }
            return;
        }
        if (((TaskItem)object).listener != null) {
            ((TaskItem)object).listener.onTaskShouldRun((TaskItem)object);
        }
        try {
            ((TaskItem)object).run();
        }
        catch (Exception exception) {
            ((TaskItem)object).setError(LPError.getNewError((Throwable)exception));
            LPLogger.e((Exception)exception);
        }
    }

    private void setItemFinish(TaskItem taskItem) {
        if (((LPSDKTaskQueue)((Object)taskItem2)).pointTaskItem != taskItem) {
            return;
        }
        if (taskItem.listener != null) {
            taskItem.listener.onTaskCompleted(taskItem);
        }
        boolean bl = false;
        LPTaskQueueListener lPTaskQueueListener = ((LPSDKTaskQueue)((Object)taskItem2)).listener;
        if (lPTaskQueueListener != null) {
            bl = lPTaskQueueListener.areYouNeedPauseTheTaskQueue((LPSDKTaskQueue)((Object)taskItem2), taskItem);
        }
        if (bl) {
            ((LPSDKTaskQueue)((Object)taskItem2)).state = TaskQueueState.Paused;
        } else {
            LPSDKTaskQueue lPSDKTaskQueue = taskItem2;
            TaskItem taskItem2 = lPSDKTaskQueue.pointTaskItem.next;
            lPSDKTaskQueue.pointTaskItem = taskItem2;
            lPSDKTaskQueue.runTaskItem(taskItem2);
        }
    }

    private void setItemCancelled(TaskItem taskItem) {
        this.setItemFinish(taskItem);
    }

    public TaskQueueState getState() {
        return this.state;
    }

    public int getTaskCount() {
        return this.mTaskCount;
    }

    public int getIndexOfTask(TaskItem taskItem) {
        int n2 = 0;
        while (taskItem.previous != null) {
            ++n2;
            taskItem = taskItem.previous;
        }
        return n2;
    }

    public <T> void addTaskItem(TaskItem<T> taskItem) {
        TaskQueueState taskQueueState = this.state;
        if (taskQueueState != TaskQueueState.Initial && taskQueueState != TaskQueueState.Paused) {
            throw new IllegalStateException("Cannot add task item while state is not initial");
        }
        if (((TaskItem)taskItem).parent != null && ((TaskItem)taskItem).parent != this) {
            throw new IllegalArgumentException("item has parent.");
        }
        TaskItem<T> taskItem2 = taskItem;
        TaskItem<T> taskItem3 = taskItem;
        LPSDKTaskQueue lPSDKTaskQueue = this;
        TaskItem.access$202(lPSDKTaskQueue.pointTaskItem, taskItem);
        TaskItem.access$002(taskItem3, lPSDKTaskQueue.pointTaskItem);
        TaskItem.access$202(taskItem3, null);
        TaskItem.access$102(taskItem2, this);
        this.pointTaskItem = taskItem2;
        ++this.mTaskCount;
    }

    public <T> void appendTaskItemAtTailDuringProcessing(TaskItem<T> taskItem) {
        if (((TaskItem)taskItem).parent != null && ((TaskItem)taskItem).parent != this) {
            throw new IllegalArgumentException("item has parent.");
        }
        TaskItem taskItem2 = this.pointTaskItem;
        while (taskItem2.next != null) {
            taskItem2 = taskItem2.next;
        }
        TaskItem taskItem3 = taskItem2;
        TaskItem.access$202(taskItem3, taskItem);
        TaskItem.access$002(taskItem, taskItem3);
        TaskItem.access$102(taskItem, this);
        ++this.mTaskCount;
    }

    public void start() {
        Object object = ((LPSDKTaskQueue)((Object)taskItem)).state;
        TaskQueueState taskQueueState = TaskQueueState.Started;
        if (object == taskQueueState) {
            return;
        }
        if (object == TaskQueueState.Completed) {
            return;
        }
        if (object == TaskQueueState.Initial) {
            LPSDKTaskQueue lPSDKTaskQueue = taskItem;
            lPSDKTaskQueue.pointTaskItem = lPSDKTaskQueue.taskQueue;
            object = lPSDKTaskQueue.listener;
            if (object != null) {
                object.onTaskQueueShouldStart((LPSDKTaskQueue)((Object)taskItem));
            }
        }
        LPSDKTaskQueue lPSDKTaskQueue = taskItem;
        lPSDKTaskQueue.state = taskQueueState;
        TaskItem taskItem = lPSDKTaskQueue.pointTaskItem.next;
        lPSDKTaskQueue.pointTaskItem = taskItem;
        lPSDKTaskQueue.runTaskItem(taskItem);
    }

    public void resume() {
        this.start();
    }

    public void restart() {
        LPSDKTaskQueue lPSDKTaskQueue = this;
        lPSDKTaskQueue.pointTaskItem = lPSDKTaskQueue.taskQueue;
        lPSDKTaskQueue.state = TaskQueueState.Initial;
        lPSDKTaskQueue.start();
    }

    public void retry() {
        LPSDKTaskQueue lPSDKTaskQueue = this;
        TaskItem.access$302(lPSDKTaskQueue.pointTaskItem, null);
        lPSDKTaskQueue.runTaskItem(lPSDKTaskQueue.pointTaskItem);
    }

    public void stop() {
        TaskItem taskItem;
        this.pointTaskItem = ((TaskItem)this.taskQueue).next;
        while ((taskItem = this.pointTaskItem) != null) {
            TaskItem taskItem2 = taskItem;
            this.pointTaskItem = taskItem.next;
            TaskItem.access$002(taskItem2, null);
            TaskItem.access$202(taskItem2, null);
            TaskItem.access$102(taskItem2, null);
            TaskItem.access$402(taskItem2, null);
            TaskItem.access$502(taskItem2, null);
            TaskItem.access$302(taskItem2, null);
            taskItem2.setCancel();
        }
        this.pointTaskItem = this.taskQueue;
        this.state = TaskQueueState.Initial;
    }

    public TaskItem getPointTaskItem() {
        return this.pointTaskItem;
    }

    public LPTaskQueueListener getTaskQueueListener() {
        return this.listener;
    }

    public void pause() {
        if (this.pointTaskItem == null) {
            return;
        }
        this.state = TaskQueueState.Paused;
    }

    public static interface LPTaskQueueListener {
        public void onTaskQueueShouldStart(LPSDKTaskQueue var1);

        public boolean areYouNeedPauseTheTaskQueue(LPSDKTaskQueue var1, TaskItem var2);

        public void onTaskQueueFinished(LPSDKTaskQueue var1);
    }

    public static interface LPTaskItemListener {
        public void onTaskShouldRun(TaskItem var1);

        public void onTaskCompleted(TaskItem var1);
    }

    public static abstract class TaskItem<T> {
        private LPTaskItemListener listener;
        private T result;
        private LPError error;
        private TaskItem previous;
        private TaskItem next;
        private LPSDKTaskQueue parent;

        public TaskItem(LPTaskItemListener lPTaskItemListener) {
            this.listener = lPTaskItemListener;
        }

        public static /* synthetic */ TaskItem access$202(TaskItem taskItem, TaskItem taskItem2) {
            taskItem.next = taskItem2;
            return taskItem2;
        }

        public static /* synthetic */ TaskItem access$002(TaskItem taskItem, TaskItem taskItem2) {
            taskItem.previous = taskItem2;
            return taskItem2;
        }

        public static /* synthetic */ LPSDKTaskQueue access$102(TaskItem taskItem, LPSDKTaskQueue lPSDKTaskQueue) {
            taskItem.parent = lPSDKTaskQueue;
            return lPSDKTaskQueue;
        }

        public static /* synthetic */ LPError access$302(TaskItem taskItem, LPError lPError) {
            taskItem.error = lPError;
            return lPError;
        }

        public static /* synthetic */ Object access$402(TaskItem taskItem, Object object) {
            taskItem.result = object;
            return object;
        }

        public static /* synthetic */ LPTaskItemListener access$502(TaskItem taskItem, LPTaskItemListener lPTaskItemListener) {
            taskItem.listener = lPTaskItemListener;
            return lPTaskItemListener;
        }

        public abstract void run();

        public void onCancel() {
        }

        public final void setResult(T object) {
            this.result = object;
            this.error = null;
            object = this.parent;
            if (object != null) {
                ((LPSDKTaskQueue)object).setItemFinish(this);
            }
        }

        public final void setError(LPError object) {
            this.error = object;
            object = this.parent;
            if (object != null) {
                ((LPSDKTaskQueue)object).setItemFinish(this);
            }
        }

        public final void setCancel() {
            TaskItem taskItem = this;
            taskItem.onCancel();
            LPSDKTaskQueue lPSDKTaskQueue = taskItem.parent;
            if (lPSDKTaskQueue != null) {
                lPSDKTaskQueue.setItemCancelled(this);
            }
        }

        public LPSDKTaskQueue getQueue() {
            return this.parent;
        }

        public void clearQueue() {
            this.parent = null;
        }

        public TaskItem getPreviousTaskItem() {
            return this.previous;
        }

        public TaskItem getNextTaskItem() {
            return this.next;
        }

        public T getResult() {
            return this.result;
        }

        public LPError getError() {
            return this.error;
        }

        public abstract String getTaskName();
    }

    public static final class TaskQueueState
    extends Enum<TaskQueueState> {
        public static final /* enum */ TaskQueueState Initial;
        public static final /* enum */ TaskQueueState Started;
        public static final /* enum */ TaskQueueState Paused;
        public static final /* enum */ TaskQueueState Completed;
        private static final /* synthetic */ TaskQueueState[] $VALUES;

        public static TaskQueueState[] values() {
            return (TaskQueueState[])$VALUES.clone();
        }

        public static TaskQueueState valueOf(String string2) {
            return Enum.valueOf(TaskQueueState.class, string2);
        }

        static {
            TaskQueueState taskQueueState;
            TaskQueueState taskQueueState2;
            TaskQueueState taskQueueState3;
            TaskQueueState taskQueueState4;
            TaskQueueState taskQueueState5 = taskQueueState4;
            Initial = new TaskQueueState();
            TaskQueueState taskQueueState6 = taskQueueState3;
            Started = new TaskQueueState();
            TaskQueueState taskQueueState7 = taskQueueState2;
            Paused = new TaskQueueState();
            TaskQueueState taskQueueState8 = taskQueueState;
            Completed = new TaskQueueState();
            $VALUES = new TaskQueueState[]{taskQueueState5, taskQueueState6, taskQueueState7, taskQueueState8};
        }
    }
}

