/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.ppt.whiteboard.shape;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.text.TextPaint;
import android.text.TextUtils;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.livecore.models.LPPointF;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.ppt.whiteboard.shape.ShapeRegionInfo;
import java.util.ArrayList;
import java.util.List;

public class RectBoundaryShape
extends Shape {
    private static final int SCALE_OPERATOR_RECT_HALF_WIDTH = 5;
    public static final int SCALE_OPERATOR_LEFT_TOP = 0;
    public static final int SCALE_OPERATOR_LEFT_MIDDLE = 1;
    public static final int SCALE_OPERATOR_LEFT_BOTTOM = 2;
    public static final int SCALE_OPERATOR_MIDDLE_BOTTOM = 3;
    public static final int SCALE_OPERATOR_RIGHT_BOTTOM = 4;
    public static final int SCALE_OPERATOR_RIGHT_MIDDLE = 5;
    public static final int SCALE_OPERATOR_RIGHT_TOP = 6;
    public static final int SCALE_OPERATOR_MIDDLE_TOP = 7;
    public static final int ROTATE_OPERATOR = 8;
    public static final int MINI_SCALE_TO = 3;
    private float width;
    private float height;
    private Paint scalePointPaint;
    private final int REDUNDANT_WIDTH;
    private int scaleOperatorDir;
    private boolean isScaleEnable;
    private boolean isShowPaintOwnerEnable;
    private boolean isRotateEnable;
    private List<String> ownerList;
    private Paint mPaintTextBg;
    private TextPaint mPaintText;
    private float mTextHeight;
    private float mTextBgHeight;
    private float mTextTopPadding;
    private float mTextLeftPadding;
    private float mTextSpacingHeight;
    private float mTextSpacingWidth;
    private float mRotateDeviationX;
    private float mRotateDeviationY;
    private float mCircleSpacing;
    private float mCircleCenterX;
    private float mCircleCenterY;
    private boolean isRatioScaleEnable;
    private float mCenterX;
    private float mCenterY;
    private float mTextX;
    private float mTextY;

    public RectBoundaryShape(Paint paint, Context context) {
        float f2;
        RectBoundaryShape rectBoundaryShape = this;
        super(paint);
        rectBoundaryShape.REDUNDANT_WIDTH = 20;
        rectBoundaryShape.scaleOperatorDir = -1;
        rectBoundaryShape.isScaleEnable = true;
        rectBoundaryShape.mPaint.setStyle(Paint.Style.STROKE);
        this.scalePointPaint = new Paint();
        this.scalePointPaint.setColor(-1);
        rectBoundaryShape.scalePointPaint.setStyle(Paint.Style.FILL);
        this.mPaintTextBg = new Paint();
        this.mPaintTextBg.setStyle(Paint.Style.FILL);
        rectBoundaryShape.mPaintTextBg.setColor(Color.parseColor((String)"#889B9B9B"));
        rectBoundaryShape.mPaintTextBg.setAntiAlias(true);
        this.mPaintText = new TextPaint();
        this.mPaintText.setStyle(Paint.Style.FILL);
        rectBoundaryShape.mPaintText.setColor(-1);
        rectBoundaryShape.mPaintText.setTextSize((float)UtilsKt.getDp((int)12));
        rectBoundaryShape.mPaintText.setAntiAlias(true);
        rectBoundaryShape.mTextHeight = rectBoundaryShape.mPaintText.descent() - this.mPaintText.ascent();
        rectBoundaryShape.mTextTopPadding = f2 = (float)UtilsKt.getDp((int)2);
        rectBoundaryShape.mTextBgHeight = rectBoundaryShape.mTextHeight + f2 * 2.0f;
        rectBoundaryShape.mTextLeftPadding = UtilsKt.getDp((int)4);
        rectBoundaryShape.mTextSpacingHeight = UtilsKt.getDp((int)4);
        rectBoundaryShape.mTextSpacingWidth = UtilsKt.getDp((int)2);
        rectBoundaryShape.mCircleSpacing = UtilsKt.getDp((int)4);
    }

    private PointF[] getRotateBoundaryPoint() {
        PointF[] pointFArray = new PointF[9];
        PointF[] pointFArray2 = pointFArray;
        RectBoundaryShape rectBoundaryShape = this;
        LPPointF lPPointF = rectBoundaryShape.mSourcePoint;
        float f2 = lPPointF.x;
        float f3 = lPPointF.y;
        float f4 = f3;
        RectBoundaryShape rectBoundaryShape2 = this;
        float f5 = f4;
        float f6 = f2;
        RectBoundaryShape rectBoundaryShape3 = this;
        float f7 = f4;
        float f8 = f2;
        float f9 = f2;
        float f10 = f4;
        RectBoundaryShape rectBoundaryShape4 = this;
        float f11 = f4;
        float f12 = f2;
        float f13 = f2;
        RectBoundaryShape rectBoundaryShape5 = this;
        float f14 = f2;
        RectBoundaryShape rectBoundaryShape6 = this;
        float f15 = f2;
        float f16 = f2;
        float f17 = f2 + this.width / 2.0f;
        f2 = f4 + this.height / 2.0f;
        float f18 = this.rotateAngle;
        pointFArray2[0] = this.calcRotatePoint(f16, f4, f17, f2, f18);
        f18 = f15 + this.width / 2.0f;
        float f19 = rectBoundaryShape6.rotateAngle;
        pointFArray2[1] = rectBoundaryShape6.calcRotatePoint(f18, f4, f17, f2, f19);
        f18 = f14 + this.width;
        f19 = rectBoundaryShape5.rotateAngle;
        pointFArray2[2] = rectBoundaryShape5.calcRotatePoint(f18, f4, f17, f2, f19);
        f18 = this.rotateAngle;
        pointFArray2[3] = this.calcRotatePoint(f13, f4 += this.height / 2.0f, f17, f2, f18);
        f4 = f12 + this.width;
        f18 = f11 + this.height / 2.0f;
        f19 = rectBoundaryShape4.rotateAngle;
        pointFArray2[4] = rectBoundaryShape4.calcRotatePoint(f4, f18, f17, f2, f19);
        f4 = f10 + this.height;
        f18 = this.rotateAngle;
        pointFArray2[5] = this.calcRotatePoint(f9, f4, f17, f2, f18);
        f4 = f8 + this.width / 2.0f;
        f18 = f7 + this.height;
        f19 = rectBoundaryShape3.rotateAngle;
        pointFArray2[6] = rectBoundaryShape3.calcRotatePoint(f4, f18, f17, f2, f19);
        f4 = f6 + this.width;
        f18 = f5 + this.height;
        f19 = rectBoundaryShape2.rotateAngle;
        pointFArray2[7] = rectBoundaryShape2.calcRotatePoint(f4, f18, f17, f2, f19);
        float f20 = f3 - this.mCircleSpacing - this.mTextBgHeight;
        f4 = rectBoundaryShape.rotateAngle;
        pointFArray[8] = rectBoundaryShape.calcRotatePoint(f17, f20, f17, f2, f4);
        return pointFArray;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    public void setScaleOperatorDir(int n2) {
        this.scaleOperatorDir = n2;
    }

    public void setScaleEnable(boolean bl) {
        this.isScaleEnable = bl;
    }

    public boolean isScaleEnable() {
        return this.isScaleEnable;
    }

    public int getScaleOperatorDir() {
        return this.scaleOperatorDir;
    }

    public void setOwnerList(List<String> list) {
        this.ownerList = list;
    }

    @Override
    public void onDraw(Canvas canvas, Matrix matrix) {
        this.onDraw(canvas, matrix, null);
    }

    @Override
    public void onDraw(Canvas canvas, Matrix matrix, ShapeRegionInfo object) {
        float f2;
        float f3;
        float f4;
        List<String> list;
        float f5;
        float f6;
        float[] fArray = new float[4];
        Object object2 = object = (Object)fArray;
        LPPointF lPPointF = this.mSourcePoint;
        float f7 = lPPointF.x;
        object[0] = f7;
        float f8 = lPPointF.y;
        object[1] = f8;
        object[2] = f7 + this.width;
        object2[3] = f8 + this.height;
        matrix.mapPoints((float[])object2);
        f7 = Math.min(fArray[0], (float)object[2]);
        f8 = Math.max(fArray[0], (float)object[2]);
        float f9 = Math.min(fArray[1], (float)object[3]);
        float f10 = Math.max(fArray[1], (float)object[3]);
        float f11 = f10;
        float f12 = f8;
        float f13 = f9;
        float f14 = f7;
        RectBoundaryShape rectBoundaryShape = this;
        RectBoundaryShape rectBoundaryShape2 = this;
        float f15 = f11;
        float f16 = f8;
        float f17 = f11;
        f11 = f8 - f7;
        f8 = f17 - f9;
        canvas.save();
        this.mCenterX = f6 = (f7 + f16) / 2.0f;
        this.mCenterY = f5 = (f9 + f15) / 2.0f;
        canvas.translate(f6, f5);
        canvas.rotate(this.rotateAngle);
        PointF[] pointFArray = new PointF[3];
        PointF[] pointFArray2 = pointFArray;
        RectBoundaryShape rectBoundaryShape3 = this;
        float f18 = f7;
        RectBoundaryShape rectBoundaryShape4 = this;
        float f19 = f7;
        RectBoundaryShape rectBoundaryShape5 = this;
        f7 = rectBoundaryShape5.mCenterX;
        f5 = rectBoundaryShape5.mCenterY;
        float f20 = rectBoundaryShape5.rotateAngle;
        pointFArray2[0] = this.calcRotatePoint(f19, f9, f7, f5, f20);
        f7 = rectBoundaryShape4.mCenterY;
        f5 = rectBoundaryShape4.mCenterX;
        f20 = rectBoundaryShape4.rotateAngle;
        pointFArray2[1] = this.calcRotatePoint(f18, f7, f5, f7, f20);
        f7 = rectBoundaryShape3.mCenterX;
        f5 = rectBoundaryShape3.mCenterY;
        f20 = rectBoundaryShape3.rotateAngle;
        pointFArray[2] = rectBoundaryShape3.calcRotatePoint(f7, f9, f7, f5, f20);
        float f21 = Math.abs(rectBoundaryShape2.mCenterX - pointFArray2[1].x);
        f7 = f21 * f21;
        float f22 = Math.abs(rectBoundaryShape2.mCenterY - pointFArray2[1].y);
        f9 = f22 * f22;
        double d2 = Math.pow(Math.abs(this.mCenterY - pointFArray2[2].y), 2.0);
        f7 = Math.round(Math.sqrt(f7 + f9));
        float f23 = Math.round(Math.sqrt(Math.pow(Math.abs(rectBoundaryShape2.mCenterX - pointFArray2[2].x), 2.0) + d2));
        float f24 = -f7;
        f5 = -f23;
        canvas.translate(f24, f5);
        rectBoundaryShape.mTextX = f24;
        rectBoundaryShape.mTextY = f5;
        rectBoundaryShape.mRotateDeviationX = f7 = rectBoundaryShape.mCenterX - f7;
        rectBoundaryShape.mRotateDeviationY = f23 = rectBoundaryShape.mCenterY - f23;
        f24 = f14 - f7;
        f5 = f13 - f23;
        f7 = f12 - f7;
        f23 = f10 - f23;
        if (this.rotateAngle == 0.0f && (list = this.ownerList) != null && list.size() > 0 && this.isShowPaintOwnerEnable) {
            int n2 = 1;
            f4 = 0.0f;
            for (int i2 = 0; i2 < this.ownerList.size(); ++i2) {
                float f25;
                RectF rectF;
                float f26 = TextUtils.isEmpty((CharSequence)this.ownerList.get(i2)) ? 0.0f : this.mPaintText.measureText(this.ownerList.get(i2));
                f3 = f24 + f4;
                f2 = this.mTextBgHeight;
                float f27 = f5 - (float)n2 * (this.mTextSpacingHeight + f2);
                float f28 = f2;
                f2 = f3 + (f26 += this.mTextLeftPadding * 2.0f);
                float f29 = f27 + f28;
                float f30 = f3;
                RectBoundaryShape rectBoundaryShape6 = this;
                RectF rectF2 = rectF;
                rectF = new RectF(f3, f27, f2, f29);
                f3 = rectBoundaryShape6.mTextSpacingHeight;
                Paint paint = rectBoundaryShape6.mPaintTextBg;
                float f31 = f3;
                canvas.drawRoundRect(rectF2, f31, f31, paint);
                f3 = f30 + this.mTextLeftPadding;
                f2 = f29 - this.mTextTopPadding - this.mTextSpacingHeight;
                if (TextUtils.isEmpty((CharSequence)this.ownerList.get(i2))) continue;
                RectBoundaryShape rectBoundaryShape7 = this;
                String string2 = rectBoundaryShape7.ownerList.get(i2);
                TextPaint textPaint = rectBoundaryShape7.mPaintText;
                canvas.drawText(string2, f3, f2, (Paint)textPaint);
                f4 = f4 + f26 + this.mTextSpacingWidth;
                if (!(f25 >= 480.0f)) continue;
                ++n2;
                f4 = 0.0f;
            }
        }
        if (this.isRotateEnable) {
            RectF rectF;
            float f32;
            RectBoundaryShape rectBoundaryShape8 = this;
            RectBoundaryShape rectBoundaryShape9 = this;
            RectBoundaryShape rectBoundaryShape10 = this;
            RectBoundaryShape rectBoundaryShape11 = this;
            this.mCircleCenterX = f32 = (f24 + f7) / 2.0f;
            f4 = f5 - this.mCircleSpacing;
            float f33 = rectBoundaryShape11.mTextBgHeight;
            this.mCircleCenterY = f4 -= f33;
            Paint paint = rectBoundaryShape11.scalePointPaint;
            canvas.drawCircle(f32, f4, f33 /= 3.0f, paint);
            f4 = rectBoundaryShape10.mCircleCenterX;
            f33 = rectBoundaryShape10.mCircleCenterY + this.mTextBgHeight / 3.0f;
            paint = rectBoundaryShape10.mPaint;
            canvas.drawLine(f4, f33, f32, f5, paint);
            f32 = this.mTextLeftPadding;
            f4 = rectBoundaryShape9.mPaintText.measureText(String.valueOf((int)this.rotateAngle)) + f32 * 2.0f;
            f33 = rectBoundaryShape9.mCircleCenterX + this.mTextHeight / 3.0f * 2.0f;
            float f34 = this.mTextBgHeight;
            f3 = this.mTextSpacingHeight;
            f2 = rectBoundaryShape9.mCircleCenterY + f34 / 2.0f - f3 - f34;
            f4 = f33 + f4;
            f34 = f2 + f34;
            f32 = f33 + f32;
            f3 = f34 - this.mTextTopPadding - f3;
            RectF rectF3 = rectF;
            rectF = new RectF(f33, f2, f4, f34);
            f4 = rectBoundaryShape9.mTextSpacingHeight;
            Paint paint2 = rectBoundaryShape9.mPaintTextBg;
            float f35 = f4;
            canvas.drawRoundRect(rectF3, f35, f35, paint2);
            String string3 = String.valueOf((int)rectBoundaryShape8.rotateAngle);
            paint2 = rectBoundaryShape8.mPaintText;
            canvas.drawText(string3, f32, f3, paint2);
        }
        Paint paint = this.mPaint;
        canvas.drawRect(f24, f5, f7, f23, paint);
        if (!this.isScaleEnable) {
            canvas.restore();
            return;
        }
        Canvas canvas2 = canvas;
        float f36 = f24;
        float f37 = f5;
        float f38 = f5;
        float f39 = f24;
        float f40 = f11;
        float f41 = f23;
        float f42 = f7;
        float f43 = f24 - 5.0f;
        float f44 = f5 - 5.0f;
        f7 = f24 + 5.0f;
        f11 = f5 + 5.0f;
        Paint paint3 = this.scalePointPaint;
        canvas.drawRect(f43, f44, f7, f11, paint3);
        float f45 = f42 - 5.0f;
        f23 = f42 + 5.0f;
        Paint paint4 = this.scalePointPaint;
        canvas.drawRect(f45, f44, f23, f11, paint4);
        float f46 = f41 - 5.0f;
        f5 = f41 + 5.0f;
        paint = this.scalePointPaint;
        canvas.drawRect(f45, f46, f23, f5, paint);
        paint = this.scalePointPaint;
        canvas.drawRect(f43, f46, f7, f5, paint);
        float f47 = f40 / 2.0f;
        f4 = f39 + Math.abs(f47) - 5.0f;
        float f48 = f39 + Math.abs(f47) + 5.0f;
        Paint paint5 = this.scalePointPaint;
        canvas.drawRect(f4, f44, f48, f11, paint5);
        f44 = f8 / 2.0f;
        f11 = f38 + Math.abs(f44) - 5.0f;
        f4 = f38 + Math.abs(f44) + 5.0f;
        Paint paint6 = this.scalePointPaint;
        canvas.drawRect(f43, f11, f7, f4, paint6);
        f43 = f37 + Math.abs(f44) - 5.0f;
        f44 = f37 + Math.abs(f44) + 5.0f;
        Paint paint7 = this.scalePointPaint;
        canvas.drawRect(f45, f43, f23, f44, paint7);
        f43 = f36 + Math.abs(f47) - 5.0f;
        f44 = f36 + Math.abs(f47) + 5.0f;
        paint7 = this.scalePointPaint;
        canvas2.drawRect(f43, f46, f44, f5, paint7);
        canvas2.restore();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int isInScaleRect(float f2, float f3) {
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14;
        PointF pointF = this.getRotateBoundaryPoint();
        int n2 = -1;
        PointF pointF2 = pointF[0];
        float f15 = pointF2.x;
        if (f2 >= f14 - 5.0f - 20.0f && f2 <= f15 + 5.0f + 20.0f) {
            float f16;
            float f17 = pointF2.y;
            if (f3 >= f16 - 5.0f - 20.0f && f3 <= f17 + 5.0f + 20.0f) {
                return 0;
            }
        }
        pointF2 = pointF[1];
        f15 = pointF2.x;
        if (f2 >= f13 - 5.0f - 20.0f && f2 <= f15 + 5.0f + 20.0f) {
            float f18;
            float f19 = pointF2.y;
            if (f3 >= f18 - 5.0f - 20.0f && f3 <= f19 + 5.0f + 20.0f) {
                return 7;
            }
        }
        PointF pointF3 = pointF[2];
        f15 = pointF3.x;
        if (f2 >= f12 - 5.0f - 20.0f && f2 <= f15 + 5.0f + 20.0f) {
            float f20;
            float f21 = pointF3.y;
            if (f3 >= f20 - 5.0f - 20.0f && f3 <= f21 + 5.0f + 20.0f) {
                return 6;
            }
        }
        PointF pointF4 = pointF[3];
        f15 = pointF4.x;
        if (f2 >= f11 - 5.0f - 20.0f && f2 <= f15 + 5.0f + 20.0f) {
            float f22;
            float f23 = pointF4.y;
            if (f3 >= f22 - 5.0f - 20.0f && f3 <= f23 + 5.0f + 20.0f) {
                return 1;
            }
        }
        PointF pointF5 = pointF[4];
        f15 = pointF5.x;
        if (f2 >= f10 - 5.0f - 20.0f && f2 <= f15 + 5.0f + 20.0f) {
            float f24;
            float f25 = pointF5.y;
            if (f3 >= f24 - 5.0f - 20.0f && f3 <= f25 + 5.0f + 20.0f) {
                return 5;
            }
        }
        PointF pointF6 = pointF[5];
        f15 = pointF6.x;
        if (f2 >= f9 - 5.0f - 20.0f && f2 <= f15 + 5.0f + 20.0f) {
            float f26;
            float f27 = pointF6.y;
            if (f3 >= f26 - 5.0f - 20.0f && f3 <= f27 + 5.0f + 20.0f) {
                return 2;
            }
        }
        PointF pointF7 = pointF[6];
        f15 = pointF7.x;
        if (f2 >= f8 - 5.0f - 20.0f && f2 <= f15 + 5.0f + 20.0f) {
            float f28;
            float f29 = pointF7.y;
            if (f3 >= f28 - 5.0f - 20.0f && f3 <= f29 + 5.0f + 20.0f) {
                return 3;
            }
        }
        PointF pointF8 = pointF[7];
        f15 = pointF8.x;
        if (f2 >= f7 - 5.0f - 20.0f && f2 <= f15 + 5.0f + 20.0f) {
            float f30;
            float f31 = pointF8.y;
            if (f3 >= f30 - 5.0f - 20.0f && f3 <= f31 + 5.0f + 20.0f) {
                return 4;
            }
        }
        pointF = pointF[8];
        float f32 = pointF.x;
        f15 = this.mTextBgHeight;
        if (!(f2 >= f6 - f5 / 3.0f)) return n2;
        if (!(f2 <= f32 + f15 / 3.0f)) return n2;
        f2 = pointF.y;
        if (!(f3 >= f4 - f15 / 3.0f)) return n2;
        if (!(f3 <= f2 + f15 / 3.0f + 5.0f + 20.0f)) return n2;
        if (this.isRotateEnable) return 8;
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public float[] getScaleParams(float f2, float f3) {
        float f4;
        float f5;
        float f6;
        float f7;
        block43: {
            if (this.scaleOperatorDir < 0) {
                return null;
            }
            RectBoundaryShape rectBoundaryShape = this;
            PointF pointF = rectBoundaryShape.getRotateBoundaryPoint();
            f7 = 1.0f;
            f6 = 1.0f;
            double d2 = (float)((double)rectBoundaryShape.rotateAngle * Math.PI / 180.0);
            float f8 = (float)Math.cos(d2);
            float f9 = (float)Math.sin(d2);
            f5 = 0.0f;
            f4 = 0.0f;
            switch (rectBoundaryShape.scaleOperatorDir) {
                default: {
                    return new float[]{f7, f6, f5, f4};
                }
                case 8: {
                    RectBoundaryShape rectBoundaryShape2 = this;
                    LPPointF lPPointF = rectBoundaryShape2.mSourcePoint;
                    float f10 = lPPointF.x;
                    f8 = lPPointF.y + this.height / 2.0f;
                    float f11 = f6 - rectBoundaryShape2.mCircleSpacing - this.mTextBgHeight;
                    this.rotateAngle = this.getIn_angle(f10 += this.width / 2.0f, f8, f10, f11, f2, f3);
                    return new float[]{f7, f6, f5, f4};
                }
                case 7: {
                    float f12;
                    if (Math.abs(this.mSourcePoint.y + this.height - f3) < 3.0f) {
                        return null;
                    }
                    PointF pointF2 = pointF[1];
                    f4 = (f2 - pointF2.x) * f9 - (f3 - pointF2.y) * f8;
                    float f13 = this.height;
                    f6 = (f4 + f13) / f13;
                    int n2 = f12 > 0.0f ? 7 : 3;
                    this.scaleOperatorDir = n2;
                    return new float[]{f7, f6, f5, f4};
                }
                case 6: {
                    if (Math.abs(f2 - this.mSourcePoint.x) < 3.0f) return null;
                    if (Math.abs(f3 - (this.mSourcePoint.y + this.height)) < 3.0f) {
                        return null;
                    }
                    pointF = pointF[2];
                    f7 = pointF.x;
                    float f14 = pointF.y;
                    f5 = (f2 - f7) * f8 - (f14 - f3) * f9;
                    f4 = (f2 - f7) * f9 + (f14 - f3) * f8;
                    f2 = this.width;
                    f6 = (f5 + f2) / f2;
                    f2 = this.height;
                    f3 = (f4 + f2) / f2;
                    float f15 = f6 - 0.0f;
                    float f16 = f15 == 0.0f ? 0 : (f15 < 0.0f ? -1 : 1);
                    if (f16 < 0 && f3 < 0.0f) {
                        this.scaleOperatorDir = 2;
                    } else if (f16 < 0) {
                        this.scaleOperatorDir = 0;
                    } else if (f3 < 0.0f) {
                        this.scaleOperatorDir = 4;
                    }
                    if (this.isRatioScaleEnable) {
                        break;
                    }
                    break block43;
                }
                case 5: {
                    float f17;
                    if (Math.abs(f2 - this.mSourcePoint.x) <= 3.0f) {
                        return null;
                    }
                    PointF pointF3 = pointF[4];
                    f5 = (f2 - pointF3.x) * f8 + (f3 - pointF3.y) * f9;
                    float f18 = this.width;
                    f7 = (f5 + f18) / f18;
                    int n3 = f17 >= 0.0f ? 5 : 1;
                    this.scaleOperatorDir = n3;
                    return new float[]{f7, f6, f5, f4};
                }
                case 4: {
                    if (Math.abs(f2 - this.mSourcePoint.x) < 3.0f) return null;
                    if (Math.abs(f3 - this.mSourcePoint.y) < 3.0f) {
                        return null;
                    }
                    pointF = pointF[7];
                    f7 = pointF.x;
                    float f19 = pointF.y;
                    f5 = (f2 - f7) * f8 - (f19 - f3) * f9;
                    f4 = (f7 - f2) * f9 + (f3 - f19) * f8;
                    f2 = this.width;
                    f6 = (f5 + f2) / f2;
                    f2 = this.height;
                    f3 = (f4 + f2) / f2;
                    float f20 = f6 - 0.0f;
                    float f21 = f20 == 0.0f ? 0 : (f20 < 0.0f ? -1 : 1);
                    if (f21 < 0 && f3 < 0.0f) {
                        this.scaleOperatorDir = 0;
                    } else if (f21 < 0) {
                        this.scaleOperatorDir = 2;
                    } else if (f3 < 0.0f) {
                        this.scaleOperatorDir = 6;
                    }
                    if (this.isRatioScaleEnable) {
                        break;
                    }
                    break block43;
                }
                case 3: {
                    float f22;
                    if (Math.abs(f3 - this.mSourcePoint.y) < 3.0f) {
                        return null;
                    }
                    pointF = pointF[6];
                    f4 = (pointF.x - f2) * f9 - (pointF.y - f3) * f8;
                    f2 = this.height;
                    f6 = (f4 + f2) / f2;
                    int n4 = f22 >= 0.0f ? 3 : 7;
                    this.scaleOperatorDir = n4;
                    return new float[]{f7, f6, f5, f4};
                }
                case 2: {
                    if (Math.abs(f2 - (this.mSourcePoint.x + this.width)) < 3.0f) return null;
                    if (Math.abs(f3 - this.mSourcePoint.y) < 3.0f) {
                        return null;
                    }
                    pointF = pointF[5];
                    f7 = pointF.x;
                    float f23 = pointF.y;
                    f5 = (f7 - f2) * f8 - (f3 - f23) * f9;
                    f4 = (f7 - f2) * f9 + (f3 - f23) * f8;
                    f2 = this.width;
                    f6 = (f5 + f2) / f2;
                    f2 = this.height;
                    f3 = (f4 + f2) / f2;
                    float f24 = f6 - 0.0f;
                    float f25 = f24 == 0.0f ? 0 : (f24 < 0.0f ? -1 : 1);
                    if (f25 < 0 && f3 < 0.0f) {
                        this.scaleOperatorDir = 6;
                    } else if (f25 < 0) {
                        this.scaleOperatorDir = 4;
                    } else if (f3 < 0.0f) {
                        this.scaleOperatorDir = 0;
                    }
                    if (this.isRatioScaleEnable) {
                        break;
                    }
                    break block43;
                }
                case 1: {
                    float f26;
                    if (Math.abs(this.mSourcePoint.x + this.width - f2) < 3.0f) {
                        return null;
                    }
                    pointF = pointF[3];
                    f5 = (pointF.x - f2) * f8 + (pointF.y - f3) * f9;
                    f2 = this.width;
                    f7 = (f5 + f2) / f2;
                    int n5 = f26 > 0.0f ? 1 : 5;
                    this.scaleOperatorDir = n5;
                    return new float[]{f7, f6, f5, f4};
                }
                case 0: {
                    if (Math.abs(f2 - (this.mSourcePoint.x + this.width)) < 3.0f) return null;
                    if (Math.abs(f3 - (this.mSourcePoint.y + this.height)) < 3.0f) {
                        return null;
                    }
                    pointF = pointF[0];
                    f7 = pointF.x;
                    float f27 = pointF.y;
                    f5 = (f7 - f2) * f8 + (f27 - f3) * f9;
                    f4 = (f2 - f7) * f9 + (f27 - f3) * f8;
                    f2 = this.width;
                    f6 = (f5 + f2) / f2;
                    f2 = this.height;
                    f3 = (f4 + f2) / f2;
                    float f28 = f6 - 0.0f;
                    float f29 = f28 == 0.0f ? 0 : (f28 < 0.0f ? -1 : 1);
                    if (f29 < 0 && f3 < 0.0f) {
                        this.scaleOperatorDir = 4;
                    } else if (f29 < 0) {
                        this.scaleOperatorDir = 6;
                    } else if (f3 < 0.0f) {
                        this.scaleOperatorDir = 2;
                    }
                    if (!this.isRatioScaleEnable) break block43;
                }
            }
            f4 = (f6 - 1.0f) * f2;
            f7 = f6;
            return new float[]{f7, f6, f5, f4};
        }
        float f30 = f6;
        f6 = f3;
        f7 = f30;
        return new float[]{f7, f6, f5, f4};
    }

    @Override
    public boolean isInBoundary(float f2, float f3) {
        float f4 = this.mSourcePoint.x;
        RectBoundaryShape rectBoundaryShape = this;
        float f5 = rectBoundaryShape.mSourcePoint.x;
        float f6 = Math.max(f5, f5 + this.width);
        float f7 = rectBoundaryShape.mSourcePoint.y;
        float f8 = Math.min(f7, f7 + this.height);
        float f9 = rectBoundaryShape.mSourcePoint.y;
        float f10 = Math.max(f9, f9 + this.height);
        return Math.min(f4, f4 + this.width) <= f2 && f6 >= f2 && f8 <= f3 && f10 >= f3;
    }

    @Override
    public boolean isTouchShape(float f2, float f3) {
        return false;
    }

    @Override
    public RectF getBoundary() {
        RectF rectF;
        RectF rectF2 = rectF;
        rectF2();
        float f2 = this.mSourcePoint.x;
        rectF2.left = Math.min(f2, f2 + this.width);
        float f3 = this.mSourcePoint.y;
        rectF2.bottom = Math.max(f3, f3 + this.height);
        float f4 = this.mSourcePoint.x;
        rectF2.right = Math.max(f4, f4 + this.width);
        float f5 = this.mSourcePoint.y;
        rectF.top = Math.min(f5, f5 + this.height);
        return rectF;
    }

    @Override
    public void moveShapeBy(float f2, float f3) {
        LPPointF lPPointF = this.mSourcePoint;
        lPPointF.x += f2;
        lPPointF.y += f3;
    }

    @Override
    public void scaleShapeBy(int n2, float f2, float f3, float f4, float f5, RectF rectF, boolean bl) {
    }

    public void setBoundaryRect(RectF rectF) {
        if (rectF == null) {
            return;
        }
        LPPointF lPPointF = this.mSourcePoint;
        lPPointF.x = rectF.left;
        lPPointF.y = rectF.top;
        this.width = rectF.width();
        this.height = rectF.height();
    }

    @Override
    public boolean isBoundaryOverlap(RectF rectF) {
        RectBoundaryShape rectBoundaryShape = this;
        float f2 = rectBoundaryShape.mSourcePoint.x;
        float f3 = Math.min(f2, f2 + this.width);
        float f4 = rectBoundaryShape.mSourcePoint.x;
        float f5 = Math.max(f4, f4 + this.width);
        float f6 = rectBoundaryShape.mSourcePoint.y;
        float f7 = Math.min(f6, f6 + this.height);
        float f8 = rectBoundaryShape.mSourcePoint.y;
        float f9 = Math.max(f8, f8 + this.height);
        return !(rectF.right < f3 || rectF.bottom < f7 || f5 < rectF.left || f9 < rectF.top);
    }

    @Override
    public boolean isValid() {
        return this.width != 0.0f && this.height != 0.0f;
    }

    @Override
    public void appendPoint(LPPointF lPPointF) {
        RectBoundaryShape rectBoundaryShape = object;
        RectBoundaryShape rectBoundaryShape2 = object;
        Object object = object.mSourcePoint;
        rectBoundaryShape2.width = lPPointF.x - ((PointF)object).x;
        rectBoundaryShape.height = lPPointF.y - ((PointF)object).y;
    }

    @Override
    public ArrayList<LPPointF> getPoints() {
        ArrayList<LPPointF> arrayList;
        ArrayList<LPPointF> arrayList2;
        ArrayList<LPPointF> arrayList3 = arrayList2 = arrayList;
        arrayList2();
        arrayList3.add(this.mSourcePoint);
        LPPointF lPPointF = this.mSourcePoint;
        float f2 = lPPointF.x + this.width;
        arrayList3.add(new LPPointF(f2, lPPointF.y));
        LPPointF lPPointF2 = this.mSourcePoint;
        arrayList3.add(new LPPointF(lPPointF2.x + this.width, lPPointF2.y + this.height));
        lPPointF2 = this.mSourcePoint;
        arrayList3.add(new LPPointF(lPPointF2.x, lPPointF2.y + this.height));
        arrayList.add(this.mSourcePoint);
        return arrayList;
    }

    @Override
    public void copyShape(Shape shape) {
        RectBoundaryShape rectBoundaryShape = rectBoundaryShape2;
        RectBoundaryShape rectBoundaryShape2 = (RectBoundaryShape)shape;
        rectBoundaryShape.width = rectBoundaryShape2.getWidth();
        rectBoundaryShape.height = rectBoundaryShape2.getHeight();
    }

    public void setSelectedStartPoint(int n2, int n3) {
        LPPointF lPPointF;
        RectBoundaryShape rectBoundaryShape = object;
        Object object = lPPointF;
        float f2 = n2;
        lPPointF = new LPPointF(f2, n3);
        rectBoundaryShape.mSourcePoint = object;
    }

    public void setSelectedEndPoint(int n2, int n3) {
        RectBoundaryShape rectBoundaryShape = object;
        RectBoundaryShape rectBoundaryShape2 = object;
        Object object = object.mSourcePoint;
        rectBoundaryShape2.width = (float)n2 - ((PointF)object).x;
        rectBoundaryShape.height = (float)n3 - ((PointF)object).y;
    }

    public void setShowPaintOwnerEnable(boolean bl) {
        this.isShowPaintOwnerEnable = bl;
    }

    @Override
    public void setAngle(float f2) {
        this.rotateAngle = f2;
    }

    public void setRotateEnable(boolean bl) {
        this.isRotateEnable = bl;
    }

    public void setRatioScaleEnable(boolean bl) {
        this.isRatioScaleEnable = bl;
    }
}

