/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.ppt.whiteboard.shape;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import com.baijiayun.livecore.models.LPPointF;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.ppt.whiteboard.shape.ShapeRegionInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class ETriangleShape
extends Shape {
    private Paint fillPaint;
    private float fillPadding;
    private final double angle;
    private PointF mPoint;
    private Queue<LPPointF> mPoints;
    private List<Float> pointX;
    private List<Float> pointY;
    private PointF rotatePoint;

    public ETriangleShape(Paint paint) {
        ETriangleShape eTriangleShape = this;
        super(paint);
        eTriangleShape.angle = 2.0943951023931953;
        eTriangleShape.mPoints = new LinkedList<LPPointF>();
        eTriangleShape.pointX = new ArrayList<Float>();
        eTriangleShape.pointY = new ArrayList<Float>();
        eTriangleShape.mPaint.setStyle(Paint.Style.STROKE);
    }

    public ETriangleShape(Paint object, boolean bl) {
        super((Paint)object);
        ArrayList arrayList;
        ArrayList arrayList2;
        LinkedList linkedList;
        this.angle = 2.0943951023931953;
        object = linkedList;
        linkedList = new LinkedList();
        this.mPoints = object;
        object = arrayList2;
        arrayList2 = new ArrayList();
        this.pointX = object;
        object = arrayList;
        arrayList = new ArrayList();
        this.pointY = object;
        if (bl) {
            this.fillPaint = this.mPaint;
        }
    }

    private PointF rotatePoint(PointF pointF) {
        LPPointF lPPointF = object.mSourcePoint;
        double d2 = pointF.x - lPPointF.x;
        double d3 = pointF.y - lPPointF.y;
        double d4 = d2 * Math.cos(2.0943951023931953) - d3 * Math.sin(2.0943951023931953);
        d3 = d2 * Math.sin(2.0943951023931953) + d3 * Math.cos(2.0943951023931953);
        Object object = object.mSourcePoint;
        float f2 = (int)(d4 + (double)((PointF)object).x);
        return new PointF(f2, (float)((int)(d3 + (double)((PointF)object).y)));
    }

    @Override
    public void onDraw(Canvas canvas, Matrix matrix) {
        this.onDraw(canvas, matrix, null);
    }

    @Override
    public void onDraw(Canvas canvas, Matrix matrix, ShapeRegionInfo shapeRegionInfo) {
        if (this.mSourcePoint != null && (shapeRegionInfo = this.mPoint) != null) {
            Path path;
            ETriangleShape eTriangleShape = this;
            PointF pointF = eTriangleShape.rotatePoint;
            pointF.x = ((PointF)shapeRegionInfo).x;
            pointF.y = ((PointF)shapeRegionInfo).y;
            shapeRegionInfo = path;
            ETriangleShape eTriangleShape2 = this;
            shapeRegionInfo();
            float[] fArray = new float[10];
            matrix.getValues(fArray);
            this.mPaint.setStyle(Paint.Style.STROKE);
            float f2 = fArray[0];
            float f3 = fArray[4];
            float f4 = fArray[2];
            float f5 = fArray[5];
            eTriangleShape2.mPoints.clear();
            eTriangleShape2.pointX.clear();
            eTriangleShape2.pointY.clear();
            PointF pointF2 = eTriangleShape2.mPoint;
            path.moveTo(pointF2.x * f2 + f4, pointF2.y * f3 + f5);
            PointF pointF3 = this.mPoint;
            float f6 = pointF3.x;
            eTriangleShape.mPoints.add(new LPPointF(f6, pointF3.y));
            eTriangleShape.pointX.add(Float.valueOf(this.mPoint.x));
            eTriangleShape.pointY.add(Float.valueOf(this.mPoint.y));
            for (int i2 = 0; i2 < 2; ++i2) {
                PointF pointF4;
                ETriangleShape eTriangleShape3 = this;
                ETriangleShape eTriangleShape4 = this;
                eTriangleShape4.rotatePoint = pointF4 = eTriangleShape4.rotatePoint(eTriangleShape4.rotatePoint);
                shapeRegionInfo.lineTo(pointF4.x * f2 + f4, pointF4.y * f3 + f5);
                PointF pointF5 = pointF4;
                float f7 = pointF5.x;
                eTriangleShape3.mPoints.add(new LPPointF(f7, pointF5.y));
                eTriangleShape3.pointX.add(Float.valueOf(pointF4.x));
                eTriangleShape3.pointY.add(Float.valueOf(pointF4.y));
            }
            ETriangleShape eTriangleShape5 = this;
            Collections.sort(eTriangleShape5.pointX);
            Collections.sort(eTriangleShape5.pointY);
            shapeRegionInfo.close();
            canvas.drawPath((Path)shapeRegionInfo, this.getPaint());
            Paint paint = this.fillPaint;
            if (paint != null) {
                paint.setStyle(Paint.Style.FILL);
                canvas.drawPath((Path)shapeRegionInfo, this.fillPaint);
            }
            return;
        }
    }

    @Override
    public ArrayList<LPPointF> getPoints() {
        return new ArrayList<LPPointF>(this.mPoints);
    }

    @Override
    public void copyShape(Shape shape) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInBoundary(float f2, float f3) {
        if (this.pointY.isEmpty()) return false;
        if (this.pointX.isEmpty()) return false;
        if (!(this.pointX.get(0).floatValue() <= f2)) return false;
        if (!(this.pointY.get(0).floatValue() <= f3)) return false;
        List<Float> list = this.pointX;
        if (!(list.get(list.size() - 1).floatValue() >= f2)) return false;
        List<Float> list2 = this.pointY;
        if (!(list2.get(list2.size() - 1).floatValue() >= f3)) return false;
        return true;
    }

    @Override
    public boolean isTouchShape(float f2, float f3) {
        return false;
    }

    @Override
    public RectF getBoundary() {
        float f2 = 2.1474836E9f;
        float f3 = -2.1474836E9f;
        float f4 = 2.1474836E9f;
        float f5 = -2.1474836E9f;
        for (PointF pointF : this.mPoints) {
            float f6;
            float f7;
            float f8 = pointF.x;
            if (f2 > f7) {
                f2 = f8;
            }
            float f9 = pointF.y;
            if (f4 > f6) {
                f4 = f9;
            }
            if (f3 < f8) {
                f3 = f8;
            }
            if (!(f5 < f9)) continue;
            f5 = f9;
        }
        new RectF().left = f2;
        new RectF().top = f4;
        new RectF().right = f3;
        new RectF().bottom = f5;
        return new RectF();
    }

    @Override
    public void moveShapeBy(float f2, float f3) {
        if (this.mPoints.isEmpty()) {
            return;
        }
        ETriangleShape eTriangleShape = this;
        PointF pointF = eTriangleShape.mPoint;
        pointF.x += f2;
        pointF.y += f3;
        LPPointF lPPointF = eTriangleShape.mSourcePoint;
        lPPointF.x += f2;
        lPPointF.y += f3;
        PointF pointF2 = eTriangleShape.rotatePoint;
        pointF2.x += f2;
        pointF2.y += f3;
    }

    @Override
    public void scaleShapeBy(int n2, float f2, float f3, float f4, float f5, RectF rectF, boolean bl) {
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isBoundaryOverlap(RectF rectF) {
        if (this.pointY.isEmpty()) return false;
        if (this.pointX.isEmpty()) return false;
        if (this.mSourcePoint == null) return false;
        if (rectF.right < this.pointX.get(0).floatValue()) return false;
        if (rectF.bottom < this.pointY.get(0).floatValue()) return false;
        List<Float> list = this.pointX;
        if (list.get(list.size() - 1).floatValue() < rectF.left) return false;
        List<Float> list2 = this.pointY;
        if (list2.get(list2.size() - 1).floatValue() < rectF.top) return false;
        return true;
    }

    @Override
    public boolean isValid() {
        return this.mSourcePoint != null && this.mPoint != null;
    }

    @Override
    public void appendPoint(LPPointF lPPointF) {
        ETriangleShape eTriangleShape = this;
        eTriangleShape.mPoint = lPPointF;
        eTriangleShape.rotatePoint = lPPointF;
    }

    @Override
    public void setAngle(float f2) {
    }
}

