/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.ppt.whiteboard;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livecore.R;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPMotionEvent;
import com.baijiayun.livecore.models.roomresponse.LPMockClearCacheModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomShapeDelModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomShapeMultipleModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomShapeSingleModel;
import com.baijiayun.livecore.ppt.util.LPShapeConverter;
import com.baijiayun.livecore.ppt.whiteboard.shape.LaserShape;
import com.baijiayun.livecore.viewmodels.impl.LPShapeViewModel;
import com.baijiayun.livecore.viewmodels.impl.ShapeVM;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;

public class LaserShapeLayer
extends FrameLayout
implements LifecycleObserver {
    private LaserShape laserShape;
    private ShapeVM shapeVM;
    private boolean isEnableDrawLaser;
    private Disposable timer;
    private String docId;
    private int page;
    private ShapeVM.LPShapeReceiverListener lpShapeReceiverListener;
    private OnChangeLaserShapeListener onChangeLaserShapeListener;
    private final PositionInfo mPositionInfo;
    private final LPMotionEvent lpMotionEvent;
    private VectorDrawableCompat shapeCursorVectorDrawable;
    private Bitmap laserShapeBitmap;
    private boolean isSupportScale;
    private int moveNum;
    private final LPResRoomShapeSingleModel singleModel;

    public LaserShapeLayer(Context context) {
        this(context, null);
    }

    public LaserShapeLayer(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public LaserShapeLayer(Context context, @Nullable AttributeSet attributeSet, int n2) {
        LaserShapeLayer laserShapeLayer = this;
        super(context, attributeSet, n2);
        laserShapeLayer.laserShape = new LaserShape(null);
        laserShapeLayer.docId = "0";
        laserShapeLayer.mPositionInfo = new PositionInfo();
        laserShapeLayer.lpMotionEvent = new LPMotionEvent();
        laserShapeLayer.singleModel = new LPResRoomShapeSingleModel();
        laserShapeLayer.setWillNotDraw(false);
        laserShapeLayer.shapeCursorVectorDrawable = VectorDrawableCompat.create((Resources)laserShapeLayer.getResources(), (int)R.drawable.live_core_svg_shape_brush, null);
        laserShapeLayer.laserShapeBitmap = BitmapFactory.decodeResource((Resources)laserShapeLayer.getContext().getResources(), (int)R.drawable.live_core_svg_shape_laser);
    }

    public LaserShapeLayer(Context context, @Nullable AttributeSet attributeSet, int n2, int n3) {
        super(context, attributeSet, n2, n3);
        LPResRoomShapeSingleModel lPResRoomShapeSingleModel;
        LPMotionEvent lPMotionEvent;
        PositionInfo positionInfo;
        LaserShape laserShape;
        Object object = laserShape;
        laserShape = new LaserShape(null);
        v1.laserShape = object;
        v1.docId = "0";
        object = positionInfo;
        positionInfo = new PositionInfo();
        v1.mPositionInfo = object;
        object = lPMotionEvent;
        lPMotionEvent = new LPMotionEvent();
        v1.lpMotionEvent = object;
        object = lPResRoomShapeSingleModel;
        lPResRoomShapeSingleModel = new LPResRoomShapeSingleModel();
        v1.singleModel = object;
    }

    private void onCreateListener(LiveRoom object) {
        ShapeVM.LPShapeReceiverListener lPShapeReceiverListener;
        boolean bl = object.getRoomInfo().roomType == LPConstants.LPRoomType.NewSmallGroup;
        LiveRoom liveRoom = object;
        LaserShapeLayer laserShapeLayer = this;
        laserShapeLayer.isSupportScale = bl;
        object = lPShapeReceiverListener;
        laserShapeLayer.lpShapeReceiverListener = new ShapeVM.LPShapeReceiverListener(){

            @Override
            public void updateShapeInfo(LPResRoomShapeSingleModel object) {
                if ("laser".equals(object.shape.id)) {
                    a a2 = this;
                    a2.LaserShapeLayer.this.updatePositionInfo();
                    LaserShapeLayer laserShapeLayer = a2.LaserShapeLayer.this;
                    a a3 = this;
                    int n2 = ((LaserShapeLayer)a3.LaserShapeLayer.this).mPositionInfo.height;
                    int n3 = ((LaserShapeLayer)a3.LaserShapeLayer.this).mPositionInfo.offsetWidth;
                    int n4 = ((LaserShapeLayer)a3.LaserShapeLayer.this).mPositionInfo.offsetHeight;
                    LaserShapeLayer.access$102(laserShapeLayer, (LaserShape)LPShapeConverter.getShapeFromModel(object.shape, ((LaserShapeLayer)laserShapeLayer).mPositionInfo.width, n2, n3, n4));
                    if (a2.LaserShapeLayer.this.laserShape == null) {
                        return;
                    }
                    if (object.shape.getShapeType() == LPConstants.ShapeType.Mouse) {
                        if (!TextUtils.isEmpty((CharSequence)object.shape.strokeStyle)) {
                            try {
                                LaserShapeLayer.this.shapeCursorVectorDrawable.setTint(Color.parseColor((String)object.shape.strokeStyle));
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        LaserShapeLayer.this.laserShape.setCursorVectorDrawable(LaserShapeLayer.this.shapeCursorVectorDrawable);
                    } else {
                        LaserShapeLayer.this.laserShape.setShowMouse(LaserShapeLayer.this.laserShapeBitmap);
                    }
                    a a4 = this;
                    a4.LaserShapeLayer.this.laserShape.setValid(true);
                    a4.LaserShapeLayer.this.invalidate();
                    RxUtils.dispose((Disposable)a4.LaserShapeLayer.this.timer);
                    object = TimeUnit.SECONDS;
                    LaserShapeLayer.access$502(a4.LaserShapeLayer.this, Observable.timer((long)3L, (TimeUnit)((Object)object)).observeOn(AndroidSchedulers.mainThread()).subscribe(l2 -> LaserShapeLayer.this.invalidate()));
                }
            }

            @Override
            public void updateShape(LPResRoomShapeMultipleModel lPResRoomShapeMultipleModel) {
            }

            @Override
            public void deleteAllShape(LPResRoomShapeDelModel lPResRoomShapeDelModel) {
            }

            @Override
            public void deleteAllShape(LPMockClearCacheModel lPMockClearCacheModel) {
            }

            @Override
            public void deleteShape(LPResRoomShapeDelModel lPResRoomShapeDelModel) {
            }

            @Override
            public void drawAllShape(LPResRoomShapeMultipleModel lPResRoomShapeMultipleModel) {
            }

            @Override
            public void appendShape(LPResRoomShapeSingleModel lPResRoomShapeSingleModel) {
            }
        };
        object = liveRoom.newShapeVM((ShapeVM.LPShapeReceiverListener)object);
        this.shapeVM = object;
        ((LPShapeViewModel)object).setLaserShapeListener(this.lpShapeReceiverListener);
    }

    private void updatePositionInfo() {
        LaserShapeLayer laserShapeLayer = object;
        PositionInfo positionInfo = laserShapeLayer.mPositionInfo;
        positionInfo.isFull = false;
        positionInfo.width = object.getWidth();
        laserShapeLayer.mPositionInfo.height = object.getHeight();
        Object object = laserShapeLayer.mPositionInfo;
        laserShapeLayer.mPositionInfo.offsetWidth = 0;
        laserShapeLayer.mPositionInfo.offsetHeight = 0;
        OnChangeLaserShapeListener onChangeLaserShapeListener = laserShapeLayer.onChangeLaserShapeListener;
        if (onChangeLaserShapeListener != null) {
            onChangeLaserShapeListener.onLaserShapeInfo((PositionInfo)object);
        }
    }

    private float adjustLaserPosition(float f2) {
        return f2 - (float)UtilsKt.getDp((int)30);
    }

    public static /* synthetic */ LaserShape access$102(LaserShapeLayer laserShapeLayer, LaserShape laserShape) {
        laserShapeLayer.laserShape = laserShape;
        return laserShape;
    }

    public static /* synthetic */ Disposable access$502(LaserShapeLayer laserShapeLayer, Disposable disposable) {
        laserShapeLayer.timer = disposable;
        return disposable;
    }

    public void addObserver(Lifecycle lifecycle) {
        if (lifecycle != null) {
            lifecycle.addObserver((LifecycleObserver)this);
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy() {
        ShapeVM shapeVM = this.shapeVM;
        if (shapeVM != null) {
            ((LPShapeViewModel)shapeVM).setLaserShapeListener(null);
            this.shapeVM = null;
        }
        this.lpShapeReceiverListener = null;
        this.onChangeLaserShapeListener = null;
        RxUtils.dispose((Disposable)this.timer);
    }

    public void setLiveRoom(LiveRoom liveRoom) {
        if (liveRoom == null) {
            return;
        }
        this.onCreateListener(liveRoom);
    }

    public void enableDrawLaser(boolean bl) {
        ((LaserShapeLayer)((Object)laserShape)).isEnableDrawLaser = bl;
        LaserShape laserShape = ((LaserShapeLayer)((Object)laserShape)).laserShape;
        if (laserShape != null) {
            laserShape.setValid(bl);
        }
    }

    public boolean isEnableDrawLaser() {
        return this.isEnableDrawLaser;
    }

    public void onDraw(Canvas canvas) {
        LaserShape laserShape = this.laserShape;
        if (laserShape != null && laserShape.isValid()) {
            this.laserShape.onDraw(canvas, this.getMatrix());
        }
    }

    public void setDocInfo(String string2, int n2) {
        LaserShapeLayer laserShapeLayer = this;
        laserShapeLayer.docId = string2;
        laserShapeLayer.page = n2;
    }

    public boolean onTouchEvent(LPMotionEvent lPMotionEvent) {
        if (!this.isEnableDrawLaser) {
            return lPMotionEvent.getMotionEvent() == null || super.onTouchEvent(lPMotionEvent.getMotionEvent());
        }
        int n2 = this.isSupportScale ? this.getWidth() - this.mPositionInfo.offsetWidth * 2 : this.mPositionInfo.width;
        int n3 = this.isSupportScale ? this.getHeight() - this.mPositionInfo.offsetHeight * 2 : this.mPositionInfo.height;
        LaserShapeLayer laserShapeLayer = this;
        laserShapeLayer.laserShape.setShowMouse(this.laserShapeBitmap);
        int n4 = Math.max(laserShapeLayer.mPositionInfo.offsetWidth, 0);
        int n5 = Math.max(laserShapeLayer.mPositionInfo.offsetHeight, 0);
        int n6 = (int)Math.min((float)(laserShapeLayer.getRight() - n4), Math.max((float)(this.getLeft() + n4), lPMotionEvent.getX()));
        int n7 = (int)Math.min((float)(laserShapeLayer.getBottom() - n5), Math.max((float)(this.getTop() + n5), this.adjustLaserPosition(lPMotionEvent.getY())));
        if (lPMotionEvent.isActionDown()) {
            LaserShapeLayer laserShapeLayer2 = this;
            RxUtils.dispose((Disposable)laserShapeLayer2.timer);
            laserShapeLayer2.updatePositionInfo();
            n2 = (int)Math.min((float)(laserShapeLayer2.getRight() - n4), Math.max((float)(this.getLeft() + n4), lPMotionEvent.getX()));
            int n8 = (int)Math.min((float)(laserShapeLayer2.getBottom() - n5), Math.max((float)(this.getTop() + n5), this.adjustLaserPosition(lPMotionEvent.getY())));
            float f2 = n2;
            laserShapeLayer2.laserShape.moveShapeTo(f2, n8);
        } else if (lPMotionEvent.isActionMove()) {
            LaserShapeLayer laserShapeLayer3 = this;
            ++laserShapeLayer3.moveNum;
            float f3 = n6;
            laserShapeLayer3.laserShape.moveShapeTo(f3, n7);
            if (laserShapeLayer3.moveNum % 5 == 0) {
                int n9 = n2;
                PositionInfo positionInfo = this.mPositionInfo;
                int n10 = positionInfo.offsetWidth;
                n2 = positionInfo.offsetHeight;
                this.singleModel.shape = LPShapeConverter.getModelFromShape(this.laserShape, n9, n3, n10, n2, 1);
                this.shapeVM.requestShapeLaserUpdate(this.singleModel);
            }
            this.invalidate();
        } else if (lPMotionEvent.isActionUp() || lPMotionEvent.isActionLeave()) {
            LaserShapeLayer laserShapeLayer4 = this;
            float f4 = n6;
            laserShapeLayer4.laserShape.moveShapeTo(f4, n7);
            LPResRoomShapeSingleModel lPResRoomShapeSingleModel = laserShapeLayer4.singleModel;
            lPResRoomShapeSingleModel.docId = this.docId;
            lPResRoomShapeSingleModel.page = this.page;
            int n11 = n2;
            PositionInfo positionInfo = this.mPositionInfo;
            int n12 = positionInfo.offsetWidth;
            n2 = positionInfo.offsetHeight;
            laserShapeLayer4.singleModel.shape = LPShapeConverter.getModelFromShape(this.laserShape, n11, n3, n12, n2, 1);
            laserShapeLayer4.shapeVM.requestShapeLaserUpdate(this.singleModel);
            laserShapeLayer4.moveNum = 0;
            RxUtils.dispose((Disposable)laserShapeLayer4.timer);
            TimeUnit timeUnit = TimeUnit.SECONDS;
            laserShapeLayer4.timer = Observable.timer((long)5L, (TimeUnit)timeUnit).observeOn(AndroidSchedulers.mainThread()).subscribe(l2 -> {
                LaserShapeLayer laserShapeLayer = this;
                laserShapeLayer.laserShape.setValid(false);
                laserShapeLayer.invalidate();
            });
        }
        return true;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent motionEvent) {
        LaserShapeLayer laserShapeLayer = this;
        laserShapeLayer.lpMotionEvent.setMotionEvent(motionEvent);
        return laserShapeLayer.onTouchEvent(laserShapeLayer.lpMotionEvent);
    }

    public void setOnChangeLaserShapeListener(OnChangeLaserShapeListener onChangeLaserShapeListener) {
        this.onChangeLaserShapeListener = onChangeLaserShapeListener;
    }

    public static class PositionInfo {
        public boolean isFull;
        public int width;
        public int height;
        public int offsetWidth;
        public int offsetHeight;
    }

    public static interface OnChangeLaserShapeListener {
        public void onLaserShapeInfo(PositionInfo var1);
    }
}

