/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.wrapper.impl;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.request.target.SimpleTarget;
import com.baijiayun.glide.request.target.Target;
import com.baijiayun.glide.request.transition.Transition;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livecore.l;
import com.baijiayun.livecore.models.launch.LPEnterRoomNative;
import java.lang.ref.WeakReference;

public class LPVideoView
extends FrameLayout {
    private static int FILL_TYPE_WATER_MARK_MAX_HEIGHT = 56;
    private static int FILL_TYPE_WATER_MARK_MIN_HEIGHT = 12;
    private static int FILL_TYPE_WATER_MARK_MAX_MARGIN = 12;
    private static int FILL_TYPE_WATER_MARK_MIN_MARGIN = 4;
    private static boolean sizeHasBeenInit = false;
    public View holderView;
    public Bitmap waterMark;
    public ImageView ivWaterMark;
    public WaterMarkTarget target;
    private String waterMarkUrl;
    private int waterMarkPosition;
    private boolean zOrderMediaOverlay;
    private LPConstants.LPAspectRatio aspectRatio;
    private LPConstants.LPVideoViewType viewType;
    private FrameLayout.LayoutParams layoutParams;
    private int videoHeight;
    private int videoWidth;

    public LPVideoView(@NonNull Context context) {
        this(context, null);
    }

    public LPVideoView(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public LPVideoView(@NonNull Context context, @Nullable AttributeSet attributeSet, int n2) {
        LPVideoView lPVideoView = this;
        super(context, attributeSet, n2);
        lPVideoView.waterMarkPosition = 1;
        lPVideoView.aspectRatio = LPConstants.LPAspectRatio.Fit;
        lPVideoView.viewType = LPConstants.LPVideoViewType.SURFACE_VIEW;
        lPVideoView.init();
    }

    public LPVideoView(@NonNull Context context, @Nullable AttributeSet attributeSet, int n2, int n3) {
        LPVideoView lPVideoView = this;
        super(context, attributeSet, n2, n3);
        lPVideoView.waterMarkPosition = 1;
        lPVideoView.aspectRatio = LPConstants.LPAspectRatio.Fit;
        lPVideoView.viewType = LPConstants.LPVideoViewType.SURFACE_VIEW;
        lPVideoView.init();
    }

    private void init() {
        FrameLayout.LayoutParams layoutParams;
        this.setBackgroundColor(-16777216);
        FrameLayout.LayoutParams layoutParams2 = layoutParams;
        layoutParams2(-1, -1);
        this.layoutParams = layoutParams2;
        layoutParams.gravity = 17;
    }

    private static void initSize() {
        if (!sizeHasBeenInit) {
            FILL_TYPE_WATER_MARK_MAX_HEIGHT = UtilsKt.getDp((int)FILL_TYPE_WATER_MARK_MAX_HEIGHT);
            FILL_TYPE_WATER_MARK_MIN_HEIGHT = UtilsKt.getDp((int)FILL_TYPE_WATER_MARK_MIN_HEIGHT);
            FILL_TYPE_WATER_MARK_MAX_MARGIN = UtilsKt.getDp((int)FILL_TYPE_WATER_MARK_MAX_MARGIN);
            FILL_TYPE_WATER_MARK_MIN_MARGIN = UtilsKt.getDp((int)FILL_TYPE_WATER_MARK_MIN_MARGIN);
            sizeHasBeenInit = true;
        }
    }

    public void setWaterMark(LPEnterRoomNative.LPWaterMark object) {
        if (object == null) {
            lPVideoView.waterMarkUrl = null;
            lPVideoView.target = null;
            LPVideoView lPVideoView = lPVideoView.ivWaterMark;
            if (lPVideoView != null) {
                lPVideoView.setVisibility(4);
            }
            return;
        }
        lPVideoView.waterMarkPosition = ((LPEnterRoomNative.LPWaterMark)object).pos;
        object = ((LPEnterRoomNative.LPWaterMark)object).url;
        lPVideoView.waterMarkUrl = object;
        if (lPVideoView.target == null && !TextUtils.isEmpty((CharSequence)object)) {
            lPVideoView.target = new WaterMarkTarget(lPVideoView);
            lPVideoView.ivWaterMark = new ImageView(lPVideoView.getContext());
            lPVideoView.ivWaterMark.setVisibility(0);
            if (DisplayUtils.isValidContextForGlide((Context)lPVideoView.getContext())) {
                Glide.with((Context)lPVideoView.getContext()).asBitmap().load(lPVideoView.waterMarkUrl).into((Target)lPVideoView.target);
            }
        }
    }

    public void onSizeChanged(int n2, int n3, int n4, int n5) {
        LPVideoView lPVideoView = this;
        super.onSizeChanged(n2, n3, n4, n5);
        if (TextUtils.isEmpty((CharSequence)lPVideoView.waterMarkUrl)) {
            return;
        }
        if (this.target == null && !TextUtils.isEmpty((CharSequence)this.waterMarkUrl)) {
            this.target = new WaterMarkTarget(this);
            this.ivWaterMark = new ImageView(this.getContext());
            this.ivWaterMark.setVisibility(4);
            if (DisplayUtils.isValidContextForGlide((Context)this.getContext())) {
                Glide.with((Context)this.getContext()).asBitmap().load(this.waterMarkUrl).into((Target)this.target);
            }
        } else {
            LPVideoView lPVideoView2 = this;
            lPVideoView2.post(() -> {
                LPVideoView lPVideoView = this;
                int n4 = lPVideoView.videoHeight;
                lPVideoView.resizeWaterMark(n4, lPVideoView.videoWidth, n3, n2);
            });
        }
    }

    public void setWaterMarkVisibility(int n2) {
        LPVideoView lPVideoView = lPVideoView.ivWaterMark;
        if (lPVideoView != null) {
            lPVideoView.setVisibility(n2);
        }
    }

    public void resizeWaterMark(int n2, int n3) {
        LPVideoView lPVideoView = this;
        int n4 = lPVideoView.getMeasuredHeight();
        int n5 = lPVideoView.getMeasuredWidth();
        lPVideoView.resizeWaterMark(n2, n3, n4, n5);
    }

    public void resizeWaterMark(int n2, int n3, int n4, int n5) {
        if (this.ivWaterMark == null) {
            return;
        }
        if (n2 != 0 && n3 != 0) {
            LPVideoView lPVideoView = this;
            lPVideoView.videoHeight = n2;
            lPVideoView.videoWidth = n3;
        }
        if (this.waterMark == null) {
            return;
        }
        float f2 = n4;
        this.setWaterMarkParams(f2, n5);
    }

    public void setWaterMarkParams(float f2, float f3) {
        int n2;
        int n3;
        LPVideoView.initSize();
        int n4 = (int)(f2 / 6.0f);
        int n5 = 0;
        int n6 = this.videoWidth;
        if (n6 != 0 && (n3 = this.videoHeight) != 0 && this.aspectRatio != LPConstants.LPAspectRatio.Fill) {
            float f4 = (float)n6 / (float)n3 - f3 / f2;
            n5 = f4 == 0.0f ? 0 : (f4 > 0.0f ? 1 : -1);
            if (n5 > 0) {
                n4 = (int)(f3 / (float)n6 * (float)n3 / 6.0f);
            }
            if (n5 > 0) {
                n2 = (int)(-Math.abs((f2 - (float)n3 * f3 / (float)n6) / 2.0f));
                n5 = (int)(f3 / 24.0f);
                n6 = (int)(f3 / (float)this.videoWidth * (float)this.videoHeight / 24.0f);
                int n7 = n2;
                n2 = n5;
                n5 = n7;
            } else {
                n2 = (int)Math.abs((f3 - f2 * (float)n6 / (float)n3) / 2.0f);
                n6 = (int)(f2 / 24.0f);
                n5 = (int)(f2 / (float)this.videoHeight * (float)this.videoWidth / 24.0f);
                int n8 = n2;
                n2 = n5;
                n5 = n8;
            }
        } else {
            n2 = (int)(f3 / 24.0f);
            n6 = (int)(f2 / 24.0f);
        }
        n2 = Math.min(FILL_TYPE_WATER_MARK_MAX_MARGIN, Math.max(FILL_TYPE_WATER_MARK_MIN_MARGIN, n2));
        n6 = Math.min(FILL_TYPE_WATER_MARK_MAX_MARGIN, Math.max(FILL_TYPE_WATER_MARK_MIN_MARGIN, n6));
        n4 = Math.min(FILL_TYPE_WATER_MARK_MAX_HEIGHT, Math.max(FILL_TYPE_WATER_MARK_MIN_HEIGHT, n4));
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.ivWaterMark.getLayoutParams();
        if (layoutParams == null) {
            FrameLayout.LayoutParams layoutParams2;
            layoutParams = layoutParams2;
            layoutParams2 = new FrameLayout.LayoutParams((int)f3, n4);
        } else {
            layoutParams.width = (int)f3;
            layoutParams.height = n4;
        }
        switch (this.waterMarkPosition) {
            default: {
                break;
            }
            case 4: {
                FrameLayout.LayoutParams layoutParams3 = layoutParams;
                FrameLayout.LayoutParams layoutParams4 = layoutParams;
                layoutParams4.leftMargin = n2 + Math.max(n5, 0);
                layoutParams4.topMargin = 0;
                layoutParams4.rightMargin = 0;
                layoutParams3.bottomMargin = n6 - Math.min(n5, 0);
                layoutParams3.gravity = 8388691;
                this.ivWaterMark.setScaleType(ImageView.ScaleType.FIT_START);
                break;
            }
            case 3: {
                FrameLayout.LayoutParams layoutParams5 = layoutParams;
                FrameLayout.LayoutParams layoutParams6 = layoutParams;
                layoutParams6.leftMargin = 0;
                layoutParams6.topMargin = 0;
                layoutParams.rightMargin = n2 + Math.max(n5, 0);
                layoutParams5.bottomMargin = n6 - Math.min(n5, 0);
                layoutParams5.gravity = 0x800055;
                this.ivWaterMark.setScaleType(ImageView.ScaleType.FIT_END);
                break;
            }
            case 2: {
                FrameLayout.LayoutParams layoutParams7 = layoutParams;
                layoutParams.leftMargin = 0;
                layoutParams.topMargin = n6 - Math.min(n5, 0);
                layoutParams7.rightMargin = n2 + Math.max(n5, 0);
                layoutParams7.bottomMargin = 0;
                layoutParams7.gravity = 8388661;
                this.ivWaterMark.setScaleType(ImageView.ScaleType.FIT_END);
                break;
            }
            case 1: {
                FrameLayout.LayoutParams layoutParams8 = layoutParams;
                layoutParams.leftMargin = n2 + Math.max(n5, 0);
                layoutParams8.topMargin = n6 - Math.min(n5, 0);
                layoutParams8.rightMargin = 0;
                layoutParams8.bottomMargin = 0;
                layoutParams8.gravity = 0x800033;
                this.ivWaterMark.setScaleType(ImageView.ScaleType.FIT_START);
            }
        }
        this.ivWaterMark.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setHolderView(View view) {
        UtilsKt.removeViewFromParent((View)view);
        UtilsKt.removeViewFromParent((View)lPVideoView2.holderView);
        lPVideoView2.holderView = view;
        if (l.b(view)) {
            l.a(lPVideoView2.holderView).setZOrderMediaOverlay(lPVideoView2.zOrderMediaOverlay);
        }
        LPVideoView lPVideoView = lPVideoView2;
        LPVideoView lPVideoView2 = lPVideoView.holderView;
        view = lPVideoView.layoutParams;
        lPVideoView.addView((View)lPVideoView2, 0, (ViewGroup.LayoutParams)view);
    }

    public View getHolderView() {
        return this.holderView;
    }

    public void setViewType(LPConstants.LPVideoViewType lPVideoViewType) {
        this.viewType = lPVideoViewType;
    }

    public LPConstants.LPVideoViewType getPreferredViewType() {
        return this.viewType;
    }

    public void setZOrderMediaOverlay(boolean bl) {
        SurfaceView surfaceView;
        LPVideoView lPVideoView = lPVideoView5;
        lPVideoView.zOrderMediaOverlay = bl;
        int n2 = lPVideoView.indexOfChild(lPVideoView.holderView);
        if (n2 == -1) {
            return;
        }
        if (bl) {
            LPVideoView lPVideoView2 = lPVideoView5;
            lPVideoView2.removeView(lPVideoView2.holderView);
            surfaceView = l.a(lPVideoView2.holderView);
            if (surfaceView != null) {
                surfaceView.setZOrderMediaOverlay(true);
            }
        } else {
            LPVideoView lPVideoView3 = lPVideoView5;
            lPVideoView3.removeView(lPVideoView3.holderView);
            surfaceView = l.a(lPVideoView3.holderView);
            if (surfaceView != null) {
                surfaceView.setZOrderMediaOverlay(false);
            }
        }
        if ((surfaceView = lPVideoView5.holderView) != null && ViewCompat.isAttachedToWindow((View)surfaceView)) {
            lPVideoView5.holderView.invalidate();
        }
        LPVideoView lPVideoView4 = lPVideoView5;
        LPVideoView lPVideoView5 = lPVideoView4.holderView;
        surfaceView = lPVideoView4.layoutParams;
        lPVideoView4.addView((View)lPVideoView5, n2, (ViewGroup.LayoutParams)surfaceView);
    }

    public void setAspectRatio(LPConstants.LPAspectRatio lPAspectRatio) {
        this.aspectRatio = lPAspectRatio;
    }

    public LPConstants.LPAspectRatio getAspectRatio() {
        return this.aspectRatio;
    }

    public static class WaterMarkTarget
    extends SimpleTarget<Bitmap> {
        public WeakReference<LPVideoView> a;

        public WaterMarkTarget(LPVideoView lPVideoView) {
            WeakReference<LPVideoView> weakReference;
            Object object = weakReference;
            weakReference = new WeakReference<LPVideoView>(lPVideoView);
            v1.a = object;
        }

        public static /* synthetic */ void a(LPVideoView lPVideoView) {
            LPVideoView lPVideoView2 = lPVideoView;
            lPVideoView2.ivWaterMark.setImageBitmap(lPVideoView.waterMark);
            lPVideoView2.ivWaterMark.setScaleType(ImageView.ScaleType.FIT_START);
            if (lPVideoView2.ivWaterMark.getParent() instanceof ViewGroup) {
                ((ViewGroup)lPVideoView.ivWaterMark.getParent()).removeView((View)lPVideoView.ivWaterMark);
            }
            LPVideoView lPVideoView3 = lPVideoView;
            lPVideoView3.setWaterMarkParams(lPVideoView3.getMeasuredHeight(), lPVideoView.getMeasuredWidth());
            lPVideoView3.addView((View)lPVideoView3.ivWaterMark);
        }

        public void a(@NonNull Bitmap bitmap, @Nullable Transition transition) {
            Object object = (LPVideoView)((Object)object.a.get());
            if (object == null) {
                return;
            }
            Object object2 = object;
            ((LPVideoView)((Object)object2)).waterMark = bitmap;
            object2.post(() -> WaterMarkTarget.a((LPVideoView)((Object)object2)));
        }
    }
}

