/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.ppt.whiteboard.shape;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import com.baijiayun.livecore.models.LPPointF;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.ppt.whiteboard.shape.ShapeRegionInfo;
import java.util.ArrayList;
import java.util.Iterator;

public class OvalShape
extends Shape {
    private static final float PADDING = 2.0f;
    private static final float DEFAULT_TOUCH_THRESHOLD_RATIO = 0.2f;
    private static final float DEFAULT_TOUCH_ENLARGE_THRESHOLD = 15.0f;
    private float width;
    private float height;
    private Paint fillPaint;
    private RectF oval;
    private RectF roundOval;
    private ArrayList<Double> results;
    private float sourcePointX;
    private float sourcePointY;
    private float centerPointX;
    private float centerPointY;

    public OvalShape(Paint paint, boolean bl) {
        super(paint);
        ArrayList arrayList;
        RectF rectF;
        RectF rectF2;
        if (bl) {
            ((OvalShape)object).fillPaint = paint;
        }
        OvalShape ovalShape = object;
        Object object = rectF2;
        rectF2 = new RectF();
        ovalShape.oval = object;
        object = rectF;
        rectF = new RectF();
        ovalShape.roundOval = object;
        object = arrayList;
        arrayList = new ArrayList();
        ovalShape.results = object;
    }

    private RectF getRotateRectF(RectF rectF, float f2, float f3) {
        RectF rectF2;
        OvalShape ovalShape = rectF2;
        ovalShape();
        ((RectF)ovalShape).left = rectF.left - f2;
        ((RectF)ovalShape).top = rectF.top - f3;
        ((RectF)ovalShape).right = rectF.right - f2;
        rectF2.bottom = rectF.bottom - f3;
        return rectF2;
    }

    private double comparePointWithOval(float f2, float f3) {
        OvalShape ovalShape = ovalShape.oval;
        float f4 = ((RectF)ovalShape).right;
        float f5 = ((RectF)ovalShape).left;
        f4 = (f4 - f5) / 2.0f;
        float f6 = ((RectF)ovalShape).top;
        float f7 = (((RectF)ovalShape).bottom - f6) / 2.0f;
        float f8 = f4;
        float f9 = f7;
        return Math.pow(f5 + f4 - f2, 2.0) / (double)(f8 * f8) + Math.pow((f6 += f7) - f3, 2.0) / (double)(f9 * f9);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRectContainsPoint(RectF rectF, float f2, float f3) {
        float f4;
        float f5;
        float f6;
        float f7;
        float f8 = rectF.left;
        float f9 = rectF.right;
        if (!(f7 < f6)) return false;
        float f10 = rectF.top;
        float f11 = rectF.bottom;
        if (!(f5 < f4)) return false;
        if (!(f2 >= f8)) return false;
        if (!(f2 <= f9)) return false;
        if (!(f3 >= f10)) return false;
        if (!(f3 <= f11)) return false;
        return true;
    }

    @Override
    public boolean isValid() {
        return this.width != 0.0f && this.height != 0.0f;
    }

    @Override
    public void appendPoint(LPPointF lPPointF) {
        float f2;
        float f3;
        this.width = Math.abs(lPPointF.x - this.sourcePointX);
        this.height = Math.abs(lPPointF.y - this.sourcePointY);
        float f4 = lPPointF.x;
        if (f3 < this.sourcePointX) {
            this.mSourcePoint.x = f4;
        }
        float f5 = lPPointF.y;
        if (f2 < this.sourcePointY) {
            this.mSourcePoint.y = f5;
        }
    }

    public void setWidth(float f2) {
        this.width = f2;
    }

    public void setHeight(float f2) {
        this.height = f2;
    }

    @Override
    public ArrayList<LPPointF> getPoints() {
        return null;
    }

    @Override
    public void copyShape(Shape shape) {
        OvalShape ovalShape = ovalShape2;
        OvalShape ovalShape2 = (OvalShape)shape;
        ovalShape.width = ovalShape2.getWidth();
        ovalShape.height = ovalShape2.getHeight();
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    @Override
    public void onDraw(Canvas canvas, Matrix matrix) {
        this.onDraw(canvas, matrix, null);
    }

    @Override
    public void onDraw(Canvas canvas, Matrix object, ShapeRegionInfo shapeRegionInfo) {
        float f2;
        Matrix matrix = object;
        float[] fArray = new float[4];
        object = fArray;
        LPPointF lPPointF = ovalShape3.mSourcePoint;
        float f3 = lPPointF.x;
        object[0] = (Matrix)f3;
        float f4 = lPPointF.y;
        object[1] = (Matrix)f4;
        object[2] = (Matrix)(f3 + ovalShape3.width);
        fArray[3] = f4 + ovalShape3.height;
        matrix.mapPoints(fArray);
        ovalShape3.mPaint.setStyle(Paint.Style.STROKE);
        ovalShape3.oval.left = Math.min((float)object[0], (float)object[2]);
        ovalShape3.oval.top = Math.min((float)object[1], (float)object[3]);
        ovalShape3.oval.right = Math.max((float)object[0], (float)object[2]);
        ovalShape3.oval.bottom = Math.max((float)object[1], (float)object[3]);
        canvas.save();
        object = ovalShape3.oval;
        ovalShape3.centerPointX = f3 = (object.left + object.right) / 2.0f;
        ovalShape3.centerPointY = f2 = (object.top + object.bottom) / 2.0f;
        canvas.translate(f3, f2);
        canvas.rotate(ovalShape3.rotateAngle);
        if (shapeRegionInfo != null) {
            float f5 = ovalShape3.centerPointX;
            f2 = f5;
            ShapeRegionInfo shapeRegionInfo2 = shapeRegionInfo;
            f3 = ovalShape3.centerPointY;
            f4 = shapeRegionInfo2.top - f3;
            f2 = shapeRegionInfo2.right - f2;
            f3 = shapeRegionInfo2.bottom - f3;
            canvas.clipRect(shapeRegionInfo.left - f5, f4, f2, f3);
        }
        OvalShape ovalShape = ovalShape3;
        RectF rectF = ovalShape.oval;
        f3 = ovalShape.centerPointX;
        f4 = ovalShape.centerPointY;
        rectF = ovalShape.getRotateRectF(rectF, f3, f4);
        canvas.drawOval(rectF, ovalShape.mPaint);
        rectF = ovalShape3.fillPaint;
        if (rectF != null) {
            rectF.setStyle(Paint.Style.FILL);
            RectF rectF2 = ovalShape3.oval;
            rectF2.left += 1.0f;
            rectF2.top += 1.0f;
            rectF2.right -= 1.0f;
            rectF2.bottom -= 1.0f;
            if (shapeRegionInfo != null) {
                float f6;
                ShapeRegionInfo shapeRegionInfo3 = shapeRegionInfo;
                shapeRegionInfo3.left = f6 = shapeRegionInfo3.left + 1.0f;
                shapeRegionInfo3.top = f3 = shapeRegionInfo3.top + 1.0f;
                shapeRegionInfo3.right = f4 = shapeRegionInfo3.right - 1.0f;
                float f7 = shapeRegionInfo3.bottom - 1.0f;
                float f8 = f4;
                float f9 = f3;
                float f10 = f6;
                shapeRegionInfo.bottom = f7;
                f6 = ovalShape3.centerPointX;
                float f11 = f10 - f6;
                f3 = ovalShape3.centerPointY;
                f4 = f9 - f3;
                f6 = f8 - f6;
                f3 = f7 - f3;
                canvas.clipRect(f11, f4, f6, f3);
            }
            OvalShape ovalShape2 = ovalShape3;
            OvalShape ovalShape3 = ovalShape2.oval;
            float f12 = ovalShape2.centerPointX;
            float f13 = ovalShape2.centerPointY;
            ovalShape3 = ovalShape2.getRotateRectF((RectF)ovalShape3, f12, f13);
            canvas.drawOval((RectF)ovalShape3, ovalShape2.fillPaint);
        }
        canvas.restore();
    }

    @Override
    public boolean isInBoundary(float f2, float f3) {
        OvalShape ovalShape = this;
        ovalShape.oval.inset(-15.0f, -15.0f);
        boolean bl = ovalShape.oval.contains(f2, f3);
        this.oval.inset(15.0f, 15.0f);
        return bl;
    }

    @Override
    public boolean isTouchShape(float f2, float f3) {
        OvalShape ovalShape = this;
        double d2 = ovalShape.comparePointWithOval(f2, f3);
        if (ovalShape.fillPaint == null) {
            return Math.abs(d2 - 1.0) < (double)0.2f;
        }
        return d2 < 1.0;
    }

    @Override
    public boolean isBoundaryOverlap(RectF rectF) {
        RectF rectF2;
        ((OvalShape)((Object)iterator)).roundOval = rectF2 = ((OvalShape)((Object)iterator)).oval;
        if (!(rectF.right < rectF2.left || rectF.bottom < rectF2.top || rectF2.right < rectF.left || rectF2.bottom < rectF.top)) {
            if (rectF.contains(rectF2)) {
                return true;
            }
            OvalShape ovalShape = iterator;
            ovalShape.results.clear();
            RectF rectF3 = rectF;
            float f2 = rectF3.left;
            ovalShape.results.add(((OvalShape)((Object)iterator)).comparePointWithOval(f2, rectF3.top));
            RectF rectF4 = rectF;
            f2 = rectF4.left;
            ovalShape.results.add(((OvalShape)((Object)iterator)).comparePointWithOval(f2, rectF4.bottom));
            RectF rectF5 = rectF;
            f2 = rectF5.right;
            ovalShape.results.add(((OvalShape)((Object)iterator)).comparePointWithOval(f2, rectF5.top));
            RectF rectF6 = rectF;
            f2 = rectF6.right;
            ovalShape.results.add(((OvalShape)((Object)iterator)).comparePointWithOval(f2, rectF6.bottom));
            int n2 = (int)ovalShape.oval.centerX();
            float f3 = rectF.left;
            float f4 = (int)ovalShape.oval.centerY();
            if (((OvalShape)((Object)iterator)).isRectContainsPoint(rectF, f3, f4)) {
                ((OvalShape)((Object)iterator)).results.add(((OvalShape)((Object)iterator)).comparePointWithOval(rectF.left, f4));
            }
            RectF rectF7 = rectF;
            if (((OvalShape)((Object)iterator)).isRectContainsPoint(rectF7, rectF7.right, f4)) {
                ((OvalShape)((Object)iterator)).results.add(((OvalShape)((Object)iterator)).comparePointWithOval(rectF.right, f4));
            }
            RectF rectF8 = rectF;
            float f5 = n2;
            if (((OvalShape)((Object)iterator)).isRectContainsPoint(rectF8, f5, rectF8.top)) {
                ((OvalShape)((Object)iterator)).results.add(((OvalShape)((Object)iterator)).comparePointWithOval(f5, rectF.top));
            }
            RectF rectF9 = rectF;
            if (((OvalShape)((Object)iterator)).isRectContainsPoint(rectF9, f5, rectF9.bottom)) {
                ((OvalShape)((Object)iterator)).results.add(((OvalShape)((Object)iterator)).comparePointWithOval(f5, rectF.bottom));
            }
            if (((OvalShape)((Object)iterator)).fillPaint == null) {
                boolean bl = false;
                boolean bl2 = false;
                for (Double d2 : ((OvalShape)((Object)iterator)).results) {
                    if (d2 == 1.0) {
                        return true;
                    }
                    if (d2 < 1.0) {
                        bl = true;
                        continue;
                    }
                    bl2 = true;
                }
                return bl && bl2;
            }
            Iterator<Double> iterator = ((OvalShape)((Object)iterator)).results.iterator();
            while (iterator.hasNext()) {
                if (!((Double)iterator.next() < 1.0)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public RectF getBoundary() {
        RectF rectF;
        RectF rectF2 = rectF;
        rectF2();
        float f2 = this.mSourcePoint.x;
        rectF2.left = Math.min(f2, f2 + this.width);
        float f3 = this.mSourcePoint.y;
        rectF2.bottom = Math.max(f3, f3 + this.height);
        float f4 = this.mSourcePoint.x;
        rectF2.right = Math.max(f4 + this.width, f4);
        float f5 = this.mSourcePoint.y;
        rectF.top = Math.min(f5, f5 + this.height);
        return rectF;
    }

    @Override
    public void moveShapeBy(float f2, float f3) {
        LPPointF lPPointF = this.mSourcePoint;
        lPPointF.x += f2;
        lPPointF.y += f3;
    }

    @Override
    public void scaleShapeBy(int n2, float f2, float f3, float f4, float f5, RectF rectF, boolean bl) {
        if (rectF == null) {
            rectF = this.getBoundary();
        }
        RectF rectF2 = rectF;
        float f6 = rectF2.left;
        float f7 = rectF2.right;
        float f8 = rectF2.top;
        float f9 = rectF2.bottom;
        switch (n2) {
            default: {
                break;
            }
            case 7: {
                Matrix matrix;
                if (f3 < 0.0f) {
                    f3 = -f3;
                    f9 -= rectF.height();
                }
                OvalShape ovalShape = this;
                LPPointF lPPointF = ovalShape.mSourcePoint;
                lPPointF.y = f2 = (lPPointF.y - rectF.bottom) * f3 + f9;
                ovalShape.height *= f3;
                if (bl) break;
                OvalShape ovalShape2 = this;
                float[] fArray = new float[2];
                float[] fArray2 = fArray;
                fArray[0] = lPPointF.x;
                fArray[1] = f2;
                float f10 = ovalShape2.centerPointX;
                f2 = f10 - f4 / 2.0f;
                f4 = ovalShape2.centerPointY;
                f5 = f4 - f5 / 2.0f;
                float f11 = ovalShape2.rotateAngle;
                PointF pointF = ovalShape2.calcRotatePoint(f2, f5, f10, f4, f11);
                Matrix matrix2 = matrix;
                PointF pointF2 = pointF;
                OvalShape ovalShape3 = this;
                Matrix matrix3 = matrix2;
                matrix3();
                matrix3.reset();
                float f12 = ovalShape3.rotateAngle;
                float f13 = ovalShape3.centerPointX;
                float f14 = ovalShape3.centerPointY;
                matrix2.postRotate(f12, f13, f14);
                f12 = -this.rotateAngle;
                f13 = pointF2.x;
                f14 = pointF2.y;
                matrix2.postRotate(f12, f13, f14);
                matrix.mapPoints(fArray2);
                LPPointF lPPointF2 = ovalShape2.mSourcePoint;
                lPPointF2.x = fArray2[0];
                lPPointF2.y = fArray2[1];
                break;
            }
            case 6: {
                Matrix matrix;
                float f15;
                float f16 = f2 - 0.0f;
                float f17 = f16 == 0.0f ? 0 : (f16 < 0.0f ? -1 : 1);
                if (f17 < 0 && f3 < 0.0f) {
                    f2 = -f2;
                    f3 = -f3;
                    f6 += rectF.width();
                    f9 -= rectF.height();
                } else if (f17 < 0) {
                    f2 = -f2;
                    f6 += rectF.width();
                } else if (f3 < 0.0f) {
                    f3 = -f3;
                    f9 -= rectF.height();
                }
                OvalShape ovalShape = this;
                LPPointF lPPointF = ovalShape.mSourcePoint;
                lPPointF.x = f6 = (lPPointF.x - rectF.left) * f2 + f6;
                lPPointF.y = f15 = (lPPointF.y - rectF.bottom) * f3 + f9;
                ovalShape.width *= f2;
                ovalShape.height *= f3;
                if (bl) break;
                OvalShape ovalShape4 = this;
                float[] fArray = new float[2];
                float[] fArray3 = fArray;
                fArray[0] = f6;
                fArray[1] = f15;
                f6 = ovalShape4.centerPointX;
                f3 = f6 + f4 / 2.0f;
                f4 = ovalShape4.centerPointY;
                f5 = f4 - f5 / 2.0f;
                f15 = ovalShape4.rotateAngle;
                PointF pointF = ovalShape4.calcRotatePoint(f3, f5, f6, f4, f15);
                Matrix matrix4 = matrix;
                PointF pointF3 = pointF;
                OvalShape ovalShape5 = this;
                Matrix matrix5 = matrix4;
                matrix5();
                matrix5.reset();
                float f18 = ovalShape5.rotateAngle;
                float f19 = ovalShape5.centerPointX;
                float f20 = ovalShape5.centerPointY;
                matrix4.postRotate(f18, f19, f20);
                f18 = -this.rotateAngle;
                f19 = pointF3.x;
                f20 = pointF3.y;
                matrix4.postRotate(f18, f19, f20);
                matrix.mapPoints(fArray3);
                LPPointF lPPointF3 = ovalShape4.mSourcePoint;
                lPPointF3.x = fArray3[0];
                lPPointF3.y = fArray3[1];
                break;
            }
            case 5: {
                Matrix matrix;
                if (f2 < 0.0f) {
                    f2 = -f2;
                    f6 += rectF.width();
                }
                OvalShape ovalShape = this;
                ovalShape.mSourcePoint.x = Math.abs(ovalShape.mSourcePoint.x - rectF.left) * f2 + f6;
                ovalShape.width *= f2;
                if (bl) break;
                OvalShape ovalShape6 = this;
                float[] fArray = new float[2];
                float[] fArray4 = fArray;
                LPPointF lPPointF = this.mSourcePoint;
                fArray4[0] = lPPointF.x;
                fArray[1] = lPPointF.y;
                f2 = ovalShape6.centerPointX;
                f3 = f2 + f4 / 2.0f;
                f4 = ovalShape6.centerPointY;
                f5 = f4 + f5 / 2.0f;
                float f21 = ovalShape6.rotateAngle;
                PointF pointF = ovalShape6.calcRotatePoint(f3, f5, f2, f4, f21);
                Matrix matrix6 = matrix;
                PointF pointF4 = pointF;
                OvalShape ovalShape7 = this;
                Matrix matrix7 = matrix6;
                matrix7();
                matrix7.reset();
                float f22 = ovalShape7.rotateAngle;
                float f23 = ovalShape7.centerPointX;
                float f24 = ovalShape7.centerPointY;
                matrix6.postRotate(f22, f23, f24);
                f22 = -this.rotateAngle;
                f23 = pointF4.x;
                f24 = pointF4.y;
                matrix6.postRotate(f22, f23, f24);
                matrix.mapPoints(fArray4);
                LPPointF lPPointF4 = ovalShape6.mSourcePoint;
                lPPointF4.x = fArray4[0];
                lPPointF4.y = fArray4[1];
                break;
            }
            case 4: {
                Matrix matrix;
                float f25;
                float f26 = f2 - 0.0f;
                float f27 = f26 == 0.0f ? 0 : (f26 < 0.0f ? -1 : 1);
                if (f27 < 0 && f3 < 0.0f) {
                    f2 = -f2;
                    f3 = -f3;
                    f6 += rectF.width();
                    f8 += rectF.height();
                } else if (f27 < 0) {
                    f2 = -f2;
                    f6 += rectF.width();
                } else if (f3 < 0.0f) {
                    f3 = -f3;
                    f8 += rectF.height();
                }
                OvalShape ovalShape = this;
                LPPointF lPPointF = ovalShape.mSourcePoint;
                lPPointF.x = f6 = (lPPointF.x - rectF.left) * f2 + f6;
                lPPointF.y = f25 = (lPPointF.y - rectF.top) * f3 + f8;
                ovalShape.width *= f2;
                ovalShape.height *= f3;
                if (bl) break;
                OvalShape ovalShape8 = this;
                float[] fArray = new float[2];
                float[] fArray5 = fArray;
                fArray[0] = f6;
                fArray[1] = f25;
                f6 = ovalShape8.centerPointX;
                f3 = f6 + f4 / 2.0f;
                f4 = ovalShape8.centerPointY;
                f5 = f4 + f5 / 2.0f;
                f25 = ovalShape8.rotateAngle;
                PointF pointF = ovalShape8.calcRotatePoint(f3, f5, f6, f4, f25);
                Matrix matrix8 = matrix;
                PointF pointF5 = pointF;
                OvalShape ovalShape9 = this;
                Matrix matrix9 = matrix8;
                matrix9();
                matrix9.reset();
                float f28 = ovalShape9.rotateAngle;
                float f29 = ovalShape9.centerPointX;
                float f30 = ovalShape9.centerPointY;
                matrix8.postRotate(f28, f29, f30);
                f28 = -this.rotateAngle;
                f29 = pointF5.x;
                f30 = pointF5.y;
                matrix8.postRotate(f28, f29, f30);
                matrix.mapPoints(fArray5);
                LPPointF lPPointF5 = ovalShape8.mSourcePoint;
                lPPointF5.x = fArray5[0];
                lPPointF5.y = fArray5[1];
                break;
            }
            case 3: {
                Matrix matrix;
                if (f3 < 0.0f) {
                    f3 = -f3;
                    f8 += rectF.height();
                }
                OvalShape ovalShape = this;
                ovalShape.mSourcePoint.y = Math.abs(ovalShape.mSourcePoint.y - rectF.top) * f3 + f8;
                ovalShape.height *= f3;
                if (bl) break;
                OvalShape ovalShape10 = this;
                float[] fArray = new float[2];
                float[] fArray6 = fArray;
                LPPointF lPPointF = this.mSourcePoint;
                fArray6[0] = lPPointF.x;
                fArray[1] = lPPointF.y;
                f2 = ovalShape10.centerPointX;
                f3 = f2 + f4 / 2.0f;
                f4 = ovalShape10.centerPointY;
                f5 = f4 + f5 / 2.0f;
                float f31 = ovalShape10.rotateAngle;
                PointF pointF = ovalShape10.calcRotatePoint(f3, f5, f2, f4, f31);
                Matrix matrix10 = matrix;
                PointF pointF6 = pointF;
                OvalShape ovalShape11 = this;
                Matrix matrix11 = matrix10;
                matrix11();
                matrix11.reset();
                float f32 = ovalShape11.rotateAngle;
                float f33 = ovalShape11.centerPointX;
                float f34 = ovalShape11.centerPointY;
                matrix10.postRotate(f32, f33, f34);
                f32 = -this.rotateAngle;
                f33 = pointF6.x;
                f34 = pointF6.y;
                matrix10.postRotate(f32, f33, f34);
                matrix.mapPoints(fArray6);
                LPPointF lPPointF6 = ovalShape10.mSourcePoint;
                lPPointF6.x = fArray6[0];
                lPPointF6.y = fArray6[1];
                break;
            }
            case 2: {
                Matrix matrix;
                float f35 = f2 - 0.0f;
                float f36 = f35 == 0.0f ? 0 : (f35 < 0.0f ? -1 : 1);
                if (f36 < 0 && f3 < 0.0f) {
                    f2 = -f2;
                    f3 = -f3;
                    f7 -= rectF.width();
                    f8 += rectF.height();
                } else if (f36 < 0) {
                    f2 = -f2;
                    f7 -= rectF.width();
                } else if (f3 < 0.0f) {
                    f3 = -f3;
                    f8 += rectF.height();
                }
                OvalShape ovalShape = this;
                LPPointF lPPointF = ovalShape.mSourcePoint;
                lPPointF.x = (lPPointF.x - rectF.right) * f2 + f7;
                lPPointF.y = Math.abs(lPPointF.y - rectF.top) * f3 + f8;
                ovalShape.width *= f2;
                ovalShape.height *= f3;
                if (bl) break;
                OvalShape ovalShape12 = this;
                float[] fArray = new float[2];
                float[] fArray7 = fArray;
                LPPointF lPPointF7 = this.mSourcePoint;
                fArray7[0] = lPPointF7.x;
                fArray[1] = lPPointF7.y;
                f2 = ovalShape12.centerPointX;
                f3 = f2 - f4 / 2.0f;
                f4 = ovalShape12.centerPointY;
                f5 = f4 + f5 / 2.0f;
                float f37 = ovalShape12.rotateAngle;
                PointF pointF = ovalShape12.calcRotatePoint(f3, f5, f2, f4, f37);
                Matrix matrix12 = matrix;
                PointF pointF7 = pointF;
                OvalShape ovalShape13 = this;
                Matrix matrix13 = matrix12;
                matrix13();
                matrix13.reset();
                float f38 = ovalShape13.rotateAngle;
                float f39 = ovalShape13.centerPointX;
                float f40 = ovalShape13.centerPointY;
                matrix12.postRotate(f38, f39, f40);
                f38 = -this.rotateAngle;
                f39 = pointF7.x;
                f40 = pointF7.y;
                matrix12.postRotate(f38, f39, f40);
                matrix.mapPoints(fArray7);
                LPPointF lPPointF8 = ovalShape12.mSourcePoint;
                lPPointF8.x = fArray7[0];
                lPPointF8.y = fArray7[1];
                break;
            }
            case 1: {
                Matrix matrix;
                if (f2 < 0.0f) {
                    f2 = -f2;
                    f7 -= rectF.width();
                }
                OvalShape ovalShape = this;
                LPPointF lPPointF = ovalShape.mSourcePoint;
                lPPointF.x = f3 = (lPPointF.x - rectF.right) * f2 + f7;
                ovalShape.width *= f2;
                if (bl) break;
                OvalShape ovalShape14 = this;
                float[] fArray = new float[2];
                float[] fArray8 = fArray;
                fArray8[0] = f3;
                fArray[1] = lPPointF.y;
                float f41 = ovalShape14.centerPointX;
                f3 = f41 - f4 / 2.0f;
                f4 = ovalShape14.centerPointY;
                f5 = f4 - f5 / 2.0f;
                float f42 = ovalShape14.rotateAngle;
                PointF pointF = ovalShape14.calcRotatePoint(f3, f5, f41, f4, f42);
                Matrix matrix14 = matrix;
                PointF pointF8 = pointF;
                OvalShape ovalShape15 = this;
                Matrix matrix15 = matrix14;
                matrix15();
                matrix15.reset();
                float f43 = ovalShape15.rotateAngle;
                float f44 = ovalShape15.centerPointX;
                float f45 = ovalShape15.centerPointY;
                matrix14.postRotate(f43, f44, f45);
                f43 = -this.rotateAngle;
                f44 = pointF8.x;
                f45 = pointF8.y;
                matrix14.postRotate(f43, f44, f45);
                matrix.mapPoints(fArray8);
                LPPointF lPPointF9 = ovalShape14.mSourcePoint;
                lPPointF9.x = fArray8[0];
                lPPointF9.y = fArray8[1];
                break;
            }
            case 0: {
                Matrix matrix;
                float f46;
                float f47;
                float f48 = f2 - 0.0f;
                float f49 = f48 == 0.0f ? 0 : (f48 < 0.0f ? -1 : 1);
                if (f49 < 0 && f3 < 0.0f) {
                    f2 = -f2;
                    f3 = -f3;
                    f7 -= rectF.width();
                    f9 -= rectF.height();
                } else if (f49 < 0) {
                    f2 = -f2;
                    f7 -= rectF.width();
                } else if (f3 < 0.0f) {
                    f3 = -f3;
                    f9 -= rectF.height();
                }
                OvalShape ovalShape = this;
                LPPointF lPPointF = ovalShape.mSourcePoint;
                lPPointF.x = f47 = (lPPointF.x - rectF.right) * f2 + f7;
                lPPointF.y = f46 = (lPPointF.y - rectF.bottom) * f3 + f9;
                ovalShape.width *= f2;
                ovalShape.height *= f3;
                if (bl) break;
                OvalShape ovalShape16 = this;
                float[] fArray = new float[2];
                float[] fArray9 = fArray;
                fArray[0] = f47;
                fArray[1] = f46;
                f47 = ovalShape16.centerPointX;
                f3 = f47 - f4 / 2.0f;
                f4 = ovalShape16.centerPointY;
                f5 = f4 - f5 / 2.0f;
                f46 = ovalShape16.rotateAngle;
                PointF pointF = ovalShape16.calcRotatePoint(f3, f5, f47, f4, f46);
                Matrix matrix16 = matrix;
                PointF pointF9 = pointF;
                OvalShape ovalShape17 = this;
                Matrix matrix17 = matrix16;
                matrix17();
                matrix17.reset();
                float f50 = ovalShape17.rotateAngle;
                float f51 = ovalShape17.centerPointX;
                float f52 = ovalShape17.centerPointY;
                matrix16.postRotate(f50, f51, f52);
                f50 = -this.rotateAngle;
                f51 = pointF9.x;
                f52 = pointF9.y;
                matrix16.postRotate(f50, f51, f52);
                matrix.mapPoints(fArray9);
                LPPointF lPPointF10 = ovalShape16.mSourcePoint;
                lPPointF10.x = fArray9[0];
                lPPointF10.y = fArray9[1];
            }
        }
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    @Override
    public void setSourcePoint(LPPointF lPPointF) {
        super.setSourcePoint(lPPointF);
        this.sourcePointX = lPPointF.x;
        this.sourcePointY = lPPointF.y;
    }

    @Override
    public void setAngle(float f2) {
        this.rotateAngle = f2;
    }
}

