/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.ppt.whiteboard.shape;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.baijiayun.livecore.models.LPPointF;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.ppt.whiteboard.shape.ShapeRegionInfo;
import java.util.ArrayList;

public class LaserShape
extends Shape {
    private static final float INNER_RADIUS = 10.0f;
    public static final float OUTER_RADIUS = 20.0f;
    private boolean isValid;
    private Bitmap mouseBitmap;

    public LaserShape(Paint paint) {
        LaserShape laserShape = this;
        super(paint);
        laserShape.mPaint.setColor(-65536);
        laserShape.mPaint.setDither(true);
        laserShape.mPaint.setAntiAlias(true);
        laserShape.mPaint.setStyle(Paint.Style.FILL);
    }

    @Override
    public void onDraw(Canvas canvas, Matrix matrix) {
        this.onDraw(canvas, matrix, null);
    }

    @Override
    public void onDraw(Canvas canvas, Matrix object, ShapeRegionInfo shapeRegionInfo) {
        float[] fArray = new float[2];
        float[] matrix3 = fArray;
        LPPointF lPPointF = this.mSourcePoint;
        matrix3[0] = lPPointF.x;
        fArray[1] = lPPointF.y;
        object.mapPoints(matrix3);
        Bitmap bitmap = this.mouseBitmap;
        if (bitmap == null) {
            this.mPaint.setAlpha(100);
            float matrix2 = matrix3[0];
            float f2 = matrix3[1];
            bitmap = this.mPaint;
            canvas.drawCircle(matrix2, f2, 20.0f, (Paint)bitmap);
            this.mPaint.setAlpha(255);
            matrix2 = matrix3[0];
            f2 = matrix3[1];
            bitmap = this.mPaint;
            canvas.drawCircle(matrix2, f2, 10.0f, (Paint)bitmap);
        } else {
            Bitmap bitmap2 = bitmap;
            float f3 = matrix3[0] - (float)bitmap.getWidth() * 0.5f;
            float f4 = matrix3[1] - (float)this.mouseBitmap.getHeight() * 0.5f;
            bitmap = this.getPaint();
            canvas.drawBitmap(bitmap2, f3, f4, (Paint)bitmap);
        }
        this.isValid = false;
    }

    @Override
    public boolean isInBoundary(float f2, float f3) {
        return false;
    }

    @Override
    public boolean isTouchShape(float f2, float f3) {
        return false;
    }

    @Override
    public RectF getBoundary() {
        LPPointF lPPointF = this.mSourcePoint;
        float f2 = lPPointF.x;
        float f3 = f2 - 20.0f;
        float f4 = lPPointF.y;
        f2 = f4 - 20.0f;
        float f5 = f2 + 20.0f;
        float f6 = f4 + 20.0f;
        return new RectF(f3, f2, f5, f6);
    }

    @Override
    public void moveShapeBy(float f2, float f3) {
    }

    public void moveShapeTo(float f2, float f3) {
        LPPointF lPPointF = this.mSourcePoint;
        lPPointF.x = f2;
        lPPointF.y = f3;
        this.isValid = true;
    }

    public void setValid(boolean bl) {
        this.isValid = bl;
    }

    @Override
    public void scaleShapeBy(int n2, float f2, float f3, float f4, float f5, RectF rectF, boolean bl) {
    }

    @Override
    public boolean isBoundaryOverlap(RectF rectF) {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void appendPoint(LPPointF lPPointF) {
        this.mSourcePoint = lPPointF;
    }

    @Override
    public ArrayList<LPPointF> getPoints() {
        return null;
    }

    @Override
    public void copyShape(Shape shape) {
        this.isValid = true;
    }

    public PointF getCenter() {
        return this.mSourcePoint;
    }

    @Override
    public void setAngle(float f2) {
        this.rotateAngle = f2;
    }

    public void setShowMouse(Bitmap bitmap) {
        this.mouseBitmap = bitmap;
    }

    public void setCursorVectorDrawable(VectorDrawableCompat vectorDrawableCompat) {
        if (vectorDrawableCompat == null) {
            this.mouseBitmap = null;
        } else {
            Canvas canvas;
            VectorDrawableCompat vectorDrawableCompat2 = vectorDrawableCompat;
            VectorDrawableCompat vectorDrawableCompat3 = vectorDrawableCompat;
            vectorDrawableCompat3.mutate();
            this.mouseBitmap = Bitmap.createBitmap((int)vectorDrawableCompat3.getIntrinsicWidth(), (int)vectorDrawableCompat.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            vectorDrawableCompat = canvas;
            int n2 = new Canvas(this.mouseBitmap).getWidth();
            int n3 = vectorDrawableCompat.getHeight();
            vectorDrawableCompat2.setBounds(0, 0, n2, n3);
            vectorDrawableCompat2.draw((Canvas)vectorDrawableCompat);
        }
    }
}

