/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.ppt.whiteboard.shape;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import com.baijiayun.livecore.models.LPPointF;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.ppt.whiteboard.shape.ShapeRegionInfo;
import java.util.ArrayList;

public class BitmapShape
extends Shape {
    private float width;
    private float height;
    private String url;
    private float ratio = 1.0f;
    private Bitmap bitmap;
    private float centerPointX;
    private float centerPointY;

    public BitmapShape(Paint paint, float f2) {
        super(paint);
        this.rotateAngle = f2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isVectorInRect(PointF pointF, PointF pointF2, RectF rectF) {
        RectF rectF2 = rectF;
        float f2 = rectF2.left;
        float f3 = rectF2.top;
        float f4 = rectF2.bottom;
        if (this.isVectorCross(pointF, pointF2, f2, f3, f2, f4)) return true;
        RectF rectF3 = rectF;
        f2 = rectF3.left;
        f3 = rectF3.bottom;
        f4 = rectF3.right;
        if (this.isVectorCross(pointF, pointF2, f2, f3, f4, f3)) return true;
        RectF rectF4 = rectF;
        f2 = rectF4.right;
        f3 = rectF4.bottom;
        f4 = rectF4.top;
        if (this.isVectorCross(pointF, pointF2, f2, f3, f2, f4)) return true;
        RectF rectF5 = rectF;
        float f5 = rectF5.right;
        float f6 = rectF5.top;
        float f7 = rectF5.left;
        if (!this.isVectorCross(pointF, pointF2, f5, f6, f7, f6)) return false;
        return true;
    }

    private boolean isVectorCross(PointF pointF, PointF pointF2, float f2, float f3, float f4, float f5) {
        float f6 = pointF.x;
        float f7 = f2 - f6;
        float f8 = pointF.y;
        float f9 = f3 - f8;
        f6 = f4 - f6;
        f8 = f5 - f8;
        float f10 = this.cal(f7, f9, f6, f8);
        f6 = pointF2.x;
        f7 = f2 - f6;
        f8 = pointF2.y;
        f9 = f3 - f8;
        f6 = f4 - f6;
        f8 = f5 - f8;
        float f11 = f10 * this.cal(f7, f9, f6, f8);
        float f12 = pointF.x - f2;
        PointF pointF3 = pointF2;
        f6 = pointF.y - f3;
        f2 = pointF3.x - f2;
        f3 = pointF3.y - f3;
        PointF pointF4 = pointF2;
        float f13 = pointF.y - f5;
        float f14 = pointF4.x - f4;
        float f15 = pointF4.y - f5;
        f13 = this.cal(f12, f6, f2, f3) * this.cal(pointF.x - f4, f13, f14, f15);
        return f11 <= 0.0f && f13 <= 0.0f;
    }

    private float cal(float f2, float f3, float f4, float f5) {
        return f2 * f5 - f4 * f3;
    }

    public void setUrl(String string2) {
        this.url = string2;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public String getUrl() {
        return this.url;
    }

    public float getRatio() {
        return this.ratio;
    }

    public void setRatio(float f2) {
        this.ratio = f2;
    }

    public void setBitmap(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float f2) {
        this.height = f2;
    }

    public void setWidth(float f2) {
        this.width = f2;
    }

    public void scale(float f2) {
        BitmapShape bitmapShape = this;
        float f3 = this.ratio;
        bitmapShape.width = bitmapShape.width / f3 * f2;
        bitmapShape.height = bitmapShape.height / f3 * f2;
        this.setRatio(f2);
    }

    @Override
    public boolean isValid() {
        return this.width != 0.0f && this.height != 0.0f;
    }

    @Override
    public void onDraw(Canvas canvas, Matrix matrix) {
        this.onDraw(canvas, matrix, null);
    }

    @Override
    public void onDraw(Canvas canvas, Matrix matrix, ShapeRegionInfo shapeRegionInfo) {
        matrix = this.bitmap;
        if (matrix != null && !matrix.isRecycled()) {
            RectF rectF;
            Canvas canvas2 = canvas;
            canvas.save();
            LPPointF lPPointF = this.mSourcePoint;
            float f2 = lPPointF.x;
            float f3 = f2 + this.width;
            float f4 = lPPointF.y;
            float f5 = f2;
            f2 = f4 + this.height;
            this.centerPointX = f3 = (f5 + f3) / 2.0f;
            this.centerPointY = f2 = (f4 + f2) / 2.0f;
            canvas.translate(f3, f2);
            canvas.rotate(this.rotateAngle);
            RectF rectF2 = rectF;
            LPPointF lPPointF2 = this.mSourcePoint;
            f3 = lPPointF2.x;
            f4 = this.centerPointX;
            float f6 = f3 - f4;
            float f7 = lPPointF2.y;
            float f8 = f3;
            float f9 = this.centerPointY;
            f3 = f7 - f9;
            f4 = f8 + this.width - f4;
            f9 = f7 + this.height - f9;
            rectF = new RectF(f6, f3, f4, f9);
            canvas2.drawBitmap(this.bitmap, null, rectF2, null);
            canvas2.restore();
            return;
        }
    }

    @Override
    public void appendPoint(LPPointF lPPointF) {
    }

    @Override
    public ArrayList<LPPointF> getPoints() {
        ArrayList<LPPointF> arrayList = new ArrayList<LPPointF>();
        arrayList.add(this.mSourcePoint);
        LPPointF lPPointF = this.mSourcePoint;
        float f2 = lPPointF.x + this.width;
        arrayList.add(new LPPointF(f2, lPPointF.y));
        LPPointF lPPointF2 = this.mSourcePoint;
        arrayList.add(new LPPointF(lPPointF2.x + this.width, lPPointF2.y + this.height));
        lPPointF2 = this.mSourcePoint;
        arrayList.add(new LPPointF(lPPointF2.x, lPPointF2.y + this.height));
        return arrayList;
    }

    @Override
    public void copyShape(Shape shape) {
        BitmapShape bitmapShape = bitmapShape2;
        BitmapShape bitmapShape2 = (BitmapShape)shape;
        bitmapShape.ratio = bitmapShape2.getRatio();
        bitmapShape.url = bitmapShape2.getUrl();
        bitmapShape.width = bitmapShape2.getWidth();
        bitmapShape.height = bitmapShape2.getHeight();
    }

    @Override
    public boolean isInBoundary(float f2, float f3) {
        LPPointF lPPointF = this.mSourcePoint;
        float f4 = lPPointF.x;
        float f5 = (f4 + f4 + this.width) / 2.0f;
        float f6 = lPPointF.y;
        float f7 = (f6 + f6 + this.height) / 2.0f;
        int n2 = 4;
        PointF[] pointFArray = new PointF[4];
        PointF[] pointFArray2 = pointFArray;
        BitmapShape bitmapShape = this;
        BitmapShape bitmapShape2 = this;
        BitmapShape bitmapShape3 = this;
        float f8 = f4;
        f4 = this.rotateAngle;
        pointFArray2[0] = this.calcRotatePoint(f8, f6, f5, f7, f4);
        LPPointF lPPointF2 = bitmapShape3.mSourcePoint;
        f4 = lPPointF2.x + this.width;
        f6 = lPPointF2.y;
        float f9 = bitmapShape3.rotateAngle;
        pointFArray2[1] = bitmapShape3.calcRotatePoint(f4, f6, f5, f7, f9);
        LPPointF lPPointF3 = bitmapShape2.mSourcePoint;
        f4 = lPPointF3.x;
        f6 = lPPointF3.y + this.height;
        f9 = bitmapShape2.rotateAngle;
        pointFArray2[2] = bitmapShape2.calcRotatePoint(f4, f6, f5, f7, f9);
        LPPointF lPPointF4 = bitmapShape.mSourcePoint;
        f4 = lPPointF4.x + this.width;
        float f10 = lPPointF4.y + this.height;
        f6 = bitmapShape.rotateAngle;
        pointFArray[3] = bitmapShape.calcRotatePoint(f4, f10, f5, f7, f6);
        f10 = 2.1474836E9f;
        f4 = -2.1474836E9f;
        f5 = 2.1474836E9f;
        f6 = -2.1474836E9f;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f11 = f6;
            float f12 = f5;
            float f13 = f4;
            PointF pointF = pointFArray2[i2];
            f4 = Math.min(f10, pointF.x);
            f5 = Math.max(f13, pointF.x);
            f6 = Math.min(f12, pointF.y);
            f10 = Math.max(f11, pointF.y);
            float f14 = f4;
            float f15 = f5;
            float f16 = f6;
            f6 = f10;
            f5 = f16;
            f4 = f15;
            f10 = f14;
        }
        return f10 <= f2 && f4 >= f2 && f5 <= f3 && f6 >= f3;
    }

    @Override
    public boolean isTouchShape(float f2, float f3) {
        return true;
    }

    @Override
    public RectF getBoundary() {
        RectF rectF;
        RectF rectF2 = rectF;
        rectF2();
        float f2 = this.mSourcePoint.x;
        rectF2.left = Math.min(f2, f2 + this.width);
        float f3 = this.mSourcePoint.y;
        rectF2.bottom = Math.max(f3, f3 + this.height);
        float f4 = this.mSourcePoint.x;
        rectF2.right = Math.max(f4, f4 + this.width);
        float f5 = this.mSourcePoint.y;
        rectF.top = Math.min(f5, f5 + this.height);
        return rectF;
    }

    @Override
    public void moveShapeBy(float f2, float f3) {
        LPPointF lPPointF = this.mSourcePoint;
        lPPointF.x += f2;
        lPPointF.y += f3;
    }

    @Override
    public void scaleShapeBy(int n2, float f2, float f3, float f4, float f5, RectF rectF, boolean bl) {
        if (rectF == null) {
            rectF = this.getBoundary();
        }
        RectF rectF2 = rectF;
        float f6 = rectF2.left;
        float f7 = rectF2.right;
        float f8 = rectF2.top;
        float f9 = rectF2.bottom;
        switch (n2) {
            default: {
                break;
            }
            case 7: {
                Matrix matrix;
                if (f3 < 0.0f) {
                    f3 = -f3;
                    f9 -= rectF.height();
                }
                BitmapShape bitmapShape = this;
                LPPointF lPPointF = bitmapShape.mSourcePoint;
                lPPointF.y = f2 = (lPPointF.y - rectF.bottom) * f3 + f9;
                bitmapShape.height *= f3;
                if (bl) break;
                BitmapShape bitmapShape2 = this;
                float[] fArray = new float[2];
                float[] fArray2 = fArray;
                fArray[0] = lPPointF.x;
                fArray[1] = f2;
                float f10 = bitmapShape2.centerPointX;
                f2 = f10 - f4 / 2.0f;
                f4 = bitmapShape2.centerPointY;
                f5 = f4 - f5 / 2.0f;
                float f11 = bitmapShape2.rotateAngle;
                PointF pointF = bitmapShape2.calcRotatePoint(f2, f5, f10, f4, f11);
                Matrix matrix2 = matrix;
                PointF pointF2 = pointF;
                BitmapShape bitmapShape3 = this;
                Matrix matrix3 = matrix2;
                matrix3();
                matrix3.reset();
                float f12 = bitmapShape3.rotateAngle;
                float f13 = bitmapShape3.centerPointX;
                f4 = bitmapShape3.centerPointY;
                matrix2.postRotate(f12, f13, f4);
                f12 = -this.rotateAngle;
                f13 = pointF2.x;
                f4 = pointF2.y;
                matrix2.postRotate(f12, f13, f4);
                matrix.mapPoints(fArray2);
                LPPointF lPPointF2 = bitmapShape2.mSourcePoint;
                lPPointF2.x = fArray2[0];
                lPPointF2.y = fArray2[1];
                break;
            }
            case 6: {
                Matrix matrix;
                float f14;
                float f15 = f2 - 0.0f;
                float f16 = f15 == 0.0f ? 0 : (f15 < 0.0f ? -1 : 1);
                if (f16 < 0 && f3 < 0.0f) {
                    f2 = -f2;
                    f3 = -f3;
                    f6 += rectF.width();
                    f9 -= rectF.height();
                } else if (f16 < 0) {
                    f2 = -f2;
                    f6 += rectF.width();
                } else if (f3 < 0.0f) {
                    f3 = -f3;
                    f9 -= rectF.height();
                }
                BitmapShape bitmapShape = this;
                LPPointF lPPointF = bitmapShape.mSourcePoint;
                lPPointF.x = f6 = (lPPointF.x - rectF.left) * f2 + f6;
                lPPointF.y = f14 = (lPPointF.y - rectF.bottom) * f3 + f9;
                bitmapShape.width *= f2;
                bitmapShape.height *= f3;
                if (bl) break;
                BitmapShape bitmapShape4 = this;
                float[] fArray = new float[2];
                float[] fArray3 = fArray;
                fArray[0] = f6;
                fArray[1] = f14;
                f6 = bitmapShape4.centerPointX;
                f3 = f6 + f4 / 2.0f;
                f4 = bitmapShape4.centerPointY;
                f5 = f4 - f5 / 2.0f;
                f14 = bitmapShape4.rotateAngle;
                PointF pointF = bitmapShape4.calcRotatePoint(f3, f5, f6, f4, f14);
                Matrix matrix4 = matrix;
                PointF pointF3 = pointF;
                BitmapShape bitmapShape5 = this;
                Matrix matrix5 = matrix4;
                matrix5();
                matrix5.reset();
                float f17 = bitmapShape5.rotateAngle;
                float f18 = bitmapShape5.centerPointX;
                f4 = bitmapShape5.centerPointY;
                matrix4.postRotate(f17, f18, f4);
                f17 = -this.rotateAngle;
                f18 = pointF3.x;
                f4 = pointF3.y;
                matrix4.postRotate(f17, f18, f4);
                matrix.mapPoints(fArray3);
                LPPointF lPPointF3 = bitmapShape4.mSourcePoint;
                lPPointF3.x = fArray3[0];
                lPPointF3.y = fArray3[1];
                break;
            }
            case 5: {
                Matrix matrix;
                if (f2 < 0.0f) {
                    f2 = -f2;
                    f6 += rectF.width();
                }
                BitmapShape bitmapShape = this;
                bitmapShape.mSourcePoint.x = Math.abs(bitmapShape.mSourcePoint.x - rectF.left) * f2 + f6;
                bitmapShape.width *= f2;
                if (bl) break;
                BitmapShape bitmapShape6 = this;
                float[] fArray = new float[2];
                float[] fArray4 = fArray;
                LPPointF lPPointF = this.mSourcePoint;
                fArray4[0] = lPPointF.x;
                fArray[1] = lPPointF.y;
                f2 = bitmapShape6.centerPointX;
                f3 = f2 + f4 / 2.0f;
                f4 = bitmapShape6.centerPointY;
                f5 = f4 + f5 / 2.0f;
                float f19 = bitmapShape6.rotateAngle;
                PointF pointF = bitmapShape6.calcRotatePoint(f3, f5, f2, f4, f19);
                Matrix matrix6 = matrix;
                PointF pointF4 = pointF;
                BitmapShape bitmapShape7 = this;
                Matrix matrix7 = matrix6;
                matrix7();
                matrix7.reset();
                float f20 = bitmapShape7.rotateAngle;
                float f21 = bitmapShape7.centerPointX;
                f4 = bitmapShape7.centerPointY;
                matrix6.postRotate(f20, f21, f4);
                f20 = -this.rotateAngle;
                f21 = pointF4.x;
                f4 = pointF4.y;
                matrix6.postRotate(f20, f21, f4);
                matrix.mapPoints(fArray4);
                LPPointF lPPointF4 = bitmapShape6.mSourcePoint;
                lPPointF4.x = fArray4[0];
                lPPointF4.y = fArray4[1];
                break;
            }
            case 4: {
                Matrix matrix;
                float f22;
                float f23 = f2 - 0.0f;
                float f24 = f23 == 0.0f ? 0 : (f23 < 0.0f ? -1 : 1);
                if (f24 < 0 && f3 < 0.0f) {
                    f2 = -f2;
                    f3 = -f3;
                    f6 += rectF.width();
                    f8 += rectF.height();
                } else if (f24 < 0) {
                    f2 = -f2;
                    f6 += rectF.width();
                } else if (f3 < 0.0f) {
                    f3 = -f3;
                    f8 += rectF.height();
                }
                BitmapShape bitmapShape = this;
                LPPointF lPPointF = bitmapShape.mSourcePoint;
                lPPointF.x = f6 = (lPPointF.x - rectF.left) * f2 + f6;
                lPPointF.y = f22 = (lPPointF.y - rectF.top) * f3 + f8;
                bitmapShape.width *= f2;
                bitmapShape.height *= f3;
                if (bl) break;
                BitmapShape bitmapShape8 = this;
                float[] fArray = new float[2];
                float[] fArray5 = fArray;
                fArray[0] = f6;
                fArray[1] = f22;
                f6 = bitmapShape8.centerPointX;
                f3 = f6 + f4 / 2.0f;
                f4 = bitmapShape8.centerPointY;
                f5 = f4 + f5 / 2.0f;
                f22 = bitmapShape8.rotateAngle;
                PointF pointF = bitmapShape8.calcRotatePoint(f3, f5, f6, f4, f22);
                Matrix matrix8 = matrix;
                PointF pointF5 = pointF;
                BitmapShape bitmapShape9 = this;
                Matrix matrix9 = matrix8;
                matrix9();
                matrix9.reset();
                float f25 = bitmapShape9.rotateAngle;
                float f26 = bitmapShape9.centerPointX;
                f4 = bitmapShape9.centerPointY;
                matrix8.postRotate(f25, f26, f4);
                f25 = -this.rotateAngle;
                f26 = pointF5.x;
                f4 = pointF5.y;
                matrix8.postRotate(f25, f26, f4);
                matrix.mapPoints(fArray5);
                LPPointF lPPointF5 = bitmapShape8.mSourcePoint;
                lPPointF5.x = fArray5[0];
                lPPointF5.y = fArray5[1];
                break;
            }
            case 3: {
                Matrix matrix;
                if (f3 < 0.0f) {
                    f3 = -f3;
                    f8 += rectF.height();
                }
                BitmapShape bitmapShape = this;
                bitmapShape.mSourcePoint.y = Math.abs(bitmapShape.mSourcePoint.y - rectF.top) * f3 + f8;
                bitmapShape.height *= f3;
                if (bl) break;
                BitmapShape bitmapShape10 = this;
                float[] fArray = new float[2];
                float[] fArray6 = fArray;
                LPPointF lPPointF = this.mSourcePoint;
                fArray6[0] = lPPointF.x;
                fArray[1] = lPPointF.y;
                f2 = bitmapShape10.centerPointX;
                f3 = f2 + f4 / 2.0f;
                f4 = bitmapShape10.centerPointY;
                f5 = f4 + f5 / 2.0f;
                float f27 = bitmapShape10.rotateAngle;
                PointF pointF = bitmapShape10.calcRotatePoint(f3, f5, f2, f4, f27);
                Matrix matrix10 = matrix;
                PointF pointF6 = pointF;
                BitmapShape bitmapShape11 = this;
                Matrix matrix11 = matrix10;
                matrix11();
                matrix11.reset();
                float f28 = bitmapShape11.rotateAngle;
                float f29 = bitmapShape11.centerPointX;
                f4 = bitmapShape11.centerPointY;
                matrix10.postRotate(f28, f29, f4);
                f28 = -this.rotateAngle;
                f29 = pointF6.x;
                f4 = pointF6.y;
                matrix10.postRotate(f28, f29, f4);
                matrix.mapPoints(fArray6);
                LPPointF lPPointF6 = bitmapShape10.mSourcePoint;
                lPPointF6.x = fArray6[0];
                lPPointF6.y = fArray6[1];
                break;
            }
            case 2: {
                Matrix matrix;
                float f30 = f2 - 0.0f;
                float f31 = f30 == 0.0f ? 0 : (f30 < 0.0f ? -1 : 1);
                if (f31 < 0 && f3 < 0.0f) {
                    f2 = -f2;
                    f3 = -f3;
                    f7 -= rectF.width();
                    f8 += rectF.height();
                } else if (f31 < 0) {
                    f2 = -f2;
                    f7 -= rectF.width();
                } else if (f3 < 0.0f) {
                    f3 = -f3;
                    f8 += rectF.height();
                }
                BitmapShape bitmapShape = this;
                LPPointF lPPointF = bitmapShape.mSourcePoint;
                lPPointF.x = (lPPointF.x - rectF.right) * f2 + f7;
                lPPointF.y = Math.abs(lPPointF.y - rectF.top) * f3 + f8;
                bitmapShape.width *= f2;
                bitmapShape.height *= f3;
                if (bl) break;
                BitmapShape bitmapShape12 = this;
                float[] fArray = new float[2];
                float[] fArray7 = fArray;
                LPPointF lPPointF7 = this.mSourcePoint;
                fArray7[0] = lPPointF7.x;
                fArray[1] = lPPointF7.y;
                f2 = bitmapShape12.centerPointX;
                f3 = f2 - f4 / 2.0f;
                f4 = bitmapShape12.centerPointY;
                f5 = f4 + f5 / 2.0f;
                float f32 = bitmapShape12.rotateAngle;
                PointF pointF = bitmapShape12.calcRotatePoint(f3, f5, f2, f4, f32);
                Matrix matrix12 = matrix;
                PointF pointF7 = pointF;
                BitmapShape bitmapShape13 = this;
                Matrix matrix13 = matrix12;
                matrix13();
                matrix13.reset();
                float f33 = bitmapShape13.rotateAngle;
                float f34 = bitmapShape13.centerPointX;
                f4 = bitmapShape13.centerPointY;
                matrix12.postRotate(f33, f34, f4);
                f33 = -this.rotateAngle;
                f34 = pointF7.x;
                f4 = pointF7.y;
                matrix12.postRotate(f33, f34, f4);
                matrix.mapPoints(fArray7);
                LPPointF lPPointF8 = bitmapShape12.mSourcePoint;
                lPPointF8.x = fArray7[0];
                lPPointF8.y = fArray7[1];
                break;
            }
            case 1: {
                Matrix matrix;
                if (f2 < 0.0f) {
                    f2 = -f2;
                    f7 -= rectF.width();
                }
                BitmapShape bitmapShape = this;
                LPPointF lPPointF = bitmapShape.mSourcePoint;
                lPPointF.x = f3 = (lPPointF.x - rectF.right) * f2 + f7;
                bitmapShape.width *= f2;
                if (bl) break;
                BitmapShape bitmapShape14 = this;
                float[] fArray = new float[2];
                float[] fArray8 = fArray;
                fArray8[0] = f3;
                fArray[1] = lPPointF.y;
                float f35 = bitmapShape14.centerPointX;
                f3 = f35 - f4 / 2.0f;
                f4 = bitmapShape14.centerPointY;
                f5 = f4 - f5 / 2.0f;
                float f36 = bitmapShape14.rotateAngle;
                PointF pointF = bitmapShape14.calcRotatePoint(f3, f5, f35, f4, f36);
                Matrix matrix14 = matrix;
                PointF pointF8 = pointF;
                BitmapShape bitmapShape15 = this;
                Matrix matrix15 = matrix14;
                matrix15();
                matrix15.reset();
                float f37 = bitmapShape15.rotateAngle;
                float f38 = bitmapShape15.centerPointX;
                f4 = bitmapShape15.centerPointY;
                matrix14.postRotate(f37, f38, f4);
                f37 = -this.rotateAngle;
                f38 = pointF8.x;
                f4 = pointF8.y;
                matrix14.postRotate(f37, f38, f4);
                matrix.mapPoints(fArray8);
                LPPointF lPPointF9 = bitmapShape14.mSourcePoint;
                lPPointF9.x = fArray8[0];
                lPPointF9.y = fArray8[1];
                break;
            }
            case 0: {
                Matrix matrix;
                float f39;
                float f40;
                float f41 = f2 - 0.0f;
                float f42 = f41 == 0.0f ? 0 : (f41 < 0.0f ? -1 : 1);
                if (f42 < 0 && f3 < 0.0f) {
                    f2 = -f2;
                    f3 = -f3;
                    f7 -= rectF.width();
                    f9 -= rectF.height();
                } else if (f42 < 0) {
                    f2 = -f2;
                    f7 -= rectF.width();
                } else if (f3 < 0.0f) {
                    f3 = -f3;
                    f9 -= rectF.height();
                }
                BitmapShape bitmapShape = this;
                LPPointF lPPointF = bitmapShape.mSourcePoint;
                lPPointF.x = f40 = (lPPointF.x - rectF.right) * f2 + f7;
                lPPointF.y = f39 = (lPPointF.y - rectF.bottom) * f3 + f9;
                bitmapShape.width *= f2;
                bitmapShape.height *= f3;
                if (bl) break;
                BitmapShape bitmapShape16 = this;
                float[] fArray = new float[2];
                float[] fArray9 = fArray;
                fArray[0] = f40;
                fArray[1] = f39;
                f40 = bitmapShape16.centerPointX;
                f3 = f40 - f4 / 2.0f;
                f4 = bitmapShape16.centerPointY;
                f5 = f4 - f5 / 2.0f;
                f39 = bitmapShape16.rotateAngle;
                PointF pointF = bitmapShape16.calcRotatePoint(f3, f5, f40, f4, f39);
                Matrix matrix16 = matrix;
                PointF pointF9 = pointF;
                BitmapShape bitmapShape17 = this;
                Matrix matrix17 = matrix16;
                matrix17();
                matrix17.reset();
                float f43 = bitmapShape17.rotateAngle;
                float f44 = bitmapShape17.centerPointX;
                f4 = bitmapShape17.centerPointY;
                matrix16.postRotate(f43, f44, f4);
                f43 = -this.rotateAngle;
                f44 = pointF9.x;
                f4 = pointF9.y;
                matrix16.postRotate(f43, f44, f4);
                matrix.mapPoints(fArray9);
                LPPointF lPPointF10 = bitmapShape16.mSourcePoint;
                lPPointF10.x = fArray9[0];
                lPPointF10.y = fArray9[1];
            }
        }
        this.ratio = this.height / this.width;
    }

    @Override
    public boolean isBoundaryOverlap(RectF rectF) {
        BitmapShape bitmapShape = bitmapShape6;
        LPPointF lPPointF = bitmapShape.mSourcePoint;
        float f2 = lPPointF.x;
        float f3 = (f2 + f2 + bitmapShape6.width) / 2.0f;
        float f4 = lPPointF.y;
        float f5 = (f4 + f4 + bitmapShape6.height) / 2.0f;
        PointF[] pointFArray = new PointF[4];
        PointF[] pointFArray2 = pointFArray;
        BitmapShape bitmapShape2 = bitmapShape6;
        BitmapShape bitmapShape3 = bitmapShape6;
        BitmapShape bitmapShape4 = bitmapShape6;
        float f6 = f2;
        f2 = bitmapShape6.rotateAngle;
        pointFArray2[0] = bitmapShape6.calcRotatePoint(f6, f4, f3, f5, f2);
        LPPointF lPPointF2 = bitmapShape4.mSourcePoint;
        f2 = lPPointF2.x + bitmapShape6.width;
        f4 = lPPointF2.y;
        float f7 = bitmapShape4.rotateAngle;
        pointFArray2[1] = bitmapShape4.calcRotatePoint(f2, f4, f3, f5, f7);
        LPPointF lPPointF3 = bitmapShape3.mSourcePoint;
        f2 = lPPointF3.x;
        f4 = lPPointF3.y + bitmapShape6.height;
        f7 = bitmapShape3.rotateAngle;
        pointFArray2[2] = bitmapShape3.calcRotatePoint(f2, f4, f3, f5, f7);
        LPPointF lPPointF4 = bitmapShape2.mSourcePoint;
        f2 = lPPointF4.x + bitmapShape6.width;
        f4 = lPPointF4.y + bitmapShape6.height;
        f7 = bitmapShape2.rotateAngle;
        pointFArray[3] = bitmapShape2.calcRotatePoint(f2, f4, f3, f5, f7);
        PointF pointF = pointFArray[0];
        if (bitmapShape.isVectorInRect(pointF, pointFArray[1], rectF)) {
            return true;
        }
        pointF = pointFArray2[1];
        if (bitmapShape6.isVectorInRect(pointF, pointFArray2[3], rectF)) {
            return true;
        }
        pointF = pointFArray2[2];
        if (bitmapShape6.isVectorInRect(pointF, pointFArray2[3], rectF)) {
            return true;
        }
        BitmapShape bitmapShape5 = bitmapShape6;
        BitmapShape bitmapShape6 = pointFArray2[1];
        return bitmapShape5.isVectorInRect((PointF)bitmapShape6, pointFArray2[2], rectF);
    }

    @Override
    public void setAngle(float f2) {
        this.rotateAngle = f2;
    }
}

