/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.ppt.whiteboard;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.request.target.Target;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.context.LPError;
import com.baijiayun.livebase.models.LPJsonModel;
import com.baijiayun.livebase.widgets.view.photoview.OnAnimTouchListener;
import com.baijiayun.livebase.widgets.view.photoview.OnDoubleTapListener;
import com.baijiayun.livebase.widgets.view.photoview.OnScaleChangedListener;
import com.baijiayun.livebase.widgets.view.photoview.OnViewTapListener;
import com.baijiayun.livebase.widgets.view.photoview.PhotoView;
import com.baijiayun.livecore.LiveSDK;
import com.baijiayun.livecore.R;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPDocExtraModel;
import com.baijiayun.livecore.models.LPDocModel;
import com.baijiayun.livecore.models.LPMotionEvent;
import com.baijiayun.livecore.models.LPPointF;
import com.baijiayun.livecore.models.LPShapeModel;
import com.baijiayun.livecore.models.LPUploadDocModel;
import com.baijiayun.livecore.models.LPWhiteboardViewInfo;
import com.baijiayun.livecore.models.animppt.LPAnimPPTPageChangeEndModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomDocUpdateModel;
import com.baijiayun.livecore.ppt.PPTView;
import com.baijiayun.livecore.ppt.util.LPShapeConverter;
import com.baijiayun.livecore.ppt.util.ShapeUtils;
import com.baijiayun.livecore.ppt.whiteboard.OnDoubleTapListener2;
import com.baijiayun.livecore.ppt.whiteboard.Whiteboard;
import com.baijiayun.livecore.ppt.whiteboard.animppt.LPAnimPPTRequestListener;
import com.baijiayun.livecore.ppt.whiteboard.animppt.LPAnimPPTRouterCallbackListener;
import com.baijiayun.livecore.ppt.whiteboard.animppt.LPAnimPPTRouterListener;
import com.baijiayun.livecore.ppt.whiteboard.animppt.LPVibratorUtil;
import com.baijiayun.livecore.ppt.whiteboard.shape.BitmapShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.DoodleShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.LaserShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.OvalShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.RectBoundaryShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.RectShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.ppt.whiteboard.shape.ShapeRegionInfo;
import com.baijiayun.livecore.ppt.whiteboard.shape.TextShape;
import com.baijiayun.livecore.viewmodels.impl.LPDocListViewModel;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class WhiteboardView
extends PhotoView
implements Whiteboard,
LPAnimPPTRouterCallbackListener {
    private static final int PAINT_DEFAULT_COLOR = Color.parseColor((String)"#FF1e5eff");
    private static final float ERASER_WIDTH = 20.0f;
    private static final int MOVE_MODE_NONE = -1;
    private static final int MOVE_MODE_SINGLE_SHAPE_SELECT = 1;
    private static final int MOVE_MODE_MULTIPLE_SHAPE_SELECT = 2;
    private static final int MOVE_MODE_SINGLE_SHAPE_SCALE = 3;
    private static final int MOVE_MODE_MULTIPLE_SHAPE_SCALE = 4;
    private static final int MOVE_MODE_SINGLE_SHAPE_DRAG = 5;
    private static final int MOVE_MODE_MULTIPLE_SHAPE_DRAG = 6;
    private static final int MOVE_MODE_SELECT = 7;
    private static final float CUSTOM_SHAPE_MIN_DISTANCE = 10.0f;
    private static final float CUSTOM_SHAPE_INVALIDATE_RANGE = 1.0f;
    private final String TAG;
    private ArrayList<Shape> shapeList;
    private ConcurrentLinkedQueue<LPShapeModel> shapeModelList;
    private List<Shape> boundaryShapeList;
    private boolean isAnimPPT;
    private boolean isPPTAuth;
    private LPConstants.H5PlayMode mH5PlayMode;
    public AtomicBoolean isAnimPPTPageChange;
    public int backupPicHostIndex;
    private int mPageIndex;
    private LPConstants.LPPPTShowWay pptShowWay;
    private boolean mTouchEnable;
    private boolean mFlipEnable;
    public boolean isLoadLargePic;
    private boolean isPCBlackboard;
    private LPConstants.LPUserType userRole;
    private boolean enableStudentOperatePaint;
    private boolean enableEraseTeacherPaint;
    private LPConstants.PPTEditMode pptEditMode;
    private Paint mShapePaint;
    private Paint mSelectedUPRectPaint;
    private Paint mCustomShapePaint;
    private DoodleShape mDrawingShape;
    private Shape mMoveShape;
    private Shape mCustomShape;
    private RectBoundaryShape mSelectRectBoundaryShape;
    private Shape mLaserShape;
    private int mPaintTextSize;
    private LPPointF mTextEditSourcePoint;
    private Shape mTextEditBoundary;
    private float PAINT_DEFAULT_SIZE;
    private float CUSTOM_PAINT_DEFAULT_SIZE;
    private Target target;
    private int previousX;
    private int previousY;
    private LPConstants.ShapeType shapeType;
    private LPConstants.ShapeType customShapeType;
    private LPAnimPPTRouterListener lpAnimPPTRouterListener;
    private LPAnimPPTRequestListener lpAnimPPTRequestListener;
    private LPShapeSendListener lpShapeSendListener;
    private OnBoardTouchListener onBoardTouchListener;
    private Whiteboard.OnPageSelectedListener onPageSelectedListener;
    private Whiteboard.OnDocUpdateListener onDocUpdateListener;
    private OnWindowSizeListener onWindowSizeListener;
    private GestureDetector mGestureDetector;
    private OnDoubleTapListener2 onDoubleTapListener;
    private OnViewTapListener onViewTapListener;
    private PPTView.OnBitmapShapeListener onBitmapShapeListener;
    private boolean h5WebViewConsumeEvent;
    private boolean animPPTConsumeEvent;
    private boolean isPreviewDoc;
    private boolean zoomEnable;
    private String docId;
    private int page;
    private int pageId;
    private int currentHeight;
    private int currentWidth;
    private int viewHeight;
    private int viewWidth;
    private int maxPage;
    private int shapeAppendIndex;
    private int mDashType;
    private LinkedHashMap<String, DoodleShape> appendingShapeMap;
    private HashMap<String, ArrayList<DoodleShape>> appendedShapeMap;
    private ArrayList<LPShapeModel> appendedShapeModelList;
    private ArrayList<String> ownerOfShapeList;
    private boolean isShowPaintOwnerEnable;
    private Whiteboard.OnShapeSelectedListener onShapeSelectedListener;
    private VectorDrawableCompat shapeCursorVectorDrawable;
    private VectorDrawableCompat brushCursorVectorDrawable;
    private VectorDrawableCompat markerShapeVectorDrawable;
    private VectorDrawableCompat arrowShapeVectorDrawable;
    private VectorDrawableCompat eraserShapeVectorDrawable;
    private Disposable disposableOfShapeCursorTimer;
    private Shape hoverMouseShape;
    private final LPMotionEvent lpMotionEvent;
    private final float MAX_HAND_WRITING_SPEED;
    private Map<String, LPDocExtraModel> extraModelMap;
    private LPDocExtraModel syncExtraModel;
    private List<LPDocModel> docList;
    private final float[] mMatrixValues;
    private LiveRoom liveRoom;
    private LPDocListViewModel docListViewModel;
    private final int INVALID_ID;
    private int mActivePointerId;
    private long timestamp;
    private ArrayList<LPPointF> pointList;
    private DoodleShape mDrawingShapeForAppend;
    private LPPointF lastPointF;
    public int mPreviewShapeId;
    private Shape textShape;
    private boolean isGroupSelected;
    private List<Shape> selectedShapes;
    private RectShape mDrawingRectShape;
    @ColorInt
    private int mDrawingRectShapePaintColor;
    private RectF multiSelectedRectBoundary;
    private RectBoundaryShape multiSelectedBoundaryShape;
    private int shapeMoveMode;
    private PointF mDrawingRectSourcePoint;
    public int laserMoveNumber;
    private LPPointF customShapeDownPoint;
    private LPPointF lastCustomShapePoint;
    private boolean shouldDrawCustomShape;
    private boolean useRelativePage;
    private String lastDocId;
    private LPAnimPPTPageChangeEndModel pageChangeEndModel;
    private float rawX;
    private boolean isVibrated;
    public boolean hasPrevPage;
    public boolean hasNextPage;
    public boolean hasPrevStep;
    public boolean hasNextStep;

    public WhiteboardView(Context context) {
        this(context, null);
    }

    public WhiteboardView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public WhiteboardView(Context context, AttributeSet attributeSet, int n2) {
        WhiteboardView whiteboardView = this;
        super(context, attributeSet, n2);
        whiteboardView.TAG = WhiteboardView.class.getCanonicalName();
        whiteboardView.shapeList = new ArrayList();
        whiteboardView.shapeModelList = new ConcurrentLinkedQueue();
        whiteboardView.boundaryShapeList = new ArrayList<Shape>();
        whiteboardView.mH5PlayMode = LPConstants.H5PlayMode.Teach;
        whiteboardView.isAnimPPTPageChange = new AtomicBoolean(false);
        whiteboardView.backupPicHostIndex = -1;
        whiteboardView.mPageIndex = -1;
        whiteboardView.mTouchEnable = true;
        whiteboardView.mFlipEnable = true;
        whiteboardView.enableStudentOperatePaint = true;
        whiteboardView.enableEraseTeacherPaint = true;
        whiteboardView.pptEditMode = LPConstants.PPTEditMode.Normal;
        whiteboardView.mPaintTextSize = 20;
        whiteboardView.PAINT_DEFAULT_SIZE = 4.0f;
        whiteboardView.CUSTOM_PAINT_DEFAULT_SIZE = 2.0f;
        whiteboardView.shapeType = LPConstants.ShapeType.Doodle;
        whiteboardView.customShapeType = LPConstants.ShapeType.StraightLine;
        whiteboardView.h5WebViewConsumeEvent = true;
        whiteboardView.zoomEnable = true;
        whiteboardView.appendingShapeMap = new LinkedHashMap();
        whiteboardView.appendedShapeMap = new HashMap();
        whiteboardView.appendedShapeModelList = new ArrayList();
        whiteboardView.ownerOfShapeList = new ArrayList();
        whiteboardView.lpMotionEvent = new LPMotionEvent();
        whiteboardView.docList = new ArrayList<LPDocModel>();
        whiteboardView.mMatrixValues = new float[9];
        whiteboardView.INVALID_ID = -1;
        whiteboardView.mActivePointerId = -1;
        whiteboardView.pointList = new ArrayList();
        whiteboardView.mPreviewShapeId = 1;
        whiteboardView.selectedShapes = new ArrayList<Shape>();
        whiteboardView.mDrawingRectShapePaintColor = Color.parseColor((String)"#4D000000");
        whiteboardView.shapeMoveMode = -1;
        whiteboardView.initParameters();
        whiteboardView.startShapeCursorTimer();
        whiteboardView.MAX_HAND_WRITING_SPEED = UtilsKt.getDp((float)1.5f);
        whiteboardView.syncExtraModel = LPDocExtraModel.getDefaultModel();
        whiteboardView.extraModelMap = new HashMap<String, LPDocExtraModel>();
    }

    private void initParameters() {
        WhiteboardView whiteboardView = this;
        this.mShapePaint = new Paint();
        this.mShapePaint.setDither(true);
        int n2 = PAINT_DEFAULT_COLOR;
        whiteboardView.mShapePaint.setColor(n2);
        whiteboardView.setShapeStrokeWidth(whiteboardView.PAINT_DEFAULT_SIZE);
        whiteboardView.mShapePaint.setStyle(Paint.Style.STROKE);
        whiteboardView.mShapePaint.setStrokeCap(Paint.Cap.ROUND);
        whiteboardView.mShapePaint.setStrokeJoin(Paint.Join.ROUND);
        whiteboardView.mShapePaint.setAntiAlias(true);
        whiteboardView.mShapePaint.setAlpha(255);
        this.mCustomShapePaint = new Paint();
        this.mCustomShapePaint.setDither(true);
        whiteboardView.mCustomShapePaint.setAntiAlias(true);
        whiteboardView.mCustomShapePaint.setColor(n2);
        whiteboardView.mCustomShapePaint.setStrokeWidth(this.CUSTOM_PAINT_DEFAULT_SIZE);
        whiteboardView.mCustomShapePaint.setStyle(Paint.Style.STROKE);
        whiteboardView.mCustomShapePaint.setAlpha(255);
        this.mSelectedUPRectPaint = new Paint();
        this.mSelectedUPRectPaint.setDither(true);
        whiteboardView.mSelectedUPRectPaint.setColor(-7829368);
        whiteboardView.mSelectedUPRectPaint.setStrokeWidth(1.0f);
        whiteboardView.mSelectedUPRectPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{5.0f, 5.0f}, 0.0f));
        whiteboardView.mSelectedUPRectPaint.setStyle(Paint.Style.STROKE);
        whiteboardView.mSelectedUPRectPaint.setAlpha(255);
        whiteboardView.brushCursorVectorDrawable = VectorDrawableCompat.create((Resources)whiteboardView.getResources(), (int)R.drawable.live_core_svg_shape_brush, null);
        whiteboardView.markerShapeVectorDrawable = VectorDrawableCompat.create((Resources)whiteboardView.getResources(), (int)R.drawable.live_core_svg_shape_marker, null);
        whiteboardView.arrowShapeVectorDrawable = VectorDrawableCompat.create((Resources)whiteboardView.getResources(), (int)R.drawable.live_core_svg_shape_select, null);
        whiteboardView.eraserShapeVectorDrawable = VectorDrawableCompat.create((Resources)whiteboardView.getResources(), (int)R.drawable.live_core_svg_shape_eraser, null);
        whiteboardView.shapeCursorVectorDrawable = whiteboardView.brushCursorVectorDrawable;
        whiteboardView.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapConfirmed(@NonNull MotionEvent motionEvent) {
                if (a2.WhiteboardView.this.onViewTapListener != null && !a2.WhiteboardView.this.isPreviewDoc) {
                    MotionEvent motionEvent2 = motionEvent;
                    a a2 = a2.WhiteboardView.this.getRootView();
                    float f2 = motionEvent2.getX();
                    float f3 = motionEvent2.getY();
                    a2.WhiteboardView.this.onViewTapListener.onViewTap((View)a2, f2, f3);
                }
                return true;
            }

            public boolean onDoubleTap(@NonNull MotionEvent motionEvent) {
                if (WhiteboardView.this.pptEditMode == LPConstants.PPTEditMode.SelectMode) {
                    for (int i2 = WhiteboardView.this.shapeList.size() - 1; i2 >= 0; --i2) {
                        PointF pointF;
                        Shape shape = (Shape)WhiteboardView.this.shapeList.get(i2);
                        if (!(shape instanceof TextShape)) continue;
                        MotionEvent motionEvent2 = motionEvent;
                        float f2 = motionEvent2.getX();
                        if (!shape.isInBoundary(f2, motionEvent2.getY())) continue;
                        MotionEvent motionEvent3 = motionEvent;
                        f2 = motionEvent3.getX();
                        if (!shape.isTouchShape(f2, motionEvent3.getY()) || !WhiteboardView.this.canOperatePaint(shape)) continue;
                        a a2 = this;
                        WhiteboardView.access$502(a2.WhiteboardView.this, shape);
                        WhiteboardView whiteboardView = a2.WhiteboardView.this;
                        WhiteboardView.access$602(whiteboardView, whiteboardView.textShape.getSourcePoint());
                        WhiteboardView.access$702(a2.WhiteboardView.this, ShapeUtils.createShape(LPConstants.ShapeType.Rect, ShapeUtils.getTextEditPaint(), 0.0f, WhiteboardView.this.userRole));
                        a2.WhiteboardView.this.mTextEditBoundary.setSourcePoint(WhiteboardView.this.mTextEditSourcePoint);
                        motionEvent = pointF;
                        a a3 = this;
                        motionEvent(((WhiteboardView)WhiteboardView.this).mTextEditBoundary.getSourcePoint().x, ((WhiteboardView)WhiteboardView.this).mTextEditBoundary.getSourcePoint().y);
                        float[] fArray = new float[10];
                        a3.WhiteboardView.this.getImageMatrix().getValues(fArray);
                        pointF.offset(((TextShape)a3.WhiteboardView.this.textShape).getTextWidth(fArray[0]), ((TextShape)WhiteboardView.this.textShape).getTextHeight(fArray[0]));
                        a2.WhiteboardView.this.mTextEditBoundary.appendPoint(new LPPointF((PointF)motionEvent));
                        WhiteboardView.access$902(a2.WhiteboardView.this, null);
                        if (a2.WhiteboardView.this.onDoubleTapListener != null) {
                            WhiteboardView.this.onDoubleTapListener.onDoubleTapOnShape(shape);
                        }
                        WhiteboardView.this.clearBoard();
                        return true;
                    }
                } else if (WhiteboardView.this.onDoubleTapListener != null) {
                    WhiteboardView.this.onDoubleTapListener.onDoubleTapConfirmed();
                }
                return false;
            }

            public boolean onDoubleTapEvent(@NonNull MotionEvent motionEvent) {
                return true;
            }
        });
        whiteboardView.setScaleTypeChangeListener(() -> this.syncZoomAndScroll());
        whiteboardView.setOnAnimTouchListener(new OnAnimTouchListener(){

            public void onTouchMove(float f2) {
                boolean bl = !WhiteboardView.this.mFlipEnable || WhiteboardView.this.isAnimPPTPageChange.get() || !WhiteboardView.this.isPPTAuth || WhiteboardView.this.isPreviewDoc || WhiteboardView.this.pptEditMode != LPConstants.PPTEditMode.Normal;
                if (bl) {
                    return;
                }
                WhiteboardView.this.onAnimTouchMove(f2);
            }

            public void onTouchEnd(float f2) {
                boolean bl = !WhiteboardView.this.mFlipEnable || WhiteboardView.this.isAnimPPTPageChange.get() || !WhiteboardView.this.isPPTAuth || WhiteboardView.this.isPreviewDoc || WhiteboardView.this.pptEditMode != LPConstants.PPTEditMode.Normal;
                if (bl) {
                    return;
                }
                WhiteboardView.this.onAnimTouchEnd(f2);
            }

            public void onTouchCancel() {
                b b2 = this;
                WhiteboardView.access$1602(b2.WhiteboardView.this, false);
                if (b2.WhiteboardView.this.onBoardTouchListener != null) {
                    WhiteboardView.this.onBoardTouchListener.onTouchEnd();
                }
            }
        });
    }

    private void touchStart(LPMotionEvent lPMotionEvent) {
        LPMotionEvent lPMotionEvent2 = lPMotionEvent;
        WhiteboardView whiteboardView = this;
        LPMotionEvent lPMotionEvent3 = lPMotionEvent;
        this.hoverMouseShape = null;
        int n2 = lPMotionEvent3.getActionIndex();
        whiteboardView.mActivePointerId = lPMotionEvent3.getPointerId(n2);
        WhiteboardView whiteboardView2 = this;
        Paint paint = whiteboardView2.mShapePaint;
        LPConstants.LPUserType lPUserType = whiteboardView2.userRole;
        whiteboardView.mDrawingShape = (DoodleShape)ShapeUtils.createShape(LPConstants.ShapeType.Doodle, paint, 0.0f, lPUserType);
        WhiteboardView whiteboardView3 = this;
        paint = whiteboardView3.mShapePaint;
        lPUserType = whiteboardView3.userRole;
        whiteboardView.mDrawingShapeForAppend = (DoodleShape)ShapeUtils.createShape(LPConstants.ShapeType.Doodle, paint, 0.0f, lPUserType);
        float f2 = lPMotionEvent2.getX(n2);
        Object object = this.drawingInBound(f2, lPMotionEvent2.getY(n2));
        if (object != null) {
            WhiteboardView whiteboardView4 = this;
            object.setLineWidthFactor(lPMotionEvent.getPressure());
            whiteboardView4.mDrawingShape.setSourcePoint((LPPointF)((Object)object));
            whiteboardView4.mDrawingShapeForAppend.setSourcePoint((LPPointF)((Object)object));
            this.lastPointF = object;
        }
        this.timestamp = System.currentTimeMillis();
        if (LiveSDK.ENABLE_SHOW_SHAPE_APPEND_CURSOR) {
            this.mDrawingShape.showCursorBitmap = true;
            for (int i2 = this.shapeList.size() - 1; i2 >= 0; --i2) {
                object = this.shapeList.get(i2);
                if (!(object instanceof DoodleShape)) continue;
                object = (DoodleShape)object;
                if (!((DoodleShape)object).showCursorBitmap) continue;
                ((DoodleShape)object).showCursorBitmap = false;
            }
        }
    }

    private void touchMove(LPMotionEvent lPMotionEvent) {
        this.hoverMouseShape = null;
        if (this.mActivePointerId == -1) {
            this.touchStart(lPMotionEvent);
            return;
        }
        if (lPMotionEvent.getMotionEvent() != null) {
            LPMotionEvent lPMotionEvent2 = lPMotionEvent;
            if (this.mActivePointerId != lPMotionEvent2.getPointerId(lPMotionEvent2.getActionIndex())) {
                return;
            }
        }
        LPMotionEvent lPMotionEvent3 = lPMotionEvent;
        int n2 = lPMotionEvent3.findPointerIndex(this.mActivePointerId);
        float f2 = lPMotionEvent3.getX(n2);
        LPPointF lPPointF = this.drawingInBound(f2, lPMotionEvent3.getY(n2));
        if (lPPointF == null) {
            this.touchEnd();
        } else {
            this.mDrawingShapeForAppend.number = this.mDrawingShape.number;
            if (lPMotionEvent.getPressure() >= 0.0f) {
                lPPointF.setLineWidthFactor(lPMotionEvent.getPressure());
            } else {
                double d2;
                WhiteboardView whiteboardView = this;
                double d3 = Math.cos((double)(Math.min(whiteboardView.getSpeedBetweenPoints(whiteboardView.lastPointF, lPPointF), this.MAX_HAND_WRITING_SPEED) / this.MAX_HAND_WRITING_SPEED) * Math.PI / 2.0);
                if (Math.abs(d2) < (double)1.0E-4f) {
                    d3 = 0.0;
                }
                lPPointF.setLineWidthFactor((float)d3);
            }
            this.mDrawingShape.appendPoint(lPPointF);
            if (System.currentTimeMillis() - this.timestamp < 400L) {
                this.pointList.add(lPPointF);
            } else {
                this.doSendShapeAppend(false);
                this.timestamp = System.currentTimeMillis();
            }
            this.lastPointF = lPPointF;
        }
    }

    private void doSendShapeAppend(boolean bl) {
        WhiteboardView whiteboardView = this;
        whiteboardView.mDrawingShapeForAppend.setPoints(this.pointList);
        if (whiteboardView.lpShapeSendListener != null) {
            WhiteboardView whiteboardView2 = this;
            LPWhiteboardViewInfo lPWhiteboardViewInfo = whiteboardView2.getWhiteboardViewInfo();
            whiteboardView2.getWhiteboardViewInfo().isEnd = bl ? 1 : 0;
            WhiteboardView whiteboardView3 = this;
            DoodleShape doodleShape = whiteboardView3.mDrawingShapeForAppend;
            int n2 = whiteboardView3.shapeAppendIndex;
            whiteboardView2.lpShapeSendListener.sendShapeAppend(doodleShape, lPWhiteboardViewInfo, n2);
        }
        WhiteboardView whiteboardView4 = this;
        ++whiteboardView4.shapeAppendIndex;
        whiteboardView4.pointList.clear();
    }

    private LPPointF drawingInBound(float f2, float f3) {
        float f4;
        Matrix matrix = this.getImageMatrix();
        float[] fArray = new float[10];
        matrix.getValues(fArray);
        float f5 = fArray[0];
        float f6 = fArray[4];
        float f7 = fArray[2];
        float f8 = fArray[5] / f6;
        float f9 = f2 / f5 - (f7 /= f5);
        float f10 = f3 / f5 - f8;
        float f11 = f9 - 0.0f;
        float f12 = f11 == 0.0f ? 0 : (f11 > 0.0f ? 1 : -1);
        if (f12 > 0 && f9 < (float)this.getWidth() / f5 - f7 * 2.0f && f10 > 0.0f && f10 < (float)this.getHeight() / f6 - f8 * 2.0f) {
            return new LPPointF(f9, f10);
        }
        if (f9 <= 0.0f && f10 > f8 && f10 < (float)this.getHeight() / f6 - f8 * 2.0f) {
            return new LPPointF(0.0f, f10);
        }
        f7 *= 2.0f;
        if (f9 >= (float)this.getWidth() / f5 - f4 && f10 > 0.0f && f10 < (float)this.getHeight() / f6 - f8 * 2.0f) {
            return new LPPointF((float)this.getWidth() / f5 - f7, f10);
        }
        if (f12 > 0 && f9 < (float)this.getWidth() / f5 - f7) {
            float f13;
            f8 *= 2.0f;
            if (f10 >= (float)this.getHeight() / f6 - f13) {
                return new LPPointF(f9, (float)this.getHeight() / f6 - f8);
            }
        }
        if (f12 > 0 && f9 < (float)this.getWidth() / f5 - f7 && f3 <= 0.0f) {
            return new LPPointF(f9, 0.0f);
        }
        return null;
    }

    private void clearBoard() {
        WhiteboardView whiteboardView = this;
        whiteboardView.multiSelectedBoundaryShape = null;
        whiteboardView.multiSelectedRectBoundary = null;
        whiteboardView.mSelectRectBoundaryShape = null;
        whiteboardView.boundaryShapeList.clear();
        whiteboardView.invalidate();
    }

    private void drawAllShapes(Canvas canvas) {
        if (this.shapeList == null) {
            return;
        }
        boolean bl = false;
        for (Shape shape : new ArrayList<Shape>(this.shapeList)) {
            Shape shape2;
            if (shape instanceof TextShape && (shape2 = this.textShape) != null && TextUtils.equals((CharSequence)shape.id, (CharSequence)shape2.id)) {
                ((TextShape)shape).setOnShapeChangeListener(this::onTextShapeChange);
                bl = true;
            }
            if (!shape.isValid()) continue;
            if (shape instanceof DoodleShape) {
                this.setCursorShapeDrawable((DoodleShape)shape);
            }
            WhiteboardView whiteboardView = this;
            shape2 = whiteboardView.getImageMatrix();
            ShapeRegionInfo shapeRegionInfo = whiteboardView.getRegionInfo(shape);
            shape.onDraw(canvas, (Matrix)shape2, shapeRegionInfo);
        }
        if (!bl) {
            this.drawEditTextBoundary(canvas);
        }
    }

    private void drawingMySelfDrawingShape(Canvas canvas) {
        DoodleShape doodleShape = this.mDrawingShape;
        if (doodleShape == null) {
            return;
        }
        if (doodleShape.isValid()) {
            WhiteboardView whiteboardView = this;
            whiteboardView.setCursorShapeDrawable(whiteboardView.mDrawingShape);
            whiteboardView.mDrawingShape.onDraw(canvas, this.getImageMatrix());
        }
    }

    private void drawAppendingShape(Canvas canvas) {
        LinkedHashMap<String, DoodleShape> linkedHashMap = this.appendingShapeMap;
        if (linkedHashMap != null && !((AbstractMap)linkedHashMap).isEmpty()) {
            linkedHashMap = this.appendingShapeMap.entrySet().iterator();
            while (linkedHashMap.hasNext()) {
                DoodleShape doodleShape;
                DoodleShape doodleShape2 = (DoodleShape)((Map.Entry)linkedHashMap.next()).getValue();
                if (!doodleShape2.isValid() || (doodleShape = this.mDrawingShape) != null && doodleShape.number.equals(doodleShape2.number)) continue;
                WhiteboardView whiteboardView = this;
                whiteboardView.setCursorShapeDrawable(doodleShape2);
                doodleShape2.onDraw(canvas, whiteboardView.getImageMatrix());
            }
            return;
        }
    }

    private void setCursorShapeDrawable(DoodleShape doodleShape) {
        VectorDrawableCompat vectorDrawableCompat = doodleShape.showCursorBitmap && this.hoverMouseShape == null ? this.shapeCursorVectorDrawable : null;
        if (vectorDrawableCompat != null) {
            this.switchCursorShapeDrawable(doodleShape);
        }
        doodleShape.setCursorVectorDrawable(vectorDrawableCompat);
    }

    private void drawRectBoundaryShape(Canvas canvas) {
        Shape shape = this.mSelectRectBoundaryShape;
        if (shape == null) {
            return;
        }
        if (shape.isValid()) {
            WhiteboardView whiteboardView = this;
            whiteboardView.ownerOfShapeList.clear();
            shape = whiteboardView.mMoveShape;
            if (shape != null && !TextUtils.isEmpty((CharSequence)shape.sendByUserName)) {
                this.ownerOfShapeList.add(UtilsKt.getEncodePhoneNumber((String)this.mMoveShape.sendByUserName));
            }
            WhiteboardView whiteboardView2 = this;
            whiteboardView2.mSelectRectBoundaryShape.setOwnerList(this.ownerOfShapeList);
            whiteboardView2.mSelectRectBoundaryShape.onDraw(canvas, this.getImageMatrix());
        }
    }

    private void drawMultiShapesRectBoundary(Canvas canvas) {
        RectBoundaryShape rectBoundaryShape = this.multiSelectedBoundaryShape;
        if (rectBoundaryShape == null) {
            return;
        }
        if (rectBoundaryShape.isValid()) {
            WhiteboardView whiteboardView = this;
            whiteboardView.ownerOfShapeList.clear();
            for (Shape shape : whiteboardView.selectedShapes) {
                if (TextUtils.isEmpty((CharSequence)shape.sendByUserName)) continue;
                boolean bl = true;
                for (String string2 : this.ownerOfShapeList) {
                    if (!shape.sendByUserName.equals(string2)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                this.ownerOfShapeList.add(UtilsKt.getEncodePhoneNumber((String)shape.sendByUserName));
            }
            WhiteboardView whiteboardView2 = this;
            whiteboardView2.multiSelectedBoundaryShape.setOwnerList(this.ownerOfShapeList);
            whiteboardView2.multiSelectedBoundaryShape.onDraw(canvas, this.getImageMatrix());
        }
    }

    private void drawCustomShape(Canvas canvas) {
        WhiteboardView whiteboardView = this;
        whiteboardView.drawLaserShape(canvas);
        Shape shape = whiteboardView.mCustomShape;
        if (shape != null && shape.isValid()) {
            shape = this.mCustomShape;
            if (!shape.hasAddedToPaintList) {
                shape.onDraw(canvas, this.getImageMatrix());
            }
        }
    }

    private void drawLaserShape(Canvas canvas) {
        Shape shape = this.mLaserShape;
        if (shape != null && this.pptEditMode == LPConstants.PPTEditMode.ShapeMode && this.shapeType == LPConstants.ShapeType.Point) {
            if (shape.isValid()) {
                this.mLaserShape.onDraw(canvas, this.getImageMatrix());
            }
            return;
        }
    }

    private void drawingBoundaryShape(Canvas canvas) {
        WhiteboardView whiteboardView = this;
        this.drawRectBoundaryShape(canvas);
        whiteboardView.drawMultiShapesRectBoundary(canvas);
        if (UtilsKt.isEmptyList(whiteboardView.boundaryShapeList)) {
            return;
        }
        for (Shape shape : this.boundaryShapeList) {
            if (shape == null || !shape.isValid()) continue;
            shape.onDraw(canvas, this.getImageMatrix());
        }
    }

    private void drawEditTextBoundary(Canvas canvas) {
        Shape shape = this.mTextEditBoundary;
        if (shape == null) {
            return;
        }
        if (shape.isValid()) {
            this.mTextEditBoundary.onDraw(canvas, this.getImageMatrix());
        }
    }

    private boolean isInFilterRoles(LPConstants.LPUserType lPUserType, LPConstants.LPUserType ... lPUserTypeArray) {
        int n2 = lPUserTypeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (lPUserTypeArray[i2] != lPUserType) continue;
            return true;
        }
        return false;
    }

    private boolean handleShapeAppend(DoodleShape doodleShape3, boolean bl) {
        ArrayList<LPPointF> arrayList;
        if (doodleShape3 == null) {
            return false;
        }
        ArrayList<LPPointF> arrayList2 = this.appendedShapeMap.get(doodleShape3.number);
        if (arrayList2 != null && arrayList2.contains(doodleShape3)) {
            return false;
        }
        if (arrayList2 == null) {
            ArrayList<LPPointF> arrayList3;
            arrayList2 = arrayList3;
            arrayList3 = new ArrayList<LPPointF>();
        }
        ArrayList<LPPointF> arrayList4 = arrayList2;
        ArrayList<LPPointF> arrayList5 = arrayList2;
        arrayList5.add((LPPointF)((Object)doodleShape3));
        Collections.sort(arrayList5, (doodleShape, doodleShape2) -> doodleShape.index - doodleShape2.index);
        this.appendedShapeMap.put(doodleShape3.number, arrayList2);
        arrayList2 = arrayList;
        arrayList = new ArrayList<LPPointF>();
        Object object = arrayList4.iterator();
        while (object.hasNext()) {
            arrayList2.addAll(((DoodleShape)object.next()).getPoints());
        }
        object = this.appendingShapeMap.get(doodleShape3.number);
        if (object == null) {
            DoodleShape doodleShape4;
            object = doodleShape4;
            new DoodleShape(null, null, 0.0f).copy(doodleShape3);
        }
        Object object2 = object;
        ((DoodleShape)object).setSmooth(bl);
        ((DoodleShape)object).setPoints(arrayList2);
        ((DoodleShape)object2).isEnd = doodleShape3.isEnd;
        ((DoodleShape)object2).showCursorBitmap = true;
        ((Shape)object).userRole = doodleShape3.userRole;
        bl = false;
        if (LiveSDK.ENABLE_SHOW_SHAPE_APPEND_CURSOR) {
            for (int i2 = this.shapeList.size() - 1; i2 >= 0; --i2) {
                Shape shape = this.shapeList.get(i2);
                if (!(shape instanceof DoodleShape) || !((DoodleShape)shape).showCursorBitmap || !TextUtils.equals((CharSequence)shape.sendByUserNumber, (CharSequence)doodleShape3.sendByUserNumber)) continue;
                ((DoodleShape)shape).showCursorBitmap = false;
                bl = true;
            }
        }
        if (!bl) {
            DoodleShape doodleShape5 = this.mDrawingShape;
            bl = doodleShape5 == null || !doodleShape5.number.equals(doodleShape3.number);
        }
        ((AbstractMap)this.appendingShapeMap).put(doodleShape3.number, (DoodleShape)object);
        if (doodleShape3.isEnd) {
            this.handleEndShape((Shape)object);
        }
        return bl;
    }

    private void handleEndShape(Shape shape) {
        WhiteboardView whiteboardView = this;
        whiteboardView.appendedShapeMap.remove(shape.number);
        ((AbstractMap)whiteboardView.appendingShapeMap).remove(shape.number);
        boolean bl = false;
        for (int i2 = (v42197).shapeList.size() - 1; i2 >= 0; --i2) {
            if (!shape.number.equals(this.shapeList.get((int)i2).number)) continue;
            this.shapeList.get((int)i2).id = shape.id;
            this.shapeList.get((int)i2).userRole = shape.userRole;
            this.shapeList.set(i2, shape);
            bl = true;
            break;
        }
        if (!bl) {
            this.shapeList.add(shape);
        }
    }

    private ShapeRegionInfo getRegionInfo(Shape object) {
        ShapeRegionInfo shapeRegionInfo;
        if (this.isPCBlackboard) {
            return null;
        }
        Shape shape = object;
        object = shapeRegionInfo;
        shapeRegionInfo = new ShapeRegionInfo();
        Matrix matrix = this.getImageMatrix();
        float[] fArray = new float[10];
        matrix.getValues(fArray);
        float f2 = fArray[0];
        float f3 = fArray[4];
        if (shape instanceof OvalShape) {
            ((ShapeRegionInfo)object).left = fArray[2];
            ((ShapeRegionInfo)object).top = fArray[5];
        }
        Object object2 = object;
        ((ShapeRegionInfo)object2).right = ((ShapeRegionInfo)object2).left + (float)Math.round((double)((float)this.getCurrentWidth() * f2) + 0.5);
        ((ShapeRegionInfo)object2).bottom = ((ShapeRegionInfo)object2).top + (float)Math.round((double)((float)this.getCurrentHeight() * f3) + 0.5);
        return object2;
    }

    private boolean isCustomShape(LPConstants.ShapeType shapeType) {
        switch (c.b[shapeType.ordinal()]) {
            default: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
        }
        return true;
    }

    private boolean canOperatePaint(Shape shape) {
        return this.enableStudentOperatePaint || (this = this.userRole) == LPConstants.LPUserType.Teacher || this == LPConstants.LPUserType.Assistant || (this = shape.userRole) != LPConstants.LPUserType.Teacher && this != LPConstants.LPUserType.Assistant;
    }

    private boolean banStudentEraseTeacherPaint(Shape shape) {
        return this.userRole == LPConstants.LPUserType.Student && ((shape = shape.userRole) == LPConstants.LPUserType.Teacher || shape == LPConstants.LPUserType.Assistant) && !this.enableEraseTeacherPaint;
    }

    private boolean onTouchEventOnEraserMode(LPMotionEvent lPMotionEvent) {
        if (this.shapeList.isEmpty()) {
            return true;
        }
        if (lPMotionEvent.isActionMove()) {
            RectF rectF;
            Object object = rectF;
            LPMotionEvent lPMotionEvent2 = lPMotionEvent;
            float f2 = lPMotionEvent2.getY() - 10.0f;
            float f3 = lPMotionEvent2.getX() + 10.0f;
            float f4 = lPMotionEvent2.getY() + 10.0f;
            rectF = new RectF(lPMotionEvent.getX() - 10.0f, f2, f3, f4);
            Iterator<Shape> iterator = this.shapeList.iterator();
            while (iterator.hasNext()) {
                Shape shape = iterator.next();
                if (!shape.isBoundaryOverlap((RectF)object) || TextUtils.isEmpty((CharSequence)shape.id) || !this.canOperatePaint(shape) || this.banStudentEraseTeacherPaint(shape)) continue;
                object = this.lpShapeSendListener;
                if (object != null) {
                    RectF rectF2 = object;
                    WhiteboardView whiteboardView = this;
                    object = whiteboardView.docId;
                    int n2 = whiteboardView.page;
                    rectF2.eraseShape(shape, (String)object, n2);
                }
                iterator.remove();
                this.invalidate();
                return true;
            }
        }
        return true;
    }

    private boolean onTouchEventOnSelectMode(LPMotionEvent object) {
        if (!((WhiteboardView)((Object)list)).shapeList.isEmpty() && object != null) {
            if (((LPMotionEvent)object).isActionDown()) {
                LPMotionEvent lPMotionEvent = object;
                float f2 = lPMotionEvent.getX();
                if (((WhiteboardView)((Object)list)).decideMultiShapeScale(f2, lPMotionEvent.getY())) {
                    ((WhiteboardView)((Object)list)).shapeMoveMode = 3;
                    return true;
                }
                List<Object> list = object;
                f2 = ((LPMotionEvent)((Object)list)).getX();
                if (((WhiteboardView)((Object)list)).decideSingleShapeScale(f2, ((LPMotionEvent)((Object)list)).getY())) {
                    ((WhiteboardView)((Object)list)).shapeMoveMode = 3;
                    return true;
                }
                List<Object> list2 = object;
                WhiteboardView whiteboardView = list;
                whiteboardView.mSelectRectBoundaryShape = null;
                whiteboardView.mMoveShape = null;
                f2 = ((LPMotionEvent)((Object)list2)).getX();
                if (((WhiteboardView)((Object)list)).decideMultiShapeSelect(f2, ((LPMotionEvent)((Object)list2)).getY())) {
                    ((WhiteboardView)((Object)list)).shapeMoveMode = 6;
                    return true;
                }
                List<Object> list3 = object;
                f2 = ((LPMotionEvent)((Object)list3)).getX();
                if (super.decideSingleShapeSelect(f2, ((LPMotionEvent)((Object)list3)).getY())) {
                    ((WhiteboardView)((Object)list)).shapeMoveMode = 5;
                    return true;
                }
                if (!((WhiteboardView)((Object)list)).boundaryShapeList.isEmpty()) {
                    ((WhiteboardView)((Object)list)).boundaryShapeList.clear();
                }
                if (!((WhiteboardView)((Object)list)).selectedShapes.isEmpty()) {
                    ((WhiteboardView)((Object)list)).selectedShapes.clear();
                }
                List<Object> list4 = object;
                float f3 = ((LPMotionEvent)((Object)list4)).getX();
                super.initSelectRect(f3, ((LPMotionEvent)((Object)list4)).getY());
                ((WhiteboardView)((Object)list)).shapeMoveMode = 7;
                return true;
            }
            if (((LPMotionEvent)object).isActionMove()) {
                LPMotionEvent lPMotionEvent = object;
                float f4 = lPMotionEvent.getX();
                if (((WhiteboardView)((Object)list)).drawSelectRect(f4, lPMotionEvent.getY())) {
                    return true;
                }
                List<Object> list = object;
                f4 = ((LPMotionEvent)((Object)list)).getX();
                if (((WhiteboardView)((Object)list)).moveMultiShapes(f4, ((LPMotionEvent)((Object)list)).getY())) {
                    return true;
                }
                List<Object> list5 = object;
                f4 = ((LPMotionEvent)((Object)list5)).getX();
                if (((WhiteboardView)((Object)list)).scaleMultiShapes(f4, ((LPMotionEvent)((Object)list5)).getY())) {
                    return true;
                }
                List<Object> list6 = object;
                float f5 = ((LPMotionEvent)((Object)list6)).getX();
                super.moveSingleShape(f5, ((LPMotionEvent)((Object)list6)).getY());
            } else if (((LPMotionEvent)object).isActionLeave() || ((LPMotionEvent)object).isActionUp()) {
                object = ((WhiteboardView)((Object)list)).onShapeSelectedListener;
                if (object != null) {
                    boolean bl = ((WhiteboardView)((Object)list)).selectedShapes.size() > 0;
                    object.onShapeSelected(bl);
                }
                if ((object = ((WhiteboardView)((Object)list)).mDrawingRectShape) != null) {
                    WhiteboardView whiteboardView = list;
                    whiteboardView.shapeList.remove(object);
                    whiteboardView.mDrawingRectShape = null;
                    whiteboardView.invalidate();
                    return true;
                }
                if (!((WhiteboardView)((Object)list)).selectedShapes.isEmpty()) {
                    ((WhiteboardView)((Object)list)).isGroupSelected = false;
                    object = ((WhiteboardView)((Object)list)).lpShapeSendListener;
                    if (object != null) {
                        WhiteboardView whiteboardView = list;
                        List<Shape> list = whiteboardView.selectedShapes;
                        object.shapeUpdate(list, whiteboardView.getWhiteboardViewInfo());
                    }
                    return true;
                }
                object = ((WhiteboardView)((Object)list)).mMoveShape;
                if (object != null) {
                    LPShapeSendListener lPShapeSendListener = ((WhiteboardView)((Object)list)).lpShapeSendListener;
                    if (lPShapeSendListener != null) {
                        object = Collections.singletonList(object);
                        lPShapeSendListener.shapeUpdate((List<Shape>)object, ((WhiteboardView)((Object)list)).getWhiteboardViewInfo());
                    }
                    if ((object = ((WhiteboardView)((Object)list)).onShapeSelectedListener) != null) {
                        object.onShapeSelected(true);
                    }
                    list.invalidate();
                    return true;
                }
            }
            return true;
        }
        return true;
    }

    private void updateSingleShape() {
        if (this.mMoveShape != null && this.lpShapeSendListener != null) {
            ArrayList<Shape> arrayList;
            ArrayList<Shape> arrayList2 = arrayList;
            arrayList2();
            arrayList.add(this.mMoveShape);
            this.lpShapeSendListener.shapeUpdate(arrayList2, this.getWhiteboardViewInfo());
        }
    }

    private void updateMultiShapes() {
        LPShapeSendListener lPShapeSendListener;
        if (!((WhiteboardView)((Object)list)).selectedShapes.isEmpty() && (lPShapeSendListener = ((WhiteboardView)((Object)list)).lpShapeSendListener) != null) {
            WhiteboardView whiteboardView = list;
            List<Shape> list = whiteboardView.selectedShapes;
            lPShapeSendListener.shapeUpdate(list, whiteboardView.getWhiteboardViewInfo());
        }
    }

    private boolean decideMultiShapeScale(float f2, float f3) {
        if (this.multiSelectedBoundaryShape != null) {
            LPPointF lPPointF;
            WhiteboardView whiteboardView = this;
            LPPointF lPPointF2 = lPPointF = whiteboardView.transferToScaledPoint(f2, f3);
            float f4 = lPPointF2.x;
            int n2 = whiteboardView.multiSelectedBoundaryShape.isInScaleRect(f4, lPPointF2.y);
            this.multiSelectedBoundaryShape.setScaleOperatorDir(n2);
            return n2 >= 0;
        }
        return false;
    }

    private boolean decideSingleShapeScale(float f2, float f3) {
        if (this.mSelectRectBoundaryShape != null) {
            LPPointF lPPointF;
            WhiteboardView whiteboardView = this;
            LPPointF lPPointF2 = lPPointF = whiteboardView.transferToScaledPoint(f2, f3);
            float f4 = lPPointF2.x;
            int n2 = whiteboardView.mSelectRectBoundaryShape.isInScaleRect(f4, lPPointF2.y);
            this.mSelectRectBoundaryShape.setScaleOperatorDir(n2);
            if (n2 >= 0) {
                return true;
            }
            Shape shape = this.mMoveShape;
            if (shape != null && shape.isInBoundary(f2, f3)) {
                PPTView.OnBitmapShapeListener onBitmapShapeListener;
                WhiteboardView whiteboardView2 = this;
                whiteboardView2.mSelectRectBoundaryShape = null;
                whiteboardView2.drawBoundaryRect(whiteboardView2.mMoveShape);
                shape = whiteboardView2.mMoveShape;
                if (shape instanceof BitmapShape && (onBitmapShapeListener = this.onBitmapShapeListener) != null) {
                    onBitmapShapeListener.onBitmapSelected(shape);
                }
                this.previousX = (int)f2;
                this.previousY = (int)f3;
                return true;
            }
        }
        return false;
    }

    private boolean decideMultiShapeSelect(float f2, float f3) {
        if (!this.selectedShapes.isEmpty()) {
            if (this.multiSelectedBoundaryShape == null) {
                Iterator<Shape> iterator = this.selectedShapes.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().isInBoundary(f2, f3)) continue;
                    this.isGroupSelected = true;
                    break;
                }
            } else {
                LPPointF lPPointF;
                WhiteboardView whiteboardView = this;
                LPPointF lPPointF2 = lPPointF = whiteboardView.transferToScaledPoint(f2, f3);
                float f4 = lPPointF2.x;
                if (whiteboardView.multiSelectedBoundaryShape.isInBoundary(f4, lPPointF2.y)) {
                    this.isGroupSelected = true;
                }
            }
            if (!this.isGroupSelected) {
                if (!this.selectedShapes.isEmpty()) {
                    this.selectedShapes.clear();
                }
                this.clearBoard();
            }
            this.previousX = (int)f2;
            this.previousY = (int)f3;
            return true;
        }
        return false;
    }

    private boolean decideSingleShapeSelect(float f2, float f3) {
        for (int i2 = this.shapeList.size() - 1; i2 >= 0; --i2) {
            PPTView.OnBitmapShapeListener onBitmapShapeListener;
            Shape shape = this.shapeList.get(i2);
            if (!shape.isInBoundary(f2, f3) || !shape.isTouchShape(f2, f3) || !this.canOperatePaint(shape)) continue;
            this.drawBoundaryRect(shape);
            if (shape instanceof BitmapShape && (onBitmapShapeListener = this.onBitmapShapeListener) != null) {
                onBitmapShapeListener.onBitmapSelected(shape);
            }
            this.previousX = (int)f2;
            this.previousY = (int)f3;
            return true;
        }
        return false;
    }

    private void initSelectRect(float f2, float f3) {
        RectShape rectShape = this.mDrawingRectShape;
        if (rectShape != null) {
            this.shapeList.remove(rectShape);
        }
        WhiteboardView whiteboardView = this;
        rectShape = ShapeUtils.getSelectedRectPaint();
        LPConstants.LPUserType lPUserType = this.userRole;
        this.mDrawingRectShape = (RectShape)ShapeUtils.createShape(LPConstants.ShapeType.Rect, (Paint)rectShape, 0.0f, lPUserType);
        this.mDrawingRectShape.setPaint(ShapeUtils.getSelectedRectPaint());
        Object object = this = whiteboardView.transferToScaledPoint(f2, f3);
        float f4 = ((PointF)object).x;
        whiteboardView.mDrawingRectShape.setSelectedStartPoint(f4, ((PointF)object).y);
        whiteboardView.multiSelectedRectBoundary = null;
        whiteboardView.mDrawingRectSourcePoint = new PointF(f2, f3);
    }

    private void updateMultiSelectBoundary(RectF rectF) {
        RectF rectF2 = this.multiSelectedRectBoundary;
        if (rectF2 == null) {
            this.multiSelectedRectBoundary = rectF;
        } else {
            WhiteboardView whiteboardView = this;
            rectF2.left = Math.min(rectF.left, rectF2.left);
            whiteboardView.multiSelectedRectBoundary.top = Math.min(rectF.top, whiteboardView.multiSelectedRectBoundary.top);
            whiteboardView.multiSelectedRectBoundary.right = Math.max(rectF.right, whiteboardView.multiSelectedRectBoundary.right);
            whiteboardView.multiSelectedRectBoundary.bottom = Math.max(rectF.bottom, whiteboardView.multiSelectedRectBoundary.bottom);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean drawSelectRect(float f2, float f3) {
        if (this.mDrawingRectShape != null) {
            RectF rectF;
            LPPointF lPPointF;
            WhiteboardView whiteboardView = this;
            LPPointF lPPointF2 = lPPointF = whiteboardView.transferToScaledPoint(f2, f3);
            float f4 = lPPointF2.x;
            whiteboardView.mDrawingRectShape.setSelectedEndPoint(f4, lPPointF2.y);
            whiteboardView.shapeList.remove(this.mDrawingRectShape);
            RectF rectF2 = rectF;
            float f5 = Math.min(this.mDrawingRectSourcePoint.x, f2);
            WhiteboardView whiteboardView2 = this;
            float f6 = Math.min(whiteboardView2.mDrawingRectSourcePoint.y, f3);
            f2 = Math.max(whiteboardView2.mDrawingRectSourcePoint.x, f2);
            f3 = Math.max(whiteboardView2.mDrawingRectSourcePoint.y, f3);
            rectF = new RectF(f5, f6, f2, f3);
            if (whiteboardView.multiSelectedBoundaryShape == null) {
                RectBoundaryShape rectBoundaryShape;
                RectBoundaryShape rectBoundaryShape2 = rectBoundaryShape;
                WhiteboardView whiteboardView3 = this;
                Paint paint = whiteboardView3.mSelectedUPRectPaint;
                rectBoundaryShape = new RectBoundaryShape(paint, whiteboardView3.getContext());
                this.multiSelectedBoundaryShape = rectBoundaryShape2;
            }
            WhiteboardView whiteboardView4 = this;
            whiteboardView4.multiSelectedBoundaryShape.setShowPaintOwnerEnable(this.isShowPaintOwnerEnable);
            for (Shape object : whiteboardView4.shapeList) {
                if (object.isBoundaryOverlap(rectF2) && !this.selectedShapes.contains(object) && this.canOperatePaint(object)) {
                    RectBoundaryShape rectBoundaryShape;
                    this.selectedShapes.add(object);
                    if (object instanceof TextShape && (rectBoundaryShape = this.multiSelectedBoundaryShape) != null) {
                        rectBoundaryShape.setScaleEnable(false);
                    }
                    Shape shape = object;
                    Paint bl = this.mSelectedUPRectPaint;
                    f6 = shape.rotateAngle;
                    LPConstants.LPUserType lPUserType = shape.userRole;
                    RectShape rectBoundaryShape3 = (RectShape)ShapeUtils.createShape(LPConstants.ShapeType.Rect, bl, f6, lPUserType);
                    rectBoundaryShape3.setPaint(this.mSelectedUPRectPaint);
                    RectF rectF3 = object.getBoundary();
                    if (rectF3 == null) break;
                    WhiteboardView whiteboardView5 = this;
                    rectBoundaryShape3.setBoundaryRect(rectF3);
                    whiteboardView5.updateMultiSelectBoundary(rectF3);
                    whiteboardView5.boundaryShapeList.add(rectBoundaryShape3);
                    continue;
                }
                int n2 = this.selectedShapes.indexOf(object);
                if (n2 < 0 || rectF2.contains(object.getBoundary()) || object.isBoundaryOverlap(rectF2)) continue;
                WhiteboardView whiteboardView6 = this;
                whiteboardView6.selectedShapes.remove(object);
                whiteboardView6.boundaryShapeList.remove(n2);
                if (whiteboardView6.multiSelectedRectBoundary != null && !this.boundaryShapeList.isEmpty()) {
                    RectBoundaryShape rectBoundaryShape;
                    void var2_14;
                    WhiteboardView whiteboardView7 = this;
                    whiteboardView7.multiSelectedRectBoundary = whiteboardView7.boundaryShapeList.get(0).getBoundary();
                    Iterator<Shape> rectBoundaryShape2 = whiteboardView7.boundaryShapeList.iterator();
                    while (rectBoundaryShape2.hasNext()) {
                        this.updateMultiSelectBoundary(rectBoundaryShape2.next().getBoundary());
                    }
                    boolean iterator = false;
                    Iterator<Shape> iterator2 = this.selectedShapes.iterator();
                    while (iterator2.hasNext()) {
                        if (!(iterator2.next() instanceof TextShape)) continue;
                        RectBoundaryShape rectBoundaryShape3 = this.multiSelectedBoundaryShape;
                        if (rectBoundaryShape3 != null) {
                            rectBoundaryShape3.setScaleEnable(false);
                        }
                        boolean bl = true;
                        break;
                    }
                    if (var2_14 != false || (rectBoundaryShape = this.multiSelectedBoundaryShape) == null) continue;
                    rectBoundaryShape.setScaleEnable(true);
                    continue;
                }
                WhiteboardView whiteboardView8 = this;
                whiteboardView8.multiSelectedBoundaryShape = null;
                whiteboardView8.multiSelectedRectBoundary = null;
            }
            WhiteboardView whiteboardView9 = this;
            whiteboardView9.shapeList.add(this.mDrawingRectShape);
            if (whiteboardView9.multiSelectedRectBoundary != null && this.multiSelectedBoundaryShape != null) {
                if (this.selectedShapes.size() == 1) {
                    WhiteboardView whiteboardView10 = this;
                    whiteboardView10.multiSelectedBoundaryShape.setAngle(this.boundaryShapeList.get((int)0).rotateAngle);
                    whiteboardView10.multiSelectedBoundaryShape.setRotateEnable(this.selectedShapes.get(0) instanceof BitmapShape);
                } else {
                    WhiteboardView whiteboardView11 = this;
                    whiteboardView11.multiSelectedBoundaryShape.setAngle(0.0f);
                    whiteboardView11.multiSelectedBoundaryShape.setRotateEnable(false);
                }
                boolean bl = false;
                Iterator<Shape> iterator = this.selectedShapes.iterator();
                while (iterator.hasNext()) {
                    if (!(iterator.next() instanceof BitmapShape)) continue;
                    bl = true;
                    break;
                }
                WhiteboardView whiteboardView12 = this;
                whiteboardView12.multiSelectedBoundaryShape.setRatioScaleEnable(bl);
                whiteboardView12.multiSelectedBoundaryShape.setBoundaryRect(this.multiSelectedRectBoundary);
                whiteboardView12.invalidate();
            } else if (this.mDrawingRectShape != null) {
                this.invalidate();
            }
            return true;
        }
        return false;
    }

    private boolean moveMultiShapes(float f2, float f3) {
        if (this.isGroupSelected && this.multiSelectedBoundaryShape != null && !this.selectedShapes.isEmpty()) {
            WhiteboardView whiteboardView = this;
            LPPointF lPPointF = whiteboardView.transferToScaledPoint(f2, f3);
            LPPointF lPPointF2 = whiteboardView.transferToScaledPoint(whiteboardView.previousX, this.previousY);
            this.previousX = (int)f2;
            this.previousY = (int)f3;
            if (this.multiSelectedBoundaryShape.getScaleOperatorDir() < 0) {
                Iterator<Shape> iterator = this.selectedShapes.iterator();
                while (iterator.hasNext()) {
                    iterator.next().moveShapeBy(lPPointF.x - lPPointF2.x, lPPointF.y - lPPointF2.y);
                }
                iterator = this.boundaryShapeList.iterator();
                while (iterator.hasNext()) {
                    iterator.next().moveShapeBy(lPPointF.x - lPPointF2.x, lPPointF.y - lPPointF2.y);
                }
                this.multiSelectedBoundaryShape.moveShapeBy(lPPointF.x - lPPointF2.x, lPPointF.y - lPPointF2.y);
            }
            this.invalidate();
            if (System.currentTimeMillis() - this.timestamp > 400L) {
                this.updateMultiShapes();
                this.timestamp = System.currentTimeMillis();
            }
            return true;
        }
        return false;
    }

    private boolean scaleMultiShapes(float f2, float f3) {
        if (this.multiSelectedBoundaryShape != null && !this.selectedShapes.isEmpty() && this.multiSelectedBoundaryShape.isScaleEnable()) {
            LPPointF lPPointF;
            WhiteboardView whiteboardView = this;
            LPPointF lPPointF2 = lPPointF = whiteboardView.transferToScaledPoint(Math.round(f2), Math.round(f3));
            float f4 = lPPointF2.x;
            float[] fArray = whiteboardView.multiSelectedBoundaryShape.getScaleParams(f4, lPPointF2.y);
            this.multiSelectedRectBoundary = null;
            if (fArray != null) {
                for (int i2 = 0; i2 < this.selectedShapes.size(); ++i2) {
                    LPPointF lPPointF3;
                    LPPointF lPPointF4;
                    WhiteboardView whiteboardView2 = this;
                    WhiteboardView whiteboardView3 = this;
                    Object object = whiteboardView3.selectedShapes.get(i2);
                    int n2 = whiteboardView3.multiSelectedBoundaryShape.getScaleOperatorDir();
                    float f5 = fArray[0];
                    float f6 = fArray[1];
                    float f7 = fArray[2];
                    float f8 = fArray[3];
                    RectF rectF = whiteboardView2.multiSelectedBoundaryShape.getBoundary();
                    boolean bl = whiteboardView2.selectedShapes.size() > 1;
                    WhiteboardView whiteboardView4 = this;
                    Shape shape = object;
                    shape.scaleShapeBy(n2, f5, f6, f7, f8, rectF, bl);
                    RectF rectF2 = shape.getBoundary();
                    whiteboardView4.updateMultiSelectBoundary(rectF2);
                    Shape shape2 = whiteboardView4.boundaryShapeList.get(i2);
                    if (whiteboardView4.selectedShapes.size() == 1) {
                        shape2.setAngle(this.multiSelectedBoundaryShape.rotateAngle);
                        object.setAngle(this.multiSelectedBoundaryShape.rotateAngle);
                    }
                    Shape shape3 = shape2;
                    object = lPPointF4;
                    RectF rectF3 = rectF2;
                    f5 = rectF3.left;
                    lPPointF4 = new LPPointF(f5, rectF3.top);
                    shape3.setSourcePoint((LPPointF)((Object)object));
                    object = lPPointF3;
                    RectF rectF4 = rectF2;
                    float f9 = rectF4.right;
                    lPPointF3 = new LPPointF(f9, rectF4.bottom);
                    shape3.appendPoint((LPPointF)((Object)object));
                }
                this.multiSelectedBoundaryShape.setBoundaryRect(this.multiSelectedRectBoundary);
            }
            this.invalidate();
            if (System.currentTimeMillis() - this.timestamp > 400L) {
                this.updateMultiShapes();
                this.timestamp = System.currentTimeMillis();
            }
            return true;
        }
        return false;
    }

    private void moveSingleShape(float f2, float f3) {
        if (this.mMoveShape == null) {
            return;
        }
        Object object = this.mSelectRectBoundaryShape;
        if (object != null && object.getScaleOperatorDir() >= 0) {
            WhiteboardView whiteboardView = this;
            Object object2 = object = whiteboardView.transferToScaledPoint(f2, f3);
            float f4 = ((PointF)object2).x;
            float[] fArray = whiteboardView.mSelectRectBoundaryShape.getScaleParams(f4, ((PointF)object2).y);
            if (fArray != null) {
                WhiteboardView whiteboardView2 = this;
                int n2 = this.mSelectRectBoundaryShape.getScaleOperatorDir();
                float f5 = fArray[0];
                float f6 = fArray[1];
                float f7 = fArray[2];
                float f8 = fArray[3];
                whiteboardView2.mMoveShape.scaleShapeBy(n2, f5, f6, f7, f8, null, false);
                whiteboardView2.mMoveShape.setAngle(this.mSelectRectBoundaryShape.rotateAngle);
            }
        } else {
            object = this.transferToScaledPoint(f2, f3);
            WhiteboardView whiteboardView = this;
            LPPointF lPPointF = whiteboardView.transferToScaledPoint(whiteboardView.previousX, this.previousY);
            float f9 = ((PointF)object).y;
            float f10 = lPPointF.y;
            if (f9 - f10 == 0.0f && ((PointF)object).x - lPPointF.x == 0.0f) {
                return;
            }
            float f11 = ((PointF)object).x - lPPointF.x;
            this.mMoveShape.moveShapeBy(f11, f9 - f10);
        }
        WhiteboardView whiteboardView = this;
        whiteboardView.drawBoundaryRect(whiteboardView.mMoveShape);
        this.previousX = Math.round(f2);
        this.previousY = Math.round(f3);
        this.invalidate();
        if (System.currentTimeMillis() - this.timestamp > 400L) {
            this.updateSingleShape();
            this.timestamp = System.currentTimeMillis();
        }
    }

    private boolean editText(MotionEvent motionEvent) {
        if (motionEvent == null) {
            return true;
        }
        if (motionEvent.getAction() == 0) {
            Matrix matrix = this.getImageMatrix();
            float[] fArray = new float[10];
            matrix.getValues(fArray);
            float f2 = fArray[2];
            float f3 = fArray[5];
            if (this.isEditTextInValid(motionEvent, f2, f3)) {
                return false;
            }
            WhiteboardView whiteboardView = this;
            MotionEvent motionEvent2 = motionEvent;
            WhiteboardView whiteboardView2 = this;
            whiteboardView2.textShape = null;
            int n2 = DisplayUtils.sp2px((Context)whiteboardView2.getContext(), (float)this.mPaintTextSize);
            MotionEvent motionEvent3 = motionEvent;
            float f4 = motionEvent3.getX();
            this.mTextEditSourcePoint = this.transferToScaledPoint(f4, motionEvent3.getY());
            f4 = n2 * 2;
            float f5 = -Math.min(f4 / 2.0f, motionEvent.getX() - f2);
            f2 = Math.min(f5 + f4, (float)this.viewWidth - motionEvent.getX() - f2);
            f4 = n2;
            float f6 = -Math.min(f4 / 2.0f, motionEvent.getY() - f3);
            float f7 = Math.min(f6 + f4, (float)this.viewHeight - motionEvent.getY() - f3);
            whiteboardView2.mTextEditSourcePoint.offset(f5, f6);
            Object object = ShapeUtils.getTextEditPaint();
            LPConstants.LPUserType lPUserType = this.userRole;
            object = ShapeUtils.createShape(LPConstants.ShapeType.Rect, object, 0.0f, lPUserType);
            this.mTextEditBoundary = object;
            object.setSourcePoint(this.mTextEditSourcePoint);
            float f8 = motionEvent2.getX();
            LPPointF lPPointF = whiteboardView.transferToScaledPoint(f8, motionEvent2.getY());
            lPPointF.offset(f2, f7);
            whiteboardView.mTextEditBoundary.appendPoint(lPPointF);
            whiteboardView.invalidate();
        }
        return true;
    }

    private boolean isEditTextInValid(MotionEvent motionEvent, float f2, float f3) {
        return motionEvent.getX() < f2 || motionEvent.getX() > (float)this.getWidth() - f2 || motionEvent.getY() < f3 || motionEvent.getY() > (float)this.getHeight() - f3;
    }

    private boolean editLaserShape(LPMotionEvent lPMotionEvent) {
        if (lPMotionEvent == null) {
            return true;
        }
        if (lPMotionEvent.isActionDown()) {
            if (((WhiteboardView)((Object)shape2)).mLaserShape == null) {
                WhiteboardView whiteboardView = shape2;
                Paint paint = whiteboardView.mShapePaint;
                LPConstants.LPUserType lPUserType = whiteboardView.userRole;
                ((WhiteboardView)((Object)shape2)).mLaserShape = ShapeUtils.createShape(LPConstants.ShapeType.Point, paint, 0.0f, lPUserType);
            }
            LPMotionEvent lPMotionEvent2 = lPMotionEvent;
            float f2 = lPMotionEvent2.getX();
            ((LaserShape)((WhiteboardView)((Object)shape2)).mLaserShape).moveShapeTo(f2, ((WhiteboardView)((Object)shape2)).adjustLaserPosition(lPMotionEvent2.getY()));
            ((WhiteboardView)((Object)shape2)).laserMoveNumber = 0;
        } else if (lPMotionEvent.isActionMove()) {
            LPShapeSendListener lPShapeSendListener;
            Shape shape = ((WhiteboardView)((Object)shape2)).mLaserShape;
            if (shape == null) {
                return false;
            }
            WhiteboardView whiteboardView = shape2;
            LPMotionEvent lPMotionEvent3 = lPMotionEvent;
            float f3 = lPMotionEvent3.getX();
            ((LaserShape)shape).moveShapeTo(f3, ((WhiteboardView)((Object)shape2)).adjustLaserPosition(lPMotionEvent3.getY()));
            ++whiteboardView.laserMoveNumber;
            whiteboardView.invalidate();
            if (whiteboardView.laserMoveNumber % 5 == 0 && (lPShapeSendListener = ((WhiteboardView)((Object)shape2)).lpShapeSendListener) != null) {
                WhiteboardView whiteboardView2 = shape2;
                Shape shape2 = whiteboardView2.mLaserShape;
                lPShapeSendListener.laserShapeUpdate(shape2, whiteboardView2.getWhiteboardViewInfo());
            }
        } else if (lPMotionEvent.isActionUp() || lPMotionEvent.isActionLeave()) {
            Shape shape = ((WhiteboardView)((Object)shape2)).mLaserShape;
            if (shape == null) {
                return false;
            }
            LPMotionEvent lPMotionEvent4 = lPMotionEvent;
            float f4 = lPMotionEvent4.getX();
            ((LaserShape)shape).moveShapeTo(f4, ((WhiteboardView)((Object)shape2)).adjustLaserPosition(lPMotionEvent4.getY()));
            Object object = ((WhiteboardView)((Object)shape2)).lpShapeSendListener;
            if (object != null) {
                LPShapeSendListener lPShapeSendListener = object;
                WhiteboardView whiteboardView = shape2;
                object = whiteboardView.mLaserShape;
                lPShapeSendListener.laserShapeUpdate((Shape)object, whiteboardView.getWhiteboardViewInfo());
            }
            WhiteboardView whiteboardView = shape2;
            whiteboardView.laserMoveNumber = 0;
            ((LaserShape)whiteboardView.mLaserShape).setValid(false);
            whiteboardView.invalidate();
        }
        return true;
    }

    private float adjustLaserPosition(float f2) {
        return f2 - (float)UtilsKt.getDp((int)25);
    }

    private LPPointF transferToScaledPoint(float f2, float f3) {
        WhiteboardView whiteboardView = whiteboardView.getImageMatrix();
        float[] fArray = new float[10];
        whiteboardView.getValues(fArray);
        float f4 = fArray[0];
        float f5 = fArray[4];
        float f6 = fArray[2];
        f6 /= f4;
        float f7 = fArray[5] / f5;
        f4 = f2 / f4 - f6;
        return new LPPointF(f4, f3 / f5 - f7);
    }

    private PointF transferToRawPoint(float f2, float f3) {
        WhiteboardView whiteboardView = whiteboardView.getImageMatrix();
        float[] fArray = new float[10];
        whiteboardView.getValues(fArray);
        float f4 = fArray[0];
        float f5 = fArray[4];
        float f6 = fArray[2];
        float f7 = fArray[5];
        f4 = f2 * f4 + f6;
        return new PointF(f4, f3 * f5 + f7);
    }

    private void drawBoundaryRect(Shape shape) {
        LPPointF lPPointF;
        LPPointF lPPointF2;
        if (object.mSelectRectBoundaryShape == null) {
            RectBoundaryShape rectBoundaryShape;
            RectBoundaryShape rectBoundaryShape2 = rectBoundaryShape;
            WhiteboardView whiteboardView = object;
            Paint paint = whiteboardView.mSelectedUPRectPaint;
            rectBoundaryShape = new RectBoundaryShape(paint, whiteboardView.getContext());
            object.mSelectRectBoundaryShape = rectBoundaryShape2;
        }
        WhiteboardView whiteboardView = object;
        whiteboardView.mSelectRectBoundaryShape.setPaint(object.mSelectedUPRectPaint);
        whiteboardView.mSelectRectBoundaryShape.setShowPaintOwnerEnable(object.isShowPaintOwnerEnable);
        whiteboardView.mSelectRectBoundaryShape.setAngle(shape.rotateAngle);
        whiteboardView.mSelectRectBoundaryShape.setScaleEnable(shape instanceof TextShape ^ true);
        if (shape instanceof BitmapShape) {
            WhiteboardView whiteboardView2 = object;
            whiteboardView2.mSelectRectBoundaryShape.setAngle(shape.rotateAngle);
            whiteboardView2.mSelectRectBoundaryShape.setRotateEnable(true);
            whiteboardView2.mSelectRectBoundaryShape.setRatioScaleEnable(true);
        } else {
            WhiteboardView whiteboardView3 = object;
            whiteboardView3.mSelectRectBoundaryShape.setRotateEnable(false);
            whiteboardView3.mSelectRectBoundaryShape.setRatioScaleEnable(false);
        }
        object.mMoveShape = shape;
        shape = shape.getBoundary();
        if (shape == null) {
            return;
        }
        WhiteboardView whiteboardView4 = object;
        Object object = lPPointF2;
        Shape shape2 = shape;
        float f2 = ((RectF)shape2).left;
        lPPointF2 = new LPPointF(f2, ((RectF)shape2).top);
        whiteboardView4.mSelectRectBoundaryShape.setSourcePoint((LPPointF)((Object)object));
        object = lPPointF;
        Shape shape3 = shape;
        float f3 = ((RectF)shape3).right;
        lPPointF = new LPPointF(f3, ((RectF)shape3).bottom);
        whiteboardView4.mSelectRectBoundaryShape.appendPoint((LPPointF)((Object)object));
    }

    private boolean customShapeDrawing(LPMotionEvent lPMotionEvent) {
        if (this.customShapeType != null && lPMotionEvent != null) {
            if (lPMotionEvent.isActionDown()) {
                Paint paint;
                LPMotionEvent lPMotionEvent2 = lPMotionEvent;
                WhiteboardView whiteboardView = this;
                whiteboardView.resetDottedLine();
                lPMotionEvent = paint;
                paint = new Paint(this.mCustomShapePaint);
                whiteboardView.mCustomShape = ShapeUtils.createShape(whiteboardView.customShapeType, (Paint)lPMotionEvent, 0.0f, this.userRole);
                float f2 = lPMotionEvent2.getX();
                LPPointF lPPointF = this.transferToScaledPoint(f2, lPMotionEvent2.getY());
                this.mCustomShape.setSourcePoint(lPPointF);
                this.lastCustomShapePoint = lPPointF;
                this.customShapeDownPoint = lPPointF;
                this.shouldDrawCustomShape = false;
            } else if (lPMotionEvent.isActionMove()) {
                if (this.mCustomShape == null) {
                    return false;
                }
                WhiteboardView whiteboardView = this;
                LPMotionEvent lPMotionEvent3 = lPMotionEvent;
                float f3 = lPMotionEvent3.getX();
                LPPointF lPPointF = whiteboardView.transferToScaledPoint(f3, lPMotionEvent3.getY());
                if (!whiteboardView.shouldDrawCustomShape) {
                    boolean bl = (float)Math.sqrt(Math.pow(Math.abs(lPPointF.x - this.customShapeDownPoint.x), 2.0) + Math.pow(Math.abs(lPPointF.y - this.customShapeDownPoint.y), 2.0)) > 10.0f;
                    this.shouldDrawCustomShape = bl;
                }
                if (this.shouldDrawCustomShape) {
                    this.mCustomShape.appendPoint(lPPointF);
                }
                if ((float)Math.sqrt(Math.pow(Math.abs(lPPointF.x - this.lastCustomShapePoint.x), 2.0) + Math.pow(Math.abs(lPPointF.y - this.lastCustomShapePoint.y), 2.0)) > 1.0f) {
                    this.invalidate();
                }
                this.lastCustomShapePoint = lPPointF;
            } else if (lPMotionEvent.isActionLeave() || lPMotionEvent.isActionUp()) {
                if (this.mCustomShape == null) {
                    return false;
                }
                WhiteboardView whiteboardView = this;
                int n2 = whiteboardView.mDashType;
                LPConstants.ShapeType shapeType = whiteboardView.shapeType;
                if (shapeType == LPConstants.ShapeType.Arrow || shapeType == LPConstants.ShapeType.DoubleArrow || shapeType == LPConstants.ShapeType.RectSolid || shapeType == LPConstants.ShapeType.OvalSolid || shapeType == LPConstants.ShapeType.TriangleSolid) {
                    n2 = 0;
                }
                WhiteboardView whiteboardView2 = this;
                LPMotionEvent lPMotionEvent4 = lPMotionEvent;
                this.resetDottedLine();
                float f4 = lPMotionEvent4.getX();
                Object object = whiteboardView2.transferToScaledPoint(f4, lPMotionEvent4.getY());
                if (whiteboardView2.shouldDrawCustomShape) {
                    WhiteboardView whiteboardView3 = this;
                    whiteboardView3.mCustomShape.appendPoint((LPPointF)((Object)object));
                    object = whiteboardView3.mCustomShape;
                    whiteboardView3.mCustomShape.dashType = n2;
                    whiteboardView3.shapeList.add((Shape)object);
                    whiteboardView3.mCustomShape.hasAddedToPaintList = true;
                    if (whiteboardView3.lpShapeSendListener != null) {
                        WhiteboardView whiteboardView4 = this;
                        object = whiteboardView4.getWhiteboardViewInfo();
                        whiteboardView4.getWhiteboardViewInfo().dashType = n2;
                        whiteboardView4.lpShapeSendListener.sendShape(this.mCustomShape, (LPWhiteboardViewInfo)object);
                    }
                }
            }
            return true;
        }
        return true;
    }

    private void resetDottedLine() {
        LPConstants.ShapeType shapeType = this.shapeType;
        if (shapeType != LPConstants.ShapeType.Arrow && shapeType != LPConstants.ShapeType.DoubleArrow && shapeType != LPConstants.ShapeType.RectSolid && shapeType != LPConstants.ShapeType.OvalSolid && shapeType != LPConstants.ShapeType.TriangleSolid) {
            if (this.mDashType == 1) {
                this.mCustomShapePaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{10.0f, 10.0f}, 0.0f));
            }
        } else {
            this.mCustomShapePaint.setPathEffect(null);
        }
    }

    private void changeDocExtraModel() {
        WhiteboardView whiteboardView = this;
        LPDocExtraModel lPDocExtraModel = whiteboardView.extraModelMap.get(this.docId);
        Object object = whiteboardView.docList.iterator();
        while (object.hasNext()) {
            LPDocModel lPDocModel = object.next();
            if (!this.docId.equals(lPDocModel.docId)) continue;
            if (lPDocExtraModel == null) {
                lPDocExtraModel = lPDocModel.docExtraModel;
                if (lPDocExtraModel != null) {
                    this.extraModelMap.put(this.docId, lPDocExtraModel);
                } else {
                    this.extraModelMap.put(this.docId, LPDocExtraModel.getDefaultModel());
                }
            }
            if (this.liveRoom.getRoomInfo().roomType != LPConstants.LPRoomType.NewSmallGroup) {
                lPDocExtraModel = this.extraModelMap.get(this.lastDocId);
                object = this.extraModelMap.get(this.docId);
                if (lPDocExtraModel != null && object != null) {
                    boolean bl = TextUtils.equals((CharSequence)lPDocExtraModel.scale, (CharSequence)((LPDocExtraModel)((Object)object)).scale) ^ true;
                    boolean bl2 = this.liveRoom.getCurrentUser().getType() == LPConstants.LPUserType.Teacher || this.liveRoom.getCurrentUser().getType() == LPConstants.LPUserType.Assistant;
                    if (bl2 && bl) {
                        ((LPDocExtraModel)((Object)object)).scale = lPDocExtraModel.scale;
                        this.sendDocUpdateSignal();
                    }
                }
            }
            if ((lPDocExtraModel = this.extraModelMap.get(this.docId)) == null) break;
            lPDocExtraModel.docId = this.docId;
            break;
        }
    }

    private void setWhiteBoardBg() {
        int n2;
        if (!whiteboardView2.isAnimPPT) {
            return;
        }
        int n3 = whiteboardView2.currentWidth;
        if (n3 > 0 && (n2 = whiteboardView2.currentHeight) > 0) {
            WhiteboardView whiteboardView = whiteboardView2;
            WhiteboardView whiteboardView2 = Bitmap.createBitmap((int)n3, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            new Canvas((Bitmap)whiteboardView2).drawARGB(0, 0, 0, 0);
            whiteboardView.setImageBitmap((Bitmap)whiteboardView2);
            return;
        }
    }

    private boolean onAnimTouchEvent(MotionEvent motionEvent) {
        if (this.mFlipEnable && !this.isAnimPPTPageChange.get()) {
            if (motionEvent.getAction() == 0) {
                this.rawX = motionEvent.getRawX();
            } else if (motionEvent.getAction() == 2) {
                this.onAnimTouchMove(motionEvent.getRawX() - this.rawX);
            } else if (motionEvent.getAction() == 1) {
                this.onAnimTouchEnd(motionEvent.getRawX() - this.rawX);
            }
            if (!this.h5WebViewConsumeEvent && !this.animPPTConsumeEvent) {
                return true;
            }
            return super.onTouchEvent(motionEvent);
        }
        return true;
    }

    private void onAnimTouchMove(float f2) {
        float f3 = Math.abs(f2);
        float f4 = f3 - 300.0f;
        float f5 = f4 == 0.0f ? 0 : (f4 > 0.0f ? 1 : -1);
        if (f5 > 0) {
            if (!((WhiteboardView)this).isVibrated) {
                ((WhiteboardView)this).isVibrated = true;
                LPVibratorUtil.Vibrate(this.getContext(), 50L);
            }
        } else {
            ((WhiteboardView)this).isVibrated = false;
        }
        if (((WhiteboardView)this).isAnimPPT) {
            if (f2 > 0.0f) {
                Object object = this;
                ViewParent viewParent = object.getParent();
                boolean bl = ((WhiteboardView)object).hasPrevPage || ((WhiteboardView)this).hasPrevStep;
                viewParent.requestDisallowInterceptTouchEvent(bl);
            } else {
                Object object = this;
                ViewParent viewParent = object.getParent();
                boolean bl = ((WhiteboardView)object).hasNextPage || ((WhiteboardView)this).hasNextStep;
                viewParent.requestDisallowInterceptTouchEvent(bl);
            }
        }
        if ((this = ((WhiteboardView)this).onBoardTouchListener) != null) {
            if (f5 > 0) {
                boolean bl = f2 > 0.0f;
                this.onBoardTouch(bl, 200);
            } else if (f3 > 100.0f) {
                boolean bl = f2 > 0.0f;
                this.onBoardTouch(bl, (int)(f3 / 4.0f));
            } else {
                boolean bl = f2 > 0.0f;
                this.onBoardTouch(bl, 0);
            }
        }
    }

    private void onAnimTouchEnd(float f2) {
        this.isVibrated = false;
        OnBoardTouchListener onBoardTouchListener = this.onBoardTouchListener;
        if (onBoardTouchListener != null) {
            onBoardTouchListener.onTouchEnd();
        }
        if (f2 > 300.0f) {
            if (this.hasPrevStep) {
                this.lpAnimPPTRouterListener.prevStep();
            } else {
                this.gotoPrevPage();
            }
        } else if (f2 < -300.0f) {
            WhiteboardView whiteboardView = this;
            int n2 = whiteboardView.getCurrentIndex();
            if (whiteboardView.useRelativePage) {
                n2 = this.docListViewModel.a(this.docId, n2);
            }
            if (this.hasNextStep) {
                this.lpAnimPPTRouterListener.nextStep();
            } else if (n2 < this.maxPage) {
                this.gotoNextPage();
            }
        }
    }

    private void generateDocUpdateModel() {
        DecimalFormat decimalFormat;
        if (((WhiteboardView)((Object)string3)).isPreviewDoc) {
            return;
        }
        WhiteboardView whiteboardView = string3;
        float f2 = whiteboardView.getValue(whiteboardView.getImageMatrix(), 2);
        WhiteboardView whiteboardView2 = string3;
        f2 /= (float)((WhiteboardView)((Object)string3)).currentWidth * whiteboardView2.getValue(whiteboardView2.getImageMatrix(), 0);
        WhiteboardView whiteboardView3 = string3;
        float f3 = whiteboardView.getValue(whiteboardView.getImageMatrix(), 5) / ((float)((WhiteboardView)((Object)string3)).currentHeight * whiteboardView3.getValue(whiteboardView3.getImageMatrix(), 4));
        DecimalFormat decimalFormat2 = decimalFormat;
        decimalFormat = new DecimalFormat("0.0000");
        LPDocExtraModel lPDocExtraModel = whiteboardView.extraModelMap.get(((WhiteboardView)((Object)string3)).docId);
        if (lPDocExtraModel == null && !((WhiteboardView)((Object)string3)).isAnimPPT) {
            String string2;
            lPDocExtraModel = LPDocExtraModel.getDefaultModel();
            LPDocExtraModel.getDefaultModel().docId = string2 = ((WhiteboardView)((Object)string3)).docId;
            ((WhiteboardView)((Object)string3)).extraModelMap.put(string2, lPDocExtraModel);
        }
        if (lPDocExtraModel == null) {
            return;
        }
        LPDocExtraModel lPDocExtraModel2 = lPDocExtraModel;
        lPDocExtraModel.scrollLeft = decimalFormat2.format(Math.abs(f2));
        lPDocExtraModel2.scrollTop = decimalFormat2.format(Math.abs(f3));
        String string3 = new DecimalFormat("0.00").format(Math.abs(string3.getScale()));
        lPDocExtraModel2.scale = string3;
        if ("1.00".equals(string3)) {
            LPDocExtraModel lPDocExtraModel3 = lPDocExtraModel;
            lPDocExtraModel3.scrollLeft = "0";
            lPDocExtraModel3.scrollTop = "0";
        }
        lPDocExtraModel.fitWay = 1;
    }

    private void sendDocUpdateSignal() {
        Object object;
        LPResRoomDocUpdateModel lPResRoomDocUpdateModel;
        if (this.isPreviewDoc) {
            return;
        }
        LPResRoomDocUpdateModel lPResRoomDocUpdateModel2 = lPResRoomDocUpdateModel;
        lPResRoomDocUpdateModel2();
        lPResRoomDocUpdateModel.docId = object = this.docId;
        object = this.extraModelMap.get(object);
        if (object == null) {
            return;
        }
        ((LPDocExtraModel)((Object)object)).page = this.page;
        Object object2 = this.pageChangeEndModel;
        if (object2 != null) {
            ((LPDocExtraModel)((Object)object)).step = object2.step;
        }
        WhiteboardView whiteboardView = this;
        lPResRoomDocUpdateModel2.docUpdateExtraModel = object;
        object2 = whiteboardView.syncExtraModel;
        ((LPDocExtraModel)((Object)object2)).scale = ((LPDocExtraModel)((Object)object)).scale;
        ((LPDocExtraModel)((Object)object2)).scrollTop = ((LPDocExtraModel)((Object)object)).scrollTop;
        whiteboardView.syncExtraModel.scrollLeft = ((LPDocExtraModel)((Object)object)).scrollLeft;
        if (whiteboardView.liveRoom.getCurrentUser().getType() == LPConstants.LPUserType.Teacher || this.liveRoom.getCurrentUser().getType() == LPConstants.LPUserType.Assistant) {
            this.liveRoom.getDocListVM().requestDocUpdate(lPResRoomDocUpdateModel2);
        }
    }

    private LPWhiteboardViewInfo getWhiteboardViewInfo() {
        LPWhiteboardViewInfo lPWhiteboardViewInfo;
        LPWhiteboardViewInfo lPWhiteboardViewInfo2 = lPWhiteboardViewInfo;
        WhiteboardView whiteboardView = this;
        int n2 = whiteboardView.getCurrentWidth();
        int n3 = whiteboardView.getCurrentHeight();
        int n4 = whiteboardView.getOffsetWidth();
        int n5 = whiteboardView.getOffsetHeight();
        lPWhiteboardViewInfo2(n2, n3, n4, n5);
        lPWhiteboardViewInfo2.docId = this.docId;
        lPWhiteboardViewInfo2.pageIndexOfDocList = this.getCurrentIndex();
        lPWhiteboardViewInfo2.pageOfCurrentDoc = this.getPage();
        lPWhiteboardViewInfo.useRelativePage = this.useRelativePage;
        return lPWhiteboardViewInfo;
    }

    private LPDocModel getNextPage(String string2, int n2) {
        ArrayList<LPDocModel> arrayList;
        ArrayList<LPDocModel> arrayList2 = arrayList;
        arrayList = new ArrayList<LPDocModel>(this.liveRoom.getDocListVM().getDocList());
        int n3 = 0;
        while (n3 < arrayList2.size()) {
            LPDocModel lPDocModel = (LPDocModel)((Object)arrayList2.get(n3));
            if (string2.equals(lPDocModel.docId)) {
                if (lPDocModel.index == n2) {
                    if (n3 < arrayList2.size() - 1) {
                        return (LPDocModel)((Object)arrayList2.get(n3 + 1));
                    }
                    return null;
                }
                ++n3;
                continue;
            }
            n3 += Math.max(1, lPDocModel.totalPage);
        }
        return null;
    }

    private LPDocModel getPrePage(String string2, int n2) {
        ArrayList<LPDocModel> arrayList;
        ArrayList<LPDocModel> arrayList2 = arrayList;
        int n3 = new ArrayList<LPDocModel>(this.liveRoom.getDocListVM().getDocList()).size() - 1;
        while (n3 >= 0) {
            LPDocModel lPDocModel = (LPDocModel)((Object)arrayList2.get(n3));
            if (string2.equals(lPDocModel.docId)) {
                if (lPDocModel.index == n2) {
                    if (n3 > 0) {
                        return (LPDocModel)((Object)arrayList2.get(n3 - 1));
                    }
                    return null;
                }
                --n3;
                continue;
            }
            n3 -= Math.max(1, lPDocModel.totalPage);
        }
        return null;
    }

    private float getSpeedBetweenPoints(LPPointF lPPointF, LPPointF lPPointF2) {
        return (float)Math.sqrt(Math.pow(Math.abs(lPPointF2.x - lPPointF.x), 2.0) + Math.pow(Math.abs(lPPointF2.y - lPPointF.y), 2.0)) / (float)(lPPointF2.timestamp - lPPointF.timestamp);
    }

    private void switchCursorShapeDrawable(Shape shape) {
        int n2 = shape.mPaint.getColor();
        if (Color.alpha((int)n2) < 255) {
            VectorDrawableCompat vectorDrawableCompat;
            this.shapeCursorVectorDrawable = vectorDrawableCompat = this.markerShapeVectorDrawable;
            vectorDrawableCompat.setTint(this.getColorWithOutAlpha(n2));
        } else {
            this.shapeCursorVectorDrawable = this.brushCursorVectorDrawable;
            this.shapeCursorVectorDrawable.setTint(n2);
        }
    }

    private int getColorWithOutAlpha(int n2) {
        if (Color.alpha((int)n2) < 255) {
            int n3 = n2;
            int n4 = Color.red((int)n3);
            n2 = Color.green((int)n3);
            int n5 = Color.blue((int)n3);
            return Color.argb((int)255, (int)n4, (int)n2, (int)n5);
        }
        return n2;
    }

    public static /* synthetic */ Shape access$502(WhiteboardView whiteboardView, Shape shape) {
        whiteboardView.textShape = shape;
        return shape;
    }

    public static /* synthetic */ LPPointF access$602(WhiteboardView whiteboardView, LPPointF lPPointF) {
        whiteboardView.mTextEditSourcePoint = lPPointF;
        return lPPointF;
    }

    public static /* synthetic */ Shape access$702(WhiteboardView whiteboardView, Shape shape) {
        whiteboardView.mTextEditBoundary = shape;
        return shape;
    }

    public static /* synthetic */ RectBoundaryShape access$902(WhiteboardView whiteboardView, RectBoundaryShape rectBoundaryShape) {
        whiteboardView.mSelectRectBoundaryShape = rectBoundaryShape;
        return rectBoundaryShape;
    }

    public static /* synthetic */ boolean access$1602(WhiteboardView whiteboardView, boolean bl) {
        whiteboardView.isVibrated = bl;
        return bl;
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public void onSizeChanged(int n2, int n3, int n4, int n5) {
        LPAnimPPTRouterListener lPAnimPPTRouterListener;
        WhiteboardView whiteboardView = onWindowSizeListener;
        super.onSizeChanged(n2, n3, n4, n5);
        if (whiteboardView.isAnimPPT && (lPAnimPPTRouterListener = ((WhiteboardView)((Object)onWindowSizeListener)).lpAnimPPTRouterListener) != null) {
            lPAnimPPTRouterListener.sizeChange();
        }
        if (n5 <= n3 && n4 <= n2 && n5 > 0 && n4 > 0) {
            WhiteboardView whiteboardView2 = onWindowSizeListener;
            super.isDoubleTapScaleEnable(true);
            OnWindowSizeListener onWindowSizeListener = whiteboardView2.onWindowSizeListener;
            if (onWindowSizeListener != null) {
                onWindowSizeListener.onDoubleTapEnableChange(true);
            }
        }
    }

    public void onLayout(boolean n2, int n3, int n4, int n5, int n6) {
        super.onLayout(n2 != 0, n3, n4, n5, n6);
        n2 = n5 - n3;
        n3 = n6 - n4;
        if (n2 > 0 && n3 > 0 && ((WhiteboardView)((Object)onDocUpdateListener)).viewWidth != n2 && ((WhiteboardView)((Object)onDocUpdateListener)).viewHeight != n3) {
            ((WhiteboardView)((Object)onDocUpdateListener)).viewHeight = n3;
            ((WhiteboardView)((Object)onDocUpdateListener)).viewWidth = n2;
            Map<String, LPDocExtraModel> map = ((WhiteboardView)((Object)onDocUpdateListener)).extraModelMap;
            Object object = map.get(map);
            if (object != null) {
                LPDocExtraModel lPDocExtraModel = object;
                float f2 = -LPDocExtraModel.getFloatValue(lPDocExtraModel.scrollLeft, 0.0f);
                WhiteboardView whiteboardView = onDocUpdateListener;
                WhiteboardView whiteboardView2 = onDocUpdateListener;
                n4 = (int)((float)whiteboardView.currentWidth * whiteboardView2.getValue(whiteboardView2.getImageMatrix(), 0));
                WhiteboardView whiteboardView3 = onDocUpdateListener;
                n5 = (int)((float)whiteboardView.currentHeight * whiteboardView3.getValue(whiteboardView3.getImageMatrix(), 4));
                float f3 = f2;
                f2 = n4;
                float f4 = Math.round(f3 * f2);
                float f5 = n5;
                float f6 = Math.round(-LPDocExtraModel.getFloatValue(lPDocExtraModel.scrollTop, 0.0f) * f5);
                boolean bl = false;
                float f7 = Math.min(Math.max(LPDocExtraModel.getFloatValue(object.scale, 1.0f), 1.0f), 3.0f) - 1.0f;
                float f8 = f7 == 0.0f ? 0 : (f7 > 0.0f ? 1 : -1);
                if (f8 > 0 && Math.abs(f4) > (float)Math.abs(n4 - ((WhiteboardView)((Object)onDocUpdateListener)).viewWidth)) {
                    f4 = -Math.abs(n4 - ((WhiteboardView)((Object)onDocUpdateListener)).viewWidth);
                    bl = true;
                }
                if (f8 > 0 && Math.abs(f6) > (float)Math.abs(n5 - ((WhiteboardView)((Object)onDocUpdateListener)).viewHeight)) {
                    f6 = -Math.abs(n5 - ((WhiteboardView)((Object)onDocUpdateListener)).viewHeight);
                    bl = true;
                }
                if (bl) {
                    WhiteboardView whiteboardView4 = onDocUpdateListener;
                    object.scrollLeft = String.valueOf(Math.abs(f4) / f2);
                    object.scrollTop = String.valueOf(Math.abs(f6) / f5);
                    whiteboardView4.syncZoomAndScroll();
                    object = whiteboardView4.onDocUpdateListener;
                    if (object != null) {
                        object.onDocUpdate();
                    }
                    super.sendDocUpdateSignal();
                } else {
                    WhiteboardView whiteboardView5 = onDocUpdateListener;
                    whiteboardView5.syncZoomAndScroll();
                    Whiteboard.OnDocUpdateListener onDocUpdateListener = whiteboardView5.onDocUpdateListener;
                    if (onDocUpdateListener != null) {
                        onDocUpdateListener.onDocUpdate();
                    }
                }
            }
        }
    }

    public void setShapeColor(int n2) {
        WhiteboardView whiteboardView = this;
        whiteboardView.mShapePaint.setColor(n2);
        whiteboardView.mCustomShapePaint.setColor(n2);
        if (whiteboardView.shapeType == LPConstants.ShapeType.MarkerDoodle) {
            Paint paint = this.mShapePaint;
            paint.setAlpha((int)((double)paint.getAlpha() * 0.3));
        }
    }

    public void setCustomShapeStrokeWidth(float f2) {
        if (f2 == 0.0f) {
            WhiteboardView whiteboardView = this;
            whiteboardView.mDashType = 1;
            whiteboardView.mCustomShapePaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{10.0f, 10.0f}, 0.0f));
            whiteboardView.mCustomShapePaint.setStrokeWidth(2.0f);
        } else {
            WhiteboardView whiteboardView = this;
            whiteboardView.mDashType = 0;
            whiteboardView.mCustomShapePaint.setPathEffect(null);
            whiteboardView.mCustomShapePaint.setStrokeWidth(f2);
        }
    }

    @Override
    public void setPPTEditMode(LPConstants.PPTEditMode pPTEditMode) {
        Object object = this.getAttacher();
        boolean bl = pPTEditMode != LPConstants.PPTEditMode.Normal && pPTEditMode != LPConstants.PPTEditMode.PPTTouchMode;
        object.setShapeTouchable(bl);
        if (pPTEditMode != LPConstants.PPTEditMode.SelectMode) {
            WhiteboardView whiteboardView = this;
            whiteboardView.clearBoard();
            object = whiteboardView.onShapeSelectedListener;
            if (object != null) {
                object.onShapeSelected(false);
            }
        }
        if (pPTEditMode == LPConstants.PPTEditMode.PPTTouchMode) {
            WhiteboardView whiteboardView = this;
            whiteboardView.animPPTConsumeEvent = true;
            whiteboardView.pptEditMode = LPConstants.PPTEditMode.Normal;
        } else {
            WhiteboardView whiteboardView = this;
            whiteboardView.animPPTConsumeEvent = false;
            whiteboardView.pptEditMode = pPTEditMode;
        }
        boolean bl2 = this.zoomEnable && pPTEditMode == LPConstants.PPTEditMode.Normal;
        super.setZoomable(bl2);
    }

    @Override
    public void setZoomable(boolean bl) {
        super.setZoomable(bl);
        this.zoomEnable = bl;
    }

    public void setShapeStrokeWidth(float f2) {
        this.mShapePaint.setStrokeWidth(f2);
    }

    public void setDrawingRectShapePaintColor(@ColorInt int n2) {
        this.mDrawingRectShapePaintColor = n2;
        ShapeUtils.setSelectedRectPaintColor(n2);
    }

    public void setShapeSendListener(LPShapeSendListener lPShapeSendListener) {
        if (this.isPreviewDoc) {
            return;
        }
        this.lpShapeSendListener = lPShapeSendListener;
    }

    public void setOnBoardTouchListener(OnBoardTouchListener onBoardTouchListener) {
        this.onBoardTouchListener = onBoardTouchListener;
    }

    public void setOnPageSelectedListener(Whiteboard.OnPageSelectedListener onPageSelectedListener) {
        this.onPageSelectedListener = onPageSelectedListener;
    }

    public void setOnDocUpdateListener(Whiteboard.OnDocUpdateListener onDocUpdateListener) {
        this.onDocUpdateListener = onDocUpdateListener;
    }

    public void setOnScaleChangedListener(OnScaleChangedListener onScaleChangedListener) {
        super.setOnScaleChangeListener(onScaleChangedListener);
    }

    public void setOnBitmapShapeListener(PPTView.OnBitmapShapeListener onBitmapShapeListener) {
        this.onBitmapShapeListener = onBitmapShapeListener;
    }

    public void touchEnd() {
        Object object = this.mDrawingShape;
        if (object == null) {
            return;
        }
        if (this.isPreviewDoc) {
            int n2 = this.mPreviewShapeId;
            this.mPreviewShapeId = n2 + 1;
            ((Shape)object).id = String.valueOf(n2);
        }
        WhiteboardView whiteboardView = this;
        whiteboardView.shapeList.add(this.mDrawingShape);
        ((AbstractMap)whiteboardView.appendingShapeMap).remove(this.mDrawingShape.number);
        whiteboardView.doSendShapeAppend(true);
        if (whiteboardView.lpShapeSendListener != null) {
            WhiteboardView whiteboardView2 = this;
            object = whiteboardView2.getWhiteboardViewInfo();
            int n3 = whiteboardView2.shapeAppendIndex > 0 ? 1 : 0;
            Object object2 = object;
            ((LPWhiteboardViewInfo)object2).hasAppend = n3;
            ((LPWhiteboardViewInfo)object2).dashType = 0;
            this.lpShapeSendListener.sendShape(this.mDrawingShape, (LPWhiteboardViewInfo)object);
            this.mDrawingShape = null;
        }
        WhiteboardView whiteboardView3 = this;
        whiteboardView3.mActivePointerId = -1;
        whiteboardView3.shapeAppendIndex = 0;
    }

    public void touchHover(LPMotionEvent object) {
        if (this.hoverMouseShape == null) {
            WhiteboardView whiteboardView = this;
            Object object2 = whiteboardView.mShapePaint;
            LPConstants.LPUserType lPUserType = whiteboardView.userRole;
            object2 = ShapeUtils.createShape(LPConstants.ShapeType.Point, object2, 0.0f, lPUserType);
            this.hoverMouseShape = object2;
            object2.mPaint.setColor(this.mShapePaint.getColor());
            object2 = this.pptEditMode;
            if (object2 == LPConstants.PPTEditMode.ShapeMode) {
                object2 = this.shapeType;
                if (object2 != LPConstants.ShapeType.Doodle && object2 != LPConstants.ShapeType.MarkerDoodle) {
                    if (object2 == LPConstants.ShapeType.Arrow) {
                        ((LaserShape)this.hoverMouseShape).setCursorVectorDrawable(this.arrowShapeVectorDrawable);
                    }
                } else if (object2 == LPConstants.ShapeType.MarkerDoodle) {
                    WhiteboardView whiteboardView2 = this;
                    WhiteboardView whiteboardView3 = this;
                    whiteboardView2.markerShapeVectorDrawable.setTint(whiteboardView3.getColorWithOutAlpha(whiteboardView3.mShapePaint.getColor()));
                    ((LaserShape)whiteboardView2.hoverMouseShape).setCursorVectorDrawable(this.markerShapeVectorDrawable);
                } else {
                    WhiteboardView whiteboardView4 = this;
                    whiteboardView4.brushCursorVectorDrawable.setTint(this.mShapePaint.getColor());
                    ((LaserShape)whiteboardView4.hoverMouseShape).setCursorVectorDrawable(this.brushCursorVectorDrawable);
                }
            } else if (object2 == LPConstants.PPTEditMode.EraserMode) {
                ((LaserShape)this.hoverMouseShape).setCursorVectorDrawable(this.eraserShapeVectorDrawable);
            }
        }
        LPMotionEvent lPMotionEvent = object;
        int n2 = lPMotionEvent.getActionIndex();
        float f2 = lPMotionEvent.getX(n2);
        LPPointF lPPointF = this.drawingInBound(f2, lPMotionEvent.getY(n2));
        if (lPPointF != null) {
            this.hoverMouseShape.setSourcePoint(lPPointF);
            if (((LPMotionEvent)object).isActionHover() && ((object = this.shapeType) == LPConstants.ShapeType.Doodle || object == LPConstants.ShapeType.MarkerDoodle)) {
                WhiteboardView whiteboardView = this;
                object = whiteboardView.hoverMouseShape;
                whiteboardView.hoverMouseShape.isHoverTrace = true;
                whiteboardView.lpShapeSendListener.laserShapeUpdate((Shape)object, this.getWhiteboardViewInfo());
            }
        }
    }

    public void touchLeave() {
        this.hoverMouseShape = null;
    }

    public void setIdentity(String string2, int n2, int n3) {
        WhiteboardView whiteboardView = this;
        whiteboardView.docId = string2;
        whiteboardView.page = n2;
        whiteboardView.pageId = n3;
    }

    @Override
    public String getDocId() {
        return this.docId;
    }

    @Override
    public int getPage() {
        if ("0".equals(this.docId)) {
            return this.pageId;
        }
        return this.page;
    }

    @Override
    public boolean isShapeListEmpty() {
        return this.shapeList.isEmpty();
    }

    @Override
    public void resetDisplayRec(int n2, int n3) {
        boolean bl = false;
        ConcurrentLinkedQueue<LPShapeModel> concurrentLinkedQueue = this.shapeModelList;
        if (concurrentLinkedQueue != null && !concurrentLinkedQueue.isEmpty()) {
            ArrayList<Shape> arrayList;
            ArrayList<Shape> arrayList2 = arrayList;
            arrayList = new ArrayList<Shape>();
            concurrentLinkedQueue = this.shapeModelList.iterator();
            while (concurrentLinkedQueue.hasNext()) {
                Shape shape = LPShapeConverter.getShapeFromModel((LPShapeModel)((Object)concurrentLinkedQueue.next()), n2, n3, 0, 0);
                if (shape == null) continue;
                arrayList2.add(shape);
            }
            WhiteboardView whiteboardView = this;
            whiteboardView.shapeList.addAll(arrayList2);
            whiteboardView.shapeModelList.clear();
            bl = true;
        }
        if (!this.appendedShapeModelList.isEmpty()) {
            for (LPShapeModel lPShapeModel : this.appendedShapeModelList) {
                concurrentLinkedQueue = (DoodleShape)LPShapeConverter.getShapeFromModel(lPShapeModel, n2, n3, 0, 0);
                this.handleShapeAppend((DoodleShape)((Object)concurrentLinkedQueue), lPShapeModel.smooth);
            }
            this.appendedShapeModelList.clear();
            bl = true;
        }
        if (bl) {
            this.invalidate();
        }
    }

    public void onDraw(Canvas canvas) {
        if (whiteboardView3.getDrawable() instanceof BitmapDrawable && ((BitmapDrawable)whiteboardView3.getDrawable()).getBitmap() != null && ((BitmapDrawable)whiteboardView3.getDrawable()).getBitmap().isRecycled()) {
            return;
        }
        WhiteboardView whiteboardView = whiteboardView3;
        super.onDraw(canvas);
        whiteboardView.drawAllShapes(canvas);
        whiteboardView.drawingMySelfDrawingShape(canvas);
        whiteboardView.drawAppendingShape(canvas);
        whiteboardView.drawCustomShape(canvas);
        whiteboardView.drawingBoundaryShape(canvas);
        Shape shape = whiteboardView.hoverMouseShape;
        if (shape != null) {
            WhiteboardView whiteboardView2 = whiteboardView3;
            WhiteboardView whiteboardView3 = whiteboardView2.getImageMatrix();
            shape.onDraw(canvas, (Matrix)whiteboardView3, whiteboardView2.getRegionInfo(whiteboardView2.hoverMouseShape));
        }
    }

    @Override
    public String eraseShapes() {
        StringBuilder stringBuilder;
        Object object = this.mMoveShape;
        if (object != null) {
            this.mSelectRectBoundaryShape = null;
            return ((Shape)object).id;
        }
        if (this.selectedShapes.isEmpty()) {
            return "";
        }
        object = stringBuilder;
        stringBuilder = new StringBuilder();
        Iterator<Shape> iterator = this.selectedShapes.iterator();
        while (iterator.hasNext()) {
            Object object2 = object;
            ((StringBuilder)object2).append(iterator.next().id);
            ((StringBuilder)object2).append(",");
        }
        WhiteboardView whiteboardView = this;
        whiteboardView.selectedShapes.clear();
        whiteboardView.multiSelectedRectBoundary = null;
        whiteboardView.multiSelectedBoundaryShape = null;
        whiteboardView.boundaryShapeList.clear();
        return ((StringBuilder)object).toString();
    }

    @Override
    public String eraseFilterShapes(LPConstants.LPUserType ... lPUserTypeArray) {
        StringBuilder stringBuilder;
        Object object = this.mMoveShape;
        if (object != null) {
            if (this.isInFilterRoles(((Shape)object).userRole, lPUserTypeArray)) {
                return "";
            }
            this.mSelectRectBoundaryShape = null;
            return this.mMoveShape.id;
        }
        if (this.selectedShapes.isEmpty()) {
            return "";
        }
        object = stringBuilder;
        stringBuilder = new StringBuilder();
        Iterator<Shape> iterator = this.selectedShapes.iterator();
        while (iterator.hasNext()) {
            Shape shape = iterator.next();
            if (this.isInFilterRoles(shape.userRole, lPUserTypeArray)) continue;
            Object object2 = object;
            ((StringBuilder)object2).append(shape.id);
            ((StringBuilder)object2).append(",");
            iterator.remove();
        }
        this.multiSelectedRectBoundary = null;
        this.multiSelectedBoundaryShape = null;
        this.boundaryShapeList.clear();
        return ((StringBuilder)object).toString();
    }

    @Override
    public void onShapeAll(List<Shape> list) {
        WhiteboardView whiteboardView = this;
        whiteboardView.mCustomShape = null;
        whiteboardView.shapeList.clear();
        whiteboardView.shapeList.addAll(list);
        whiteboardView.invalidate();
    }

    @Override
    public void onShapeAdd(Shape shape) {
        String string2;
        if (shape != null && (string2 = shape.number) != null) {
            Shape shape2 = this.mCustomShape;
            if (shape2 != null && string2.equals(shape2.number)) {
                this.mCustomShape = null;
            }
            WhiteboardView whiteboardView = this;
            whiteboardView.handleEndShape(shape);
            whiteboardView.invalidate();
            return;
        }
    }

    @Override
    public void onShapeUpdate(Shape shape) {
        for (int i2 = 0; i2 < this.shapeList.size(); ++i2) {
            if (!shape.id.equals(this.shapeList.get((int)i2).id)) continue;
            WhiteboardView whiteboardView = this;
            whiteboardView.shapeList.set(i2, shape);
            whiteboardView.invalidate();
            break;
        }
        this.mCustomShape = null;
    }

    @Override
    public void onShapesUpdate(List<Shape> list) {
        LinkedHashMap<String, Shape> linkedHashMap;
        if (list.isEmpty()) {
            return;
        }
        LinkedHashMap<String, Shape> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<String, Shape>();
        for (Shape object : this.shapeList) {
            linkedHashMap2.put(object.id, object);
        }
        Object object = null;
        for (Shape shape : list) {
            if (!linkedHashMap2.containsKey(shape.id)) continue;
            if (shape instanceof BitmapShape && (object = (Shape)linkedHashMap2.get(shape.id)) instanceof BitmapShape) {
                ((BitmapShape)shape).setBitmap(((BitmapShape)object).getBitmap());
            }
            linkedHashMap2.put(shape.id, shape);
            object = (Shape)linkedHashMap2.get(shape.id);
        }
        WhiteboardView whiteboardView = this;
        whiteboardView.shapeList.clear();
        whiteboardView.shapeList.addAll(linkedHashMap2.values());
        if (object == null && list.size() == 1 && list.get(0) instanceof LaserShape) {
            this.shapeList.add(list.get(0));
        }
        this.mCustomShape = null;
        this.invalidate();
    }

    @Override
    public void onShapeDelete(String stringArray) {
        if (TextUtils.isEmpty((CharSequence)stringArray)) {
            return;
        }
        WhiteboardView whiteboardView = this;
        whiteboardView.mCustomShape = null;
        whiteboardView.mMoveShape = null;
        block0: for (String string2 : stringArray.split(",")) {
            Iterator<Shape> iterator = this.shapeList.iterator();
            while (iterator.hasNext()) {
                Shape shape = iterator.next();
                if (!string2.equals(shape.id)) continue;
                iterator.remove();
                if (!(shape instanceof BitmapShape)) continue block0;
                this.mSelectRectBoundaryShape = null;
                continue block0;
            }
        }
        this.invalidate();
    }

    @Override
    public void onShapeModelAdd(LPShapeModel lPShapeModel) {
        ConcurrentLinkedQueue<LPShapeModel> concurrentLinkedQueue = ((WhiteboardView)((Object)concurrentLinkedQueue)).shapeModelList;
        if (concurrentLinkedQueue == null) {
            return;
        }
        concurrentLinkedQueue.add(lPShapeModel);
    }

    @Override
    public void setShapeModels(List<LPShapeModel> list) {
        ConcurrentLinkedQueue<LPShapeModel> concurrentLinkedQueue = ((WhiteboardView)((Object)concurrentLinkedQueue)).shapeModelList;
        if (concurrentLinkedQueue != null) {
            concurrentLinkedQueue.addAll(list);
        }
    }

    @Override
    public void onShapeClear() {
        WhiteboardView whiteboardView = this;
        whiteboardView.shapeList.clear();
        whiteboardView.mMoveShape = null;
        whiteboardView.mCustomShape = null;
        whiteboardView.selectedShapes.clear();
        whiteboardView.appendingShapeMap.clear();
        whiteboardView.appendedShapeMap.clear();
        whiteboardView.clearBoard();
    }

    @Override
    public void onShapeAppend(DoodleShape doodleShape, boolean bl) {
        if (this.handleShapeAppend(doodleShape, bl)) {
            this.invalidate();
        }
    }

    @Override
    public void onShapeModelAppend(LPShapeModel lPShapeModel) {
        this.appendedShapeModelList.add(lPShapeModel);
    }

    @Override
    public void onShapeModelAppend(List<LPShapeModel> list) {
        if (list != null) {
            this.appendedShapeModelList.addAll(list);
        }
    }

    public void setRealWidthHeight(int n2, int n3) {
        WhiteboardView whiteboardView = this;
        whiteboardView.currentWidth = n2;
        whiteboardView.currentHeight = n3;
    }

    @Override
    public int getCurrentWidth() {
        return this.currentWidth;
    }

    @Override
    public int getCurrentHeight() {
        return this.currentHeight;
    }

    public void setMaxPage(int n2) {
        this.maxPage = n2;
    }

    @Override
    public void setFlipEnable(boolean bl) {
        this.mFlipEnable = bl;
        this.getAttacher().setFlipEnable(bl);
    }

    @Override
    public void setPPTShowWay(LPConstants.LPPPTShowWay lPPPTShowWay) {
        if (lPPPTShowWay != null && this.pptShowWay != lPPPTShowWay) {
            this.pptShowWay = lPPPTShowWay;
            if (lPPPTShowWay == LPConstants.LPPPTShowWay.SHOW_COVERED) {
                this.getAttacher().setScaleType(ImageView.ScaleType.FIT_XY);
            } else if (lPPPTShowWay == LPConstants.LPPPTShowWay.SHOW_FULL_SCREEN) {
                this.getAttacher().setScaleType(ImageView.ScaleType.FIT_CENTER);
            }
            return;
        }
    }

    @Override
    public int getOffsetWidth() {
        return 0;
    }

    @Override
    public int getOffsetHeight() {
        return 0;
    }

    public int getCurrentIndex() {
        return this.mPageIndex;
    }

    public void setCurrentIndex(int n2) {
        this.mPageIndex = n2;
    }

    public void setLPAnimRouterListener(LPAnimPPTRouterListener lPAnimPPTRouterListener) {
        this.lpAnimPPTRouterListener = lPAnimPPTRouterListener;
    }

    public void setLpAnimPPTRequestListener(LPAnimPPTRequestListener lPAnimPPTRequestListener) {
        this.lpAnimPPTRequestListener = lPAnimPPTRequestListener;
    }

    public void setLiveRoom(LiveRoom liveRoom) {
        this.liveRoom = liveRoom;
        this.docListViewModel = (LPDocListViewModel)liveRoom.getDocListVM();
    }

    public void setAnimPPT(boolean bl) {
        super.setAnimPPT(bl);
        this.isAnimPPT = bl;
    }

    @Override
    public void setTouchAble(boolean bl) {
        this.mTouchEnable = bl;
    }

    @Override
    public void setOnDoubleTapListener(OnDoubleTapListener2 onDoubleTapListener2) {
        this.onDoubleTapListener = onDoubleTapListener2;
        this.getAttacher().setOnDoubleTapListener((OnDoubleTapListener)onDoubleTapListener2);
    }

    @Override
    public void setDoubleTapScaleEnable(boolean bl) {
        this.getAttacher().setDoubleTapScaleEnable(bl);
    }

    public void setPCBlackboard(boolean bl) {
        this.isPCBlackboard = bl;
    }

    public void setUserRole(LPConstants.LPUserType lPUserType) {
        this.userRole = lPUserType;
    }

    public void setEnableStudentOperatePaint(boolean bl) {
        this.enableStudentOperatePaint = bl;
    }

    public void setEnableEraseTeacherPaint(boolean bl) {
        this.enableEraseTeacherPaint = bl;
    }

    @Override
    public void setCustomShapeType(LPConstants.ShapeType shapeType) {
        if (shapeType != null) {
            this.shapeType = shapeType;
            if (this.isCustomShape(shapeType)) {
                this.customShapeType = shapeType;
            }
            this.pptEditMode = LPConstants.PPTEditMode.ShapeMode;
            if (shapeType == LPConstants.ShapeType.MarkerDoodle) {
                WhiteboardView whiteboardView = this;
                whiteboardView.mShapePaint.setAlpha(76);
                whiteboardView.shapeCursorVectorDrawable = whiteboardView.markerShapeVectorDrawable;
            } else {
                if (shapeType == LPConstants.ShapeType.Doodle) {
                    this.shapeCursorVectorDrawable = this.brushCursorVectorDrawable;
                }
                this.mShapePaint.setAlpha(255);
            }
        }
    }

    @Override
    public void setPPTAuth(boolean bl) {
        this.isPPTAuth = bl;
        this.setFlipEnable(bl);
    }

    public void sendDrawTextConfirmed(String object, String string2) {
        if (((WhiteboardView)((Object)list)).mTextEditSourcePoint == null) {
            return;
        }
        if (((WhiteboardView)((Object)list)).lpShapeSendListener != null) {
            if (((WhiteboardView)((Object)list)).textShape != null && (!TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)string2))) {
                List<Shape> list;
                if (!TextUtils.isEmpty((CharSequence)object) && TextUtils.isEmpty((CharSequence)string2)) {
                    WhiteboardView whiteboardView = list;
                    list = whiteboardView.textShape;
                    object = whiteboardView.docId;
                    int n2 = whiteboardView.getPage();
                    ((WhiteboardView)((Object)list)).lpShapeSendListener.eraseShape((Shape)((Object)list), (String)object, n2);
                } else if (!TextUtils.isEmpty((CharSequence)object) && !TextUtils.isEmpty((CharSequence)string2)) {
                    WhiteboardView whiteboardView = list;
                    ((TextShape)whiteboardView.textShape).setText(string2);
                    List<Shape> list2 = list;
                    list = Collections.singletonList(((WhiteboardView)((Object)list2)).textShape);
                    whiteboardView.lpShapeSendListener.shapeUpdate(list, super.getWhiteboardViewInfo());
                }
            } else {
                WhiteboardView whiteboardView = list;
                WhiteboardView whiteboardView2 = list;
                object = whiteboardView2.mShapePaint;
                LPConstants.LPUserType lPUserType = whiteboardView2.userRole;
                ((WhiteboardView)((Object)list)).textShape = object = ShapeUtils.createShape(LPConstants.ShapeType.Text, (Paint)object, 0.0f, lPUserType);
                ((Shape)object).setSourcePoint(((WhiteboardView)((Object)list)).mTextEditSourcePoint);
                object = (TextShape)whiteboardView.textShape;
                int n3 = whiteboardView.currentWidth;
                if (n3 == 0) {
                    n3 = ((WhiteboardView)((Object)list)).viewWidth;
                }
                List<Shape> list = list;
                ((TextShape)object).setMaxLineWidth((float)n3 - ((WhiteboardView)((Object)list)).mTextEditSourcePoint.x);
                ((TextShape)((WhiteboardView)((Object)list)).textShape).setTextSize(DisplayUtils.sp2px((Context)list.getContext(), (float)((WhiteboardView)((Object)list)).mPaintTextSize));
                ((TextShape)((WhiteboardView)((Object)list)).textShape).setText(string2);
                ((TextShape)((WhiteboardView)((Object)list)).textShape).setTextBold(ShapeUtils.isFontWeight);
                ((TextShape)((WhiteboardView)((Object)list)).textShape).setTextItalic(ShapeUtils.isFontItalic);
                ((WhiteboardView)((Object)list)).shapeList.add(((WhiteboardView)((Object)list)).textShape);
                object = super.getWhiteboardViewInfo();
                super.getWhiteboardViewInfo().dashType = 0;
                ((WhiteboardView)((Object)list)).lpShapeSendListener.sendShape(((WhiteboardView)((Object)list)).textShape, (LPWhiteboardViewInfo)object);
            }
        }
    }

    @Override
    public void setOnViewTapListener(OnViewTapListener onViewTapListener) {
        super.setOnViewTapListener(onViewTapListener);
        this.onViewTapListener = onViewTapListener;
    }

    public void setOnWindowSizeListener(OnWindowSizeListener onWindowSizeListener) {
        this.onWindowSizeListener = onWindowSizeListener;
    }

    public boolean isTouchEnable() {
        return this.mTouchEnable;
    }

    public boolean onTouchEvent(LPMotionEvent lPMotionEvent) {
        GestureDetector gestureDetector;
        if (this.hoverMouseShape != null && !lPMotionEvent.isShowHoverIcon()) {
            this.hoverMouseShape = null;
            this.invalidate();
        }
        if (lPMotionEvent.getMotionEvent() != null && (gestureDetector = this.mGestureDetector) != null && gestureDetector.onTouchEvent(lPMotionEvent.getMotionEvent())) {
            return true;
        }
        if (!this.isTouchEnable()) {
            if (this.mH5PlayMode == LPConstants.H5PlayMode.Practice) {
                return lPMotionEvent.getMotionEvent() == null || super.onTouchEvent(lPMotionEvent.getMotionEvent());
            }
            if (!this.isPPTAuth) {
                return true;
            }
            return lPMotionEvent.getMotionEvent() == null || this.onAnimTouchEvent(lPMotionEvent.getMotionEvent());
        }
        if (this.isAnimPPT && this.isAnimPPTPageChange.get() || this.isPreviewDoc) {
            return true;
        }
        if (this.pptEditMode != LPConstants.PPTEditMode.Normal) {
            this.getParent().requestDisallowInterceptTouchEvent(true);
        }
        switch (c.a[this.pptEditMode.ordinal()]) {
            default: {
                return true;
            }
            case 4: {
                WhiteboardView whiteboardView = this;
                if (whiteboardView.isCustomShape(whiteboardView.shapeType)) {
                    if (this.shapeType == LPConstants.ShapeType.Arrow && lPMotionEvent.isShowHoverIcon()) {
                        WhiteboardView whiteboardView2 = this;
                        whiteboardView2.touchHover(lPMotionEvent);
                        whiteboardView2.invalidate();
                    }
                    return this.customShapeDrawing(lPMotionEvent);
                }
                gestureDetector = this.shapeType;
                if (gestureDetector == LPConstants.ShapeType.Text) {
                    return lPMotionEvent.getMotionEvent() == null || this.editText(lPMotionEvent.getMotionEvent());
                }
                if (gestureDetector == LPConstants.ShapeType.Point) {
                    return this.editLaserShape(lPMotionEvent);
                }
                if (gestureDetector == LPConstants.ShapeType.Doodle || gestureDetector == LPConstants.ShapeType.MarkerDoodle) {
                    if (lPMotionEvent.getActionMasked() == 5) {
                        return true;
                    }
                    if (lPMotionEvent.isActionDown()) {
                        this.touchStart(lPMotionEvent);
                    } else if (lPMotionEvent.isActionMove()) {
                        this.touchMove(lPMotionEvent);
                    } else if (!lPMotionEvent.isActionUp() && !lPMotionEvent.isActionCancel()) {
                        if (lPMotionEvent.isActionHover()) {
                            this.touchHover(lPMotionEvent);
                        } else if (lPMotionEvent.isActionLeave()) {
                            this.touchLeave();
                        }
                    } else {
                        this.touchEnd();
                    }
                    this.invalidate();
                }
                return true;
            }
            case 3: {
                if (lPMotionEvent.isShowHoverIcon()) {
                    WhiteboardView whiteboardView = this;
                    whiteboardView.touchHover(lPMotionEvent);
                    whiteboardView.invalidate();
                }
                return this.onTouchEventOnEraserMode(lPMotionEvent);
            }
            case 2: {
                return this.onTouchEventOnSelectMode(lPMotionEvent);
            }
            case 1: 
        }
        if (this.isAnimPPT) {
            if (this.isPPTAuth) {
                return lPMotionEvent.getMotionEvent() == null || this.onAnimTouchEvent(lPMotionEvent.getMotionEvent());
            }
            return true;
        }
        if (this.isPPTAuth) {
            return lPMotionEvent.getMotionEvent() == null || super.onTouchEvent(lPMotionEvent.getMotionEvent());
        }
        return true;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent motionEvent) {
        WhiteboardView whiteboardView = this;
        whiteboardView.lpMotionEvent.setMotionEvent(motionEvent);
        return whiteboardView.onTouchEvent(whiteboardView.lpMotionEvent);
    }

    public void invalidateTextBoundary() {
        if (!this.boundaryShapeList.isEmpty()) {
            this.boundaryShapeList.clear();
        }
        if (!this.selectedShapes.isEmpty()) {
            this.selectedShapes.clear();
        }
        this.mSelectRectBoundaryShape = null;
        if (this.mTextEditBoundary == null && this.mTextEditSourcePoint == null) {
            return;
        }
        this.mTextEditBoundary = null;
        this.mTextEditSourcePoint = null;
        this.textShape = null;
        this.invalidate();
    }

    public void setPaintTextSize(int n2) {
        this.mPaintTextSize = n2;
    }

    public void switchBitmapLayer(String string2, int n2) {
        block22: {
            block19: {
                block21: {
                    block20: {
                        block18: {
                            if (TextUtils.isEmpty((CharSequence)string2)) {
                                return;
                            }
                            if (n2 != 0) break block18;
                            n2 = -1;
                            int n3 = 0;
                            for (Shape shape : this.shapeList) {
                                if (!(shape instanceof BitmapShape)) continue;
                                if (shape.id.equals(string2)) {
                                    n3 = this.shapeList.indexOf(shape);
                                    n2 = 0;
                                    continue;
                                }
                                if (n2 != 0) continue;
                                n2 = this.shapeList.indexOf(shape);
                                break;
                            }
                            if (n2 > 0 && n2 != n3) {
                                Collections.swap(this.shapeList, n2, n3);
                            }
                            break block19;
                        }
                        if (n2 != 1) break block20;
                        n2 = 0;
                        int n4 = 0;
                        for (Shape shape : this.shapeList) {
                            if (shape instanceof BitmapShape) {
                                if (shape.id.equals(string2)) break;
                                n2 = this.shapeList.indexOf(shape);
                            }
                            ++n4;
                        }
                        if (n2 > 0 && n2 != n4) {
                            Collections.swap(this.shapeList, n2, n4);
                        }
                        break block19;
                    }
                    if (n2 != 3) break block21;
                    n2 = -1;
                    Shape shape = null;
                    int n5 = -1;
                    for (Shape shape2 : this.shapeList) {
                        if (!(shape2 instanceof BitmapShape)) continue;
                        if (n2 == -1) {
                            n2 = this.shapeList.indexOf(shape2);
                        }
                        if (!shape2.id.equals(string2)) continue;
                        n5 = this.shapeList.indexOf(shape2);
                        shape = shape2;
                        break;
                    }
                    if (shape != null && n5 != n2) {
                        this.shapeList.remove(shape);
                        if (n2 > 0) {
                            this.shapeList.add(n2 - 1, shape);
                        } else {
                            this.shapeList.add(0, shape);
                        }
                    }
                    break block19;
                }
                if (n2 != 2) break block22;
                Shape shape = null;
                for (Shape shape3 : this.shapeList) {
                    if (!(shape3 instanceof BitmapShape) || !shape3.id.equals(string2)) continue;
                    this.shapeList.remove(shape3);
                    shape = shape3;
                    break;
                }
                if (shape != null) {
                    this.shapeList.add(shape);
                }
            }
            this.invalidate();
            return;
        }
    }

    public void scaleBitmapShape(String object, float f2) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return;
        }
        for (Shape shape : this.shapeList) {
            if (!(shape instanceof BitmapShape) || !((String)object).equals(shape.id)) continue;
            object = (BitmapShape)shape;
            float f3 = ((BitmapShape)object).getHeight() * f2;
            if (!(UtilsKt.getDp((float)(((BitmapShape)object).getWidth() * f2)) < 24.0f) && !(UtilsKt.getDp((float)f3) < 24.0f)) {
                ((BitmapShape)object).scale(f2);
                this.drawBoundaryRect(shape);
                break;
            }
            return;
        }
        this.invalidate();
    }

    public void sendBitmapShape(LPUploadDocModel lPUploadDocModel, int n2) {
        this.sendBitmapShape(lPUploadDocModel, 0, n2);
    }

    public void sendBitmapShape(LPUploadDocModel lPUploadDocModel, int n2, int n3) {
        if (lPUploadDocModel != null && !TextUtils.isEmpty((CharSequence)lPUploadDocModel.url)) {
            WhiteboardView whiteboardView = lPWhiteboardViewInfo;
            Object object = whiteboardView.mShapePaint;
            LPConstants.LPUserType lPUserType = whiteboardView.userRole;
            object = ShapeUtils.createShape(LPConstants.ShapeType.Bitmap, object, 0.0f, lPUserType);
            float f2 = n2;
            object.setSourcePoint(new LPPointF(f2, n3));
            BitmapShape bitmapShape = (BitmapShape)object;
            bitmapShape.setWidth(lPUploadDocModel.width);
            bitmapShape.setHeight(lPUploadDocModel.height);
            bitmapShape.setUrl(lPUploadDocModel.url);
            if (((WhiteboardView)((Object)lPWhiteboardViewInfo)).lpShapeSendListener != null) {
                WhiteboardView whiteboardView2 = lPWhiteboardViewInfo;
                LPWhiteboardViewInfo lPWhiteboardViewInfo = whiteboardView2.getWhiteboardViewInfo();
                whiteboardView2.getWhiteboardViewInfo().dashType = 0;
                whiteboardView2.lpShapeSendListener.sendShape((Shape)object, lPWhiteboardViewInfo);
            }
            return;
        }
    }

    public void sendBitmapShape(LPUploadDocModel lPUploadDocModel) {
        this.sendBitmapShape(lPUploadDocModel, 0);
    }

    public Matrix getImageMatrix() {
        if (this.isPCBlackboard) {
            return this.getMatrix();
        }
        return super.getImageMatrix();
    }

    @Override
    public void onAnimPageChangeStart(boolean bl) {
        if (this.isAnimPPTPageChange.get()) {
            return;
        }
        if (!bl) {
            WhiteboardView whiteboardView = this;
            whiteboardView.onShapeClear();
            whiteboardView.isAnimPPTPageChange.set(true);
        }
    }

    @Override
    public void onAnimPageChangeFinish(LPAnimPPTPageChangeEndModel lPAnimPPTPageChangeEndModel) {
        String string2;
        WhiteboardView whiteboardView = lPAnimPPTRequestListener;
        whiteboardView.isAnimPPTPageChange.set(false);
        LPAnimPPTPageChangeEndModel lPAnimPPTPageChangeEndModel2 = whiteboardView.pageChangeEndModel;
        boolean bl = lPAnimPPTPageChangeEndModel2 == null || lPAnimPPTPageChangeEndModel.page != lPAnimPPTPageChangeEndModel2.page;
        ((WhiteboardView)((Object)lPAnimPPTRequestListener)).pageChangeEndModel = lPAnimPPTPageChangeEndModel;
        ((WhiteboardView)((Object)lPAnimPPTRequestListener)).docId = string2 = lPAnimPPTPageChangeEndModel.docId;
        ((WhiteboardView)((Object)lPAnimPPTRequestListener)).useRelativePage = lPAnimPPTPageChangeEndModel.useRelativePage;
        ((WhiteboardView)((Object)lPAnimPPTRequestListener)).hasPrevStep = lPAnimPPTPageChangeEndModel.hasPrevStep;
        ((WhiteboardView)((Object)lPAnimPPTRequestListener)).hasNextStep = lPAnimPPTPageChangeEndModel.hasNextStep;
        ((WhiteboardView)((Object)lPAnimPPTRequestListener)).hasPrevPage = lPAnimPPTPageChangeEndModel.hasPrevPage;
        ((WhiteboardView)((Object)lPAnimPPTRequestListener)).hasNextPage = lPAnimPPTPageChangeEndModel.hasNextPage;
        boolean bl2 = false;
        if (!string2.equals(((WhiteboardView)((Object)lPAnimPPTRequestListener)).lastDocId) || lPAnimPPTPageChangeEndModel.page != ((WhiteboardView)((Object)lPAnimPPTRequestListener)).mPageIndex) {
            Whiteboard.OnPageSelectedListener onPageSelectedListener;
            LPDocExtraModel lPDocExtraModel;
            if (((WhiteboardView)((Object)lPAnimPPTRequestListener)).docList.size() > lPAnimPPTPageChangeEndModel.page) {
                ((WhiteboardView)((Object)lPAnimPPTRequestListener)).changeDocExtraModel();
            }
            if ((lPDocExtraModel = ((WhiteboardView)((Object)lPAnimPPTRequestListener)).extraModelMap.get(((WhiteboardView)((Object)lPAnimPPTRequestListener)).docId)) == null) {
                String string3;
                lPDocExtraModel = LPDocExtraModel.getDefaultModel();
                LPDocExtraModel.getDefaultModel().docId = string3 = ((WhiteboardView)((Object)lPAnimPPTRequestListener)).docId;
                ((WhiteboardView)((Object)lPAnimPPTRequestListener)).extraModelMap.put(string3, lPDocExtraModel);
            }
            float f2 = LPDocExtraModel.getFloatValue(lPDocExtraModel.scale, 1.0f);
            ((WhiteboardView)((Object)lPAnimPPTRequestListener)).currentWidth = (int)((float)UtilsKt.getDp((int)lPAnimPPTPageChangeEndModel.width) / f2);
            ((WhiteboardView)((Object)lPAnimPPTRequestListener)).currentHeight = (int)((float)UtilsKt.getDp((int)lPAnimPPTPageChangeEndModel.height) / f2);
            if (bl) {
                super.setWhiteBoardBg();
            }
            LPAnimPPTRequestListener lPAnimPPTRequestListener = lPAnimPPTRequestListener;
            ((WhiteboardView)((Object)lPAnimPPTRequestListener)).syncZoomAndScroll();
            Object object = ((WhiteboardView)((Object)lPAnimPPTRequestListener)).onDocUpdateListener;
            if (object != null) {
                object.onDocUpdate();
            }
            if ((object = ((WhiteboardView)((Object)lPAnimPPTRequestListener)).lpAnimPPTRequestListener) != null) {
                Object object2 = lPAnimPPTRequestListener;
                object.setCurrentWhiteboard(lPAnimPPTPageChangeEndModel);
                ((WhiteboardView)object2).lpAnimPPTRequestListener.requestPageAllShapes(lPAnimPPTPageChangeEndModel);
                if (!((WhiteboardView)object2).docId.equals(((WhiteboardView)((Object)lPAnimPPTRequestListener)).lastDocId)) {
                    boolean bl3;
                    bl2 = bl3 = ((WhiteboardView)((Object)lPAnimPPTRequestListener)).lpAnimPPTRequestListener.isH5PPT(((WhiteboardView)((Object)lPAnimPPTRequestListener)).docId);
                }
            }
            if ((onPageSelectedListener = ((WhiteboardView)((Object)lPAnimPPTRequestListener)).onPageSelectedListener) != null) {
                onPageSelectedListener.onH5PageChangeFinish(lPAnimPPTPageChangeEndModel);
            }
        }
        if (bl2) {
            ((WhiteboardView)((Object)lPAnimPPTRequestListener)).setH5WebViewConsumeEvent(true);
        }
        ((WhiteboardView)((Object)lPAnimPPTRequestListener)).lastDocId = ((WhiteboardView)((Object)lPAnimPPTRequestListener)).docId;
        ((WhiteboardView)((Object)lPAnimPPTRequestListener)).mPageIndex = lPAnimPPTPageChangeEndModel.page;
        LPAnimPPTRequestListener lPAnimPPTRequestListener = ((WhiteboardView)((Object)lPAnimPPTRequestListener)).lpAnimPPTRequestListener;
        if (lPAnimPPTRequestListener != null) {
            lPAnimPPTRequestListener.animPPTFinishFeedBack();
        }
    }

    public void setDocList(List<LPDocModel> list) {
        WhiteboardView whiteboardView = this;
        whiteboardView.docList.clear();
        whiteboardView.docList.addAll(list);
    }

    @Override
    public void onAnimPageSize(int n2, int n3, boolean bl) {
        if (this.isAnimPPT && (this.currentWidth == 0 || this.currentHeight == 0)) {
            LPDocExtraModel lPDocExtraModel = this.extraModelMap.get(this.docId);
            if (lPDocExtraModel != null) {
                WhiteboardView whiteboardView = this;
                LPAnimPPTPageChangeEndModel lPAnimPPTPageChangeEndModel = this.pageChangeEndModel;
                lPAnimPPTPageChangeEndModel.width = n2;
                lPAnimPPTPageChangeEndModel.height = n3;
                float f2 = LPDocExtraModel.getFloatValue(lPDocExtraModel.scale, 1.0f);
                whiteboardView.currentWidth = (int)((float)UtilsKt.getDp((int)whiteboardView.pageChangeEndModel.width) / f2);
                whiteboardView.currentHeight = (int)((float)UtilsKt.getDp((int)whiteboardView.pageChangeEndModel.height) / f2);
            }
            WhiteboardView whiteboardView = this;
            whiteboardView.setWhiteBoardBg();
            whiteboardView.syncZoomAndScroll();
        }
    }

    @Override
    public void onAnimMaxPageChanged(int n2, boolean bl, boolean bl2) {
    }

    @Override
    public void onAnimPPTLoadStart() {
        LPAnimPPTRequestListener lPAnimPPTRequestListener = ((WhiteboardView)((Object)lPAnimPPTRequestListener)).lpAnimPPTRequestListener;
        if (lPAnimPPTRequestListener != null) {
            lPAnimPPTRequestListener.onAnimPPTLoadStart();
        }
    }

    @Override
    public void onAnimPPPTLoadError(LPError lPError) {
        LPAnimPPTRequestListener lPAnimPPTRequestListener = ((WhiteboardView)((Object)lPAnimPPTRequestListener)).lpAnimPPTRequestListener;
        if (lPAnimPPTRequestListener != null) {
            lPAnimPPTRequestListener.animPPTErrorFeedBack(lPError);
        }
    }

    @Override
    public void onPageCountChange(String string2, int n2) {
        Whiteboard.OnPageSelectedListener onPageSelectedListener = ((WhiteboardView)((Object)onPageSelectedListener)).onPageSelectedListener;
        if (onPageSelectedListener != null) {
            onPageSelectedListener.onH5PageCountChange(string2, n2);
        }
    }

    @Override
    public void onRecordsAllReq() {
        LPAnimPPTRequestListener lPAnimPPTRequestListener = this.lpAnimPPTRequestListener;
        if (lPAnimPPTRequestListener != null) {
            lPAnimPPTRequestListener.onRecordsAllReq(this.docId);
        }
    }

    public void setH5PlayMode(LPConstants.H5PlayMode h5PlayMode) {
        this.mH5PlayMode = h5PlayMode;
    }

    public void setH5WebViewConsumeEvent(boolean bl) {
        this.h5WebViewConsumeEvent = bl;
    }

    public void setPreviewDoc(boolean bl) {
        this.isPreviewDoc = bl;
    }

    public void gotoNextPage() {
        if (((WhiteboardView)((Object)string2)).isAnimPPT) {
            if (((WhiteboardView)((Object)string2)).hasNextPage && !((WhiteboardView)((Object)string2)).isPreviewDoc) {
                ((WhiteboardView)((Object)string2)).lpAnimPPTRouterListener.nextPage();
            } else {
                Object object = ((WhiteboardView)((Object)string2)).pageChangeEndModel;
                if (object != null) {
                    LPAnimPPTPageChangeEndModel lPAnimPPTPageChangeEndModel = object;
                    object = lPAnimPPTPageChangeEndModel.docId;
                    if ((object = ((WhiteboardView)((Object)string2)).getNextPage((String)object, lPAnimPPTPageChangeEndModel.page)) != null && ((WhiteboardView)((Object)string2)).lpAnimPPTRouterListener.getCanChangePage()) {
                        Object object2 = object;
                        String string2 = ((LPDocModel)((Object)object2)).docId;
                        ((WhiteboardView)((Object)string2)).lpAnimPPTRouterListener.gotoPage(string2, ((LPDocModel)((Object)object2)).index);
                    }
                }
            }
        }
    }

    public void gotoPrevPage() {
        if (((WhiteboardView)((Object)string2)).isAnimPPT) {
            if (((WhiteboardView)((Object)string2)).hasPrevPage && !((WhiteboardView)((Object)string2)).isPreviewDoc) {
                ((WhiteboardView)((Object)string2)).lpAnimPPTRouterListener.prevPage();
            } else {
                Object object = ((WhiteboardView)((Object)string2)).pageChangeEndModel;
                if (object != null) {
                    LPAnimPPTPageChangeEndModel lPAnimPPTPageChangeEndModel = object;
                    object = lPAnimPPTPageChangeEndModel.docId;
                    if ((object = ((WhiteboardView)((Object)string2)).getPrePage((String)object, lPAnimPPTPageChangeEndModel.page)) != null && ((WhiteboardView)((Object)string2)).lpAnimPPTRouterListener.getCanChangePage()) {
                        Object object2 = object;
                        String string2 = ((LPDocModel)((Object)object2)).docId;
                        ((WhiteboardView)((Object)string2)).lpAnimPPTRouterListener.gotoPage(string2, ((LPDocModel)((Object)object2)).index);
                    }
                }
            }
        }
    }

    public void onH5RecordChange(LPJsonModel lPJsonModel) {
        if (this.isAnimPPT) {
            this.lpAnimPPTRouterListener.onH5DataChange(lPJsonModel);
        }
    }

    public void onTextShapeChange(Canvas object, float f2, float f3) {
        LPPointF lPPointF;
        if (this.mTextEditBoundary == null) {
            return;
        }
        Canvas canvas = object;
        object = lPPointF;
        object(this.mTextEditBoundary.getSourcePoint().x, this.mTextEditBoundary.getSourcePoint().y);
        lPPointF.offset(f2, f3);
        this.mTextEditBoundary.appendPoint((LPPointF)((Object)object));
        this.drawEditTextBoundary(canvas);
    }

    public float getValue(Matrix matrix, int n2) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[n2];
    }

    public void onScaleChange(float f2, float f3, float f4) {
        this.generateDocUpdateModel();
    }

    public void onScaleEnd(float f2, float f3, float f4) {
        this.sendDocUpdateSignal();
    }

    public void onDrag(float f2, float f3) {
        this.generateDocUpdateModel();
    }

    public void onDragEnd(float f2, float f3) {
        this.sendDocUpdateSignal();
    }

    public void onFlingFinished(float f2, float f3) {
        WhiteboardView whiteboardView = this;
        whiteboardView.generateDocUpdateModel();
        whiteboardView.sendDocUpdateSignal();
    }

    public LPDocExtraModel getDocExtraModel() {
        Object object = object.extraModelMap.get(object.docId);
        if (object == null) {
            object = LPDocExtraModel.getDefaultModel();
        }
        return object;
    }

    public boolean checkDocExtraModelValid() {
        DecimalFormat decimalFormat;
        WhiteboardView whiteboardView = this;
        float f2 = whiteboardView.getValue(whiteboardView.getImageMatrix(), 2);
        WhiteboardView whiteboardView2 = this;
        WhiteboardView whiteboardView3 = this;
        float f3 = whiteboardView.getValue(whiteboardView.getImageMatrix(), 5) / ((float)this.currentHeight * whiteboardView3.getValue(whiteboardView3.getImageMatrix(), 4));
        Object object = decimalFormat;
        ((DecimalFormat)object)("0.0000");
        String string2 = ((NumberFormat)object).format(Math.abs(f2 /= (float)this.currentWidth * whiteboardView2.getValue(whiteboardView2.getImageMatrix(), 0)));
        String string3 = decimalFormat.format(Math.abs(f3));
        object = new DecimalFormat("0.00").format(Math.abs(this.getScale()));
        if ("1.00".equals(object)) {
            string2 = "0";
            string3 = "0";
        }
        return !(TextUtils.equals((CharSequence)object, (CharSequence)this.syncExtraModel.scale) && TextUtils.equals((CharSequence)string2, (CharSequence)this.syncExtraModel.scrollLeft) && TextUtils.equals((CharSequence)string3, (CharSequence)this.syncExtraModel.scrollTop));
    }

    public LPDocExtraModel getDocPreviewExtraModel() {
        DecimalFormat decimalFormat;
        LPDocExtraModel lPDocExtraModel;
        LPDocExtraModel lPDocExtraModel2 = lPDocExtraModel;
        WhiteboardView whiteboardView = string2;
        lPDocExtraModel2();
        float f2 = whiteboardView.getValue(whiteboardView.getImageMatrix(), 2);
        WhiteboardView whiteboardView2 = string2;
        WhiteboardView whiteboardView3 = string2;
        float f3 = whiteboardView.getValue(whiteboardView.getImageMatrix(), 5) / ((float)((WhiteboardView)((Object)string2)).currentHeight * whiteboardView3.getValue(whiteboardView3.getImageMatrix(), 4));
        DecimalFormat decimalFormat2 = decimalFormat;
        decimalFormat2("0.0000");
        lPDocExtraModel2.scrollLeft = decimalFormat2.format(Math.abs(f2 /= (float)((WhiteboardView)((Object)string2)).currentWidth * whiteboardView2.getValue(whiteboardView2.getImageMatrix(), 0)));
        lPDocExtraModel.scrollTop = decimalFormat.format(Math.abs(f3));
        String string2 = new DecimalFormat("0.00").format(Math.abs(string2.getScale()));
        lPDocExtraModel.scale = string2;
        if ("1.00".equals(string2)) {
            LPDocExtraModel lPDocExtraModel3 = lPDocExtraModel2;
            lPDocExtraModel3.scrollLeft = "0";
            lPDocExtraModel3.scrollTop = "0";
        }
        lPDocExtraModel2.fitWay = 1;
        return lPDocExtraModel2;
    }

    @Override
    public void setShowPaintOwnerEnable(boolean bl) {
        ((WhiteboardView)this).isShowPaintOwnerEnable = bl;
        RectBoundaryShape rectBoundaryShape = ((WhiteboardView)this).mSelectRectBoundaryShape;
        if (rectBoundaryShape != null) {
            rectBoundaryShape.setShowPaintOwnerEnable(bl);
        }
        if ((this = ((WhiteboardView)this).multiSelectedBoundaryShape) != null) {
            ((RectBoundaryShape)this).setShowPaintOwnerEnable(bl);
        }
    }

    @Override
    public void setOnShapeSelectedListener(Whiteboard.OnShapeSelectedListener onShapeSelectedListener) {
        this.onShapeSelectedListener = onShapeSelectedListener;
    }

    @Override
    public void syncZoomAndScroll() {
        WhiteboardView whiteboardView = this;
        whiteboardView.syncZoomAndScroll(whiteboardView.extraModelMap.get(this.docId));
    }

    @Override
    public void syncZoomAndScroll(LPDocExtraModel lPDocExtraModel) {
        if (lPDocExtraModel == null) {
            return;
        }
        if (TextUtils.equals((CharSequence)this.docId, (CharSequence)lPDocExtraModel.docId)) {
            LPDocExtraModel lPDocExtraModel2 = lPDocExtraModel;
            float f2 = -LPDocExtraModel.getFloatValue(lPDocExtraModel2.scrollLeft, 0.0f);
            f2 = Math.round(f2 * (float)this.currentWidth);
            float f3 = Math.round(-LPDocExtraModel.getFloatValue(lPDocExtraModel2.scrollTop, 0.0f) * (float)this.currentHeight);
            this.setScaleAndTranslate(Math.min(Math.max(LPDocExtraModel.getFloatValue(lPDocExtraModel.scale, 1.0f), 1.0f), 3.0f), 0.0f, 0.0f, f2, f3);
        }
        this.extraModelMap.put(lPDocExtraModel.docId, lPDocExtraModel);
    }

    @Override
    public void destroy() {
        if (this.target != null && DisplayUtils.isValidContextForGlide((Context)this.getContext())) {
            Glide.with((Context)this.getContext()).clear(this.target);
        }
        WhiteboardView whiteboardView = this;
        whiteboardView.target = null;
        whiteboardView.shapeList.clear();
        whiteboardView.shapeModelList.clear();
        whiteboardView.ownerOfShapeList.clear();
        whiteboardView.appendingShapeMap.clear();
        whiteboardView.appendedShapeMap.clear();
        whiteboardView.lpAnimPPTRouterListener = null;
        whiteboardView.lpAnimPPTRequestListener = null;
        whiteboardView.lpShapeSendListener = null;
        whiteboardView.onBoardTouchListener = null;
        whiteboardView.onPageSelectedListener = null;
        whiteboardView.onDoubleTapListener = null;
        whiteboardView.onViewTapListener = null;
        whiteboardView.onWindowSizeListener = null;
        whiteboardView.onShapeSelectedListener = null;
        whiteboardView.backupPicHostIndex = -1;
        RxUtils.dispose((Disposable)whiteboardView.disposableOfShapeCursorTimer);
    }

    public void startShapeCursorTimer() {
        if (!LiveSDK.ENABLE_SHOW_SHAPE_APPEND_CURSOR) {
            return;
        }
        RxUtils.dispose((Disposable)this.disposableOfShapeCursorTimer);
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        this.disposableOfShapeCursorTimer = Observable.interval((long)500L, (TimeUnit)timeUnit).observeOn(AndroidSchedulers.mainThread()).subscribe(l2 -> {
            boolean bl = false;
            long l3 = System.currentTimeMillis();
            for (Shape shape : new ArrayList<Shape>(this.shapeList)) {
                if (!(shape instanceof DoodleShape)) continue;
                shape = (DoodleShape)shape;
                if (!((DoodleShape)shape).showCursorBitmap || l3 - ((DoodleShape)shape).timestamp < 2000L) continue;
                ((DoodleShape)shape).showCursorBitmap = false;
                bl = true;
            }
            if (bl) {
                this.invalidate();
            }
        });
    }

    public static interface OnWindowSizeListener {
        public void onDoubleTapEnableChange(boolean var1);
    }

    public static interface OnBoardTouchListener {
        public void onBoardTouch(boolean var1, int var2);

        public void onTouchEnd();
    }

    public static interface LPShapeSendListener {
        public void sendShape(Shape var1, LPWhiteboardViewInfo var2);

        public boolean eraseShape(Shape var1, String var2, int var3);

        public void shapeUpdate(List<Shape> var1, LPWhiteboardViewInfo var2);

        public void laserShapeUpdate(Shape var1, LPWhiteboardViewInfo var2);

        public void sendShapeAppend(Shape var1, LPWhiteboardViewInfo var2, int var3);
    }
}

