/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.models;

import android.text.TextUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPDataModel;
import com.baijiayun.livebase.models.LPIpAddress;
import com.baijiayun.livebase.models.LPUserModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livecore.models.LPMediaResolutionModel;
import com.baijiayun.livecore.models.imodels.IMediaModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomModel;
import com.baijiayun.livecore.utils.LPMediaIdUtils;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class LPMediaModel
extends LPResRoomModel
implements IMediaModel {
    @SerializedName(value="video_on")
    public boolean videoOn;
    @SerializedName(value="audio_on")
    public boolean audioOn;
    @SerializedName(value="publish_server")
    public LPIpAddress publishServer;
    @SerializedName(value="publish_index")
    public int publishIndex;
    @SerializedName(value="is_screen_sharing")
    public int isScreenSharing;
    public LPUserModel user;
    @SerializedName(value="video_resolution")
    public LPMediaResolutionModel videoResolution;
    @SerializedName(value="link_type")
    public LPConstants.LPLinkType link_type;
    @SerializedName(value="skip_release")
    public int skipRelease;
    @SerializedName(value="support_mute_stream")
    public int supportMuteStream = 1;
    @SerializedName(value="definitions")
    public ArrayList<LPConstants.VideoDefinition> videoDefinitions;
    @SerializedName(value="keep_alive")
    public boolean keepAlive;
    @SerializedName(value="media_id")
    public String mediaId;
    @SerializedName(value="has_low_stream")
    public int hasLowStream;
    @SerializedName(value="width")
    public int width;
    @SerializedName(value="height")
    public int height;
    public transient boolean isHandUp;
    public transient boolean screenShareFlag;

    public void setVideoResolution(LPMediaResolutionModel lPMediaResolutionModel) {
        this.videoResolution = lPMediaResolutionModel;
    }

    @Override
    public boolean isVideoOn() {
        return this.videoOn;
    }

    @Override
    public void setVideoOn(boolean bl) {
        this.videoOn = bl;
    }

    @Override
    public void setAudioOn(boolean bl) {
        this.audioOn = bl;
    }

    @Override
    public boolean isAudioOn() {
        return this.audioOn;
    }

    @Override
    public boolean isHandUp() {
        return this.isHandUp;
    }

    @Override
    public IUserModel getUser() {
        return this.user;
    }

    @Override
    public int getOriginalVideoWidth() {
        LPDataModel lPDataModel = lPDataModel.videoResolution;
        return lPDataModel == null ? 0 : lPDataModel.width;
    }

    @Override
    public int getOriginalVideoHeight() {
        LPDataModel lPDataModel = lPDataModel.videoResolution;
        return lPDataModel == null ? 0 : lPDataModel.height;
    }

    @Override
    public int skipRelease() {
        return this.skipRelease;
    }

    @Override
    public String getMediaId() {
        if (TextUtils.isEmpty((CharSequence)this.mediaId)) {
            return this.user.userId;
        }
        if (this.mediaId.equals(this.user.userId)) {
            return this.mediaId;
        }
        LPMediaModel lPMediaModel = this;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        n2 = Integer.parseInt(lPMediaModel.mediaId);
        try {
            n3 = Integer.parseInt(lPMediaModel.user.userId);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        if (n2 > n3) {
            return this.user.userId + "_" + (n2 - n3);
        }
        return this.user.userId + "_" + this.mediaId;
    }

    @Override
    public String getRealMediaId() {
        if (TextUtils.isEmpty((CharSequence)this.mediaId)) {
            return this.user.userId;
        }
        if (this.mediaId.equals(this.user.userId)) {
            return this.mediaId;
        }
        LPMediaModel lPMediaModel = this;
        int n2 = 0;
        int n3 = 0;
        n3 = Integer.parseInt(lPMediaModel.user.userId);
        try {
            n2 = Integer.parseInt(lPMediaModel.mediaId);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        if (n2 > n3) {
            String string2 = this.user.userId;
            return string2.substring(0, string2.length() - 1) + (n2 - n3);
        }
        String string3 = this.user.userId;
        return string3.substring(0, string3.length() - 1) + this.mediaId;
    }

    @Override
    public LPConstants.MediaSourceType getMediaSourceType() {
        return LPMediaIdUtils.getMediaSourceType(this.getMediaId());
    }

    @Override
    public boolean hasExtraStreams() {
        return false;
    }

    @Override
    public List<? extends IMediaModel> getExtraStreams() {
        return null;
    }

    @Override
    public boolean isMixedStream() {
        return false;
    }

    @Override
    public List<LPConstants.VideoDefinition> getVideoDefinitions() {
        ArrayList<LPConstants.VideoDefinition> arrayList = ((LPMediaModel)((Object)arrayList)).videoDefinitions;
        if (arrayList == null) {
            ArrayList arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList();
        }
        return arrayList;
    }

    @Override
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public boolean isScreenShare() {
        return this.screenShareFlag;
    }

    @Override
    public void setScreenShareFlag(boolean bl) {
        this.screenShareFlag = bl;
    }

    @Override
    public boolean isWarmingUpVideo() {
        return false;
    }

    public String toString() {
        return "LPMediaModel{mediaId=" + this.mediaId + ", videoOn=" + this.videoOn + ", audioOn=" + this.audioOn + ", user=" + this.user + '}';
    }
}

