/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.viewmodels.impl;

import android.text.TextUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.context.LPError;
import com.baijiayun.livebase.models.LPJsonModel;
import com.baijiayun.livebase.network.alilog.AliYunLogHelper;
import com.baijiayun.livecore.context.LPSDKContext;
import com.baijiayun.livecore.models.LPDocModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomPageChangeModel;
import com.baijiayun.livecore.viewmodels.DocListVM;
import com.baijiayun.livecore.viewmodels.impl.LPBaseViewModel;
import com.baijiayun.livecore.viewmodels.impl.PPTVM;
import com.uber.autodispose.AutoDispose;
import com.uber.autodispose.FlowableSubscribeProxy;
import com.uber.autodispose.ObservableSubscribeProxy;
import com.uber.autodispose.ScopeProvider;
import io.reactivex.FlowableConverter;
import io.reactivex.Observable;
import io.reactivex.ObservableConverter;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.subjects.PublishSubject;
import java.util.List;

public class LPPPTViewModel
extends LPBaseViewModel
implements PPTVM {
    private DocListVM mDocListViewModel;
    private PPTVM.LPPPTFragmentInterface mListener;
    private final int COUNT_MIN_WHITEBOARD;
    private final int COUNT_MAX_WHITEBOARD;
    private PublishSubject<Integer> publishSubjectOfWhiteboardAdd = PublishSubject.create();
    private PublishSubject<Integer> publishSubjectOfWhiteboardDelete = PublishSubject.create();

    public LPPPTViewModel(PPTVM.LPPPTFragmentInterface lPPPTFragmentInterface, LPSDKContext lPSDKContext, DocListVM docListVM) {
        super(lPSDKContext);
        this.COUNT_MIN_WHITEBOARD = 1;
        this.COUNT_MAX_WHITEBOARD = 10;
        this.mDocListViewModel = docListVM;
        this.mListener = lPPPTFragmentInterface;
    }

    private boolean canAssistantOperateDocument() {
        return !this.isAssistant() || this.getLPSDKContext().getGlobalVM().getAdminAuth() == null || this.getLPSDKContext().getGlobalVM().getAdminAuth().documentControl;
    }

    private int getWhiteboardCount() {
        int n2 = 0;
        List<LPDocModel> list = this.mDocListViewModel.getDocList();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (!"0".equals(list.get((int)i2).docId)) continue;
            ++n2;
        }
        return n2;
    }

    public boolean isAssistant() {
        return this.getLPSDKContext().getCurrentUser().getType() == LPConstants.LPUserType.Assistant;
    }

    @Override
    public void changePage(String string2, int n2) {
        if (this.mDocListViewModel.isEnableChangePPTPage() && this.canAssistantOperateDocument()) {
            if (this.getLPSDKContext().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
                AliYunLogHelper.getInstance().addDebugLog("\u5b66\u751f\u53d1\u9001page_change_trigger");
            }
            this.getLPSDKContext().getRoomServer().requestPageChange(string2, n2);
        }
    }

    @Override
    public void start() {
        LPPPTViewModel lPPPTViewModel = this;
        ((FlowableSubscribeProxy)lPPPTViewModel.mDocListViewModel.getObservableOfDocListChanged().observeOn(AndroidSchedulers.mainThread()).as((FlowableConverter)AutoDispose.autoDisposable((ScopeProvider)this))).subscribe(list -> {
            PPTVM.LPPPTFragmentInterface lPPPTFragmentInterface = ((LPPPTViewModel)((Object)lPPPTFragmentInterface)).mListener;
            if (lPPPTFragmentInterface != null) {
                lPPPTFragmentInterface.initDocList((List<LPDocModel>)list);
            }
        });
        ((FlowableSubscribeProxy)lPPPTViewModel.getLPSDKContext().getRoomServer().getObservableOfPageChange().filter(lPResRoomPageChangeModel -> lPResRoomPageChangeModel.userId != null).observeOn(AndroidSchedulers.mainThread()).as((FlowableConverter)AutoDispose.autoDisposable((ScopeProvider)this))).subscribe(lPResRoomPageChangeModel -> {
            PPTVM.LPPPTFragmentInterface lPPPTFragmentInterface = ((LPPPTViewModel)((Object)lPPPTFragmentInterface)).mListener;
            if (lPPPTFragmentInterface != null) {
                lPPPTFragmentInterface.updatePCPage((LPResRoomPageChangeModel)lPResRoomPageChangeModel, false);
            }
        });
        ((ObservableSubscribeProxy)lPPPTViewModel.mDocListViewModel.getObservableOfDocPageIndex().distinctUntilChanged().observeOn(AndroidSchedulers.mainThread()).as((ObservableConverter)AutoDispose.autoDisposable((ScopeProvider)this))).subscribe(n2 -> {
            if (this.mListener != null) {
                if (this.getLPSDKContext().getCurrentUser() == null || !this.getLPSDKContext().getGlobalVM().isAdmin()) {
                    LPPPTViewModel lPPPTViewModel = this;
                    PPTVM.LPPPTFragmentInterface lPPPTFragmentInterface = lPPPTViewModel.mListener;
                    int n3 = lPPPTViewModel.mDocListViewModel.isDisableOverTeacherMaxPage() ? this.mDocListViewModel.getDocPageIndex() : this.mDocListViewModel.getDocList().size();
                    lPPPTFragmentInterface.setMaxPage(n3);
                }
                this.mListener.updatePage((int)n2, false, true);
            }
        });
        lPPPTViewModel.getLPSDKContext().getRoomServer().requestBroadcastCache("h5_doc_play_mode");
        ((FlowableSubscribeProxy)lPPPTViewModel.getLPSDKContext().getRoomServer().getObservableOfPageAdd().as((FlowableConverter)AutoDispose.autoDisposable((ScopeProvider)this))).subscribe(lPRoomDocPageModel -> {
            int n2 = lPRoomDocPageModel.pageId;
            if (n2 < 0) {
                this.publishSubjectOfWhiteboardAdd.onError((Throwable)new LPError(-2004, "\u6dfb\u52a0\u767d\u677f\u5931\u8d25"));
            } else {
                this.publishSubjectOfWhiteboardAdd.onNext((Object)n2);
            }
        });
        ((FlowableSubscribeProxy)lPPPTViewModel.getLPSDKContext().getRoomServer().getObservableOfPageDel().as((FlowableConverter)AutoDispose.autoDisposable((ScopeProvider)this))).subscribe(lPRoomDocPageModel -> {
            int n2 = lPRoomDocPageModel.pageId;
            if (n2 < 0) {
                this.publishSubjectOfWhiteboardDelete.onError((Throwable)new LPError(-2005, "\u5220\u9664\u767d\u677f\u5931\u8d25"));
            } else {
                this.publishSubjectOfWhiteboardDelete.onNext((Object)n2);
            }
        });
    }

    @Override
    public void stop() {
        this.destroy();
    }

    @Override
    public void destroy() {
        LPPPTViewModel lPPPTViewModel = this;
        super.destroy();
        lPPPTViewModel.publishSubjectOfWhiteboardAdd.onComplete();
        lPPPTViewModel.publishSubjectOfWhiteboardDelete.onComplete();
        lPPPTViewModel.mListener = null;
        lPPPTViewModel.mDocListViewModel = null;
    }

    @Override
    public boolean getForbidStudentSwitchPPTState() {
        return this.getLPSDKContext().getGlobalVM().getForbidStudentSwitchPPTState();
    }

    @Override
    public Observable<Boolean> getStudentSwitchPPTStateSubscribe() {
        return this.getLPSDKContext().getGlobalVM().getObservableOfForbidStudentSwitchPPT();
    }

    @Override
    public void requestGetH5RecordAll(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        this.getLPSDKContext().getRoomServer().requestH5RecordCache(string2);
    }

    @Override
    public Observable<LPJsonModel> getObservableOfH5RecordAll() {
        return this.getLPSDKContext().getRoomServer().getObservableOfH5RecordAll();
    }

    @Override
    public Observable<LPJsonModel> getObservableOfH5RecordAdd() {
        return this.getLPSDKContext().getRoomServer().getObservableOfH5RecordAdd();
    }

    @Override
    public Observable<LPJsonModel> getObservableOfSnapShotUpdate() {
        return this.getLPSDKContext().getRoomServer().getObservableOfSnapUpdate();
    }

    @Override
    public boolean addPPTWhiteboardPage() {
        if (this.getWhiteboardCount() == 10) {
            return false;
        }
        this.getLPSDKContext().getRoomServer().requestPageAdd();
        return true;
    }

    @Override
    public boolean deletePPTWhiteboardPage(int n2) {
        if (this.getWhiteboardCount() == 1) {
            return false;
        }
        this.getLPSDKContext().getRoomServer().requestPageDel(n2);
        return true;
    }

    @Override
    public Observable<Integer> getObservableOfWhiteboardAdd() {
        return this.publishSubjectOfWhiteboardAdd;
    }

    @Override
    public Observable<Integer> getObservableOfWhiteboardDelete() {
        return this.publishSubjectOfWhiteboardDelete;
    }

    @Override
    public boolean isMultiWhiteboardEnable() {
        return this.getLPSDKContext().enableMultiWhiteboard();
    }
}

