/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.ppt.whiteboard;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.request.target.SimpleTarget;
import com.baijiayun.glide.request.target.Target;
import com.baijiayun.glide.request.transition.Transition;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.AliCloudImageUtil;
import com.baijiayun.livebase.widgets.view.photoview.OnViewTapListener;
import com.baijiayun.livecore.models.LPDocExtraModel;
import com.baijiayun.livecore.models.LPMotionEvent;
import com.baijiayun.livecore.models.LPShapeModel;
import com.baijiayun.livecore.models.roomresponse.LPMockClearCacheModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomShapeDelModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomShapeMultipleModel;
import com.baijiayun.livecore.models.roomresponse.LPResRoomShapeSingleModel;
import com.baijiayun.livecore.ppt.util.LPShapeConverter;
import com.baijiayun.livecore.ppt.whiteboard.OnDoubleTapListener2;
import com.baijiayun.livecore.ppt.whiteboard.Whiteboard;
import com.baijiayun.livecore.ppt.whiteboard.WhiteboardView;
import com.baijiayun.livecore.ppt.whiteboard.shape.BitmapShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.DoodleShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.viewmodels.impl.ShapeVM;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ShapeDispatcher
implements ShapeVM.LPShapeReceiverListener {
    private boolean isAnimPPTEnabled;
    private List<Whiteboard> whiteboardList;
    private boolean isShowPaintOwnerEnable;
    private Whiteboard whiteboard;
    private boolean isInSbbMode;

    public ShapeDispatcher() {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        v1.whiteboardList = arrayList2;
    }

    private void loadBitmapShape(final BitmapShape bitmapShape, String string2) {
        string2 = AliCloudImageUtil.getScaledUrl((String)string2, (String)"m_lfit", (int)1080, (int)1080);
        Glide.with((Context)((WhiteboardView)this.whiteboard).getContext()).asBitmap().load(string2).into((Target)new SimpleTarget<Bitmap>(){

            public void a(@NonNull Bitmap bitmap, Transition<? super Bitmap> transition) {
                a a2 = this;
                a2.bitmapShape.setBitmap(bitmap);
                a2.ShapeDispatcher.this.whiteboard.onShapeAdd(bitmapShape);
            }
        });
    }

    private void deleteShape(Whiteboard whiteboard, String string2) {
        whiteboard.onShapeDelete(string2);
    }

    private int getPageIndex(String string2, int n2) {
        if (!TextUtils.isEmpty((CharSequence)string2) && n2 >= 0 && !this.whiteboardList.isEmpty()) {
            int n3 = 0;
            for (Whiteboard whiteboard : this.whiteboardList) {
                if (string2.equals(whiteboard.getDocId()) && n2 == whiteboard.getPage()) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }
        return -1;
    }

    private boolean checkWbStatus(String string2, int n2) {
        if (this.whiteboardList.isEmpty()) {
            return false;
        }
        if (this.isAnimPPTEnabled) {
            Whiteboard whiteboard;
            this.whiteboard = whiteboard = this.whiteboardList.get(0);
            return string2 != null && string2.equals(whiteboard.getDocId()) && n2 == this.whiteboard.getPage();
        }
        int n3 = this.getPageIndex(string2, n2);
        if (n3 < 0) {
            return false;
        }
        this.whiteboard = this.whiteboardList.get(n3);
        return true;
    }

    public void addWhiteboard(Whiteboard whiteboard) {
        Iterator<Whiteboard> iterator;
        whiteboard.setShowPaintOwnerEnable(this.isShowPaintOwnerEnable);
        if (this.isInSbbMode && (iterator = this.whiteboardList.iterator()).hasNext() && TextUtils.equals((CharSequence)iterator.next().getDocId(), (CharSequence)whiteboard.getDocId())) {
            iterator.remove();
        }
        this.whiteboardList.add(whiteboard);
    }

    public void removeWhiteboard(Whiteboard whiteboard) {
        this.whiteboardList.remove(whiteboard);
    }

    public int getIndexOfWhiteboard(Object object) {
        return this.whiteboardList.indexOf(object);
    }

    public void clearWhiteboardList() {
        this.whiteboardList.clear();
    }

    public void setAnimPPTEnabled(boolean bl) {
        this.isAnimPPTEnabled = bl;
    }

    @Override
    public void updateShapeInfo(LPResRoomShapeSingleModel lPResRoomShapeSingleModel) {
        String string2 = lPResRoomShapeSingleModel.docId;
        if (this.isInSbbMode) {
            string2 = lPResRoomShapeSingleModel.layer + "_" + string2;
        }
        if (!this.checkWbStatus(string2, lPResRoomShapeSingleModel.page)) {
            return;
        }
        if (this.whiteboard.getCurrentWidth() == 0) {
            this.whiteboard.onShapeModelAdd(lPResRoomShapeSingleModel.shape);
        } else {
            ShapeDispatcher shapeDispatcher = this;
            int n2 = shapeDispatcher.whiteboard.getCurrentHeight();
            int n3 = shapeDispatcher.whiteboard.getOffsetWidth();
            int n4 = shapeDispatcher.whiteboard.getOffsetHeight();
            Shape shape = LPShapeConverter.getShapeFromModel(lPResRoomShapeSingleModel.shape, this.whiteboard.getCurrentWidth(), n2, n3, n4);
            if (shape != null) {
                if (this.isInSbbMode && shape instanceof BitmapShape) {
                    this.loadBitmapShape((BitmapShape)shape, lPResRoomShapeSingleModel.shape.url);
                }
                this.whiteboard.onShapeAdd(shape);
            }
        }
    }

    @Override
    public void updateShape(LPResRoomShapeMultipleModel object) {
        Object object2 = ((LPResRoomShapeMultipleModel)object).docId;
        if (this.isInSbbMode) {
            object2 = ((LPResRoomModel)object).layer + "_" + (String)object2;
        }
        if (this.checkWbStatus((String)object2, ((LPResRoomShapeMultipleModel)object).page)) {
            if (this.whiteboard.getCurrentWidth() == 0) {
                this.whiteboard.setShapeModels(((LPResRoomShapeMultipleModel)object).shapeList);
            } else {
                ArrayList arrayList;
                LPResRoomShapeMultipleModel lPResRoomShapeMultipleModel = object;
                object = arrayList;
                arrayList = new ArrayList();
                object2 = lPResRoomShapeMultipleModel.shapeList.iterator();
                while (object2.hasNext()) {
                    ShapeDispatcher shapeDispatcher = this;
                    int n2 = shapeDispatcher.whiteboard.getCurrentHeight();
                    int n3 = shapeDispatcher.whiteboard.getOffsetWidth();
                    int n4 = shapeDispatcher.whiteboard.getOffsetHeight();
                    Shape shape = LPShapeConverter.getShapeFromModel((LPShapeModel)((Object)object2.next()), this.whiteboard.getCurrentWidth(), n2, n3, n4);
                    if (shape == null) continue;
                    object.add(shape);
                }
                this.whiteboard.onShapesUpdate((List<Shape>)object);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteAllShape(LPResRoomShapeDelModel lPResRoomShapeDelModel) {
        if (((ShapeDispatcher)((Object)this)).whiteboardList.isEmpty()) {
            return;
        }
        if (((ShapeDispatcher)((Object)this)).isInSbbMode) {
            for (Whiteboard whiteboard : ((ShapeDispatcher)((Object)this)).whiteboardList) {
                String string2 = lPResRoomShapeDelModel.layer + "_" + lPResRoomShapeDelModel.docId;
                if (TextUtils.isEmpty((CharSequence)whiteboard.getDocId()) || !whiteboard.getDocId().equals(string2) || whiteboard.getPage() != lPResRoomShapeDelModel.page) continue;
                whiteboard.onShapeClear();
                return;
            }
            return;
        }
        if (((ShapeDispatcher)((Object)this)).isAnimPPTEnabled) {
            Whiteboard whiteboard;
            ((ShapeDispatcher)((Object)this)).whiteboard = whiteboard = ((ShapeDispatcher)((Object)this)).whiteboardList.get(0);
            String string3 = lPResRoomShapeDelModel.docId;
            if (string3 == null || !string3.equals(whiteboard.getDocId()) || lPResRoomShapeDelModel.page != ((ShapeDispatcher)((Object)this)).whiteboard.getPage()) return;
            ((ShapeDispatcher)((Object)this)).whiteboard.onShapeClear();
            return;
        }
        for (Whiteboard whiteboard : ((ShapeDispatcher)((Object)this)).whiteboardList) {
            if (TextUtils.isEmpty((CharSequence)whiteboard.getDocId()) || !whiteboard.getDocId().equals(lPResRoomShapeDelModel.docId) || whiteboard.getPage() != lPResRoomShapeDelModel.page) continue;
            whiteboard.onShapeClear();
            return;
        }
    }

    @Override
    public void deleteAllShape(LPMockClearCacheModel lPMockClearCacheModel) {
        if (((ShapeDispatcher)((Object)iterator)).whiteboardList.isEmpty()) {
            return;
        }
        if (!((ShapeDispatcher)((Object)iterator)).isAnimPPTEnabled) {
            Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
            while (iterator.hasNext()) {
                ((Whiteboard)iterator.next()).onShapeClear();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteShape(LPResRoomShapeDelModel lPResRoomShapeDelModel) {
        if (((ShapeDispatcher)((Object)whiteboard2)).whiteboardList.isEmpty()) {
            return;
        }
        if (((ShapeDispatcher)((Object)whiteboard2)).isInSbbMode) {
            for (Whiteboard whiteboard : ((ShapeDispatcher)((Object)whiteboard2)).whiteboardList) {
                String string2 = lPResRoomShapeDelModel.layer + "_" + lPResRoomShapeDelModel.docId;
                if (TextUtils.isEmpty((CharSequence)whiteboard.getDocId()) || !whiteboard.getDocId().equals(string2) || whiteboard.getPage() != lPResRoomShapeDelModel.page) continue;
                super.deleteShape(whiteboard, lPResRoomShapeDelModel.shapeId);
                return;
            }
            return;
        }
        if (((ShapeDispatcher)((Object)whiteboard2)).isAnimPPTEnabled) {
            Whiteboard whiteboard;
            ((ShapeDispatcher)((Object)whiteboard2)).whiteboard = whiteboard = ((ShapeDispatcher)((Object)whiteboard2)).whiteboardList.get(0);
            String string3 = lPResRoomShapeDelModel.docId;
            if (string3 == null || !string3.equals(whiteboard.getDocId()) || lPResRoomShapeDelModel.page != ((ShapeDispatcher)((Object)whiteboard2)).whiteboard.getPage()) return;
            ShapeDispatcher shapeDispatcher = whiteboard2;
            Whiteboard whiteboard2 = ((ShapeDispatcher)((Object)whiteboard2)).whiteboard;
            shapeDispatcher.deleteShape(whiteboard2, lPResRoomShapeDelModel.shapeId);
            return;
        }
        for (Whiteboard whiteboard : ((ShapeDispatcher)((Object)whiteboard2)).whiteboardList) {
            if (TextUtils.isEmpty((CharSequence)whiteboard.getDocId()) || !whiteboard.getDocId().equals(lPResRoomShapeDelModel.docId) || whiteboard.getPage() != lPResRoomShapeDelModel.page) continue;
            ((ShapeDispatcher)((Object)whiteboard2)).deleteShape(whiteboard, lPResRoomShapeDelModel.shapeId);
            return;
        }
    }

    @Override
    public void drawAllShape(LPResRoomShapeMultipleModel iterator) {
        ArrayList arrayList;
        Object object = ((LPResRoomShapeMultipleModel)((Object)iterator)).docId;
        if (this.isInSbbMode) {
            object = ((LPResRoomModel)((Object)iterator)).layer + "_" + (String)object;
        }
        if (!this.checkWbStatus((String)object, ((LPResRoomShapeMultipleModel)((Object)iterator)).page)) {
            return;
        }
        object = arrayList;
        arrayList = new ArrayList();
        if (this.whiteboard.getCurrentWidth() == 0) {
            ShapeDispatcher shapeDispatcher = this;
            shapeDispatcher.whiteboard.setShapeModels(((LPResRoomShapeMultipleModel)((Object)iterator)).shapeList);
            shapeDispatcher.whiteboard.onShapeModelAppend(((LPResRoomShapeMultipleModel)((Object)iterator)).shapeAppendList);
        } else {
            Object object2 = ((LPResRoomShapeMultipleModel)((Object)iterator)).shapeList;
            if (object2 != null) {
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    Object object3 = (LPShapeModel)((Object)object2.next());
                    ShapeDispatcher shapeDispatcher = this;
                    int n2 = shapeDispatcher.whiteboard.getCurrentHeight();
                    int n3 = shapeDispatcher.whiteboard.getOffsetWidth();
                    int n4 = shapeDispatcher.whiteboard.getOffsetHeight();
                    Shape shape = LPShapeConverter.getShapeFromModel(object3, this.whiteboard.getCurrentWidth(), n2, n3, n4);
                    if (shape == null) continue;
                    if (shape instanceof DoodleShape) {
                        ((DoodleShape)shape).isEnd = true;
                    } else if (shape instanceof BitmapShape && this.isInSbbMode) {
                        LPShapeModel lPShapeModel = object3;
                        object3 = (BitmapShape)shape;
                        this.loadBitmapShape((BitmapShape)object3, lPShapeModel.url);
                    }
                    ((ArrayList)object).add(shape);
                }
                this.whiteboard.onShapeAll((List<Shape>)object);
            }
            if ((iterator = ((LPResRoomShapeMultipleModel)((Object)iterator)).shapeAppendList) != null) {
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    object = (LPShapeModel)((Object)iterator.next());
                    ShapeDispatcher shapeDispatcher = this;
                    int n5 = shapeDispatcher.whiteboard.getCurrentHeight();
                    int n6 = shapeDispatcher.whiteboard.getOffsetWidth();
                    int n7 = shapeDispatcher.whiteboard.getOffsetHeight();
                    object2 = LPShapeConverter.getShapeFromModel((LPShapeModel)((Object)object), this.whiteboard.getCurrentWidth(), n5, n6, n7);
                    if (object2 == null) continue;
                    Object object4 = object;
                    object = (DoodleShape)object2;
                    this.whiteboard.onShapeAppend((DoodleShape)object, ((LPShapeModel)((Object)object4)).smooth);
                }
            }
        }
    }

    @Override
    public void appendShape(LPResRoomShapeSingleModel lPResRoomShapeSingleModel) {
        String string2 = lPResRoomShapeSingleModel.docId;
        if (this.isInSbbMode) {
            string2 = lPResRoomShapeSingleModel.layer + "_" + string2;
        }
        if (!this.checkWbStatus(string2, lPResRoomShapeSingleModel.page)) {
            return;
        }
        if (this.whiteboard.getCurrentWidth() == 0) {
            this.whiteboard.onShapeModelAppend(lPResRoomShapeSingleModel.shape);
        } else {
            ShapeDispatcher shapeDispatcher = this;
            int n2 = shapeDispatcher.whiteboard.getCurrentHeight();
            int n3 = shapeDispatcher.whiteboard.getOffsetWidth();
            int n4 = shapeDispatcher.whiteboard.getOffsetHeight();
            Shape shape = LPShapeConverter.getShapeFromModel(lPResRoomShapeSingleModel.shape, this.whiteboard.getCurrentWidth(), n2, n3, n4);
            if (shape != null) {
                this.whiteboard.onShapeAppend((DoodleShape)shape, lPResRoomShapeSingleModel.shape.smooth);
            }
        }
    }

    public void setCustomShapeType(LPConstants.ShapeType shapeType) {
        List<Whiteboard> list;
        if (!((ShapeDispatcher)((Object)iterator)).isAnimPPTEnabled && (list = ((ShapeDispatcher)((Object)iterator)).whiteboardList) != null && !list.isEmpty() && shapeType != null) {
            Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
            while (iterator.hasNext()) {
                ((Whiteboard)iterator.next()).setCustomShapeType(shapeType);
            }
            return;
        }
    }

    public void setPPTEditMode(LPConstants.PPTEditMode pPTEditMode) {
        List<Whiteboard> list;
        if (!((ShapeDispatcher)((Object)iterator)).isAnimPPTEnabled && (list = ((ShapeDispatcher)((Object)iterator)).whiteboardList) != null && !list.isEmpty()) {
            Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
            while (iterator.hasNext()) {
                ((Whiteboard)iterator.next()).setPPTEditMode(pPTEditMode);
            }
            return;
        }
    }

    public String eraseShapes(String string2, int n2) {
        int n3 = this.getPageIndex(string2, n2);
        if (n3 >= 0 && this.whiteboardList.get(n3) != null) {
            return this.whiteboardList.get(n3).eraseShapes();
        }
        return "";
    }

    public String eraseFilterShapes(String string2, int n2, LPConstants.LPUserType ... lPUserTypeArray) {
        int n3 = this.getPageIndex(string2, n2);
        if (n3 >= 0 && this.whiteboardList.get(n3) != null) {
            return this.whiteboardList.get(n3).eraseFilterShapes(lPUserTypeArray);
        }
        return "";
    }

    public void changePPTFlipEnable(boolean bl) {
        List<Whiteboard> list;
        if (!((ShapeDispatcher)((Object)iterator)).isAnimPPTEnabled && (list = ((ShapeDispatcher)((Object)iterator)).whiteboardList) != null && !list.isEmpty()) {
            Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
            while (iterator.hasNext()) {
                ((Whiteboard)iterator.next()).setFlipEnable(bl);
            }
            return;
        }
    }

    public void setPaintTextSize(int n2) {
        if (((ShapeDispatcher)((Object)iterator)).whiteboardList.isEmpty()) {
            return;
        }
        Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
        while (iterator.hasNext()) {
            ((WhiteboardView)((Whiteboard)iterator.next())).setPaintTextSize(n2);
        }
    }

    public void setCustomShapeStrokeWidth(float f2) {
        if (((ShapeDispatcher)((Object)iterator)).whiteboardList.isEmpty()) {
            return;
        }
        Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
        while (iterator.hasNext()) {
            ((WhiteboardView)((Whiteboard)iterator.next())).setCustomShapeStrokeWidth(f2);
        }
    }

    public boolean isShapeListEmpty(String string2, int n2) {
        int n3 = this.getPageIndex(string2, n2);
        if (n3 >= 0 && this.whiteboardList.get(n3) != null) {
            return this.whiteboardList.get(n3).isShapeListEmpty();
        }
        return false;
    }

    public void setPPTShowWay(LPConstants.LPPPTShowWay lPPPTShowWay) {
        if (lPPPTShowWay != null && !((ShapeDispatcher)((Object)iterator)).whiteboardList.isEmpty()) {
            Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
            while (iterator.hasNext()) {
                ((Whiteboard)iterator.next()).setPPTShowWay(lPPPTShowWay);
            }
            return;
        }
    }

    public void setTouchAble(boolean bl) {
        if (((ShapeDispatcher)((Object)iterator)).whiteboardList.isEmpty()) {
            return;
        }
        Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
        while (iterator.hasNext()) {
            ((Whiteboard)iterator.next()).setTouchAble(bl);
        }
    }

    public void setOnViewTapListener(OnViewTapListener onViewTapListener) {
        if (onViewTapListener != null && !((ShapeDispatcher)((Object)iterator)).whiteboardList.isEmpty()) {
            Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
            while (iterator.hasNext()) {
                ((Whiteboard)iterator.next()).setOnViewTapListener(onViewTapListener);
            }
            return;
        }
    }

    public void setOnDoubleTapListener(OnDoubleTapListener2 onDoubleTapListener2) {
        if (onDoubleTapListener2 != null && !((ShapeDispatcher)((Object)iterator)).whiteboardList.isEmpty()) {
            Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
            while (iterator.hasNext()) {
                ((Whiteboard)iterator.next()).setOnDoubleTapListener(onDoubleTapListener2);
            }
            return;
        }
    }

    public void setDoubleTapScaleEnable(boolean bl) {
        if (((ShapeDispatcher)((Object)iterator)).whiteboardList.isEmpty()) {
            return;
        }
        Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
        while (iterator.hasNext()) {
            ((Whiteboard)iterator.next()).setDoubleTapScaleEnable(bl);
        }
    }

    public void setZoomable(boolean bl) {
        if (((ShapeDispatcher)((Object)iterator)).whiteboardList.isEmpty()) {
            return;
        }
        Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
        while (iterator.hasNext()) {
            ((Whiteboard)iterator.next()).setZoomable(bl);
        }
    }

    public void setShapeStrokeWidth(float f2) {
        if (((ShapeDispatcher)((Object)iterator)).whiteboardList.isEmpty()) {
            return;
        }
        Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
        while (iterator.hasNext()) {
            ((WhiteboardView)((Whiteboard)iterator.next())).setShapeStrokeWidth(f2);
        }
    }

    public void sendDrawTextConfirmed(String string2, String string3) {
        if (((ShapeDispatcher)((Object)iterator)).whiteboardList.isEmpty()) {
            return;
        }
        Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
        while (iterator.hasNext()) {
            ((WhiteboardView)((Whiteboard)iterator.next())).sendDrawTextConfirmed(string2, string3);
        }
    }

    public void invalidateCurrentPage() {
        if (((ShapeDispatcher)((Object)iterator)).whiteboardList.isEmpty()) {
            return;
        }
        Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
        while (iterator.hasNext()) {
            ((WhiteboardView)((Whiteboard)iterator.next())).invalidateTextBoundary();
        }
    }

    public void setPaintColor(int n2) {
        if (((ShapeDispatcher)((Object)iterator)).whiteboardList.isEmpty()) {
            return;
        }
        Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
        while (iterator.hasNext()) {
            ((WhiteboardView)((Whiteboard)iterator.next())).setShapeColor(n2);
        }
    }

    public void setWhiteboardWidthAndHeight(int n2, int n3) {
        for (Whiteboard whiteboard : ((ShapeDispatcher)this).whiteboardList) {
            ((WhiteboardView)whiteboard).setRealWidthHeight(n2, n3);
            whiteboard.resetDisplayRec(n2, n3);
        }
    }

    public void setPPTAuth(boolean bl) {
        Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
        while (iterator.hasNext()) {
            ((Whiteboard)iterator.next()).setPPTAuth(bl);
        }
    }

    public void setIsInSbbMode(boolean bl) {
        this.isInSbbMode = bl;
    }

    public void setShowPaintOwnerEnable(boolean bl) {
        ((ShapeDispatcher)((Object)iterator)).isShowPaintOwnerEnable = bl;
        Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
        while (iterator.hasNext()) {
            ((Whiteboard)iterator.next()).setShowPaintOwnerEnable(bl);
        }
    }

    public void forceTouchEnd() {
        Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
        while (iterator.hasNext()) {
            ((WhiteboardView)((Whiteboard)iterator.next())).touchEnd();
        }
    }

    public void onZXYBMotionEvent(String string2, int n2, LPMotionEvent lPMotionEvent) {
        for (Whiteboard whiteboard : ((ShapeDispatcher)this).whiteboardList) {
            if (!string2.equals(whiteboard.getDocId()) || n2 != whiteboard.getPage()) continue;
            ((WhiteboardView)whiteboard).onTouchEvent(lPMotionEvent);
            break;
        }
    }

    public void syncZoomAndScroll() {
        List<Whiteboard> list = ((ShapeDispatcher)((Object)iterator)).whiteboardList;
        if (list != null && !list.isEmpty()) {
            Iterator<Whiteboard> iterator = ((ShapeDispatcher)((Object)iterator)).whiteboardList.iterator();
            while (iterator.hasNext()) {
                ((Whiteboard)iterator.next()).syncZoomAndScroll();
            }
        }
    }

    public void syncZoomAndScroll(LPDocExtraModel lPDocExtraModel) {
        List<Whiteboard> object2 = ((ShapeDispatcher)this).whiteboardList;
        if (object2 != null && !object2.isEmpty()) {
            for (Whiteboard whiteboard : ((ShapeDispatcher)this).whiteboardList) {
                if (!TextUtils.equals((CharSequence)whiteboard.getDocId(), (CharSequence)lPDocExtraModel.docId)) continue;
                whiteboard.syncZoomAndScroll(lPDocExtraModel);
            }
        }
    }

    public void onDestroy() {
        List<Whiteboard> list = this.whiteboard;
        if (list != null) {
            list.destroy();
        }
        this.whiteboard = null;
        list = this.whiteboardList;
        if (list != null && !list.isEmpty()) {
            list = this.whiteboardList.iterator();
            while (list.hasNext()) {
                list.next().destroy();
            }
            this.whiteboardList.clear();
        }
    }
}

