/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.network;

import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.livebase.context.LPError;
import com.baijiayun.livebase.models.LPIpAddress;
import com.baijiayun.livebase.network.BJYWSServer;
import com.baijiayun.livebase.network.alilog.AliYunLogHelper;
import com.baijiayun.livecore.utils.LPJsonUtils;
import com.baijiayun.network.OkHttpClientSingleton;
import com.baijiayun.network.webscoket.BJMessageBody;
import com.baijiayun.network.webscoket.BJNetworkClientListener;
import com.baijiayun.network.webscoket.BJNetworkClientState;
import com.baijiayun.network.webscoket.BJWebSocketClient;
import com.baijiayun.network.webscoket.IBJNetworkClient;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class LPWSServer
extends BJYWSServer
implements BJNetworkClientListener {
    private static final int PING_INTERVAL = 5;
    private static final int TIME_OUT = 10;
    private static final String LOG_USE = " use ";
    public List<LPIpAddress> backupIpAddrs;
    public int backupIndex = -1;
    public int reconnectCount = 0;
    public IBJNetworkClient wsClient;
    public PublishSubject<LPError> subjectOfFailure;

    public LPWSServer() {
        this(null);
    }

    public LPWSServer(String string2) {
        this(string2, 0);
    }

    public LPWSServer(String string2, int n2) {
        this(string2, n2, null);
    }

    public LPWSServer(String string2, List<LPIpAddress> list) {
        this(string2, 0, list);
    }

    public LPWSServer(String string2, int n2, List<LPIpAddress> list) {
        this.wsClient = this.createWSClient(string2, n2);
        this.setBackupIpAddrs(list);
        this.gson = LPJsonUtils.gson;
    }

    private IBJNetworkClient createWSClient(String string2, int n2) {
        TimeUnit timeUnit = TimeUnit.SECONDS;
        this.wsClient = new BJWebSocketClient(string2, OkHttpClientSingleton.getInstance().newBuilder().pingInterval(5L, timeUnit).readTimeout(10L, timeUnit).writeTimeout(10L, timeUnit).connectTimeout(10L, timeUnit).build());
        this.wsClient.setLogLevel(BJWebSocketClient.LogLevel.None);
        if (n2 == 0) {
            this.wsClient.setAddress("wss://" + string2);
        } else {
            this.wsClient.setAddress("wss://" + string2 + ":" + n2);
        }
        LPWSServer lPWSServer = this;
        lPWSServer.wsClient.setListener((BJNetworkClientListener)this);
        return lPWSServer.wsClient;
    }

    public void setClientName(String string2) {
        this.wsClient.setClientName(string2);
    }

    public void onReconnect(IBJNetworkClient iBJNetworkClient) {
        this.wsClient.disconnect();
    }

    public void onSentMessageFailure(IBJNetworkClient iBJNetworkClient, BJMessageBody bJMessageBody) {
        AliYunLogHelper.getInstance().addErrorLog(this.getWSServerName() + " \u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a " + bJMessageBody.getContent());
    }

    public void onMessage(IBJNetworkClient iBJNetworkClient, String string2) {
        super.onMessage(iBJNetworkClient, LPJsonUtils.toJsonObject(string2));
        String string3 = LPJsonUtils.toJsonObject(string2).get("message_type").getAsString();
        if (!("heart_beat".equals(string3) || string3.contains("user") || string3.contains("shape"))) {
            LPLogger.d((String)"LPWSServer", (String)((String)string3 + "::" + string2));
        }
    }

    public void onStateChanged(IBJNetworkClient iBJNetworkClient, BJNetworkClientState bJNetworkClientState) {
        LPLogger.e((String)"LPWSServer", (String)("onStateChanged " + this.getWSServerName() + ", " + bJNetworkClientState.name()));
        if (bJNetworkClientState == BJNetworkClientState.Connected) {
            this.reset();
        }
    }

    public PublishSubject<LPError> getSubjectOfFailure() {
        if (this.subjectOfFailure == null) {
            this.subjectOfFailure = PublishSubject.create();
        }
        return this.subjectOfFailure;
    }

    public void emitFailure(LPError lPError) {
        AliYunLogHelper.getInstance().addErrorLog("LPRoomServer \u8fde\u63a5\u5931\u8d25  " + lPError.getMessage());
        this.getSubjectOfFailure().onNext((Object)lPError);
    }

    public BJNetworkClientState getWSConnectionState() {
        return this.wsClient.getState();
    }

    public void setBackupIpAddrs(List<LPIpAddress> arrayList) {
        if (arrayList != null) {
            ArrayList<LPIpAddress> arrayList2;
            ArrayList<LPIpAddress> arrayList3 = arrayList2;
            arrayList2 = new ArrayList<LPIpAddress>(arrayList);
            this.backupIpAddrs = arrayList3;
        } else {
            ArrayList<LPIpAddress> arrayList4;
            arrayList = arrayList4;
            arrayList4 = new ArrayList<LPIpAddress>();
            this.backupIpAddrs = arrayList;
        }
        this.backupIndex = -1;
    }

    public void setAddress(LPIpAddress lPIpAddress) {
        this.wsClient.setAddress(lPIpAddress.url);
    }

    public void connect() {
        LPWSServer lPWSServer = this;
        lPWSServer.wsClient.setAddress(this.getCurrentIpAddress());
        lPWSServer.wsClient.connect();
        AliYunLogHelper.getInstance().addDebugLog(this.getWSServerName() + LOG_USE + " connect " + this.getCurrentIpAddress());
    }

    public void disconnect() {
        this.wsClient.disconnect();
    }

    public String getCurrentIpAddress() {
        int n2;
        if (!this.backupIpAddrs.isEmpty() && (n2 = this.backupIndex) >= 0) {
            return this.backupIpAddrs.get((int)n2).url;
        }
        return this.wsClient.getAddress();
    }

    public void sendLoginRequest(String string2) {
        this.wsClient.sendMessage(string2);
    }

    public abstract String getWSServerName();

    public void reset() {
        LPWSServer lPWSServer = this;
        lPWSServer.backupIndex = -1;
        lPWSServer.reconnectCount = 0;
    }

    public boolean isImportantMessage(String string2) {
        return !"heart_beat".equals(string2) && !"user_count_change".equals(string2);
    }
}

