/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.models;

import android.text.TextUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPDataModel;
import com.baijiayun.livebase.models.LPMessageDataModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.LPChatMessageParser;
import com.baijiayun.livecore.models.LPMessageAtUserModel;
import com.baijiayun.livecore.models.LPMessageReferenceModel;
import com.baijiayun.livecore.models.LPMessageUserModel;
import com.baijiayun.livecore.models.imodels.IMessageModel;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.List;

public class LPMessageModel
extends LPDataModel
implements IMessageModel {
    @SerializedName(value="message_type")
    public String messageType;
    @SerializedName(value="id")
    public String id;
    @SerializedName(value="timestamp", alternate={"time"})
    public Date newTime;
    @SerializedName(value="content")
    public String content;
    public LPMessageDataModel data;
    @SerializedName(value="from")
    public LPMessageUserModel from;
    @SerializedName(value="to_user")
    public LPMessageUserModel toUser;
    @SerializedName(value="reference")
    public LPMessageReferenceModel reference;
    @SerializedName(value="at")
    public List<LPMessageAtUserModel> atUserList;
    public String to;
    public String fromUserId;
    public String channel;
    public LPConstants.MessageType type;
    public String url;
    public String key;
    public double alpha = 1.0;
    public String translateLanguage = "";
    @SerializedName(value="is_virtual")
    public boolean isVirtual;
    @SerializedName(value="user_number")
    public String userNumber;
    @SerializedName(value="state", alternate={"wall_state"})
    public int state;

    public LPMessageModel() {
    }

    public LPMessageModel(String string2) {
        this.id = string2;
    }

    public LPMessageModel(String string2, String string3, String string4) {
        this.id = string2;
        this.content = string3;
        this.fromUserId = string4;
    }

    public void parse(LPChatMessageParser object) {
        LPChatMessageParser lPChatMessageParser = object;
        lPChatMessageParser.parseMessage(this.content);
        int n2 = lPChatMessageParser.getType();
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    this.type = LPConstants.MessageType.Text;
                } else {
                    this.type = LPConstants.MessageType.Image;
                    this.url = object.getUrl();
                }
            } else {
                this.type = LPConstants.MessageType.EmojiWithName;
                this.key = object.getKey();
                this.url = object.getUrl();
            }
        } else {
            this.type = LPConstants.MessageType.Emoji;
            this.key = object.getKey();
            this.url = object.getUrl();
        }
        object = this.data;
        if (object != null) {
            if ("emoji".equals(object.type)) {
                this.type = LPConstants.MessageType.Emoji;
            } else if ("image".equals(this.data.type)) {
                this.type = LPConstants.MessageType.Image;
            } else {
                if (!"reward-gift".equals(this.data.type) && !"reward-cash".equals(this.data.type)) {
                    return;
                }
                this.type = LPConstants.MessageType.Reward;
            }
            object = TextUtils.isEmpty((CharSequence)this.data.url) ? this.url : this.data.url;
            this.url = object;
            this.key = this.data.key;
        }
    }

    @Override
    public String getContent() {
        Object object = ((LPMessageModel)object).content;
        if (object == null) {
            object = "";
        }
        return object;
    }

    public void setContent(String string2) {
        this.content = string2;
    }

    public LPMessageUserModel getFrom() {
        return this.from;
    }

    @Override
    public String getTo() {
        return this.to;
    }

    @Override
    public IUserModel getToUser() {
        return this.toUser;
    }

    public void setFrom(LPMessageUserModel lPMessageUserModel) {
        this.from = lPMessageUserModel;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    public void setId(String string2) {
        this.id = string2;
    }

    @Override
    public LPConstants.MessageType getMessageType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setMessageType(String string2) {
        this.messageType = string2;
    }

    @Override
    public Date getTimestamp() {
        return this.newTime;
    }

    @Override
    public boolean isPrivateChat() {
        String string2 = ((LPMessageModel)((Object)string2)).to;
        return string2 != null && !"-1".equals(string2);
    }

    @Override
    public LPMessageDataModel getData() {
        return this.data;
    }

    @Override
    public List<LPMessageAtUserModel> getAtUserList() {
        return this.atUserList;
    }

    @Override
    public void setWallState(int n2) {
        this.state = n2;
    }

    @Override
    public int getWallState() {
        return this.state;
    }

    public void setTimestamp(Date date) {
        this.newTime = date;
    }

    @Override
    public LPMessageReferenceModel getReference() {
        return this.reference;
    }

    public void setReference(LPMessageReferenceModel lPMessageReferenceModel) {
        this.reference = lPMessageReferenceModel;
    }
}

