/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.ppt.whiteboard.shape;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import com.baijiayun.livecore.models.LPPointF;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.ppt.whiteboard.shape.ShapeRegionInfo;
import java.util.ArrayList;

public class TextShape
extends Shape {
    private String mText;
    private final TextPaint textPaint;
    private float textSize;
    private boolean isFontWeight = false;
    private boolean isFontItalic = false;
    private float width;
    private float height;
    private float minWidth;
    private float minHeight;
    private float maxLineWidth;
    private IOnTextShapeChangeLister mOnShapeChangeListener;
    private final float[] mPoints = new float[2];
    public StaticLayout layout;

    public TextShape(Paint paint) {
        super(paint);
        TextPaint textPaint;
        TextShape textShape = textPaint;
        v1.textPaint = new TextPaint(paint);
        v1.textSize = textShape.getTextSize();
    }

    public String getText() {
        return this.mText;
    }

    public void setText(String string2) {
        this.mText = string2;
    }

    public void setTextSize(int n2) {
        float f2;
        this.textSize = f2 = (float)n2;
        this.textPaint.setTextSize(f2);
    }

    public void setMaxLineWidth(float f2) {
        this.maxLineWidth = Math.max(f2, this.textSize);
    }

    public void setOnShapeChangeListener(IOnTextShapeChangeLister iOnTextShapeChangeLister) {
        this.mOnShapeChangeListener = iOnTextShapeChangeLister;
    }

    public float getMaxLineWidth() {
        return this.maxLineWidth;
    }

    public void setTextBold(boolean bl) {
        this.isFontWeight = bl;
    }

    public void setTextItalic(boolean bl) {
        this.isFontItalic = bl;
    }

    public boolean getFontWeight() {
        return this.isFontWeight;
    }

    public boolean getFontItalic() {
        return this.isFontItalic;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void appendPoint(LPPointF lPPointF) {
    }

    @Override
    public ArrayList<LPPointF> getPoints() {
        return null;
    }

    @Override
    public void copyShape(Shape shape) {
        TextShape textShape = textShape2;
        TextShape textShape2 = (TextShape)shape;
        textShape.mText = textShape2.getText();
        textShape.isFontItalic = textShape2.getFontItalic();
        textShape.isFontWeight = textShape2.getFontWeight();
        textShape.maxLineWidth = textShape2.getMaxLineWidth();
    }

    @Override
    public void onDraw(Canvas canvas, Matrix matrix) {
        this.onDraw(canvas, matrix, null);
    }

    @Override
    public void onDraw(Canvas canvas, Matrix object, ShapeRegionInfo object2) {
        float f2;
        if (this.mText == null) {
            return;
        }
        TextShape textShape = this;
        float[] fArray = new float[10];
        object.getValues(fArray);
        float f3 = fArray[0];
        float f4 = fArray[4];
        float f5 = fArray[2];
        float f6 = fArray[5];
        textShape.textPaint.setTextSize(this.textSize * f3);
        textShape.textPaint.setFakeBoldText(this.isFontWeight);
        textShape.textPaint.setStyle(Paint.Style.FILL);
        if (textShape.isFontItalic) {
            this.textPaint.setTypeface(Typeface.create((Typeface)Typeface.SANS_SERIF, (int)2));
        } else {
            this.textPaint.setTypeface(Typeface.SANS_SERIF);
        }
        float f7 = this.maxLineWidth;
        if (f2 <= 0.0f) {
            f7 = 2.1474836E9f;
        }
        int n2 = Math.abs((int)(f7 * f3));
        if (Build.VERSION.SDK_INT >= 23) {
            String string2 = this.mText;
            int n3 = string2.length();
            TextPaint textPaint = this.textPaint;
            this.layout = StaticLayout.Builder.obtain((CharSequence)string2, (int)0, (int)n3, (TextPaint)textPaint, (int)n2).build();
        } else {
            StaticLayout staticLayout;
            StaticLayout staticLayout2 = staticLayout;
            TextShape textShape2 = this;
            String string3 = textShape2.mText;
            Layout.Alignment alignment = Layout.Alignment.ALIGN_NORMAL;
            staticLayout = new StaticLayout((CharSequence)string3, textShape2.textPaint, n2, alignment, 1.0f, 0.0f, false);
            this.layout = staticLayout2;
        }
        Matrix matrix = object;
        canvas.save();
        float[] fArray2 = new float[2];
        object = fArray2;
        LPPointF lPPointF = this.mSourcePoint;
        object[0] = (Matrix)lPPointF.x;
        fArray2[1] = lPPointF.y;
        matrix.mapPoints((float[])object);
        this.mPoints[0] = (float)object[0];
        this.mPoints[1] = (float)object[1];
        if (object2 != null) {
            float f8 = ((ShapeRegionInfo)object2).left + f5;
            ShapeRegionInfo shapeRegionInfo = object2;
            float f9 = shapeRegionInfo.top + f6;
            float f10 = shapeRegionInfo.right + f5;
            f5 = shapeRegionInfo.bottom + f6;
            canvas.clipRect(f8, f9, f10, f5);
        }
        TextShape textShape3 = this;
        float f11 = this.mPoints[0];
        canvas.translate(f11, this.mPoints[1]);
        this.layout.draw(canvas);
        canvas.restore();
        textShape3.width = Math.min(textShape3.textPaint.measureText(this.mText), (float)this.layout.getWidth());
        textShape3.height = textShape3.layout.getHeight();
        textShape3.minWidth = textShape3.width / f3;
        textShape3.minHeight = f11 = (float)textShape3.layout.getHeight() / f4;
        object2 = textShape3.mOnShapeChangeListener;
        if (object2 != null) {
            object2.onTextShapeChange(canvas, this.minWidth, f11);
            this.mOnShapeChangeListener = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInBoundary(float f2, float f3) {
        float f4;
        float f5;
        float[] fArray = this.mPoints;
        float f6 = this.mPoints[0];
        if (!(f5 <= f2)) return false;
        if (!(f2 <= this.width + f6)) return false;
        f2 = fArray[1];
        if (!(f3 >= f4)) return false;
        if (!(f3 <= this.height + f2)) return false;
        return true;
    }

    @Override
    public boolean isTouchShape(float f2, float f3) {
        return true;
    }

    @Override
    public RectF getBoundary() {
        float f2;
        RectF rectF;
        RectF rectF2 = rectF;
        rectF2();
        LPPointF lPPointF = this.mSourcePoint;
        rectF2.left = f2 = lPPointF.x;
        float f3 = lPPointF.y;
        rectF2.bottom = f3 + this.minHeight;
        rectF.right = f2 + this.minWidth;
        rectF.top = f3;
        return rectF;
    }

    @Override
    public void moveShapeBy(float f2, float f3) {
        LPPointF lPPointF = this.mSourcePoint;
        lPPointF.x += f2;
        lPPointF.y += f3;
    }

    @Override
    public void scaleShapeBy(int n2, float f2, float f3, float f4, float f5, RectF rectF, boolean bl) {
    }

    public float getTextSize() {
        return this.textSize;
    }

    @Override
    public boolean isBoundaryOverlap(RectF rectF) {
        float f2;
        float[] fArray = this.mPoints;
        float f3 = this.mPoints[0];
        return !(rectF.right < f3 || rectF.bottom < (f2 = fArray[1]) || this.width + f3 < rectF.left || this.height + f2 < rectF.top);
    }

    @Override
    public void setAngle(float f2) {
        this.rotateAngle = f2;
    }

    public float getTextWidth(float f2) {
        if (this.layout == null) {
            return 0.0f;
        }
        return Math.min(this.textPaint.measureText(this.mText), (float)this.layout.getWidth()) / f2;
    }

    public float getTextHeight(float f2) {
        TextShape textShape = textShape.layout;
        if (textShape == null) {
            return 0.0f;
        }
        return (float)textShape.getHeight() / f2;
    }

    public static interface IOnTextShapeChangeLister {
        public void onTextShapeChange(Canvas var1, float var2, float var3);
    }
}

