/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.ppt.whiteboard.shape;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import androidx.annotation.Nullable;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livecore.models.LPPointF;
import com.baijiayun.livecore.ppt.util.ShapeUtils;
import com.baijiayun.livecore.ppt.whiteboard.shape.ShapeRegionInfo;
import java.util.ArrayList;

public abstract class Shape {
    public String id;
    public String number;
    public Paint mPaint;
    public LPPointF mSourcePoint;
    public boolean hasAddedToPaintList;
    public int dashType = 0;
    public String sendByUserName;
    public String sendByUserNumber;
    public float rotateAngle;
    public boolean isHoverTrace;
    public LPConstants.LPUserType userRole;

    public Shape(Paint paint) {
        if (paint == null) {
            Paint paint2;
            paint = paint2;
            paint2 = new Paint();
            this.mPaint = paint;
        } else {
            Paint paint3;
            Paint paint4 = paint3;
            paint3 = new Paint(paint);
            this.mPaint = paint4;
        }
        Shape shape = this;
        shape.number = ShapeUtils.generateNonceStr();
        shape.mSourcePoint = new LPPointF();
    }

    public void setPaint(Paint paint) {
        this.mPaint = paint;
    }

    public Paint getPaint() {
        return this.mPaint;
    }

    public void setSourcePoint(LPPointF lPPointF) {
        this.mSourcePoint = lPPointF;
    }

    public LPPointF getSourcePoint() {
        return this.mSourcePoint;
    }

    public abstract void onDraw(Canvas var1, Matrix var2);

    public abstract void onDraw(Canvas var1, Matrix var2, ShapeRegionInfo var3);

    public abstract boolean isInBoundary(float var1, float var2);

    public abstract boolean isTouchShape(float var1, float var2);

    public abstract RectF getBoundary();

    public abstract void moveShapeBy(float var1, float var2);

    public abstract void scaleShapeBy(int var1, float var2, float var3, float var4, float var5, @Nullable RectF var6, boolean var7);

    public abstract boolean isBoundaryOverlap(RectF var1);

    public abstract boolean isValid();

    public abstract void appendPoint(LPPointF var1);

    public abstract ArrayList<LPPointF> getPoints();

    public abstract void copyShape(Shape var1);

    public abstract void setAngle(float var1);

    public void copy(Shape shape) {
        this.id = shape.id;
        this.number = shape.number;
        this.mPaint = shape.getPaint();
        this.mSourcePoint = shape.getSourcePoint();
        this.rotateAngle = shape.rotateAngle;
        this.sendByUserName = shape.sendByUserName;
        this.sendByUserNumber = shape.sendByUserNumber;
        this.copyShape(shape);
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public PointF calcRotatePoint(float f2, float f3, float f4, float f5, float f6) {
        float f7 = f2;
        double d2 = (float)((double)f6 * Math.PI / 180.0);
        float f8 = (float)Math.cos(d2);
        f2 = (float)Math.sin(d2);
        float f9 = f7 - f4;
        f2 = f9 * f8 - (f3 -= f5) * f2 + f4;
        f8 = f9 * f2 + f3 * f8 + f5;
        return new PointF(f2, f8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getIn_angle(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f4 - f2;
        f4 = f6 - f2;
        float f9 = f7 - f3;
        float f10 = f8;
        float f11 = f5 -= f3;
        float f12 = f4;
        float f13 = f9;
        int n2 = (int)(Math.acos((double)(f8 * f4 + f5 * f9) / Math.sqrt((Math.abs(f10 * f10) + Math.abs(f11 * f11)) * (Math.abs(f12 * f12) + Math.abs(f13 * f13)))) * 180.0 / Math.PI);
        if (f6 > f2) return n2 % 360;
        if (f6 < f2) {
            if (n2 == 0 && f7 > f3) return 180;
            n2 = 360 - n2;
            return n2 % 360;
        } else {
            if (!(f7 < f3)) return 180;
            return 0;
        }
    }
}

