/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.ppt.whiteboard.shape;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import android.text.TextUtils;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.baijiayun.livecore.LiveSDK;
import com.baijiayun.livecore.models.LPPointF;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.ppt.whiteboard.shape.ShapeRegionInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DoodleShape
extends Shape {
    private ConcurrentLinkedQueue<LPPointF> mPoints;
    public boolean autoClosePath;
    private Paint fillPaint;
    private List<LPPointF> shapeRectList;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private final int TOUCH_RECT_HALF_LENGTH;
    private Path fillPath;
    public int index;
    public boolean isEnd;
    public boolean showCursorBitmap;
    private boolean smooth;
    public long timestamp;
    private float centerPointX;
    private float centerPointY;
    private Bitmap cursorBitmap;
    private PathMeasure pathMeasure;
    private float lastPathLength;
    private float originStrokeWidth;
    private final float MIN_PAINT_WIDTH_RATIO;
    private final float MIN_PATH_MEASURE_DRAW_DISTANCE;
    private final float MAX_LINE_WIDTH_DIFF_TWO_LINES;
    private boolean disableHandWritingStyle;
    private Path drawingPath;
    private Path segmentPath;
    private List<LPPointF> _points;
    private float[] values;

    public DoodleShape(Paint paint, Paint paint2, float f2) {
        DoodleShape doodleShape = this;
        super(paint);
        this.minX = 2.1474836E9f;
        this.minY = 2.1474836E9f;
        this.maxX = -2.1474836E9f;
        this.maxY = 2.1474836E9f;
        this.TOUCH_RECT_HALF_LENGTH = 5;
        this.MIN_PAINT_WIDTH_RATIO = 0.6f;
        this.MIN_PATH_MEASURE_DRAW_DISTANCE = 0.5f;
        this.MAX_LINE_WIDTH_DIFF_TWO_LINES = 0.4f;
        this.disableHandWritingStyle = LiveSDK.DISABLE_DRAWING_DOODLE_IN_HANDWRITING_STYLE;
        this.values = new float[9];
        doodleShape.fillPaint = paint2;
        doodleShape.mPoints = new ConcurrentLinkedQueue();
        doodleShape.shapeRectList = new ArrayList<LPPointF>();
        doodleShape.drawingPath = new Path();
        doodleShape.segmentPath = new Path();
        this.rotateAngle = f2;
        this.timestamp = System.currentTimeMillis();
        this.pathMeasure = new PathMeasure();
        this.originStrokeWidth = this.getPaint().getStrokeWidth();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isVectorInRect(PointF pointF, PointF pointF2, RectF rectF) {
        RectF rectF2 = rectF;
        float f2 = rectF2.left;
        float f3 = rectF2.top;
        float f4 = rectF2.bottom;
        if (this.isVectorCross(pointF, pointF2, f2, f3, f2, f4)) return true;
        RectF rectF3 = rectF;
        f2 = rectF3.left;
        f3 = rectF3.bottom;
        f4 = rectF3.right;
        if (this.isVectorCross(pointF, pointF2, f2, f3, f4, f3)) return true;
        RectF rectF4 = rectF;
        f2 = rectF4.right;
        f3 = rectF4.bottom;
        f4 = rectF4.top;
        if (this.isVectorCross(pointF, pointF2, f2, f3, f2, f4)) return true;
        RectF rectF5 = rectF;
        float f5 = rectF5.right;
        float f6 = rectF5.top;
        float f7 = rectF5.left;
        if (!this.isVectorCross(pointF, pointF2, f5, f6, f7, f6)) return false;
        return true;
    }

    private boolean isVectorCross(PointF pointF, PointF pointF2, float f2, float f3, float f4, float f5) {
        float f6 = pointF.x;
        float f7 = f2 - f6;
        float f8 = pointF.y;
        float f9 = f3 - f8;
        f6 = f4 - f6;
        f8 = f5 - f8;
        float f10 = this.cal(f7, f9, f6, f8);
        f6 = pointF2.x;
        f7 = f2 - f6;
        f8 = pointF2.y;
        f9 = f3 - f8;
        f6 = f4 - f6;
        f8 = f5 - f8;
        float f11 = f10 * this.cal(f7, f9, f6, f8);
        float f12 = pointF.x - f2;
        PointF pointF3 = pointF2;
        f6 = pointF.y - f3;
        f2 = pointF3.x - f2;
        f3 = pointF3.y - f3;
        PointF pointF4 = pointF2;
        float f13 = pointF.y - f5;
        float f14 = pointF4.x - f4;
        float f15 = pointF4.y - f5;
        f13 = this.cal(f12, f6, f2, f3) * this.cal(pointF.x - f4, f13, f14, f15);
        return f11 <= 0.0f && f13 <= 0.0f;
    }

    private float cal(float f2, float f3, float f4, float f5) {
        return f2 * f5 - f4 * f3;
    }

    @Override
    public boolean isValid() {
        return this.mPoints.size() > 0;
    }

    @Override
    public void appendPoint(LPPointF lPPointF) {
        this.mPoints.offer(lPPointF);
    }

    @Override
    public ArrayList<LPPointF> getPoints() {
        return new ArrayList<LPPointF>(this.mPoints);
    }

    @Override
    public void copyShape(Shape shape) {
        DoodleShape doodleShape = doodleShape2;
        DoodleShape doodleShape2 = (DoodleShape)shape;
        doodleShape.fillPaint = doodleShape2.fillPaint;
        doodleShape.smooth = doodleShape2.smooth;
        doodleShape.index = doodleShape2.index;
        doodleShape.isEnd = doodleShape2.isEnd;
        doodleShape.mPoints = new ConcurrentLinkedQueue<LPPointF>(doodleShape2.mPoints);
        doodleShape.originStrokeWidth = doodleShape2.originStrokeWidth;
        doodleShape.disableHandWritingStyle = doodleShape2.disableHandWritingStyle;
    }

    public void setPoints(ArrayList<LPPointF> object) {
        this.mPoints.clear();
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            LPPointF lPPointF = (LPPointF)((Object)object.next());
            this.mPoints.offer(lPPointF);
        }
    }

    @Override
    public void setSourcePoint(LPPointF lPPointF) {
        super.setSourcePoint(lPPointF);
    }

    public void reset() {
        this.mPoints.clear();
    }

    @Override
    public void onDraw(Canvas canvas, Matrix matrix) {
        this.onDraw(canvas, matrix, null);
    }

    @Override
    public void onDraw(Canvas canvas, Matrix object, ShapeRegionInfo shapeRegionInfo) {
        if (this.mPoints.isEmpty()) {
            return;
        }
        DoodleShape doodleShape = this;
        doodleShape._points = new ArrayList<LPPointF>(this.mPoints);
        doodleShape.drawingPath.reset();
        object.getValues(doodleShape.values);
        object = this._points.get(0);
        if (object == null) {
            return;
        }
        DoodleShape doodleShape2 = this;
        canvas.save();
        float f2 = doodleShape2.values[0];
        float f3 = doodleShape2.values[4];
        float f4 = doodleShape2.values[2];
        float f5 = doodleShape2.values[5];
        doodleShape2.minX = 2.1474836E9f;
        doodleShape2.minY = 2.1474836E9f;
        doodleShape2.maxX = -2.1474836E9f;
        doodleShape2.maxY = -2.1474836E9f;
        Iterator<LPPointF> iterator = doodleShape2._points.iterator();
        while (iterator.hasNext()) {
            DoodleShape doodleShape3 = this;
            PointF pointF = iterator.next();
            doodleShape3.minX = Math.min(pointF.x, this.minX);
            doodleShape3.maxX = Math.max(pointF.x, this.maxX);
            doodleShape3.minY = Math.min(pointF.y, this.minY);
            doodleShape3.maxY = Math.max(pointF.y, this.maxY);
        }
        float f6 = f5;
        float f7 = f4;
        DoodleShape doodleShape4 = this;
        DoodleShape doodleShape5 = this;
        float f8 = doodleShape5.minX;
        float f9 = f8 * f2 + f4;
        f4 = doodleShape5.maxX * f2 + f4;
        float f10 = doodleShape5.minY;
        float f11 = f10 * f3 + f5;
        this.centerPointX = f4 = (f4 + f9) / 2.0f;
        doodleShape5.centerPointY = f5 = (doodleShape5.maxY * f3 + f5 + f11) / 2.0f;
        PointF[] pointFArray = new PointF[3];
        PointF[] pointFArray2 = pointFArray;
        DoodleShape doodleShape6 = this;
        DoodleShape doodleShape7 = this;
        float f12 = f8;
        f8 = this.rotateAngle;
        pointFArray2[0] = this.calcRotatePoint(f12, f10, f4, f5, f8);
        f4 = doodleShape7.minX;
        f5 = doodleShape7.centerPointY;
        f8 = doodleShape7.centerPointX;
        f10 = doodleShape7.rotateAngle;
        pointFArray2[1] = doodleShape7.calcRotatePoint(f4, f5, f8, f5, f10);
        f4 = doodleShape6.centerPointX;
        f5 = doodleShape6.minY;
        f8 = doodleShape6.centerPointY;
        f10 = doodleShape6.rotateAngle;
        pointFArray[2] = doodleShape6.calcRotatePoint(f4, f5, f4, f8, f10);
        f4 = doodleShape5.centerPointX;
        canvas.translate(f4, doodleShape5.centerPointY);
        canvas.rotate(this.rotateAngle);
        float f13 = Math.abs(doodleShape4.centerPointX - pointFArray2[1].x);
        f4 = f13 * f13;
        float f14 = Math.abs(doodleShape4.centerPointY - pointFArray2[1].y);
        f5 = f14 * f14;
        double d2 = Math.pow(Math.abs(this.centerPointY - pointFArray2[2].y), 2.0);
        f8 = Math.round(Math.sqrt(f4 + f5) + 0.5);
        float f15 = Math.round(Math.sqrt(Math.pow(Math.abs(doodleShape4.centerPointX - pointFArray2[2].x), 2.0) + d2) + 0.5);
        f5 = -f8;
        canvas.translate(f5, -f15);
        f5 = this.centerPointX - f8;
        f15 = this.centerPointY - f15;
        f8 = f7 - f5;
        float f16 = f6 - f15;
        if (this._points.size() == 1) {
            DoodleShape doodleShape8 = this;
            Object object2 = object;
            float f17 = object2.x * f2 + f8;
            f10 = object2.y * f3 + f16;
            Paint paint = this.getPaint();
            canvas.drawPoint(f17, f10, paint);
            doodleShape8.shapeRectList.add(new LPPointF(object.x * f2 + f8 + f5, object.y * f3 + f16 + f15));
            Bitmap bitmap = doodleShape8.cursorBitmap;
            if (bitmap != null) {
                Bitmap bitmap2 = bitmap;
                Object object3 = object;
                float f18 = object3.x * f2 + f8 - (float)bitmap.getWidth() * 0.5f;
                float f19 = object3.y * f3 + f16 - (float)this.cursorBitmap.getHeight() * 0.5f;
                bitmap = this.getPaint();
                canvas.drawBitmap(bitmap2, f18, f19, (Paint)bitmap);
            }
            canvas.restore();
            return;
        }
        DoodleShape doodleShape9 = this;
        doodleShape9.drawingPath.moveTo(object.x * f2 + f8, object.y * f3 + f16);
        List<LPPointF> list = doodleShape9._points;
        list.add(list.get(list.size() - 1));
        int n2 = 0;
        doodleShape9.lastPathLength = 0.0f;
        f11 = 1.0f;
        float f20 = doodleShape9.getPaint().getStrokeWidth();
        Iterator<LPPointF> iterator2 = doodleShape9._points.iterator();
        while (iterator2.hasNext()) {
            Object object4 = object;
            object = iterator2.next();
            float f21 = object.x * f2 + f8;
            float f22 = object.y * f3 + f16;
            float f23 = object4.x * f2 + f8;
            float f24 = object4.y * f3 + f16;
            if (this.autoClosePath) {
                this.drawingPath.lineTo(f21, f22);
            } else {
                DoodleShape doodleShape10 = this;
                float f25 = (f23 + f21) / 2.0f;
                float f26 = (f24 + f22) / 2.0f;
                doodleShape10.drawingPath.quadTo(f23, f24, f25, f26);
                if (!doodleShape10.disableHandWritingStyle && (Math.sqrt(Math.pow(Math.abs(f23 - f21), 2.0) + Math.pow(Math.abs(f24 - f22), 2.0)) > 0.5 || n2 == this._points.size() - 1)) {
                    DoodleShape doodleShape11 = this;
                    float f27 = f20;
                    DoodleShape doodleShape12 = this;
                    doodleShape12.pathMeasure.setPath(this.drawingPath, false);
                    f20 = doodleShape12.pathMeasure.getLength();
                    f11 = doodleShape12.originStrokeWidth * ((object.lineWidthFactor + f11) / 2.0f + 0.6f);
                    f11 = Math.min(f27 + 0.4f, f11);
                    doodleShape11.getPaint().setStrokeWidth(f11);
                    doodleShape11.segmentPath.reset();
                    DoodleShape doodleShape13 = this;
                    f23 = doodleShape13.lastPathLength;
                    Path path = doodleShape13.segmentPath;
                    doodleShape11.pathMeasure.getSegment(f23, f20, path, true);
                    Path path2 = doodleShape11.segmentPath;
                    canvas.drawPath(path2, doodleShape11.getPaint());
                    this.lastPathLength = f20;
                    float f28 = f20 = object.lineWidthFactor;
                    f20 = f11;
                    f11 = f28;
                }
            }
            if (this.shapeRectList.size() > n2 && this.shapeRectList.get(n2) != null) {
                this.shapeRectList.get(n2).set(f21 += f5, f22 + f15);
            } else {
                LPPointF lPPointF;
                LPPointF lPPointF2 = lPPointF;
                lPPointF = new LPPointF(f21 += f5, f22 + f15);
                this.shapeRectList.add(lPPointF2);
            }
            ++n2;
        }
        if (this.autoClosePath) {
            DoodleShape doodleShape14 = this;
            doodleShape14.drawingPath.close();
            Path path = doodleShape14.drawingPath;
            canvas.drawPath(path, doodleShape14.getPaint());
        } else if (this.disableHandWritingStyle) {
            DoodleShape doodleShape15 = this;
            Path path = doodleShape15.drawingPath;
            canvas.drawPath(path, doodleShape15.getPaint());
        }
        if (shapeRegionInfo != null) {
            ShapeRegionInfo shapeRegionInfo2 = shapeRegionInfo;
            float f29 = shapeRegionInfo2.top + f16;
            float f30 = shapeRegionInfo2.right + f8;
            f5 = shapeRegionInfo2.bottom + f16;
            canvas.clipRect(shapeRegionInfo.left + f8, f29, f30, f5);
        }
        if (this.fillPaint != null && this.autoClosePath) {
            this.fillPath = this.drawingPath;
        }
        if ((shapeRegionInfo = this.cursorBitmap) != null) {
            ShapeRegionInfo shapeRegionInfo3 = shapeRegionInfo;
            Object object5 = object;
            float f31 = object5.x * f2 + f8 - (float)shapeRegionInfo.getWidth() * 0.5f;
            float f32 = object5.y * f3 + f16 - (float)this.cursorBitmap.getHeight() * 0.5f;
            shapeRegionInfo = this.getPaint();
            canvas.drawBitmap((Bitmap)shapeRegionInfo3, f31, f32, (Paint)shapeRegionInfo);
        }
        canvas.restore();
    }

    @Override
    public boolean isInBoundary(float f2, float f3) {
        float f4 = this.maxY;
        if (f4 == -2.1474836E9f) {
            return false;
        }
        return this.minX - 15.0f <= f2 && this.minY - 15.0f <= f3 && this.maxX + 15.0f >= f2 && f4 + 15.0f >= f3;
    }

    @Override
    public boolean isTouchShape(float f2, float f3) {
        float f4;
        if (this.shapeRectList.isEmpty()) {
            return false;
        }
        if (!this.autoClosePath) {
            int n2 = 0;
            while (n2 < this.shapeRectList.size() - 1) {
                PointF pointF = this.shapeRectList.get(n2);
                PointF pointF2 = this.shapeRectList.get(++n2);
                float f5 = Math.min(pointF.x, pointF2.x);
                PointF pointF3 = pointF;
                float f6 = Math.min(pointF3.y, pointF2.y);
                float f7 = Math.max(pointF3.y, pointF2.y);
                if (Math.max(pointF.x, pointF2.x) < f2 - 5.0f || f7 < f3 - 5.0f || f2 + 5.0f < f5 || f3 + 5.0f < f6) continue;
                return true;
            }
            return false;
        }
        if (this.mPoints.size() != 8 && this.mPoints.size() != 11) {
            if (this.fillPath != null) {
                Region region;
                Region region2 = region;
                region2();
                DoodleShape doodleShape = this;
                int n3 = (int)doodleShape.minY;
                int n4 = (int)doodleShape.maxX;
                int n5 = (int)doodleShape.maxY;
                region2.setPath(this.fillPath, new Region((int)this.minX, n3, n4, n5));
                n3 = (int)f2;
                return region.contains(n3, (int)f3);
            }
            for (int i2 = 0; i2 < this.shapeRectList.size(); ++i2) {
                float f8;
                DoodleShape doodleShape = this;
                PointF pointF = doodleShape.shapeRectList.get(i2);
                PointF pointF4 = i2 == doodleShape.shapeRectList.size() - 1 ? (PointF)this.shapeRectList.get(0) : (PointF)this.shapeRectList.get(i2 + 1);
                float f9 = pointF.x;
                float f10 = pointF4.x;
                if (f9 == f10) {
                    f8 = Math.abs(f9 - f2);
                } else {
                    float f11 = pointF.y;
                    float f12 = pointF4.y;
                    if (f11 == f12) {
                        f8 = Math.abs(f11 - f3);
                    } else {
                        float f13 = f12 - f11;
                        float f14 = f11;
                        f11 = f9 - f10;
                        f12 = f10 * f14 - f9 * f12;
                        float f15 = f13;
                        float f16 = f11;
                        f8 = Math.abs(f13 * f2 + f11 * f3 + f12) / (float)Math.sqrt(f15 * f15 + f16 * f16);
                    }
                }
                if (!(f8 <= 5.0f)) continue;
                return true;
            }
            return false;
        }
        float f17 = this.maxX;
        float f18 = this.minX;
        if (f17 == f18) {
            f4 = Math.abs(f17 - f2);
        } else {
            float f19 = this.minY;
            float f20 = this.maxY;
            if (f19 == f20) {
                f4 = Math.abs(f20 - f3);
            } else {
                float f21 = f20 - f19;
                float f22 = f2;
                f2 = f18 - f17;
                f20 = f17 * f19 - f18 * f20;
                float f23 = f21;
                float f24 = f2;
                f4 = Math.abs(f21 * f22 + f2 * f3 + f20) / (float)Math.sqrt(f23 * f23 + f24 * f24);
            }
        }
        return f4 <= 5.0f;
    }

    @Override
    public RectF getBoundary() {
        if (this.maxY == -2.1474836E9f) {
            return null;
        }
        float f2 = 2.1474836E9f;
        float f3 = -2.1474836E9f;
        float f4 = 2.1474836E9f;
        float f5 = -2.1474836E9f;
        Iterator iterator = new ArrayList<LPPointF>(this.mPoints).iterator();
        while (iterator.hasNext()) {
            float f6 = f5;
            float f7 = f3;
            PointF pointF = (PointF)iterator.next();
            f3 = Math.min(f2, pointF.x);
            f4 = Math.min(f4, pointF.y);
            f5 = Math.max(f7, pointF.x);
            f2 = Math.max(f6, pointF.y);
            float f8 = f3;
            float f9 = f5;
            f5 = f2;
            f3 = f9;
            f2 = f8;
        }
        new RectF().left = f2;
        new RectF().top = f4;
        new RectF().right = f3;
        new RectF().bottom = f5;
        return new RectF();
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    @Override
    public void moveShapeBy(float f2, float f3) {
        int n2 = this.mPoints.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            DoodleShape doodleShape = this;
            LPPointF lPPointF = doodleShape.mPoints.poll();
            lPPointF.x += f2;
            lPPointF.y += f3;
            doodleShape.mPoints.offer(lPPointF);
        }
        LPPointF lPPointF = this.mSourcePoint;
        lPPointF.x += f2;
        lPPointF.y += f3;
    }

    @Override
    public void scaleShapeBy(int n2, float f2, float f3, float f4, float f5, RectF rectF, boolean bl) {
        if (rectF == null) {
            rectF = this.getBoundary();
        }
        RectF rectF2 = rectF;
        float f6 = rectF2.left;
        float f7 = rectF2.right;
        float f8 = rectF2.top;
        float f9 = rectF2.bottom;
        switch (n2) {
            default: {
                break;
            }
            case 7: {
                if (f3 < 0.0f) {
                    f3 = -f3;
                    f9 -= rectF.height();
                }
                int n3 = this.mPoints.size();
                float[] fArray = new float[n3 * 2];
                for (int i2 = 0; i2 < n3; ++i2) {
                    float f10;
                    LPPointF lPPointF = this.mPoints.poll();
                    lPPointF.y = f10 = (lPPointF.y - rectF.bottom) * f3 + f9;
                    int n4 = i2 * 2;
                    fArray[n4] = lPPointF.x;
                    fArray[n4 + 1] = f10;
                }
                if (bl) {
                    for (int i3 = 0; i3 < n3; ++i3) {
                        int n5 = i3 * 2;
                        f4 = fArray[n5];
                        this.mPoints.offer(new LPPointF(f4, fArray[n5 + 1]));
                    }
                } else {
                    Matrix matrix;
                    LPPointF lPPointF;
                    LPPointF lPPointF2 = lPPointF;
                    DoodleShape doodleShape = this;
                    float f11 = doodleShape.centerPointX;
                    f4 = f11 - f4 / 2.0f;
                    float f12 = doodleShape.centerPointY;
                    f5 = f12 - f5 / 2.0f;
                    float f13 = doodleShape.rotateAngle;
                    lPPointF = new LPPointF(doodleShape.calcRotatePoint(f4, f5, f11, f12, f13));
                    Matrix matrix2 = matrix;
                    LPPointF lPPointF3 = lPPointF2;
                    DoodleShape doodleShape2 = this;
                    Matrix matrix3 = matrix2;
                    matrix3();
                    matrix3.reset();
                    float f14 = doodleShape2.rotateAngle;
                    float f15 = doodleShape2.centerPointX;
                    f5 = doodleShape2.centerPointY;
                    matrix2.postRotate(f14, f15, f5);
                    f14 = -this.rotateAngle;
                    f15 = lPPointF3.x;
                    f5 = lPPointF3.y;
                    matrix2.postRotate(f14, f15, f5);
                    matrix.mapPoints(fArray);
                    for (int i4 = 0; i4 < n3; ++i4) {
                        int n6 = i4 * 2;
                        f15 = fArray[n6];
                        this.mPoints.offer(new LPPointF(f15, fArray[n6 + 1]));
                    }
                }
                break;
            }
            case 6: {
                float f16 = f2 - 0.0f;
                float f17 = f16 == 0.0f ? 0 : (f16 < 0.0f ? -1 : 1);
                if (f17 < 0 && f3 < 0.0f) {
                    f2 = -f2;
                    f3 = -f3;
                    f6 += rectF.width();
                    f9 -= rectF.height();
                } else if (f17 < 0) {
                    f2 = -f2;
                    f6 += rectF.width();
                } else if (f3 < 0.0f) {
                    f3 = -f3;
                    f9 -= rectF.height();
                }
                int n7 = this.mPoints.size();
                f17 = n7;
                float[] fArray = new float[n7 * 2];
                for (int i5 = 0; i5 < f17; ++i5) {
                    float f18;
                    float f19;
                    LPPointF lPPointF = this.mPoints.poll();
                    lPPointF.x = f19 = (lPPointF.x - rectF.left) * f2 + f6;
                    lPPointF.y = f18 = (lPPointF.y - rectF.bottom) * f3 + f9;
                    int n8 = i5 * 2;
                    fArray[n8] = f19;
                    fArray[n8 + 1] = f18;
                }
                if (bl) {
                    for (int i6 = 0; i6 < f17; ++i6) {
                        int n9 = i6 * 2;
                        f2 = fArray[n9];
                        this.mPoints.offer(new LPPointF(f2, fArray[n9 + 1]));
                    }
                } else {
                    Matrix matrix;
                    LPPointF lPPointF;
                    LPPointF lPPointF4 = lPPointF;
                    DoodleShape doodleShape = this;
                    f2 = doodleShape.centerPointX;
                    f3 = f2 + f4 / 2.0f;
                    f4 = doodleShape.centerPointY;
                    f5 = f4 - f5 / 2.0f;
                    float f20 = doodleShape.rotateAngle;
                    lPPointF = new LPPointF(doodleShape.calcRotatePoint(f3, f5, f2, f4, f20));
                    Matrix matrix4 = matrix;
                    LPPointF lPPointF5 = lPPointF4;
                    DoodleShape doodleShape3 = this;
                    Matrix matrix5 = matrix4;
                    matrix5();
                    matrix5.reset();
                    float f21 = doodleShape3.rotateAngle;
                    float f22 = doodleShape3.centerPointX;
                    f3 = doodleShape3.centerPointY;
                    matrix4.postRotate(f21, f22, f3);
                    f21 = -this.rotateAngle;
                    f22 = lPPointF5.x;
                    f3 = lPPointF5.y;
                    matrix4.postRotate(f21, f22, f3);
                    matrix.mapPoints(fArray);
                    for (int i7 = 0; i7 < f17; ++i7) {
                        int n10 = i7 * 2;
                        f22 = fArray[n10];
                        this.mPoints.offer(new LPPointF(f22, fArray[n10 + 1]));
                    }
                }
                break;
            }
            case 5: {
                if (f2 < 0.0f) {
                    f2 = -f2;
                    f6 += rectF.width();
                }
                int n11 = this.mPoints.size();
                float[] fArray = new float[n11 * 2];
                for (int i8 = 0; i8 < n11; ++i8) {
                    float f23;
                    LPPointF lPPointF = this.mPoints.poll();
                    lPPointF.x = f23 = Math.abs(lPPointF.x - rectF.left) * f2 + f6;
                    int n12 = i8 * 2;
                    fArray[n12] = f23;
                    int n13 = n12 + 1;
                    fArray[n13] = lPPointF.y;
                }
                if (bl) {
                    for (int i9 = 0; i9 < n11; ++i9) {
                        int n14 = i9 * 2;
                        f2 = fArray[n14];
                        this.mPoints.offer(new LPPointF(f2, fArray[n14 + 1]));
                    }
                } else {
                    Matrix matrix;
                    LPPointF lPPointF;
                    LPPointF lPPointF6 = lPPointF;
                    DoodleShape doodleShape = this;
                    f2 = doodleShape.centerPointX;
                    f4 = f2 + f4 / 2.0f;
                    float f24 = doodleShape.centerPointY;
                    f5 = f24 + f5 / 2.0f;
                    float f25 = doodleShape.rotateAngle;
                    lPPointF = new LPPointF(doodleShape.calcRotatePoint(f4, f5, f2, f24, f25));
                    Matrix matrix6 = matrix;
                    LPPointF lPPointF7 = lPPointF6;
                    DoodleShape doodleShape4 = this;
                    Matrix matrix7 = matrix6;
                    matrix7();
                    matrix7.reset();
                    float f26 = doodleShape4.rotateAngle;
                    float f27 = doodleShape4.centerPointX;
                    f4 = doodleShape4.centerPointY;
                    matrix6.postRotate(f26, f27, f4);
                    f26 = -this.rotateAngle;
                    f27 = lPPointF7.x;
                    f4 = lPPointF7.y;
                    matrix6.postRotate(f26, f27, f4);
                    matrix.mapPoints(fArray);
                    for (int i10 = 0; i10 < n11; ++i10) {
                        int n15 = i10 * 2;
                        f27 = fArray[n15];
                        this.mPoints.offer(new LPPointF(f27, fArray[n15 + 1]));
                    }
                }
                break;
            }
            case 4: {
                float f28 = f2 - 0.0f;
                float f29 = f28 == 0.0f ? 0 : (f28 < 0.0f ? -1 : 1);
                if (f29 < 0 && f3 < 0.0f) {
                    f2 = -f2;
                    f3 = -f3;
                    f6 += rectF.width();
                    f8 += rectF.height();
                } else if (f29 < 0) {
                    f2 = -f2;
                    f6 += rectF.width();
                } else if (f3 < 0.0f) {
                    f3 = -f3;
                    f8 += rectF.height();
                }
                int n16 = this.mPoints.size();
                f29 = n16;
                float[] fArray = new float[n16 * 2];
                for (int i11 = 0; i11 < f29; ++i11) {
                    float f30;
                    float f31;
                    LPPointF lPPointF = this.mPoints.poll();
                    lPPointF.x = f31 = (lPPointF.x - rectF.left) * f2 + f6;
                    lPPointF.y = f30 = (lPPointF.y - rectF.top) * f3 + f8;
                    int n17 = i11 * 2;
                    fArray[n17] = f31;
                    fArray[n17 + 1] = f30;
                }
                if (bl) {
                    for (int i12 = 0; i12 < f29; ++i12) {
                        int n18 = i12 * 2;
                        f2 = fArray[n18];
                        this.mPoints.offer(new LPPointF(f2, fArray[n18 + 1]));
                    }
                } else {
                    Matrix matrix;
                    LPPointF lPPointF;
                    LPPointF lPPointF8 = lPPointF;
                    DoodleShape doodleShape = this;
                    f2 = doodleShape.centerPointX;
                    f3 = f2 + f4 / 2.0f;
                    f4 = doodleShape.centerPointY;
                    f5 = f4 + f5 / 2.0f;
                    float f32 = doodleShape.rotateAngle;
                    lPPointF = new LPPointF(doodleShape.calcRotatePoint(f3, f5, f2, f4, f32));
                    Matrix matrix8 = matrix;
                    LPPointF lPPointF9 = lPPointF8;
                    DoodleShape doodleShape5 = this;
                    Matrix matrix9 = matrix8;
                    matrix9();
                    matrix9.reset();
                    float f33 = doodleShape5.rotateAngle;
                    float f34 = doodleShape5.centerPointX;
                    f3 = doodleShape5.centerPointY;
                    matrix8.postRotate(f33, f34, f3);
                    f33 = -this.rotateAngle;
                    f34 = lPPointF9.x;
                    f3 = lPPointF9.y;
                    matrix8.postRotate(f33, f34, f3);
                    matrix.mapPoints(fArray);
                    for (int i13 = 0; i13 < f29; ++i13) {
                        int n19 = i13 * 2;
                        f34 = fArray[n19];
                        this.mPoints.offer(new LPPointF(f34, fArray[n19 + 1]));
                    }
                }
                break;
            }
            case 3: {
                if (f3 < 0.0f) {
                    f3 = -f3;
                    f8 += rectF.height();
                }
                int n20 = this.mPoints.size();
                float[] fArray = new float[n20 * 2];
                for (int i14 = 0; i14 < n20; ++i14) {
                    float f35;
                    LPPointF lPPointF = this.mPoints.poll();
                    lPPointF.y = f35 = (lPPointF.y - rectF.top) * f3 + f8;
                    int n21 = i14 * 2;
                    fArray[n21] = lPPointF.x;
                    fArray[n21 + 1] = f35;
                }
                if (bl) {
                    for (int i15 = 0; i15 < n20; ++i15) {
                        int n22 = i15 * 2;
                        f4 = fArray[n22];
                        this.mPoints.offer(new LPPointF(f4, fArray[n22 + 1]));
                    }
                } else {
                    Matrix matrix;
                    LPPointF lPPointF;
                    LPPointF lPPointF10 = lPPointF;
                    DoodleShape doodleShape = this;
                    float f36 = doodleShape.centerPointX;
                    f4 = f36 + f4 / 2.0f;
                    float f37 = doodleShape.centerPointY;
                    f5 = f37 + f5 / 2.0f;
                    float f38 = doodleShape.rotateAngle;
                    lPPointF = new LPPointF(doodleShape.calcRotatePoint(f4, f5, f36, f37, f38));
                    Matrix matrix10 = matrix;
                    LPPointF lPPointF11 = lPPointF10;
                    DoodleShape doodleShape6 = this;
                    Matrix matrix11 = matrix10;
                    matrix11();
                    matrix11.reset();
                    float f39 = doodleShape6.rotateAngle;
                    float f40 = doodleShape6.centerPointX;
                    f5 = doodleShape6.centerPointY;
                    matrix10.postRotate(f39, f40, f5);
                    f39 = -this.rotateAngle;
                    f40 = lPPointF11.x;
                    f5 = lPPointF11.y;
                    matrix10.postRotate(f39, f40, f5);
                    matrix.mapPoints(fArray);
                    for (int i16 = 0; i16 < n20; ++i16) {
                        int n23 = i16 * 2;
                        f40 = fArray[n23];
                        this.mPoints.offer(new LPPointF(f40, fArray[n23 + 1]));
                    }
                }
                break;
            }
            case 2: {
                float f41 = f2 - 0.0f;
                float f42 = f41 == 0.0f ? 0 : (f41 < 0.0f ? -1 : 1);
                if (f42 < 0 && f3 < 0.0f) {
                    f2 = -f2;
                    f3 = -f3;
                    f7 -= rectF.width();
                    f8 += rectF.height();
                } else if (f42 < 0) {
                    f2 = -f2;
                    f7 -= rectF.width();
                } else if (f3 < 0.0f) {
                    f3 = -f3;
                    f8 += rectF.height();
                }
                int n24 = this.mPoints.size();
                f42 = n24;
                float[] fArray = new float[n24 * 2];
                for (int i17 = 0; i17 < f42; ++i17) {
                    float f43;
                    float f44;
                    PointF pointF = this.mPoints.poll();
                    pointF.x = f44 = (pointF.x - rectF.right) * f2 + f7;
                    pointF.y = f43 = (pointF.y - rectF.top) * f3 + f8;
                    int n25 = i17 * 2;
                    fArray[n25] = f44;
                    fArray[n25 + 1] = f43;
                }
                if (bl) {
                    for (int i18 = 0; i18 < f42; ++i18) {
                        int n26 = i18 * 2;
                        f3 = fArray[n26];
                        this.mPoints.offer(new LPPointF(f3, fArray[n26 + 1]));
                    }
                } else {
                    Matrix matrix;
                    DoodleShape doodleShape = this;
                    f2 = doodleShape.centerPointX;
                    f3 = f2 - f4 / 2.0f;
                    f4 = doodleShape.centerPointY;
                    f5 = f4 + f5 / 2.0f;
                    float f45 = doodleShape.rotateAngle;
                    PointF pointF = doodleShape.calcRotatePoint(f3, f5, f2, f4, f45);
                    Matrix matrix12 = matrix;
                    PointF pointF2 = pointF;
                    DoodleShape doodleShape7 = this;
                    Matrix matrix13 = matrix12;
                    matrix13();
                    matrix13.reset();
                    float f46 = doodleShape7.rotateAngle;
                    float f47 = doodleShape7.centerPointX;
                    f4 = doodleShape7.centerPointY;
                    matrix12.postRotate(f46, f47, f4);
                    f46 = -this.rotateAngle;
                    f47 = pointF2.x;
                    f4 = pointF2.y;
                    matrix12.postRotate(f46, f47, f4);
                    matrix.mapPoints(fArray);
                    for (int i19 = 0; i19 < f42; ++i19) {
                        int n27 = i19 * 2;
                        f47 = fArray[n27];
                        this.mPoints.offer(new LPPointF(f47, fArray[n27 + 1]));
                    }
                }
                break;
            }
            case 1: {
                if (f2 < 0.0f) {
                    f2 = -f2;
                    f7 -= rectF.width();
                }
                int n28 = this.mPoints.size();
                float[] fArray = new float[n28 * 2];
                for (int i20 = 0; i20 < n28; ++i20) {
                    float f48;
                    LPPointF lPPointF = this.mPoints.poll();
                    lPPointF.x = f48 = (lPPointF.x - rectF.right) * f2 + f7;
                    int n29 = i20 * 2;
                    fArray[n29] = f48;
                    int n30 = n29 + 1;
                    fArray[n30] = lPPointF.y;
                }
                if (bl) {
                    for (int i21 = 0; i21 < n28; ++i21) {
                        int n31 = i21 * 2;
                        f4 = fArray[n31];
                        this.mPoints.offer(new LPPointF(f4, fArray[n31 + 1]));
                    }
                } else {
                    Matrix matrix;
                    LPPointF lPPointF;
                    LPPointF lPPointF12 = lPPointF;
                    DoodleShape doodleShape = this;
                    float f49 = doodleShape.centerPointX;
                    f4 = f49 - f4 / 2.0f;
                    float f50 = doodleShape.centerPointY;
                    f5 = f50 - f5 / 2.0f;
                    f7 = doodleShape.rotateAngle;
                    lPPointF = new LPPointF(doodleShape.calcRotatePoint(f4, f5, f49, f50, f7));
                    Matrix matrix14 = matrix;
                    LPPointF lPPointF13 = lPPointF12;
                    DoodleShape doodleShape8 = this;
                    Matrix matrix15 = matrix14;
                    matrix15();
                    matrix15.reset();
                    float f51 = doodleShape8.rotateAngle;
                    float f52 = doodleShape8.centerPointX;
                    f5 = doodleShape8.centerPointY;
                    matrix14.postRotate(f51, f52, f5);
                    f51 = -this.rotateAngle;
                    f52 = lPPointF13.x;
                    f5 = lPPointF13.y;
                    matrix14.postRotate(f51, f52, f5);
                    matrix.mapPoints(fArray);
                    for (int i22 = 0; i22 < n28; ++i22) {
                        int n32 = i22 * 2;
                        f52 = fArray[n32];
                        this.mPoints.offer(new LPPointF(f52, fArray[n32 + 1]));
                    }
                }
                break;
            }
            case 0: {
                float f53 = f2 - 0.0f;
                float f54 = f53 == 0.0f ? 0 : (f53 < 0.0f ? -1 : 1);
                if (f54 < 0 && f3 < 0.0f) {
                    f2 = -f2;
                    f3 = -f3;
                    f7 -= rectF.width();
                    f9 -= rectF.height();
                } else if (f54 < 0) {
                    f2 = -f2;
                    f7 -= rectF.width();
                } else if (f3 < 0.0f) {
                    f3 = -f3;
                    f9 -= rectF.height();
                }
                int n33 = this.mPoints.size();
                f54 = n33;
                float[] fArray = new float[n33 * 2];
                for (int i23 = 0; i23 < f54; ++i23) {
                    float f55;
                    float f56;
                    PointF pointF = this.mPoints.poll();
                    pointF.x = f56 = (pointF.x - rectF.right) * f2 + f7;
                    pointF.y = f55 = (pointF.y - rectF.bottom) * f3 + f9;
                    int n34 = i23 * 2;
                    fArray[n34] = f56;
                    fArray[n34 + 1] = f55;
                }
                if (bl) {
                    for (int i24 = 0; i24 < f54; ++i24) {
                        int n35 = i24 * 2;
                        f3 = fArray[n35];
                        this.mPoints.offer(new LPPointF(f3, fArray[n35 + 1]));
                    }
                } else {
                    Matrix matrix;
                    LPPointF lPPointF;
                    LPPointF lPPointF14 = lPPointF;
                    DoodleShape doodleShape = this;
                    f3 = doodleShape.centerPointX;
                    f4 = f3 - f4 / 2.0f;
                    float f57 = doodleShape.centerPointY;
                    f5 = f57 - f5 / 2.0f;
                    float f58 = doodleShape.rotateAngle;
                    lPPointF = new LPPointF(doodleShape.calcRotatePoint(f4, f5, f3, f57, f58));
                    Matrix matrix16 = matrix;
                    LPPointF lPPointF15 = lPPointF14;
                    DoodleShape doodleShape9 = this;
                    Matrix matrix17 = matrix16;
                    matrix17();
                    matrix17.reset();
                    float f59 = doodleShape9.rotateAngle;
                    float f60 = doodleShape9.centerPointX;
                    f4 = doodleShape9.centerPointY;
                    matrix16.postRotate(f59, f60, f4);
                    f59 = -this.rotateAngle;
                    f60 = lPPointF15.x;
                    f4 = lPPointF15.y;
                    matrix16.postRotate(f59, f60, f4);
                    matrix.mapPoints(fArray);
                    for (int i25 = 0; i25 < f54; ++i25) {
                        int n36 = i25 * 2;
                        f60 = fArray[n36];
                        this.mPoints.offer(new LPPointF(f60, fArray[n36 + 1]));
                    }
                }
                break;
            }
        }
    }

    @Override
    public boolean isBoundaryOverlap(RectF rectF) {
        if (this.maxY == -2.1474836E9f) {
            return false;
        }
        if (this.shapeRectList.size() == 1) {
            return rectF.contains(this.shapeRectList.get((int)0).x, this.shapeRectList.get((int)0).y);
        }
        int n2 = 0;
        while (n2 < this.shapeRectList.size() - 1) {
            float f2;
            float f3;
            float f4;
            DoodleShape doodleShape = this;
            LPPointF lPPointF = doodleShape.shapeRectList.get(n2);
            LPPointF lPPointF2 = doodleShape.shapeRectList.get(++n2);
            if (doodleShape.rotateAngle != 0.0f) {
                LPPointF lPPointF3;
                LPPointF lPPointF4;
                LPPointF lPPointF5 = lPPointF4;
                DoodleShape doodleShape2 = this;
                LPPointF lPPointF6 = lPPointF;
                float f5 = lPPointF6.x;
                f4 = lPPointF6.y;
                f3 = doodleShape2.centerPointX;
                f2 = doodleShape2.centerPointY;
                float f6 = doodleShape2.rotateAngle;
                lPPointF4 = new LPPointF(doodleShape2.calcRotatePoint(f5, f4, f3, f2, f6));
                lPPointF = lPPointF3;
                DoodleShape doodleShape3 = this;
                LPPointF lPPointF7 = lPPointF2;
                float f7 = lPPointF7.x;
                f4 = lPPointF7.y;
                f3 = doodleShape3.centerPointX;
                f2 = doodleShape3.centerPointY;
                f6 = doodleShape3.rotateAngle;
                lPPointF3 = new LPPointF(doodleShape3.calcRotatePoint(f7, f4, f3, f2, f6));
                lPPointF2 = lPPointF;
                lPPointF = lPPointF5;
            }
            float f8 = Math.min(lPPointF.x, lPPointF2.x);
            LPPointF lPPointF8 = lPPointF;
            f4 = Math.max(lPPointF8.x, lPPointF2.x);
            f3 = Math.min(lPPointF8.y, lPPointF2.y);
            if (rectF.contains(f8, f3, f4, f2 = Math.max(lPPointF8.y, lPPointF2.y))) {
                return true;
            }
            if (f4 < rectF.left || f2 < rectF.top || rectF.right < f8 || rectF.bottom < f3 || !this.isVectorInRect(lPPointF, lPPointF2, rectF)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof DoodleShape) {
            object = (DoodleShape)object;
            boolean bl = false;
            boolean bl2 = false;
            if (!TextUtils.isEmpty((CharSequence)this.id)) {
                bl = this.id.equals(((Shape)object).id);
            } else if (TextUtils.isEmpty((CharSequence)((Shape)object).id)) {
                bl = true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.number)) {
                bl2 = this.number.equals(((Shape)object).number);
            } else if (TextUtils.isEmpty((CharSequence)((Shape)object).number)) {
                bl2 = true;
            }
            return bl && bl2 && this.index == ((DoodleShape)object).index;
        }
        return false;
    }

    public void setSmooth(boolean bl) {
        this.smooth = bl;
    }

    public boolean isSmooth() {
        return this.smooth;
    }

    @Override
    public void setAngle(float f2) {
        this.rotateAngle = f2;
    }

    @Override
    public Paint getPaint() {
        Paint paint = this.fillPaint;
        if (paint != null && this.autoClosePath) {
            return paint;
        }
        return super.getPaint();
    }

    public float getStrokeWidth() {
        return this.originStrokeWidth;
    }

    public void setCursorVectorDrawable(VectorDrawableCompat vectorDrawableCompat) {
        if (LiveSDK.ENABLE_SHOW_SHAPE_APPEND_CURSOR && vectorDrawableCompat != null && !this.autoClosePath) {
            Canvas canvas;
            VectorDrawableCompat vectorDrawableCompat2 = vectorDrawableCompat;
            VectorDrawableCompat vectorDrawableCompat3 = vectorDrawableCompat;
            vectorDrawableCompat3.mutate();
            this.cursorBitmap = Bitmap.createBitmap((int)vectorDrawableCompat3.getIntrinsicWidth(), (int)vectorDrawableCompat.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            vectorDrawableCompat = canvas;
            int n2 = new Canvas(this.cursorBitmap).getWidth();
            int n3 = vectorDrawableCompat.getHeight();
            vectorDrawableCompat2.setBounds(0, 0, n2, n3);
            vectorDrawableCompat2.draw((Canvas)vectorDrawableCompat);
        } else {
            this.cursorBitmap = null;
        }
    }

    public void disableHandWritingStyle() {
        this.disableHandWritingStyle = true;
    }
}

