/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.ppt.whiteboard.shape;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import com.baijiayun.livecore.models.LPPointF;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.ppt.whiteboard.shape.ShapeRegionInfo;
import java.util.ArrayList;

public class SingleArrowShape
extends Shape {
    private Paint fillPaint;
    private PointF endPoint;
    private PointF mPoint = new PointF();
    private ArrayList<LPPointF> points = new ArrayList();
    private int left = Integer.MAX_VALUE;
    private int right = Integer.MIN_VALUE;
    private int bottom = Integer.MIN_VALUE;
    private int top = Integer.MAX_VALUE;
    private float thickness;
    private boolean isDouble;
    private int fillStyle;
    private double arrowCenterX;
    private double arrowCenterY;
    private double angle = 2.0943951023931953;

    public SingleArrowShape(Paint paint, boolean bl, boolean bl2) {
        super(paint);
        this.mPaint = paint;
        paint.setStrokeWidth(2.0f);
        this.thickness = this.mPaint.getStrokeWidth();
        this.fillStyle = paint.getColor();
        this.isDouble = bl2;
    }

    private float[] getLinePoints() {
        SingleArrowShape singleArrowShape = singleArrowShape7;
        float f2 = singleArrowShape.mPaint.getStrokeWidth() * 5.0f;
        LPPointF lPPointF = singleArrowShape.mSourcePoint;
        float f3 = lPPointF.x;
        float f4 = lPPointF.y;
        PointF pointF = singleArrowShape.endPoint;
        f3 = pointF.x;
        float f5 = pointF.y;
        f3 = singleArrowShape.getDistance(f3, f4, f3, f5);
        PointF pointF2 = singleArrowShape.endPoint;
        LPPointF lPPointF2 = singleArrowShape7.mSourcePoint;
        double d2 = Math.atan2(pointF2.y - lPPointF2.y, pointF2.x - lPPointF2.x);
        if (Double.isNaN(d2)) {
            return null;
        }
        if (f3 < f2) {
            singleArrowShape7.thickness = singleArrowShape7.mPaint.getStrokeWidth();
            f2 = f3 / 5.0f;
        } else {
            float f6;
            singleArrowShape7.thickness = f2;
            f2 = f3 / 5.0f;
            if (f6 > 10.0f) {
                f2 = 10.0f;
            }
        }
        SingleArrowShape singleArrowShape2 = singleArrowShape7;
        singleArrowShape2.thickness = singleArrowShape2.mPaint.getStrokeWidth() * 2.0f;
        double d3 = f2;
        singleArrowShape2.arrowCenterX = (double)singleArrowShape2.endPoint.x - d3 * Math.cos(d2);
        singleArrowShape2.arrowCenterY = (double)singleArrowShape2.endPoint.y - d3 * Math.sin(d2);
        float[] fArray = singleArrowShape2.isDouble ? new float[22] : new float[16];
        float[] fArray2 = fArray;
        float[] fArray3 = fArray;
        SingleArrowShape singleArrowShape3 = singleArrowShape7;
        SingleArrowShape singleArrowShape4 = singleArrowShape7;
        fArray[0] = (float)((double)singleArrowShape7.mSourcePoint.x + (double)(singleArrowShape7.thickness / 2.0f) * Math.sin(d2));
        fArray[1] = (float)((double)singleArrowShape7.mSourcePoint.y + (double)(singleArrowShape7.thickness / 2.0f) * Math.cos(d2));
        double d4 = f3 - f2;
        fArray[2] = (float)((double)singleArrowShape7.mSourcePoint.x + (double)(singleArrowShape7.thickness / 2.0f) * Math.sin(d2) + d4 * Math.cos(d2));
        fArray[3] = (float)((double)singleArrowShape7.mSourcePoint.y + (double)(singleArrowShape7.thickness / 2.0f) * Math.cos(d2) + d4 * Math.sin(d2));
        PointF pointF3 = singleArrowShape4.endPoint;
        double d5 = singleArrowShape4.angle;
        singleArrowShape4.rotatePointBy(pointF3, d5);
        pointF3 = singleArrowShape4.mPoint;
        fArray[4] = pointF3.x;
        fArray[5] = pointF3.y;
        PointF pointF4 = singleArrowShape7.endPoint;
        fArray[6] = pointF4.x;
        fArray[7] = pointF4.y;
        d5 = singleArrowShape3.angle;
        singleArrowShape3.rotatePointBy(pointF3, d5);
        PointF pointF5 = singleArrowShape3.mPoint;
        fArray[8] = pointF5.x;
        fArray[9] = pointF5.y;
        pointF3 = singleArrowShape7.computeSymmetryPoint(new Point((int)((double)singleArrowShape7.mSourcePoint.x + (double)(singleArrowShape7.thickness / 2.0f) * Math.sin(d2)), (int)((double)singleArrowShape7.mSourcePoint.y + (double)(singleArrowShape7.thickness / 2.0f) * Math.cos(d2))));
        fArray2[10] = (float)((double)pointF3.x + d4 * Math.cos(d2));
        fArray3[11] = (float)((double)pointF3.y + d4 * Math.sin(d2));
        fArray2[12] = pointF3.x;
        fArray3[13] = pointF3.y;
        if (singleArrowShape7.isDouble) {
            PointF pointF6;
            SingleArrowShape singleArrowShape5 = singleArrowShape7;
            SingleArrowShape singleArrowShape6 = singleArrowShape7;
            LPPointF lPPointF3 = singleArrowShape6.mSourcePoint;
            singleArrowShape6.arrowCenterX = lPPointF3.x;
            singleArrowShape6.arrowCenterY = lPPointF3.y;
            lPPointF3 = pointF6;
            pointF6 = new PointF(singleArrowShape7.mSourcePoint.x - (float)((int)(d3 * Math.cos(d2))), singleArrowShape7.mSourcePoint.y - (float)((int)(d3 * Math.sin(d2))));
            double d6 = singleArrowShape6.angle;
            singleArrowShape6.rotatePointBy(lPPointF3, d6);
            PointF pointF7 = singleArrowShape6.mPoint;
            fArray[14] = pointF7.x;
            fArray[15] = pointF7.y;
            fArray[16] = singleArrowShape7.mSourcePoint.x - (float)((int)(d3 * Math.cos(d2)));
            fArray[17] = singleArrowShape7.mSourcePoint.y - (float)((int)(d3 * Math.sin(d2)));
            SingleArrowShape singleArrowShape7 = singleArrowShape5.mPoint;
            double d7 = singleArrowShape5.angle;
            singleArrowShape5.rotatePointBy((PointF)singleArrowShape7, d7);
            PointF pointF8 = singleArrowShape5.mPoint;
            fArray[18] = pointF8.x;
            fArray[19] = pointF8.y;
            fArray[20] = pointF3.x;
            fArray[21] = pointF3.y;
        } else {
            fArray[14] = (float)((double)singleArrowShape7.mSourcePoint.x + (double)(singleArrowShape7.thickness / 2.0f) * Math.sin(d2));
            fArray[15] = (float)((double)singleArrowShape7.mSourcePoint.y + (double)(singleArrowShape7.thickness / 2.0f) * Math.cos(d2));
        }
        return fArray;
    }

    private float getDistance(float f2, float f3, float f4, float f5) {
        float f6 = f4 - f2;
        float f7 = f5 - f3;
        return (float)Math.sqrt(f6 * f6 + f7 * f7);
    }

    private Point computeSymmetryPoint(Point point) {
        PointF pointF = object.endPoint;
        float f2 = pointF.y;
        Object object = object.mSourcePoint;
        float f3 = ((PointF)object).y;
        float f4 = f2 - f3;
        float f5 = ((PointF)object).x;
        float f6 = pointF.x;
        float f7 = f6;
        float f8 = f5;
        f7 = f8 - f7;
        f5 = f3 * (f6 - f8) - f5 * (f2 - f3);
        int n2 = point.x;
        int n3 = point.y;
        float f9 = f4;
        float f10 = f7;
        f5 = (f4 * (float)n2 + f7 * (float)n3 + f5) * -2.0f / (f9 * f9 + f10 * f10);
        new Point().x = (int)((float)n2 + f5 * f4);
        new Point().y = (int)((float)n3 + f5 * f7);
        return new Point();
    }

    private void rotatePointBy(PointF pointF, double d2) {
        double d3;
        double d4 = (double)pointF.x - this.arrowCenterX;
        double d5 = d3 = d4;
        d3 = (double)pointF.y - this.arrowCenterY;
        double d6 = d5 * Math.cos(d2) - d3 * Math.sin(d2);
        double d7 = d4 * Math.sin(d2) + d3 * Math.cos(d2);
        PointF pointF2 = this.mPoint;
        pointF2.x = (int)(d6 + this.arrowCenterX);
        this.mPoint.y = (int)(d7 + this.arrowCenterY);
    }

    @Override
    public void onDraw(Canvas canvas, Matrix matrix) {
        this.onDraw(canvas, matrix, null);
    }

    @Override
    public void onDraw(Canvas canvas, Matrix matrix, ShapeRegionInfo object) {
        Object object2;
        object = this.mSourcePoint;
        if (object != null && (object2 = this.endPoint) != null && object2.x - ((PointF)object).x != 0.0f && object2.y - ((PointF)object).y != 0.0f) {
            Path path;
            float[] fArray = this.getLinePoints();
            object = fArray;
            if (fArray == null) {
                return;
            }
            Object object3 = object;
            object2 = new float[((ShapeRegionInfo)object3).length];
            int n2 = ((ShapeRegionInfo)object3).length;
            System.arraycopy(object3, 0, object2, 0, n2);
            if (matrix != null) {
                matrix.mapPoints((float[])object);
            }
            SingleArrowShape singleArrowShape = this;
            SingleArrowShape singleArrowShape2 = this;
            matrix = path;
            Object object4 = object;
            matrix();
            ShapeRegionInfo shapeRegionInfo = object4[0];
            path.moveTo((float)shapeRegionInfo, (float)object4[1]);
            shapeRegionInfo = object[0];
            singleArrowShape2.left = (int)shapeRegionInfo;
            singleArrowShape2.right = (int)shapeRegionInfo;
            shapeRegionInfo = object[1];
            singleArrowShape.top = (int)shapeRegionInfo;
            singleArrowShape.bottom = (int)shapeRegionInfo;
            singleArrowShape.points.clear();
            Object object5 = object2;
            shapeRegionInfo = object5[0];
            singleArrowShape.points.add(new LPPointF((float)shapeRegionInfo, (float)object5[1]));
            for (int i2 = 2; i2 < ((ShapeRegionInfo)object).length; i2 += 2) {
                ShapeRegionInfo shapeRegionInfo2;
                ShapeRegionInfo shapeRegionInfo3;
                Object object6 = object;
                Object object7 = object2;
                Object object8 = object7[i2];
                int n3 = i2 + 1;
                this.points.add(new LPPointF((float)object8, (float)object7[n3]));
                object8 = object6[i2];
                matrix.lineTo((float)object8, (float)object6[n3]);
                object8 = object[i2];
                if (shapeRegionInfo3 > (float)this.right) {
                    this.right = (int)object8;
                }
                ShapeRegionInfo shapeRegionInfo4 = object[n3];
                if (shapeRegionInfo2 > (float)this.bottom) {
                    this.bottom = (int)shapeRegionInfo4;
                }
                if (object8 < (float)this.left) {
                    this.left = (int)object8;
                }
                if (!(shapeRegionInfo4 < (float)this.top)) continue;
                this.top = (int)shapeRegionInfo4;
            }
            matrix.close();
            if (canvas != null) {
                canvas.drawPath((Path)matrix, this.mPaint);
            }
            if (this.fillStyle != 0 && canvas != null) {
                if (this.fillPaint == null) {
                    Paint paint;
                    object = paint;
                    paint = new Paint();
                    this.fillPaint = object;
                }
                SingleArrowShape singleArrowShape3 = this;
                singleArrowShape3.fillPaint.setAntiAlias(true);
                singleArrowShape3.fillPaint.setDither(true);
                singleArrowShape3.fillPaint.setColor(this.fillStyle);
                singleArrowShape3.fillPaint.setStyle(Paint.Style.FILL_AND_STROKE);
                singleArrowShape3.fillPaint.setAlpha(255);
                canvas.drawPath((Path)matrix, singleArrowShape3.fillPaint);
            }
            return;
        }
    }

    @Override
    public boolean isInBoundary(float f2, float f3) {
        return (float)this.left <= f2 && (float)this.top <= f3 && (float)this.right >= f2 && (float)this.bottom >= f3;
    }

    @Override
    public boolean isTouchShape(float f2, float f3) {
        return false;
    }

    @Override
    public RectF getBoundary() {
        float[] fArray = ((SingleArrowShape)object).getLinePoints();
        Object object = fArray;
        if (fArray == null) {
            return null;
        }
        Object object2 = object;
        Object object3 = object2[0];
        int n2 = (int)object3;
        int n3 = (int)object3;
        Object object4 = object2[1];
        int n4 = (int)object4;
        int n5 = (int)object4;
        for (int i2 = 2; i2 < ((Object)object).length; i2 += 2) {
            Object object5;
            Object object6;
            Object object7 = object[i2];
            if (object6 > (float)n3) {
                n3 = (int)object7;
            }
            Object object8 = object[i2 + 1];
            if (object5 > (float)n5) {
                n5 = (int)object8;
            }
            if (object7 < (float)n2) {
                n2 = (int)object7;
            }
            if (!(object8 < (float)n4)) continue;
            n4 = (int)object8;
        }
        float f2 = n2;
        float f3 = n4;
        float f4 = n3;
        float f5 = n5;
        return new RectF(f2, f3, f4, f5);
    }

    @Override
    public void moveShapeBy(float f2, float f3) {
        SingleArrowShape singleArrowShape = this;
        PointF pointF = singleArrowShape.endPoint;
        pointF.x += f2;
        pointF.y += f3;
        LPPointF lPPointF = singleArrowShape.mSourcePoint;
        lPPointF.x += f2;
        lPPointF.y += f3;
    }

    @Override
    public void scaleShapeBy(int n2, float f2, float f3, float f4, float f5, RectF rectF, boolean bl) {
    }

    @Override
    public boolean isBoundaryOverlap(RectF rectF) {
        return !(rectF.right < (float)this.left || rectF.bottom < (float)this.top || (float)this.right < rectF.left || (float)this.bottom < rectF.top);
    }

    @Override
    public boolean isValid() {
        return this.endPoint != null && this.mSourcePoint != null;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    @Override
    public void appendPoint(LPPointF lPPointF) {
        this.endPoint = lPPointF;
    }

    @Override
    public ArrayList<LPPointF> getPoints() {
        return this.points;
    }

    @Override
    public void copyShape(Shape shape) {
    }

    @Override
    public void setAngle(float f2) {
        this.angle = f2;
    }
}

