/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.ppt.whiteboard.shape;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import com.baijiayun.livecore.models.LPPointF;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.ppt.whiteboard.shape.ShapeRegionInfo;
import java.util.ArrayList;

public class RectShape
extends Shape {
    private float width;
    private float height;
    private Paint fillPaint;
    private int fillStyle;

    public RectShape(Paint paint, float f2) {
        RectShape rectShape = this;
        super(paint);
        rectShape.fillStyle = 0;
        rectShape.mPaint.setStyle(Paint.Style.STROKE);
        this.rotateAngle = f2;
    }

    public RectShape(Paint paint, boolean bl) {
        super(paint);
        this.fillStyle = 0;
        if (bl) {
            this.fillStyle = paint.getColor();
        }
        this.mPaint.setStyle(Paint.Style.STROKE);
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(int n2) {
        this.height = n2;
    }

    public void setWidth(int n2) {
        this.width = n2;
    }

    @Override
    public boolean isValid() {
        return this.width != 0.0f && this.height != 0.0f;
    }

    @Override
    public void appendPoint(LPPointF lPPointF) {
        RectShape rectShape = object;
        RectShape rectShape2 = object;
        Object object = object.mSourcePoint;
        rectShape2.width = lPPointF.x - ((PointF)object).x;
        rectShape.height = lPPointF.y - ((PointF)object).y;
    }

    @Override
    public ArrayList<LPPointF> getPoints() {
        ArrayList<LPPointF> arrayList = new ArrayList<LPPointF>();
        arrayList.add(this.mSourcePoint);
        LPPointF lPPointF = this.mSourcePoint;
        float f2 = lPPointF.x + this.width;
        arrayList.add(new LPPointF(f2, lPPointF.y));
        LPPointF lPPointF2 = this.mSourcePoint;
        arrayList.add(new LPPointF(lPPointF2.x + this.width, lPPointF2.y + this.height));
        lPPointF2 = this.mSourcePoint;
        arrayList.add(new LPPointF(lPPointF2.x, lPPointF2.y + this.height));
        return arrayList;
    }

    @Override
    public void copyShape(Shape shape) {
        RectShape rectShape = rectShape3;
        RectShape rectShape2 = rectShape3;
        RectShape rectShape3 = (RectShape)shape;
        rectShape2.width = rectShape3.getWidth();
        rectShape2.height = rectShape3.getHeight();
        rectShape.rotateAngle = shape.rotateAngle;
    }

    @Override
    public void onDraw(Canvas canvas, Matrix matrix) {
        this.onDraw(canvas, matrix, null);
    }

    @Override
    public void onDraw(Canvas canvas, Matrix object, ShapeRegionInfo shapeRegionInfo) {
        Matrix matrix;
        Matrix matrix2;
        reference var6_14;
        float f2;
        RectShape rectShape = this;
        Matrix matrix3 = object;
        canvas.save();
        float[] fArray = new float[4];
        object = fArray;
        LPPointF lPPointF = this.mSourcePoint;
        float f3 = lPPointF.x;
        object[0] = (Matrix)f3;
        float f4 = lPPointF.y;
        object[1] = (Matrix)f4;
        object[2] = (Matrix)(f3 + this.width);
        fArray[3] = f4 + this.height;
        matrix3.mapPoints(fArray);
        rectShape.mPaint.setStyle(Paint.Style.STROKE);
        f3 = 0.0f;
        f4 = 0.0f;
        Object object2 = rectShape.width;
        if (f2 < 0.0f && this.height < 0.0f) {
            Object object3 = object;
            object2 = object3[2];
            var6_14 = object3[3];
            matrix2 = object3[0];
            matrix = object3[1];
        } else if (object2 < 0.0f) {
            Object object4 = object;
            object2 = object4[2];
            var6_14 = object4[1];
            matrix2 = object4[0];
            matrix = object4[3];
        } else if (this.height < 0.0f) {
            Object object5 = object;
            object2 = object5[0];
            var6_14 = object5[3];
            matrix2 = object5[2];
            matrix = object5[1];
        } else {
            Object object6 = object;
            object2 = object6[0];
            var6_14 = object6[1];
            matrix2 = object6[2];
            matrix = object6[3];
        }
        if (this.rotateAngle != 0.0f) {
            f3 = (object2 + matrix2) / 2.0f;
            f4 = (float)((var6_14 + matrix) / 2.0f);
            canvas.translate(f3, f4);
            canvas.rotate(this.rotateAngle);
        }
        float f5 = f4;
        float f6 = f3;
        f3 = object2 - f3;
        f4 = (float)(var6_14 - f4);
        object2 = matrix2 - f6;
        var6_14 = matrix - f5;
        Paint paint = this.mPaint;
        canvas.drawRect(f3, f4, object2, (float)var6_14, paint);
        if (this.fillStyle != 0) {
            Object object7 = object;
            RectShape rectShape2 = this;
            this.fillPaint = rectShape2.mPaint;
            this.fillPaint.setAntiAlias(true);
            rectShape2.fillPaint.setDither(true);
            rectShape2.fillPaint.setColor(this.fillStyle);
            rectShape2.fillPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            rectShape2.fillPaint.setAlpha(255);
            int n2 = (int)(object7[0] + 1.0f);
            int n3 = (int)(object7[1] + 1.0f);
            int n4 = (int)(object7[2] - 1.0f);
            float f7 = n2;
            float f8 = n3;
            float f9 = n4;
            f4 = (int)(object7[3] - 1.0f);
            Paint paint2 = this.fillPaint;
            canvas.drawRect(f7, f8, f9, f4, paint2);
        }
        canvas.restore();
    }

    @Override
    public boolean isInBoundary(float f2, float f3) {
        float f4 = this.mSourcePoint.x;
        RectShape rectShape = this;
        float f5 = rectShape.mSourcePoint.x;
        float f6 = Math.max(f5, f5 + this.width);
        float f7 = rectShape.mSourcePoint.y;
        float f8 = Math.min(f7, f7 + this.height);
        float f9 = rectShape.mSourcePoint.y;
        float f10 = Math.max(f9, f9 + this.height);
        return Math.min(f4, f4 + this.width) <= f2 && f6 >= f2 && f8 <= f3 && f10 >= f3;
    }

    @Override
    public boolean isTouchShape(float f2, float f3) {
        return false;
    }

    @Override
    public RectF getBoundary() {
        RectF rectF;
        RectF rectF2 = rectF;
        rectF2();
        float f2 = this.mSourcePoint.x;
        rectF2.left = Math.min(f2, f2 + this.width);
        float f3 = this.mSourcePoint.y;
        rectF2.bottom = Math.max(f3, f3 + this.height);
        float f4 = this.mSourcePoint.x;
        rectF2.right = Math.max(f4, f4 + this.width);
        float f5 = this.mSourcePoint.y;
        rectF.top = Math.min(f5, f5 + this.height);
        return rectF;
    }

    @Override
    public void moveShapeBy(float f2, float f3) {
        LPPointF lPPointF = this.mSourcePoint;
        lPPointF.x += f2;
        lPPointF.y += f3;
    }

    public void setBoundaryRect(RectF rectF) {
        if (rectF == null) {
            return;
        }
        LPPointF lPPointF = this.mSourcePoint;
        lPPointF.x = rectF.left;
        lPPointF.y = rectF.top;
        this.width = rectF.width();
        this.height = rectF.height();
    }

    @Override
    public void setAngle(float f2) {
        this.rotateAngle = f2;
    }

    @Override
    public void scaleShapeBy(int n2, float f2, float f3, float f4, float f5, RectF rectF, boolean bl) {
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    @Override
    public boolean isBoundaryOverlap(RectF rectF) {
        RectShape rectShape = this;
        float f2 = rectShape.mSourcePoint.x;
        float f3 = Math.min(f2, f2 + this.width);
        float f4 = rectShape.mSourcePoint.x;
        float f5 = Math.max(f4, f4 + this.width);
        float f6 = rectShape.mSourcePoint.y;
        float f7 = Math.min(f6, f6 + this.height);
        float f8 = rectShape.mSourcePoint.y;
        float f9 = Math.max(f8, f8 + this.height);
        return !(rectF.right < f3 || rectF.bottom < f7 || f5 < rectF.left || f9 < rectF.top);
    }

    public void setSelectedStartPoint(float f2, float f3) {
        LPPointF lPPointF = this.mSourcePoint;
        lPPointF.x = f2;
        lPPointF.y = f3;
    }

    public void setSelectedEndPoint(float f2, float f3) {
        RectShape rectShape = object;
        RectShape rectShape2 = object;
        Object object = object.mSourcePoint;
        rectShape2.width = f2 - ((PointF)object).x;
        rectShape.height = f3 - ((PointF)object).y;
    }
}

