/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.ppt.whiteboard.shape;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import com.baijiayun.livecore.models.LPPointF;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.ppt.whiteboard.shape.ShapeRegionInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ArrowShape
extends Shape {
    private static final double H = 20.0;
    private static final double L = 8.0;
    private double arrow_degree;
    private double arrow_len;
    private float ex;
    private float ey;
    private float x3;
    private float x4;
    private float y3;
    private float y4;
    private List<Float> pointX;
    private List<Float> pointY;
    private ArrayList<LPPointF> sendPoints;

    public ArrowShape(Paint paint) {
        ArrowShape arrowShape = this;
        super(paint);
        this.sendPoints = new ArrayList();
        double d2 = paint.getStrokeWidth();
        double d3 = d2 + 20.0;
        double d4 = d2 + 8.0;
        this.arrow_degree = Math.atan(d4 / d3);
        arrowShape.arrow_len = Math.sqrt(d4 * d4 + d3 + d2 * d3);
        arrowShape.pointX = new ArrayList<Float>();
        arrowShape.pointY = new ArrayList<Float>();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void appendPoint(LPPointF lPPointF) {
        this.ex = lPPointF.x;
        this.ey = lPPointF.y;
        this.measureArrow();
    }

    @Override
    public ArrayList<LPPointF> getPoints() {
        return this.sendPoints;
    }

    @Override
    public void copyShape(Shape shape) {
        ArrowShape arrowShape = arrowShape2;
        ArrowShape arrowShape2 = (ArrowShape)shape;
        arrowShape.ex = arrowShape2.getEx();
        arrowShape.ey = arrowShape2.getEy();
        arrowShape.measureArrow();
    }

    public void measureArrow() {
        ArrowShape arrowShape = object;
        LPPointF lPPointF = object.mSourcePoint;
        float f2 = arrowShape.ex - lPPointF.x;
        float f3 = arrowShape.ey - lPPointF.y;
        double d2 = arrowShape.arrow_degree;
        double d3 = arrowShape.arrow_len;
        double[] dArray = arrowShape.rotateVec(f2, f3, d2, true, d3);
        Object object = object.mSourcePoint;
        f2 = arrowShape.ex - ((PointF)object).x;
        float f4 = arrowShape.ey - ((PointF)object).y;
        d2 = -arrowShape.arrow_degree;
        d3 = arrowShape.arrow_len;
        double[] dArray2 = arrowShape.rotateVec(f2, f4, d2, true, d3);
        f2 = arrowShape.ex;
        d2 = (double)f2 - dArray[0];
        float f5 = arrowShape.ey;
        double d4 = d2;
        double d5 = (double)f5 - dArray[1];
        d2 = (double)f2 - dArray2[0];
        double d6 = (double)f5 - dArray2[1];
        arrowShape.x3 = Double.valueOf(d4).intValue();
        arrowShape.y3 = Double.valueOf(d5).intValue();
        arrowShape.x4 = Double.valueOf(d2).intValue();
        arrowShape.y4 = Double.valueOf(d6).intValue();
    }

    @Override
    public void onDraw(Canvas canvas, Matrix matrix) {
        this.onDraw(canvas, matrix);
    }

    @Override
    public void onDraw(Canvas canvas, Matrix matrix, ShapeRegionInfo shapeRegionInfo) {
        float f2;
        float f3;
        float f4 = this.ex;
        LPPointF lPPointF = this.mSourcePoint;
        float f5 = lPPointF.x;
        if (f4 != f5 && (f3 = this.ey) != (f2 = lPPointF.y)) {
            Path path;
            float[] fArray;
            ArrowShape arrowShape = this;
            int n2 = 10;
            float[] fArray2 = new float[10];
            float[] fArray3 = fArray = fArray2;
            float[] fArray4 = fArray;
            fArray3[0] = f5;
            fArray4[1] = f2;
            fArray3[2] = f4;
            fArray4[3] = f3;
            fArray[4] = f4 = this.x3;
            float f6 = this.y3;
            f2 = f6;
            float f7 = f4;
            fArray[5] = f2;
            fArray[6] = f4 = this.x4;
            fArray[7] = f2 = this.y4;
            fArray[8] = (f7 + f4) / 2.0f;
            fArray2[9] = (f6 + f2) / 2.0f;
            matrix.mapPoints(fArray2);
            arrowShape.pointX.clear();
            arrowShape.pointY.clear();
            arrowShape.sendPoints.clear();
            for (int i2 = 0; i2 < n2; i2 += 2) {
                ArrowShape arrowShape2 = this;
                arrowShape2.pointX.add(Float.valueOf(fArray[i2]));
                arrowShape2.pointY.add(Float.valueOf(fArray[i2 + 1]));
            }
            ArrowShape arrowShape3 = this;
            ArrowShape arrowShape4 = this;
            float f8 = fArray[0];
            float f9 = fArray[1];
            float f10 = fArray[8];
            f2 = fArray[9];
            Paint paint = this.mPaint;
            canvas.drawLine(f8, f9, f10, f2, paint);
            LPPointF lPPointF2 = this.mSourcePoint;
            f8 = lPPointF2.x;
            arrowShape4.sendPoints.add(new LPPointF(f8, lPPointF2.y));
            ArrowShape arrowShape5 = this;
            f8 = arrowShape5.ex;
            arrowShape4.sendPoints.add(new LPPointF(f8, arrowShape5.ey));
            Path path2 = path;
            path2();
            f9 = fArray[2];
            path2.moveTo(f9, fArray[3]);
            f9 = fArray[4];
            path2.lineTo(f9, fArray[5]);
            f9 = fArray[6];
            path.lineTo(f9, fArray[7]);
            path.close();
            canvas.drawPath(path2, arrowShape4.mPaint);
            ArrowShape arrowShape6 = this;
            float f11 = arrowShape6.x3;
            arrowShape3.sendPoints.add(new LPPointF(f11, arrowShape6.y3));
            ArrowShape arrowShape7 = this;
            f11 = arrowShape7.ex;
            arrowShape3.sendPoints.add(new LPPointF(f11, arrowShape7.ey));
            ArrowShape arrowShape8 = this;
            float f12 = arrowShape8.x4;
            arrowShape3.sendPoints.add(new LPPointF(f12, arrowShape8.y4));
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInBoundary(float f2, float f3) {
        if (this.pointY.isEmpty()) return false;
        if (this.pointX.isEmpty()) return false;
        ArrowShape arrowShape = this;
        Collections.sort(arrowShape.pointX);
        Collections.sort(arrowShape.pointY);
        if (!(arrowShape.pointX.get(0).floatValue() <= f2)) return false;
        if (!(this.pointY.get(0).floatValue() <= f3)) return false;
        List<Float> list = this.pointX;
        if (!(list.get(list.size() - 1).floatValue() >= f2)) return false;
        List<Float> list2 = this.pointY;
        if (!(list2.get(list2.size() - 1).floatValue() >= f3)) return false;
        return true;
    }

    @Override
    public boolean isTouchShape(float f2, float f3) {
        return false;
    }

    @Override
    public RectF getBoundary() {
        if (!this.pointX.isEmpty() && !this.pointY.isEmpty()) {
            RectF rectF;
            RectF rectF2 = rectF;
            rectF2();
            rectF2.left = this.pointX.get(0).intValue() - 1;
            rectF2.top = this.pointY.get(0).intValue() - 1;
            List<Float> list = this.pointX;
            rectF2.right = list.get(list.size() - 1).intValue() + 1;
            List<Float> list2 = this.pointY;
            rectF.bottom = list2.get(list2.size() - 1).intValue() + 1;
            return rectF;
        }
        return null;
    }

    @Override
    public void moveShapeBy(float f2, float f3) {
    }

    @Override
    public void scaleShapeBy(int n2, float f2, float f3, float f4, float f5, RectF rectF, boolean bl) {
    }

    @Override
    public boolean isBoundaryOverlap(RectF rectF) {
        return false;
    }

    public double[] rotateVec(float f2, float f3, double d2, boolean bl, double d3) {
        Object object = new double[2];
        double d4 = f2;
        double d5 = d4;
        double d6 = f3;
        d5 = d5 * Math.cos(d2) - d6 * Math.sin(d2);
        d6 = d4 * Math.sin(d2) + d6 * Math.cos(d2);
        if (bl) {
            Object object2 = object;
            double d7 = d6;
            double d8 = d5;
            double d9 = d6;
            d6 = Math.sqrt(d8 * d8 + d9 * d9);
            d2 = d8 / d6 * d3;
            d6 = d7 / d6 * d3;
            object2[0] = d2;
            object2[1] = d6;
        }
        return object;
    }

    public float getEx() {
        return this.ex;
    }

    public void setEx(int n2) {
        this.ex = n2;
    }

    public float getEy() {
        return this.ey;
    }

    public void setEy(int n2) {
        this.ey = n2;
    }

    @Override
    public void setAngle(float f2) {
        this.rotateAngle = f2;
    }
}

