/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.livecore.ppt.util;

import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import androidx.annotation.ColorInt;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livecore.ppt.whiteboard.shape.BitmapShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.DoodleShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.ETriangleShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.LaserShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.OvalShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.RectShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.Shape;
import com.baijiayun.livecore.ppt.whiteboard.shape.SingleArrowShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.StraightLineShape;
import com.baijiayun.livecore.ppt.whiteboard.shape.TextShape;
import java.util.Random;

public class ShapeUtils {
    private static Paint mSelectedRectPaint;
    @ColorInt
    private static int mSelectedRectPaintColor;
    private static Paint mTextEditPaint;
    public static boolean isFontItalic;
    public static boolean isFontWeight;
    public static final int SWITCH_TO_UP_LAYER = 0;
    public static final int SWITCH_TO_DOWN_LAYER = 1;
    public static final int SWITCH_TO_TOP_LAYER = 2;
    public static final int SWITCH_TO_BOTTOM_LAYER = 3;
    private static final Random RANDOM;

    private ShapeUtils() {
    }

    public static Paint getSelectedRectPaint() {
        if (mSelectedRectPaint == null) {
            mSelectedRectPaint = new Paint();
            mSelectedRectPaint.setAntiAlias(true);
            mSelectedRectPaint.setDither(true);
            mSelectedRectPaint.setColor(mSelectedRectPaintColor);
            mSelectedRectPaint.setStrokeWidth(2.0f);
            mSelectedRectPaint.setStyle(Paint.Style.STROKE);
            mSelectedRectPaint.setAlpha(255);
            mSelectedRectPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{5.0f, 5.0f}, 0.0f));
        }
        return mSelectedRectPaint;
    }

    public static Paint getTextEditPaint() {
        if (mTextEditPaint == null) {
            mTextEditPaint = new Paint();
            mTextEditPaint.setAntiAlias(true);
            mTextEditPaint.setDither(true);
            mTextEditPaint.setColor(mSelectedRectPaintColor);
            mTextEditPaint.setStrokeWidth(2.0f);
            mTextEditPaint.setStyle(Paint.Style.STROKE);
            mTextEditPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{5.0f, 5.0f}, 0.0f));
            mTextEditPaint.setAlpha(255);
        }
        return mTextEditPaint;
    }

    public static Shape createShape(LPConstants.ShapeType object, Paint paint, float f2, LPConstants.LPUserType lPUserType) {
        switch (a.a[object.ordinal()]) {
            default: {
                DoodleShape doodleShape;
                object = doodleShape;
                doodleShape = new DoodleShape(paint, null, 0.0f);
                break;
            }
            case 13: {
                BitmapShape bitmapShape;
                object = bitmapShape;
                bitmapShape = new BitmapShape(paint, 0.0f);
                break;
            }
            case 12: {
                StraightLineShape straightLineShape;
                object = straightLineShape;
                straightLineShape = new StraightLineShape(paint);
                break;
            }
            case 11: {
                ETriangleShape eTriangleShape;
                object = eTriangleShape;
                eTriangleShape = new ETriangleShape(paint, true);
                break;
            }
            case 10: {
                SingleArrowShape singleArrowShape;
                object = singleArrowShape;
                singleArrowShape = new SingleArrowShape(paint, true, true);
                break;
            }
            case 9: {
                ETriangleShape eTriangleShape;
                object = eTriangleShape;
                eTriangleShape = new ETriangleShape(paint);
                break;
            }
            case 8: {
                OvalShape ovalShape;
                object = ovalShape;
                ovalShape = new OvalShape(paint, false);
                break;
            }
            case 7: {
                OvalShape ovalShape;
                object = ovalShape;
                ovalShape = new OvalShape(paint, true);
                break;
            }
            case 6: {
                RectShape rectShape;
                object = rectShape;
                rectShape = new RectShape(paint, true);
                break;
            }
            case 5: {
                LaserShape laserShape;
                object = laserShape;
                laserShape = new LaserShape(paint);
                break;
            }
            case 4: {
                TextShape textShape;
                object = textShape;
                textShape = new TextShape(paint);
                break;
            }
            case 3: {
                SingleArrowShape singleArrowShape;
                object = singleArrowShape;
                singleArrowShape = new SingleArrowShape(paint, true, false);
                break;
            }
            case 2: {
                RectShape rectShape;
                object = rectShape;
                rectShape = new RectShape(paint, f2);
                break;
            }
            case 1: {
                DoodleShape doodleShape;
                object = doodleShape;
                new DoodleShape(paint, null, f2).setSmooth(true);
                if (paint.getAlpha() >= 255) break;
                ((DoodleShape)object).disableHandWritingStyle();
            }
        }
        ((Shape)object).userRole = lPUserType;
        return object;
    }

    public static String generateNonceStr() {
        return ShapeUtils.getRandomString(7) + System.currentTimeMillis();
    }

    public static void setSelectedRectPaintColor(@ColorInt int n2) {
        Paint paint;
        mSelectedRectPaintColor = n2;
        Paint paint2 = mSelectedRectPaint;
        if (paint2 != null) {
            paint2.setColor(n2);
        }
        if ((paint = mTextEditPaint) != null) {
            paint.setColor(mSelectedRectPaintColor);
        }
    }

    private static String getRandomString(int n2) {
        StringBuilder stringBuilder;
        String string2 = "abcdefghijklmnopqrstuvwxyz1234567890";
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder2.append(string2.charAt(RANDOM.nextInt(36)));
        }
        return stringBuilder2.toString();
    }

    static {
        mSelectedRectPaintColor = Color.parseColor((String)"#4D000000");
        RANDOM = new Random();
    }
}

