/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.evaluation;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import android.webkit.JavascriptInterface;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.livebase.base.BasePresenter;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPJsonModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livebase.widgets.view.webview.BJWebViewImpl;
import com.baijiayun.livecore.LiveSDK;
import com.baijiayun.livecore.utils.CommonUtils;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.toolbox.evaluation.EvaDialogContract;
import com.tencent.smtt.export.external.interfaces.WebResourceError;
import com.tencent.smtt.export.external.interfaces.WebResourceRequest;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class EvaDialogFragment
extends BaseDialogFragment
implements EvaDialogContract.View {
    private static final String ARGS_TYPE = "1";
    private static final String WINDOW_NAME = "bjlapp";
    private EvaDialogContract.Presenter presenter;
    private IUserModel currentUserInfo;
    private String roomId;
    private String roomToken;
    private boolean isDestroyed = false;
    private List<LPJsonModel> signalList = new ArrayList<LPJsonModel>();
    public static final int WIDTH_MARGIN = 24;
    public static final int HEIGHT_MARGIN = 32;
    public static final int HEIGHT_MARGIN_LANDSCAPE = 48;
    public static final int WIDTH_DEFAULT = 540;
    private float downY;
    private BJWebViewImpl webView;

    protected int getLayoutId() {
        return R.layout.bjy_fragment_eva;
    }

    protected void init(Bundle savedInstanceState, Bundle arguments) {
        this.hideTitleBar();
        this.initWebClient();
        this.loadUrl();
        LPLogger.d((String)"\u8bfe\u540e\u8bc4\u4ef7");
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = new Dialog((Context)this.getActivity(), R.style.BJYDialogStyle);
        dialog.setCanceledOnTouchOutside(false);
        return dialog;
    }

    public void setCloseBtnStatus(boolean forceJoin) {
        if (this.presenter == null) {
            return;
        }
        if (!forceJoin) {
            if (this.isQueryPlusNull()) {
                return;
            }
            this.editable(true);
            this.editText(this.getString(R.string.live_quiz_close));
            this.editClick(v -> this.showCloseDlg());
        } else {
            this.editable(false);
        }
    }

    private void showCloseDlg() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.contextReference);
        AlertDialog dialog = builder.setMessage(R.string.live_quiz_dialog_tip).setPositiveButton(R.string.live_quiz_dialog_confirm, (dialog12, which) -> {
            dialog12.dismiss();
            if (this.presenter != null) {
                this.presenter.dismissDlg();
            }
        }).setNegativeButton(R.string.live_quiz_dialog_cancel, (dialog1, which) -> dialog1.dismiss()).create();
        dialog.show();
        dialog.getButton(-1).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.contextReference, (int)R.attr.base_theme_live_product_color));
        dialog.getButton(-2).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.contextReference, (int)R.attr.base_theme_live_product_color));
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.keepAboveKeyboard(view);
    }

    private void keepAboveKeyboard(View root) {
        root.getViewTreeObserver().addOnGlobalLayoutListener(() -> {
            Rect rect = new Rect();
            root.getWindowVisibleDisplayFrame(rect);
            int rootInvisibleHeight = root.getRootView().getBottom() - rect.bottom;
            if (rootInvisibleHeight > 150) {
                int scrollHeight = (int)(this.downY + 150.0f - (float)rect.bottom);
                root.scrollTo(0, Math.max(scrollHeight, 0));
            } else {
                root.scrollTo(0, 0);
            }
        });
    }

    public void onStart() {
        super.onStart();
        this.getDialog().getWindow().setBackgroundDrawable(ThemeDataUtil.getCommonWindowBg((Context)this.contextReference));
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "ClickableViewAccessibility"})
    private void initWebClient() {
        this.$.id(R.id.pb_web_view_eva).background(ThemeDataUtil.getCommonWindowBg((Context)this.contextReference));
        this.webView = (BJWebViewImpl)this.$.id(R.id.wv_eva_main).view();
        this.webView.setOnTouchListener((v, event) -> {
            this.downY = event.getRawY();
            return false;
        });
        this.webView.setLayerType(2, null);
        this.webView.enableJavaScript((Object)this, WINDOW_NAME);
        this.webView.enableCache();
        this.webView.setBackgroundColor(0);
        this.webView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView view, int newProgress) {
                ((ProgressBar)EvaDialogFragment.this.$.id(R.id.pb_web_view_eva).view()).setProgress(newProgress);
                super.onProgressChanged(view, newProgress);
            }
        });
        this.webView.setWebViewClient((WebViewClient)new BJWebViewImpl.BJWebViewClient(){

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                EvaDialogFragment.this.$.id(R.id.pb_web_view_eva).visible();
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                LPLogger.i((String)(((Object)((Object)this)).getClass().getSimpleName() + " : " + url + "\uff0cisDestroyed\uff1a" + EvaDialogFragment.this.isDestroyed));
                if (EvaDialogFragment.this.isDestroyed) {
                    return;
                }
                EvaDialogFragment.this.$.id(R.id.pb_web_view_eva).gone();
                EvaDialogFragment.this.callJsInQueue();
            }

            @TargetApi(value=23)
            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                LPLogger.i((String)(((Object)((Object)this)).getClass().getSimpleName() + " : error:" + error.getErrorCode() + ",message:" + error.getDescription()));
                if (error.getErrorCode() != -11) {
                    EvaDialogFragment.this.$.id(R.id.pb_web_view_eva).gone();
                    EvaDialogFragment.this.setCloseBtnStatus(false);
                }
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                LPLogger.i((String)(((Object)((Object)this)).getClass().getSimpleName() + " : error:" + errorCode + ",message:" + description));
                if (errorCode != -11) {
                    EvaDialogFragment.this.$.id(R.id.pb_web_view_eva).gone();
                    EvaDialogFragment.this.setCloseBtnStatus(false);
                }
            }
        });
    }

    private void loadUrl() {
        try {
            this.roomToken = URLEncoder.encode(this.roomToken, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String params = "?userNumber=" + this.currentUserInfo.getNumber() + "&userName=" + CommonUtils.encodeUTF8((String)this.currentUserInfo.getName()) + "&roomId=" + this.roomId + "&token=" + this.roomToken + "&argType=" + ARGS_TYPE + "&userGroup=" + this.currentUserInfo.getGroup();
        String host = LPConstants.HOSTS_WEB[LiveSDK.getDeployType().getType()];
        String url = host.concat("m/evaluation/index").concat(params);
        LPLogger.i((String)(this.getClass().getSimpleName() + " : " + url));
        this.webView.loadUrl(url);
    }

    protected void setWindowParams(WindowManager.LayoutParams windowParams) {
        windowParams.windowAnimations = R.style.BJYLiveBaseSendMsgDialogAnim;
        windowParams.gravity = 17;
        int height = DisplayUtils.getScreenHeightPixels((Context)this.contextReference) - DisplayUtils.getStatusBarHeight((Activity)this.getActivity());
        int width = DisplayUtils.getScreenWidthPixels((Context)this.contextReference);
        if (this.getResources().getConfiguration().orientation == 1) {
            windowParams.width = width - UtilsKt.getDp((int)24);
            windowParams.height = height - UtilsKt.getDp((int)32);
        } else {
            windowParams.width = UtilsKt.getDp((int)540);
            windowParams.height = Math.min(height, width) - UtilsKt.getDp((int)48);
        }
    }

    public void setPresenter(EvaDialogContract.Presenter presenter2) {
        super.setBasePresenter((BasePresenter)presenter2);
        this.presenter = presenter2;
        presenter2.getCurrentUser();
        this.roomToken = TextUtils.isEmpty((CharSequence)presenter2.getRoomToken()) ? "" : presenter2.getRoomToken();
        this.roomId = String.valueOf(presenter2.getRoomId());
    }

    @Override
    public void onClassEnd(LPJsonModel jsonModel) {
        this.signalList.add(jsonModel);
    }

    @Override
    public void onGetCurrentUser(IUserModel userModel) {
        this.currentUserInfo = userModel;
    }

    @Override
    public void dismissDlg() {
        this.presenter.dismissDlg();
    }

    private void callJsInQueue() {
        if (this.signalList != null && this.signalList.size() > 0) {
            for (LPJsonModel jsonModel : this.signalList) {
                this.callJs(jsonModel.data.toString());
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.isDestroyed = true;
        if (this.signalList != null) {
            this.signalList.clear();
        }
        if (this.webView != null) {
            this.webView.destroy();
        }
        this.presenter = null;
    }

    @JavascriptInterface
    public void close() {
        this.presenter.dismissDlg();
    }

    @JavascriptInterface
    public void sendMessage(String json) {
        if (!TextUtils.isEmpty((CharSequence)json)) {
            this.presenter.submitAnswer(json);
        }
    }

    private void callJs(String json) {
        this.webView.loadUrl("javascript:bjlapp.receivedMessage(" + json + ")");
    }
}

