/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.toolbar;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.baijiayun.liveuibase.R;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0012\u0010\u001b\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/baijiayun/liveuibase/widgets/toolbar/DragConstraintLayout;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dx", "dy", "hasMove", "", "lastX", "lastY", "screenHeight", "screenWidth", "statusBarHeight", "threshold", "useParentContainer", "checkNeedLayout", "left", "nLeft", "top", "nTop", "initScreenParam", "", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onInterceptTouchEvent", "event", "Landroid/view/MotionEvent;", "liveuibase_release"})
public final class DragConstraintLayout
extends ConstraintLayout {
    private int screenWidth;
    private int screenHeight;
    private int lastX;
    private int lastY;
    private int dx;
    private int dy;
    private int statusBarHeight;
    private boolean useParentContainer;
    private final int threshold;
    private boolean hasMove;
    @NotNull
    public Map<Integer, View> _$_findViewCache;

    @JvmOverloads
    public DragConstraintLayout(@NotNull Context context2, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this._$_findViewCache = new LinkedHashMap();
        super(context2, attrs, defStyleAttr);
        this.threshold = 50;
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet $this$_init__u24lambda_u240 = attributeSet;
            boolean bl = false;
            TypedArray typedArray = context2.obtainStyledAttributes($this$_init__u24lambda_u240, R.styleable.BJYDragLayout);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026.styleable.BJYDragLayout)");
            TypedArray typedArray2 = typedArray;
            this.useParentContainer = typedArray2.getBoolean(R.styleable.BJYDragLayout_BJYUserParentContainer, false);
            typedArray2.recycle();
        }
        this.initScreenParam(context2);
    }

    public /* synthetic */ DragConstraintLayout(Context context2, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context2, attributeSet, n);
    }

    protected void onConfigurationChanged(@Nullable Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context");
        this.initScreenParam(context2);
    }

    private final void initScreenParam(Context context2) {
        DisplayMetrics metric = new DisplayMetrics();
        Object object = context2.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        WindowManager wm = (WindowManager)object;
        wm.getDefaultDisplay().getMetrics(metric);
        this.screenWidth = metric.widthPixels;
        this.screenHeight = metric.heightPixels;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            this.statusBarHeight = this.getResources().getDimensionPixelSize(resourceId);
        }
        if (context2.getResources().getConfiguration().orientation == 1) {
            this.screenHeight -= this.statusBarHeight;
        }
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        switch (event.getAction()) {
            case 0: {
                this.hasMove = false;
                this.lastX = (int)event.getRawX();
                this.lastY = (int)event.getRawY();
                if (!this.useParentContainer || !(this.getParent() instanceof ViewGroup)) break;
                ViewParent viewParent = this.getParent();
                Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.ViewGroup");
                ViewGroup parent = (ViewGroup)viewParent;
                this.screenWidth = parent.getMeasuredWidth();
                this.screenHeight = parent.getMeasuredHeight();
                break;
            }
            case 2: {
                this.dx = (int)event.getRawX() - this.lastX;
                this.dy = (int)event.getRawY() - this.lastY;
                int nLeft = this.getLeft() + this.dx;
                int nTop = this.getTop() + this.dy;
                int nRight = this.getRight() + this.dx;
                int nBottom = this.getBottom() + this.dy;
                if (nLeft < 0) {
                    nLeft = 0;
                    nRight = nLeft + this.getWidth();
                }
                if (nRight > this.screenWidth) {
                    nRight = this.screenWidth;
                    nLeft = this.screenWidth - this.getWidth();
                }
                if (nTop < 0) {
                    nTop = 0;
                    nBottom = nTop + this.getHeight();
                }
                if (nBottom > this.screenHeight) {
                    nBottom = this.screenHeight;
                    nTop = this.screenHeight - this.getHeight();
                }
                if (!this.checkNeedLayout(this.getLeft(), nLeft, this.getTop(), nTop)) break;
                this.layout(nLeft, nTop, nRight, nBottom);
                if (this.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                    ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
                    Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
                    ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)layoutParams;
                    params.leftMargin = nLeft;
                    params.topMargin = nTop;
                    params.rightMargin = this.screenWidth - nRight;
                    params.bottomMargin = this.screenHeight - nBottom;
                }
                this.lastX = (int)event.getRawX();
                this.lastY = (int)event.getRawY();
                this.hasMove = true;
                break;
            }
            case 1: {
                return this.hasMove;
            }
        }
        return super.onInterceptTouchEvent(event);
    }

    private final boolean checkNeedLayout(int left, int nLeft, int top, int nTop) {
        return Math.max(Math.abs(left - nLeft), Math.abs(top - nTop)) > this.threshold || this.hasMove;
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    @JvmOverloads
    public DragConstraintLayout(@NotNull Context context2, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this(context2, attrs, 0, 4, null);
    }

    @JvmOverloads
    public DragConstraintLayout(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this(context2, null, 0, 6, null);
    }
}

