/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import com.baijiayun.liveuibase.R;

public class DotProgressView
extends View {
    private int dotRadius = 4;
    private int dotColor = 0;
    private int maxCount = 5;
    private int count = 1;
    private boolean isAdd = true;
    private Paint paint;
    private RectF oval;

    public DotProgressView(Context context2) {
        this(context2, null);
    }

    public DotProgressView(Context context2, @Nullable AttributeSet attrs) {
        this(context2, attrs, 0);
    }

    public DotProgressView(Context context2, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.init(context2, attrs);
    }

    @RequiresApi(api=21)
    public DotProgressView(Context context2, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context2, attrs, defStyleAttr, defStyleRes);
        this.init(context2, attrs);
    }

    private void init(Context context2, AttributeSet attrs) {
        this.setLayerType(1, null);
        if (attrs != null) {
            TypedArray typedArray = context2.obtainStyledAttributes(attrs, R.styleable.BJYDotProgressView);
            this.dotRadius = typedArray.getDimensionPixelSize(R.styleable.BJYDotProgressView_bjlive_dot_radius, 4);
            this.dotColor = typedArray.getColor(R.styleable.BJYDotProgressView_bjlive_dot_color, ContextCompat.getColor((Context)context2, (int)R.color.base_icon_color));
            this.maxCount = typedArray.getInt(R.styleable.BJYDotProgressView_bjlive_dot_count, 5);
            typedArray.recycle();
        }
        if (this.dotColor == 0) {
            this.dotColor = ContextCompat.getColor((Context)context2, (int)R.color.base_icon_color);
        }
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.dotColor);
        this.oval = new RectF();
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        float space = ((float)(width - this.getPaddingStart() - this.getPaddingEnd()) - 2.0f * (float)this.dotRadius) / (float)(this.maxCount - 1);
        float x = (float)width / 2.0f - (float)(this.maxCount - 1) / 2.0f * space;
        float y = height - this.dotRadius - 2;
        for (int i = 0; i < this.count; ++i) {
            this.oval.left = x - (float)this.dotRadius;
            this.oval.top = y - (float)this.dotRadius;
            this.oval.right = x + (float)this.dotRadius;
            this.oval.bottom = y + (float)this.dotRadius;
            canvas.drawOval(this.oval, this.paint);
            x += space;
        }
        this.count = this.isAdd ? ++this.count : --this.count;
        if (this.count >= this.maxCount) {
            this.isAdd = false;
            this.count = this.maxCount;
        }
        if (this.count <= 1) {
            this.isAdd = true;
            this.count = 1;
        }
        this.postInvalidateDelayed(200L);
    }
}

