/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Size;
import android.view.Surface;
import android.view.TextureView;
import android.widget.Toast;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.utils.CameraPreviewManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0013*\u0002$'\u0018\u0000 R2\u00020\u0001:\u0003RSTB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u0004H\u0002J\u001a\u0010-\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020.2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*JC\u0010/\u001a\u00020!2\f\u00100\u001a\b\u0012\u0004\u0012\u00020!012\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020!H\u0003\u00a2\u0006\u0002\u00107J\b\u00108\u001a\u00020\u0017H\u0002J\u0018\u00109\u001a\u00020\u00172\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u0004H\u0003J\b\u0010<\u001a\u00020\u0017H\u0003J\u0006\u0010=\u001a\u00020\u0017J\u0006\u0010>\u001a\u00020\u001bJ\u0006\u0010?\u001a\u00020*J\u0010\u0010@\u001a\u00020\u00172\u0006\u0010A\u001a\u00020BH\u0016J\u0012\u0010C\u001a\u00020\u00172\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*J \u0010C\u001a\u00020\u00172\u0006\u0010D\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\u00042\u0006\u0010F\u001a\u00020\u001bH\u0003J\u0006\u0010G\u001a\u00020\u0017J\u0006\u0010H\u001a\u00020\u0017J\u0006\u0010I\u001a\u00020\u0017J\u0010\u0010J\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u001fH\u0003J\u0016\u0010L\u001a\u00020\u00172\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016J\u0018\u0010M\u001a\u00020\u00172\u0006\u0010D\u001a\u00020\u00042\u0006\u0010E\u001a\u00020\u0004H\u0003J\b\u0010N\u001a\u00020\u0017H\u0002J\b\u0010O\u001a\u00020\u0017H\u0002J\b\u0010P\u001a\u00020\u0017H\u0002J\u000e\u0010Q\u001a\u00020\u00172\u0006\u0010F\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010#\u001a\u00020$8\u0002X\u0083\u0004\u00a2\u0006\u0004\n\u0002\u0010%R\u0010\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010(R\u000e\u0010)\u001a\u00020*X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/baijiayun/liveuibase/utils/CameraPreviewManager;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "()V", "MAX_PREVIEW_HEIGHT", "", "MAX_PREVIEW_WIDTH", "_activity", "Landroid/app/Activity;", "activity", "getActivity", "()Landroid/app/Activity;", "backgroundHandler", "Landroid/os/Handler;", "backgroundThread", "Landroid/os/HandlerThread;", "cameraDevice", "Landroid/hardware/camera2/CameraDevice;", "cameraOpenCloseLock", "Ljava/util/concurrent/Semaphore;", "captureSession", "Landroid/hardware/camera2/CameraCaptureSession;", "errorListener", "Lkotlin/Function0;", "", "flashSupported", "", "mCameraId", "", "previewRequest", "Landroid/hardware/camera2/CaptureRequest;", "previewRequestBuilder", "Landroid/hardware/camera2/CaptureRequest$Builder;", "previewSize", "Landroid/util/Size;", "sensorOrientation", "stateCallback", "com/baijiayun/liveuibase/utils/CameraPreviewManager$stateCallback$1", "Lcom/baijiayun/liveuibase/utils/CameraPreviewManager$stateCallback$1;", "surfaceTextureListener", "com/baijiayun/liveuibase/utils/CameraPreviewManager$surfaceTextureListener$1", "Lcom/baijiayun/liveuibase/utils/CameraPreviewManager$surfaceTextureListener$1;", "textureView", "Landroid/view/TextureView;", "areDimensionsSwapped", "displayRotation", "bindActivity", "Landroidx/appcompat/app/AppCompatActivity;", "chooseOptimalSize", "choices", "", "textureViewWidth", "textureViewHeight", "maxWidth", "maxHeight", "aspectRatio", "([Landroid/util/Size;IIIILandroid/util/Size;)Landroid/util/Size;", "closeCamera", "configureTransform", "viewWidth", "viewHeight", "createCameraPreviewSession", "destroy", "getCameraId", "getTextureView", "onDestroy", "owner", "Landroidx/lifecycle/LifecycleOwner;", "openCamera", "width", "height", "cameraId", "pause", "refreshDisplayRotation", "resume", "setAutoFlash", "requestBuilder", "setErrorListener", "setUpCameraOutputs", "showCameraError", "startBackgroundThread", "stopBackgroundThread", "switchCamera", "Companion", "CompareSizesByArea", "SingletonHolder", "liveuibase_release"})
public final class CameraPreviewManager
implements DefaultLifecycleObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private CameraCaptureSession captureSession;
    @Nullable
    private CameraDevice cameraDevice;
    @Nullable
    private HandlerThread backgroundThread;
    @Nullable
    private Handler backgroundHandler;
    private CaptureRequest.Builder previewRequestBuilder;
    private CaptureRequest previewRequest;
    private boolean flashSupported;
    @NotNull
    private final Semaphore cameraOpenCloseLock = new Semaphore(1);
    @NotNull
    private String mCameraId = "1";
    private int sensorOrientation;
    private Size previewSize;
    private TextureView textureView;
    private final int MAX_PREVIEW_WIDTH;
    private final int MAX_PREVIEW_HEIGHT;
    @Nullable
    private Activity _activity;
    @Nullable
    private Function0<Unit> errorListener;
    @NotNull
    private final surfaceTextureListener.1 surfaceTextureListener = new TextureView.SurfaceTextureListener(this){
        final /* synthetic */ CameraPreviewManager this$0;
        {
            this.this$0 = $receiver;
        }

        @RequiresApi(value=21)
        public void onSurfaceTextureAvailable(@NotNull SurfaceTexture texture, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            CameraPreviewManager.access$openCamera(this.this$0, width, height, CameraPreviewManager.access$getMCameraId$p(this.this$0));
        }

        @RequiresApi(value=21)
        public void onSurfaceTextureSizeChanged(@NotNull SurfaceTexture texture, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            CameraPreviewManager.access$configureTransform(this.this$0, width, height);
        }

        public boolean onSurfaceTextureDestroyed(@NotNull SurfaceTexture texture) {
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
            return true;
        }

        public void onSurfaceTextureUpdated(@NotNull SurfaceTexture texture) {
            Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        }
    };
    @RequiresApi(value=21)
    @NotNull
    private final stateCallback.1 stateCallback = new CameraDevice.StateCallback(this){
        final /* synthetic */ CameraPreviewManager this$0;
        {
            this.this$0 = $receiver;
        }

        public void onOpened(@NotNull CameraDevice cameraDevice) {
            Intrinsics.checkNotNullParameter((Object)cameraDevice, (String)"cameraDevice");
            CameraPreviewManager.access$getCameraOpenCloseLock$p(this.this$0).release();
            CameraPreviewManager.access$setCameraDevice$p(this.this$0, cameraDevice);
            CameraPreviewManager.access$createCameraPreviewSession(this.this$0);
        }

        public void onClosed(@NotNull CameraDevice camera) {
            Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
            super.onClosed(camera);
            HandlerThread handlerThread = CameraPreviewManager.access$getBackgroundThread$p(this.this$0);
            if (handlerThread != null) {
                handlerThread.quit();
            }
            try {
                CameraPreviewManager.access$setBackgroundThread$p(this.this$0, null);
                Handler handler = CameraPreviewManager.access$getBackgroundHandler$p(this.this$0);
                if (handler != null) {
                    handler.removeCallbacksAndMessages(null);
                }
                CameraPreviewManager.access$setBackgroundHandler$p(this.this$0, null);
            }
            catch (InterruptedException e) {
                CameraPreviewManager.access$showCameraError(this.this$0);
            }
        }

        public void onDisconnected(@NotNull CameraDevice cameraDevice) {
            Intrinsics.checkNotNullParameter((Object)cameraDevice, (String)"cameraDevice");
            CameraPreviewManager.access$getCameraOpenCloseLock$p(this.this$0).release();
            cameraDevice.close();
            CameraPreviewManager.access$showCameraError(this.this$0);
            CameraPreviewManager.access$setCameraDevice$p(this.this$0, null);
        }

        public void onError(@NotNull CameraDevice cameraDevice, int error) {
            Intrinsics.checkNotNullParameter((Object)cameraDevice, (String)"cameraDevice");
            this.onDisconnected(cameraDevice);
            CameraPreviewManager.access$showCameraError(this.this$0);
        }
    };

    private CameraPreviewManager() {
        this.MAX_PREVIEW_WIDTH = 1920;
        this.MAX_PREVIEW_HEIGHT = 1080;
    }

    private final Activity getActivity() {
        Activity activity = this._activity;
        Intrinsics.checkNotNull((Object)activity);
        return activity;
    }

    public final void openCamera(@Nullable TextureView textureView) {
        this.textureView = textureView != null ? textureView : new TextureView((Context)this.getActivity());
        this.closeCamera();
        this.startBackgroundThread();
        TextureView textureView2 = this.textureView;
        if (textureView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
            textureView2 = null;
        }
        if (textureView2.isAvailable()) {
            TextureView textureView3 = this.textureView;
            if (textureView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
                textureView3 = null;
            }
            int n = textureView3.getWidth();
            TextureView textureView4 = this.textureView;
            if (textureView4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
                textureView4 = null;
            }
            this.openCamera(n, textureView4.getHeight(), this.mCameraId);
        } else {
            TextureView textureView5 = this.textureView;
            if (textureView5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
                textureView5 = null;
            }
            textureView5.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.surfaceTextureListener);
        }
    }

    public static /* synthetic */ void openCamera$default(CameraPreviewManager cameraPreviewManager2, TextureView textureView, int n, Object object) {
        if ((n & 1) != 0) {
            textureView = null;
        }
        cameraPreviewManager2.openCamera(textureView);
    }

    public final void bindActivity(@NotNull AppCompatActivity activity, @Nullable TextureView textureView) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this._activity = (Activity)activity;
        if (textureView != null) {
            this.textureView = textureView;
        }
        activity.getLifecycle().addObserver((LifecycleObserver)this);
    }

    public static /* synthetic */ void bindActivity$default(CameraPreviewManager cameraPreviewManager2, AppCompatActivity appCompatActivity, TextureView textureView, int n, Object object) {
        if ((n & 2) != 0) {
            textureView = null;
        }
        cameraPreviewManager2.bindActivity(appCompatActivity, textureView);
    }

    public final void resume() {
        if (this.textureView == null) {
            return;
        }
        this.startBackgroundThread();
        TextureView textureView = this.textureView;
        if (textureView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
            textureView = null;
        }
        if (textureView.isAvailable()) {
            TextureView textureView2 = this.textureView;
            if (textureView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
                textureView2 = null;
            }
            int n = textureView2.getWidth();
            TextureView textureView3 = this.textureView;
            if (textureView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
                textureView3 = null;
            }
            this.openCamera(n, textureView3.getHeight(), this.mCameraId);
        } else {
            TextureView textureView4 = this.textureView;
            if (textureView4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
                textureView4 = null;
            }
            textureView4.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.surfaceTextureListener);
        }
    }

    public final void pause() {
        if (this.textureView == null) {
            return;
        }
        this.closeCamera();
        this.stopBackgroundThread();
    }

    public final void destroy() {
        this._activity = null;
        if (this.textureView == null) {
            return;
        }
        this.closeCamera();
        this.stopBackgroundThread();
    }

    @NotNull
    public final String getCameraId() {
        return this.mCameraId;
    }

    @NotNull
    public final TextureView getTextureView() {
        TextureView textureView = this.textureView;
        if (textureView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
            textureView = null;
        }
        return textureView;
    }

    public final void switchCamera(@NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        this.mCameraId = cameraId;
        this.closeCamera();
        this.stopBackgroundThread();
        this.startBackgroundThread();
        TextureView textureView = this.textureView;
        if (textureView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
            textureView = null;
        }
        if (textureView.isAvailable()) {
            TextureView textureView2 = this.textureView;
            if (textureView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
                textureView2 = null;
            }
            int n = textureView2.getWidth();
            TextureView textureView3 = this.textureView;
            if (textureView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
                textureView3 = null;
            }
            this.openCamera(n, textureView3.getHeight(), this.mCameraId);
        } else {
            TextureView textureView4 = this.textureView;
            if (textureView4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
                textureView4 = null;
            }
            textureView4.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.surfaceTextureListener);
        }
    }

    public final void setErrorListener(@Nullable Function0<Unit> errorListener) {
        this.errorListener = errorListener;
    }

    @RequiresApi(value=21)
    @SuppressLint(value={"MissingPermission"})
    private final void openCamera(int width, int height, String cameraId) {
        if (this._activity == null) {
            return;
        }
        int permission = ContextCompat.checkSelfPermission((Context)((Context)this.getActivity()), (String)"android.permission.CAMERA");
        if (permission != 0) {
            this.showCameraError();
            return;
        }
        this.mCameraId = cameraId;
        this.setUpCameraOutputs(width, height);
        this.configureTransform(width, height);
        Object object = this.getActivity().getSystemService("camera");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        CameraManager manager = (CameraManager)object;
        try {
            if (!this.cameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Time out waiting to lock camera opening.");
            }
            manager.openCamera(cameraId, (CameraDevice.StateCallback)this.stateCallback, this.backgroundHandler);
        }
        catch (CameraAccessException e) {
            this.showCameraError();
        }
        catch (InterruptedException e) {
            this.showCameraError();
        }
    }

    @RequiresApi(value=21)
    private final void configureTransform(int viewWidth, int viewHeight) {
        TextureView textureView;
        int rotation = UtilsKt.isAppForeground((Context)((Context)this.getActivity())) || DisplayUtils.isPad((Context)((Context)this.getActivity())) ? this.getActivity().getWindowManager().getDefaultDisplay().getRotation() : 0;
        Matrix matrix = new Matrix();
        RectF viewRect = new RectF(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
        Size size = this.previewSize;
        if (size == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewSize");
            size = null;
        }
        float f = size.getHeight();
        Size size2 = this.previewSize;
        if (size2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"previewSize");
            size2 = null;
        }
        RectF bufferRect = new RectF(0.0f, 0.0f, f, (float)size2.getWidth());
        float centerX = viewRect.centerX();
        float centerY = viewRect.centerY();
        bufferRect.offset(centerX - bufferRect.centerX(), centerY - bufferRect.centerY());
        matrix.setRectToRect(viewRect, bufferRect, Matrix.ScaleToFit.FILL);
        if (1 == rotation || 3 == rotation) {
            matrix.postRotate((float)(90 * (rotation - 2)), centerX, centerY);
        } else if (2 == rotation) {
            matrix.postRotate(180.0f, centerX, centerY);
        }
        if ((textureView = this.textureView) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
            textureView = null;
        }
        textureView.setTransform(matrix);
    }

    public final void refreshDisplayRotation() {
        if (this.previewSize != null) {
            TextureView textureView = this.textureView;
            if (textureView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
                textureView = null;
            }
            int n = textureView.getWidth();
            TextureView textureView2 = this.textureView;
            if (textureView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
                textureView2 = null;
            }
            this.configureTransform(n, textureView2.getHeight());
        }
    }

    @RequiresApi(value=21)
    private final void setUpCameraOutputs(int width, int height) {
        Object object = this.getActivity().getSystemService("camera");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        CameraManager manager = (CameraManager)object;
        try {
            int maxPreviewHeight;
            StreamConfigurationMap map;
            CameraCharacteristics cameraCharacteristics = manager.getCameraCharacteristics(this.mCameraId);
            Intrinsics.checkNotNullExpressionValue((Object)cameraCharacteristics, (String)"manager.getCameraCharacteristics(mCameraId)");
            CameraCharacteristics characteristics = cameraCharacteristics;
            StreamConfigurationMap streamConfigurationMap = map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            Intrinsics.checkNotNull((Object)streamConfigurationMap);
            Size[] sizeArray = streamConfigurationMap.getOutputSizes(256);
            Intrinsics.checkNotNullExpressionValue((Object)sizeArray, (String)"map!!.getOutputSizes(ImageFormat.JPEG)");
            Size[] sizeArray2 = sizeArray;
            Size largest = (Size)Collections.max(CollectionsKt.listOf((Object[])Arrays.copyOf(sizeArray2, sizeArray2.length)), new CompareSizesByArea());
            int displayRotation = this.getActivity().getWindowManager().getDefaultDisplay().getRotation();
            Object object2 = characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
            Intrinsics.checkNotNull((Object)object2);
            this.sensorOrientation = ((Number)object2).intValue();
            boolean swappedDimensions = this.areDimensionsSwapped(displayRotation);
            Point displaySize = new Point();
            this.getActivity().getWindowManager().getDefaultDisplay().getSize(displaySize);
            int rotatedPreviewWidth = swappedDimensions ? height : width;
            int rotatedPreviewHeight = swappedDimensions ? width : height;
            int maxPreviewWidth = swappedDimensions ? displaySize.y : displaySize.x;
            int n = maxPreviewHeight = swappedDimensions ? displaySize.x : displaySize.y;
            if (maxPreviewWidth > this.MAX_PREVIEW_WIDTH) {
                maxPreviewWidth = this.MAX_PREVIEW_WIDTH;
            }
            if (maxPreviewHeight > this.MAX_PREVIEW_HEIGHT) {
                maxPreviewHeight = this.MAX_PREVIEW_HEIGHT;
            }
            Size[] sizeArray3 = map.getOutputSizes(SurfaceTexture.class);
            Intrinsics.checkNotNullExpressionValue((Object)sizeArray3, (String)"map.getOutputSizes(SurfaceTexture::class.java)");
            Intrinsics.checkNotNullExpressionValue((Object)largest, (String)"largest");
            this.previewSize = this.chooseOptimalSize(sizeArray3, rotatedPreviewWidth, rotatedPreviewHeight, maxPreviewWidth, maxPreviewHeight, largest);
            this.flashSupported = Intrinsics.areEqual((Object)characteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE), (Object)true);
        }
        catch (CameraAccessException e) {
            this.showCameraError();
        }
        catch (NullPointerException e) {
            this.showCameraError();
        }
    }

    @RequiresApi(value=21)
    private final void createCameraPreviewSession() {
        try {
            TextureView textureView = this.textureView;
            if (textureView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textureView");
                textureView = null;
            }
            SurfaceTexture texture = textureView.getSurfaceTexture();
            Surface surface = new Surface(texture);
            CameraDevice cameraDevice = this.cameraDevice;
            Intrinsics.checkNotNull((Object)cameraDevice);
            CaptureRequest.Builder builder = cameraDevice.createCaptureRequest(1);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"cameraDevice!!.createCap\u2026ATE_PREVIEW\n            )");
            this.previewRequestBuilder = builder;
            CaptureRequest.Builder builder2 = this.previewRequestBuilder;
            if (builder2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"previewRequestBuilder");
                builder2 = null;
            }
            builder2.addTarget(surface);
            CameraDevice cameraDevice2 = this.cameraDevice;
            if (cameraDevice2 != null) {
                cameraDevice2.createCaptureSession(CollectionsKt.listOf((Object)surface), new CameraCaptureSession.StateCallback(this){
                    final /* synthetic */ CameraPreviewManager this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onConfigured(@NotNull CameraCaptureSession cameraCaptureSession) {
                        Intrinsics.checkNotNullParameter((Object)cameraCaptureSession, (String)"cameraCaptureSession");
                        if (CameraPreviewManager.access$getCameraDevice$p(this.this$0) == null) {
                            return;
                        }
                        CameraPreviewManager.access$setCaptureSession$p(this.this$0, cameraCaptureSession);
                        try {
                            CaptureRequest.Builder builder = CameraPreviewManager.access$getPreviewRequestBuilder$p(this.this$0);
                            if (builder == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"previewRequestBuilder");
                                builder = null;
                            }
                            builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                            CaptureRequest.Builder builder2 = CameraPreviewManager.access$getPreviewRequestBuilder$p(this.this$0);
                            if (builder2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"previewRequestBuilder");
                                builder2 = null;
                            }
                            CameraPreviewManager.access$setAutoFlash(this.this$0, builder2);
                            CaptureRequest.Builder builder3 = CameraPreviewManager.access$getPreviewRequestBuilder$p(this.this$0);
                            if (builder3 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"previewRequestBuilder");
                                builder3 = null;
                            }
                            CaptureRequest captureRequest = builder3.build();
                            Intrinsics.checkNotNullExpressionValue((Object)captureRequest, (String)"previewRequestBuilder.build()");
                            CameraPreviewManager.access$setPreviewRequest$p(this.this$0, captureRequest);
                            CameraCaptureSession cameraCaptureSession2 = CameraPreviewManager.access$getCaptureSession$p(this.this$0);
                            if (cameraCaptureSession2 != null) {
                                CaptureRequest captureRequest2 = CameraPreviewManager.access$getPreviewRequest$p(this.this$0);
                                if (captureRequest2 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"previewRequest");
                                    captureRequest2 = null;
                                }
                                cameraCaptureSession2.setRepeatingRequest(captureRequest2, null, CameraPreviewManager.access$getBackgroundHandler$p(this.this$0));
                            }
                        }
                        catch (CameraAccessException e) {
                            CameraPreviewManager.access$showCameraError(this.this$0);
                        }
                    }

                    public void onConfigureFailed(@NotNull CameraCaptureSession session) {
                        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                        CameraPreviewManager.access$showCameraError(this.this$0);
                    }
                }, null);
            }
        }
        catch (CameraAccessException e) {
            this.showCameraError();
        }
    }

    private final boolean areDimensionsSwapped(int displayRotation) {
        boolean swappedDimensions = false;
        switch (displayRotation) {
            case 0: 
            case 2: {
                if (this.sensorOrientation != 90 && this.sensorOrientation != 270) break;
                swappedDimensions = true;
                break;
            }
            case 1: 
            case 3: {
                if (this.sensorOrientation != 0 && this.sensorOrientation != 180) break;
                swappedDimensions = true;
            }
        }
        return swappedDimensions;
    }

    @RequiresApi(value=21)
    private final void setAutoFlash(CaptureRequest.Builder requestBuilder) {
        if (this.flashSupported) {
            requestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
        }
    }

    @RequiresApi(value=21)
    private final Size chooseOptimalSize(Size[] choices, int textureViewWidth, int textureViewHeight, int maxWidth, int maxHeight, Size aspectRatio) {
        Size size;
        ArrayList<Size> bigEnough = new ArrayList<Size>();
        ArrayList<Size> notBigEnough = new ArrayList<Size>();
        int w = aspectRatio.getWidth();
        int h = aspectRatio.getHeight();
        int n = choices.length;
        for (int i = 0; i < n; ++i) {
            Size option = choices[i];
            if (option.getWidth() > maxWidth || option.getHeight() > maxHeight || option.getHeight() != option.getWidth() * h / w) continue;
            if (option.getWidth() >= textureViewWidth && option.getHeight() >= textureViewHeight) {
                bigEnough.add(option);
                continue;
            }
            notBigEnough.add(option);
        }
        if (bigEnough.size() > 0) {
            Object t = Collections.min((Collection)bigEnough, new CompareSizesByArea());
            Intrinsics.checkNotNullExpressionValue(t, (String)"{\n                Collec\u2026esByArea())\n            }");
            size = (Size)t;
        } else if (notBigEnough.size() > 0) {
            Object t = Collections.max((Collection)notBigEnough, new CompareSizesByArea());
            Intrinsics.checkNotNullExpressionValue(t, (String)"{\n                Collec\u2026esByArea())\n            }");
            size = (Size)t;
        } else {
            size = choices[0];
        }
        return size;
    }

    private final void showCameraError() {
        if (this.errorListener != null) {
            Function0<Unit> function0 = this.errorListener;
            if (function0 != null) {
                function0.invoke();
            }
        } else {
            if (this._activity == null) {
                return;
            }
            Toast.makeText((Context)((Context)this.getActivity()), (CharSequence)this.getActivity().getString(R.string.bjy_base_device_testing_camera_not_found), (int)0).show();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void startBackgroundThread() {
        void it;
        HandlerThread handlerThread;
        HandlerThread handlerThread2 = handlerThread = new HandlerThread("CameraBackground");
        CameraPreviewManager cameraPreviewManager2 = this;
        boolean bl = false;
        it.start();
        cameraPreviewManager2.backgroundThread = handlerThread;
        HandlerThread handlerThread3 = this.backgroundThread;
        Intrinsics.checkNotNull((Object)handlerThread3);
        this.backgroundHandler = new Handler(handlerThread3.getLooper());
    }

    private final void stopBackgroundThread() {
        HandlerThread handlerThread = this.backgroundThread;
        if (handlerThread != null) {
            handlerThread.quitSafely();
        }
        try {
            HandlerThread handlerThread2 = this.backgroundThread;
            if (handlerThread2 != null) {
                handlerThread2.join();
            }
            this.backgroundThread = null;
            Handler handler = this.backgroundHandler;
            if (handler != null) {
                handler.removeCallbacksAndMessages(null);
            }
            this.backgroundHandler = null;
        }
        catch (InterruptedException e) {
            this.showCameraError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeCamera() {
        try {
            this.cameraOpenCloseLock.acquire();
            CameraCaptureSession cameraCaptureSession = this.captureSession;
            if (cameraCaptureSession != null) {
                cameraCaptureSession.close();
            }
            this.captureSession = null;
            CameraDevice cameraDevice = this.cameraDevice;
            if (cameraDevice != null) {
                cameraDevice.close();
            }
            this.cameraDevice = null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera closing.", e);
        }
        finally {
            this.cameraOpenCloseLock.release();
        }
    }

    public void onDestroy(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super.onDestroy(owner);
        this.destroy();
    }

    public static final /* synthetic */ CameraDevice access$getCameraDevice$p(CameraPreviewManager $this) {
        return $this.cameraDevice;
    }

    public static final /* synthetic */ void access$setCaptureSession$p(CameraPreviewManager $this, CameraCaptureSession cameraCaptureSession) {
        $this.captureSession = cameraCaptureSession;
    }

    public static final /* synthetic */ CaptureRequest.Builder access$getPreviewRequestBuilder$p(CameraPreviewManager $this) {
        return $this.previewRequestBuilder;
    }

    public static final /* synthetic */ void access$setAutoFlash(CameraPreviewManager $this, CaptureRequest.Builder requestBuilder) {
        $this.setAutoFlash(requestBuilder);
    }

    public static final /* synthetic */ void access$setPreviewRequest$p(CameraPreviewManager $this, CaptureRequest captureRequest) {
        $this.previewRequest = captureRequest;
    }

    public static final /* synthetic */ CameraCaptureSession access$getCaptureSession$p(CameraPreviewManager $this) {
        return $this.captureSession;
    }

    public static final /* synthetic */ CaptureRequest access$getPreviewRequest$p(CameraPreviewManager $this) {
        return $this.previewRequest;
    }

    public static final /* synthetic */ Handler access$getBackgroundHandler$p(CameraPreviewManager $this) {
        return $this.backgroundHandler;
    }

    public static final /* synthetic */ void access$showCameraError(CameraPreviewManager $this) {
        $this.showCameraError();
    }

    public /* synthetic */ CameraPreviewManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ void access$openCamera(CameraPreviewManager $this, int width, int height, String cameraId) {
        $this.openCamera(width, height, cameraId);
    }

    public static final /* synthetic */ String access$getMCameraId$p(CameraPreviewManager $this) {
        return $this.mCameraId;
    }

    public static final /* synthetic */ void access$configureTransform(CameraPreviewManager $this, int viewWidth, int viewHeight) {
        $this.configureTransform(viewWidth, viewHeight);
    }

    public static final /* synthetic */ Semaphore access$getCameraOpenCloseLock$p(CameraPreviewManager $this) {
        return $this.cameraOpenCloseLock;
    }

    public static final /* synthetic */ void access$setCameraDevice$p(CameraPreviewManager $this, CameraDevice cameraDevice) {
        $this.cameraDevice = cameraDevice;
    }

    public static final /* synthetic */ void access$createCameraPreviewSession(CameraPreviewManager $this) {
        $this.createCameraPreviewSession();
    }

    public static final /* synthetic */ HandlerThread access$getBackgroundThread$p(CameraPreviewManager $this) {
        return $this.backgroundThread;
    }

    public static final /* synthetic */ void access$setBackgroundThread$p(CameraPreviewManager $this, HandlerThread handlerThread) {
        $this.backgroundThread = handlerThread;
    }

    public static final /* synthetic */ void access$setBackgroundHandler$p(CameraPreviewManager $this, Handler handler) {
        $this.backgroundHandler = handler;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0017\u00a8\u0006\t"}, d2={"Lcom/baijiayun/liveuibase/utils/CameraPreviewManager$CompareSizesByArea;", "Ljava/util/Comparator;", "Landroid/util/Size;", "Lkotlin/Comparator;", "()V", "compare", "", "lhs", "rhs", "liveuibase_release"})
    public static final class CompareSizesByArea
    implements Comparator<Size> {
        @Override
        @RequiresApi(value=21)
        public int compare(@NotNull Size lhs, @NotNull Size rhs) {
            Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
            Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
            return Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/baijiayun/liveuibase/utils/CameraPreviewManager$Companion;", "", "()V", "getInstance", "Lcom/baijiayun/liveuibase/utils/CameraPreviewManager;", "liveuibase_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CameraPreviewManager getInstance() {
            return SingletonHolder.INSTANCE.getINSTANCE();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\n\n\u0002\b\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/baijiayun/liveuibase/utils/CameraPreviewManager$SingletonHolder;", "", "()V", "INSTANCE", "Lcom/baijiayun/liveuibase/utils/CameraPreviewManager;", "getINSTANCE", "()Lcom/baijiayun/liveuibase/utils/CameraPreviewManager;", "INSTANCE$1", "liveuibase_release"})
    private static final class SingletonHolder {
        @NotNull
        public static final SingletonHolder INSTANCE = new SingletonHolder();
        @NotNull
        private static final CameraPreviewManager INSTANCE$1 = new CameraPreviewManager(null);

        private SingletonHolder() {
        }

        @NotNull
        public final CameraPreviewManager getINSTANCE() {
            return INSTANCE$1;
        }
    }
}

