/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.livetimer;

import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livecore.models.LPBJTimerModel;
import com.baijiayun.liveuibase.toolbox.livetimer.TimerContract;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;
import kotlin.Pair;

public class TimerPresenter
implements TimerContract.Presenter {
    public static final String PAUSE_TIMER = "pause";
    public static final String CONTINUE_TIMER = "continue";
    public static final String START_TIMER = "start";
    public static final String STOP_TIMER = "stop";
    private TimerContract.View view;
    private CompositeDisposable disposables;
    private long remainSeconds = -1L;
    private long timeDuration;
    private boolean isCountDown = false;
    private boolean isPause = false;
    private Disposable timeDisposable;
    private LPBJTimerModel lpbjTimerModel;
    private boolean isSetting = false;
    private RouterViewModel routerViewModel;

    @Override
    public void requestTimerStart(long current, long total, boolean isCountDown) {
        if (this.isSetting) {
            if (!this.isPause) {
                this.timeDuration = total;
            }
            current = this.remainSeconds > -1L ? this.remainSeconds : total;
            this.routerViewModel.getLiveRoom().getToolBoxVM().requestBJTimerStart(current, this.timeDuration, isCountDown);
            LPBJTimerModel lpbjTimerModel = new LPBJTimerModel();
            lpbjTimerModel.startTimer = System.currentTimeMillis() / 1000L;
            lpbjTimerModel.current = current;
            lpbjTimerModel.total = this.timeDuration;
            lpbjTimerModel.action = START_TIMER;
            lpbjTimerModel.type = isCountDown ? "1" : "0";
            this.routerViewModel.getShowTimerShowy().setValue((Object)new Pair((Object)true, (Object)lpbjTimerModel));
            this.unSubscribe();
        } else {
            this.routerViewModel.getLiveRoom().getToolBoxVM().requestBJTimerStart(current, total, isCountDown);
        }
    }

    @Override
    public void requestTimerPause(long current, long total, boolean isCountDown) {
        this.isPause = true;
        this.routerViewModel.getLiveRoom().getToolBoxVM().requestBJTimerPause(this.remainSeconds, this.timeDuration, this.isCountDown);
    }

    @Override
    public void requestTimerEnd() {
        if (this.routerViewModel.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Teacher) {
            this.routerViewModel.getLiveRoom().getToolBoxVM().requestBJTimerEnd();
            if (this.isSetting) {
                this.resetData();
                this.routerViewModel.getShowTimer().setValue((Object)new Pair((Object)false, (Object)this.lpbjTimerModel));
            }
        }
    }

    private void resetData() {
        this.remainSeconds = -1L;
        this.timeDuration = 0L;
        this.isPause = false;
        this.isCountDown = false;
    }

    @Override
    public void closeTimer() {
        this.routerViewModel.getShowTimer().setValue((Object)new Pair((Object)false, null));
    }

    @Override
    public void showTimer() {
        if (this.routerViewModel.isCurrentUserTeacher()) {
            this.routerViewModel.getShowTimerByClick().setValue((Object)this.lpbjTimerModel);
        }
    }

    @Override
    public boolean isTimerShowy() {
        if (this.routerViewModel.getShowTimerShowy().getValue() != null) {
            return (Boolean)((Pair)this.routerViewModel.getShowTimerShowy().getValue()).component1();
        }
        return false;
    }

    @Override
    public boolean isFullScreen() {
        if (this.routerViewModel.getSwitch2FullScreen().getValue() != null) {
            return (Boolean)((Pair)this.routerViewModel.getSwitch2FullScreen().getValue()).component1();
        }
        return false;
    }

    @Override
    public boolean isLiveEE() {
        return this.routerViewModel.isLiveEE();
    }

    @Override
    public LPConstants.LPUserType getUserType() {
        return this.routerViewModel.liveRoom.getCurrentUser().getType();
    }

    public void setView(TimerContract.View view) {
        this.view = view;
    }

    public void setIsSetting(boolean isSetting) {
        this.isSetting = isSetting;
    }

    public LPBJTimerModel getLPBJTimerModel() {
        if (this.lpbjTimerModel == null) {
            return new LPBJTimerModel();
        }
        LPBJTimerModel lpbjTimerModel1 = this.lpbjTimerModel;
        lpbjTimerModel1.action = this.isPause ? PAUSE_TIMER : START_TIMER;
        lpbjTimerModel1.current = this.remainSeconds;
        return lpbjTimerModel1;
    }

    private String getTimerState(long time) {
        if (this.isPause) {
            return CONTINUE_TIMER;
        }
        return time > 0L ? PAUSE_TIMER : START_TIMER;
    }

    public void subscribe() {
        this.disposables = new CompositeDisposable();
        if (this.lpbjTimerModel != null) {
            this.isPause = PAUSE_TIMER.equals(this.lpbjTimerModel.action);
            this.isCountDown = this.lpbjTimerModel.isCountDown();
            this.timeDuration = this.lpbjTimerModel.total;
            long time = this.lpbjTimerModel.current;
            if (this.lpbjTimerModel.isCache && !this.isPause) {
                time -= System.currentTimeMillis() / 1000L - this.lpbjTimerModel.startTimer;
                this.lpbjTimerModel.isCache = false;
            }
            if (this.isSetting) {
                this.view.showCountDown(this.isCountDown);
                this.view.setTimer(this.lpbjTimerModel.total);
                this.view.setButtonState(this.getTimerState(time));
            } else {
                this.view.setTimer(this.isCountDown ? 0L : this.timeDuration);
                if (time < 0L) {
                    this.view.showTimerEnd();
                }
            }
            if (time > 0L) {
                this.remainSeconds = time;
                this.startTimer();
            }
        }
        this.disposables.add(this.routerViewModel.getLiveRoom().getToolBoxVM().getObservableOfBJTimerStart().mergeWith((ObservableSource)this.routerViewModel.getLiveRoom().getToolBoxVM().getObservableOfBJTimerPause()).observeOn(AndroidSchedulers.mainThread()).subscribe(lpbjTimerModel1 -> {
            if (lpbjTimerModel1 == null) {
                return;
            }
            if (STOP_TIMER.equals(lpbjTimerModel1.action)) {
                RxUtils.dispose((Disposable)this.timeDisposable);
                this.view.showTimerEnd();
                return;
            }
            this.isPause = PAUSE_TIMER.equals(lpbjTimerModel1.action);
            this.view.showTimerPause(this.isPause);
            this.lpbjTimerModel = lpbjTimerModel1;
            this.isCountDown = lpbjTimerModel1.isCountDown();
            this.timeDuration = this.lpbjTimerModel.total;
            long time = this.lpbjTimerModel.current;
            if (this.lpbjTimerModel.isCache) {
                time = this.lpbjTimerModel.startTimer + time - System.currentTimeMillis() / 1000L;
            }
            if (time > 0L) {
                this.remainSeconds = time;
                this.startTimer();
            }
        }));
        this.disposables.add(this.routerViewModel.getLiveRoom().getToolBoxVM().getObservableOfBJTimerEnd().observeOn(AndroidSchedulers.mainThread()).subscribe(b -> {
            if (this.isSetting) {
                RxUtils.dispose((Disposable)this.timeDisposable);
                this.view.setButtonState(this.getTimerState(0L));
                this.view.setTimer(this.lpbjTimerModel == null ? 0L : this.lpbjTimerModel.total);
            }
        }));
    }

    private void startTimer() {
        this.view.showTimerPause(this.isPause);
        RxUtils.dispose((Disposable)this.timeDisposable);
        this.timeDisposable = Observable.interval((long)0L, (long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            if (this.view == null) {
                return;
            }
            if (this.remainSeconds < 0L) {
                RxUtils.dispose((Disposable)this.timeDisposable);
                this.view.showTimerEnd();
                if (this.isSetting) {
                    this.view.setTimer(this.lpbjTimerModel == null ? 0L : this.lpbjTimerModel.total);
                }
            }
            if (this.remainSeconds >= 0L) {
                long seconds = this.isCountDown ? this.remainSeconds : this.timeDuration - this.remainSeconds;
                this.view.setTimer(seconds);
                this.view.setButtonState(this.getTimerState(this.remainSeconds));
                this.view.showViewWarning(this.remainSeconds <= 60L && this.timeDuration > 60L);
                this.view.showCountDown(this.isCountDown);
                this.remainSeconds -= this.isPause ? 0L : 1L;
            }
        });
    }

    public void unSubscribe() {
        RxUtils.dispose((Disposable)this.disposables);
        RxUtils.dispose((Disposable)this.timeDisposable);
        this.lpbjTimerModel = null;
    }

    public void destroy() {
        this.view = null;
    }

    public void setTimerModel(LPBJTimerModel lpbjTimerModel) {
        this.lpbjTimerModel = lpbjTimerModel;
    }

    @Override
    public void setRouter(RouterViewModel routerViewModel2) {
        this.routerViewModel = routerViewModel2;
    }
}

