/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.dialog;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.lifecycle.Lifecycle;
import com.baijiayun.glide.Glide;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPUserModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPAwardUserInfo;
import com.baijiayun.livecore.models.LPInteractionAwardModel;
import com.baijiayun.livecore.models.launch.LPAwardConfig;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.RouterListener;
import com.baijiayun.liveuibase.widgets.popupwindow.BaseAutoArrangePopupWindow;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import java.util.HashMap;
import java.util.Map;

public class AwardPopupWindow
extends BaseAutoArrangePopupWindow {
    private IOnItemClickListener onItemClickListener;
    private HashMap<String, TextView> tvAwardCounts;
    private IUserModel userModel;
    private final CompositeDisposable compositeDisposable = new CompositeDisposable();
    private LPAwardUserInfo awardUserInfo;
    private long lastDismissTime = -1L;
    private RelativeLayout contentView;
    private boolean isGalleryLayout;
    private RouterListener routerListener;

    public AwardPopupWindow(Context context2, IOnItemClickListener onItemClickListener) {
        this(context2, (IUserModel)new LPUserModel(), onItemClickListener);
    }

    public AwardPopupWindow(Context context2, Lifecycle lifecycle, IOnItemClickListener onItemClickListener) {
        this(context2, null, lifecycle, onItemClickListener);
    }

    public AwardPopupWindow(Context context2, IUserModel userModel, IOnItemClickListener onItemClickListener) {
        super(context2);
        this.init(context2, userModel, onItemClickListener);
    }

    public AwardPopupWindow(Context context2, IUserModel userModel, Lifecycle lifecycle, IOnItemClickListener onItemClickListener) {
        super(context2, lifecycle);
        this.init(context2, userModel, onItemClickListener);
    }

    private void init(Context context2, IUserModel userModel, IOnItemClickListener onItemClickListener) {
        this.userModel = userModel;
        if (!(context2 instanceof RouterListener)) {
            throw new RuntimeException("context is not extends RouterListener");
        }
        this.routerListener = (RouterListener)context2;
        this.onItemClickListener = onItemClickListener;
        this.contentView = new RelativeLayout(context2);
        this.initCustomOffset(-8, -4);
        this.createView((View)this.contentView, false);
        this.setDirectionMode(1);
        this.setOnDismissListener(() -> {
            this.lastDismissTime = System.currentTimeMillis();
            this.contentView.removeAllViews();
            this.unSubscribe();
        });
    }

    public void setUserModel(IUserModel userModel) {
        this.userModel = userModel;
    }

    private void subscribe() {
        if (this.routerListener.getLiveRoom() == null) {
            return;
        }
        this.isGalleryLayout = this.routerListener.getLiveRoom().getCurrentRoomLayout() == LPConstants.RoomLayoutMode.GALLERY;
        this.updateAwardCount(this.routerListener.getLiveRoom().getToolBoxVM().getAwardValue());
        this.compositeDisposable.add(this.routerListener.getLiveRoom().getObservableOfRoomLayoutSwitch().observeOn(AndroidSchedulers.mainThread()).subscribe(mode -> this.dismiss()));
        this.compositeDisposable.add(this.routerListener.getLiveRoom().getToolBoxVM().getObservableOfAward().ofType(LPInteractionAwardModel.class).filter(lpInteractionAwardModel -> lpInteractionAwardModel.isFromCache || lpInteractionAwardModel.value.to.equals(this.userModel.getNumber()) || lpInteractionAwardModel.value.to.equals("-1")).observeOn(AndroidSchedulers.mainThread()).subscribe(awardModel -> {
            this.updateAwardCount((LPInteractionAwardModel)awardModel);
            if (awardModel.isFromCache) {
                for (Map.Entry<String, TextView> entry : this.tvAwardCounts.entrySet()) {
                    entry.getValue().setText((CharSequence)this.getCountFromModel(entry.getKey()));
                }
            } else {
                TextView textView = this.tvAwardCounts.get(awardModel.value.awardType);
                if (textView != null) {
                    textView.setText((CharSequence)this.getCountFromModel(awardModel.value.awardType));
                }
            }
        }));
    }

    private void unSubscribe() {
        this.compositeDisposable.clear();
    }

    private void generateContentView(RelativeLayout contentView) {
        if (this.routerListener.getLiveRoom() == null) {
            return;
        }
        contentView.setBackground(ThemeDataUtil.getCommonWindowBgWithBorder((Context)this.context));
        this.tvAwardCounts = new HashMap();
        int itemMargin = this.context.getResources().getDimensionPixelOffset(R.dimen.bjy_base_award_popup_window_item_margin);
        int iconSize = this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_award_popup_window_icon_size);
        int tvWidth = this.context.getResources().getDimensionPixelOffset(R.dimen.bjy_base_award_popup_window_award_count_tv_width);
        int textColor = ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_main_text_color);
        LPAwardConfig[] awardConfigs = this.routerListener.getLiveRoom().getToolBoxVM().getAwardConfigs();
        RelativeLayout preLineItem = null;
        for (LPAwardConfig awardConfig : awardConfigs) {
            if (awardConfig.isEnable != 1) continue;
            RelativeLayout item = new RelativeLayout(this.context);
            ImageView imageView = new ImageView(this.context);
            Glide.with((View)imageView).load(awardConfig.logoUrl).into(imageView);
            imageView.setId(View.generateViewId());
            item.addView((View)imageView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(iconSize, iconSize));
            TextView textView = new TextView(this.context);
            RelativeLayout.LayoutParams tvParams = new RelativeLayout.LayoutParams(tvWidth, iconSize);
            tvParams.addRule(15);
            tvParams.addRule(17, imageView.getId());
            textView.setTextSize(0, this.context.getResources().getDimension(R.dimen.bjy_base_award_popup_window_text_size));
            textView.setTextColor(textColor);
            textView.setText((CharSequence)this.getCountFromModel(awardConfig.key));
            textView.setLayoutParams((ViewGroup.LayoutParams)tvParams);
            textView.setGravity(16);
            item.addView((View)textView, (ViewGroup.LayoutParams)tvParams);
            this.tvAwardCounts.put(awardConfig.key, textView);
            RelativeLayout.LayoutParams itemParams = new RelativeLayout.LayoutParams(-2, -2);
            item.setId(View.generateViewId());
            if (preLineItem != null) {
                itemParams.addRule(3, preLineItem.getId());
            }
            preLineItem = item;
            itemParams.setMargins(itemMargin, itemMargin, itemMargin, itemMargin);
            item.setOnClickListener(v -> this.onItemClick(awardConfig.key));
            contentView.addView((View)item, (ViewGroup.LayoutParams)itemParams);
        }
    }

    private boolean canAward(IUserModel user) {
        if (this.routerListener.getLiveRoom() == null || !this.routerListener.getLiveRoom().isClassStarted()) {
            return false;
        }
        if (this.routerListener.getLiveRoom().getRoomInfo().roomType == LPConstants.LPRoomType.Multi && this.routerListener.getLiveRoom().getRoomInfo().newGroupLive == 1) {
            if (this.routerListener.getLiveRoom().isTeacherOrAssistant()) {
                return true;
            }
            if (this.routerListener.getLiveRoom().isGroupTeacherOrAssistant()) {
                if (user == null) {
                    return false;
                }
                return this.routerListener.getLiveRoom().getCurrentUser().getGroup() == user.getGroup();
            }
            return false;
        }
        return this.routerListener.getLiveRoom().isTeacherOrAssistant() || this.routerListener.getLiveRoom().isGroupTeacherOrAssistant();
    }

    private void onItemClick(String key) {
        if (this.routerListener.getLiveRoom() == null) {
            this.dismiss();
            return;
        }
        if (!this.canAward(this.userModel)) {
            this.dismiss();
            return;
        }
        if (this.onItemClickListener != null) {
            this.onItemClickListener.onItemClick(this.userModel, key);
        }
        this.dismiss();
    }

    private void updateAwardCount(LPInteractionAwardModel awardModel) {
        if (awardModel == null) {
            return;
        }
        this.awardUserInfo = (LPAwardUserInfo)awardModel.value.recordAwardAll.recordAward.get(this.userModel.getNumber());
    }

    private String getCountFromModel(String key) {
        if (this.awardUserInfo != null && this.awardUserInfo.typeCount != null) {
            Integer value = (Integer)this.awardUserInfo.typeCount.get(key);
            return String.valueOf(value == null ? 0 : value);
        }
        return "0";
    }

    @Override
    protected void initViewDataHashMap() {
    }

    @Override
    public void show(View anchor) {
        if (this.userModel == null) {
            return;
        }
        if (System.currentTimeMillis() - this.lastDismissTime > 200L) {
            this.generateContentView(this.contentView);
            this.subscribe();
            this.showWithViewOfDirection(anchor, this.isGalleryLayout ? 1 : -1);
        }
    }

    public void onDestroy() {
        this.compositeDisposable.clear();
        this.onItemClickListener = null;
        this.routerListener = null;
    }

    public static interface IOnItemClickListener {
        public void onItemClick(IUserModel var1, String var2);
    }
}

