/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.liveshow.shop;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.Switch;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPLiveProductInventoryModel;
import com.baijiayun.livecore.models.LPLiveProductModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.listeners.CallbackManager;
import com.baijiayun.liveuibase.liveshow.shop.ProductAdapter;
import com.baijiayun.liveuibase.liveshow.shop.ProductSettingFragment;
import com.baijiayun.liveuibase.liveshow.shop.SearchFragment;
import com.baijiayun.liveuibase.liveshow.shop.SortFragment;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import com.baijiayun.liveuibase.utils.LinearLayoutWrapManager;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import com.baijiayun.liveuibase.widgets.webview.ControllerWebView;
import com.google.android.material.tabs.TabLayout;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class ShopFragment
extends BaseDialogFragment {
    private LiveRoom liveRoom;
    private ProductAdapter productAdapter;
    private CompositeDisposable disposables;
    private TextView tvStuCount;
    private ControllerWebView mWebView;
    private long lastReqNextPageTime;
    private ImageView ivEmptyIcon;
    private TextView tvEmptyDesc;
    private Button btEmptyRefresh;
    private RecyclerView recyclerView;
    private int lastRecyclerPos = -1;
    private RouterViewModel routerViewModel;
    private FrameLayout flContainer;
    private TabLayout tabLayout;
    private ImageView ivSort;
    private TextView tvSort;
    private TextView tvSearch;
    private ImageView ivSearch;
    private TextView tvMore;
    private ImageView ivMore;
    private FrameLayout moreContainer;
    private Switch swShowShop;
    private TextView tvShowShop;
    private TabLayout.OnTabSelectedListener listener = new TabLayout.OnTabSelectedListener(){

        public void onTabSelected(TabLayout.Tab tab) {
            if (ShopFragment.this.tabLayout.getSelectedTabPosition() == 0) {
                ShopFragment.this.updateProductList(ShopFragment.this.generateTopExplainModelList(ShopFragment.this.liveRoom.getLiveShowVM().getProductsOnSale()));
            } else {
                ShopFragment.this.updateProductList(ShopFragment.this.liveRoom.getLiveShowVM().getProductsNotSale());
            }
        }

        public void onTabUnselected(TabLayout.Tab tab) {
        }

        public void onTabReselected(TabLayout.Tab tab) {
        }
    };

    protected int getLayoutId() {
        return R.layout.bjy_show_fragment_shop;
    }

    public void onAttach(@NonNull Context context2) {
        super.onAttach(context2);
        this.routerViewModel = (RouterViewModel)new ViewModelProvider((ViewModelStoreOwner)this.getActivity()).get(RouterViewModel.class);
    }

    @SuppressLint(value={"SetTextI18n", "ClickableViewAccessibility"})
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.contentBackgroundColor(0);
        this.flContainer = (FrameLayout)view.findViewById(R.id.fragment_replace_container);
        this.moreContainer = (FrameLayout)view.findViewById(R.id.fragment_more_container);
        view.findViewById(R.id.live_show_product_close_bg_top).setOnClickListener(v -> this.dismissAllowingStateLoss());
        view.findViewById(R.id.live_show_product_close_bg_bottom).setOnClickListener(v -> this.dismissAllowingStateLoss());
        view.findViewById(R.id.live_show_product_close_bg_left).setOnClickListener(v -> this.dismissAllowingStateLoss());
        view.findViewById(R.id.live_show_product_close_bg_right).setOnClickListener(v -> this.dismissAllowingStateLoss());
        this.productAdapter = new ProductAdapter(this.contextReference, this.liveRoom, false, new ProductAdapter.ProductCallback(){

            @Override
            public void onBackToShop(@NonNull Fragment fragment) {
                ShopFragment.this.getChildFragmentManager().beginTransaction().remove(fragment).commitAllowingStateLoss();
                ShopFragment.this.flContainer.setVisibility(8);
            }

            @Override
            public void onOpenBrowserToBuy(@Nullable LPLiveProductModel productModel) {
                if (CallbackManager.getInstance().getShopProductCallback() != null) {
                    CallbackManager.getInstance().getShopProductCallback().onOpenBrowserToBuy(ShopFragment.this.contextReference, productModel);
                } else if (productModel != null) {
                    ShopFragment.this.openProductDetail(productModel.getBuyUrl());
                }
            }

            @Override
            public void onOpenProductDetail(@Nullable LPLiveProductModel productModel) {
                if (CallbackManager.getInstance().getShopProductCallback() != null) {
                    CallbackManager.getInstance().getShopProductCallback().onOpenProductDetail(ShopFragment.this.contextReference, productModel);
                } else if (productModel != null) {
                    ShopFragment.this.openProductDetail(productModel.getBuyUrl());
                }
            }

            @Override
            public void onExplainProduct(@Nullable LPLiveProductModel productModel) {
                if (CallbackManager.getInstance().getShopProductCallback() != null) {
                    CallbackManager.getInstance().getShopProductCallback().onExplainProduct(ShopFragment.this.contextReference, productModel);
                }
            }

            @Override
            public void onProductShelfStateChanged(@Nullable LPLiveProductModel productModel, boolean onShelf) {
                if (CallbackManager.getInstance().getShopProductCallback() != null) {
                    CallbackManager.getInstance().getShopProductCallback().onProductShelfStateChanged(ShopFragment.this.contextReference, productModel, onShelf);
                }
            }
        }, this.routerViewModel.isSupportLiveShow());
        this.tvStuCount = (TextView)view.findViewById(R.id.tv_stu_count);
        this.tabLayout = (TabLayout)view.findViewById(R.id.tl_shop);
        this.mWebView = (ControllerWebView)view.findViewById(R.id.live_show_product_detail_webview);
        this.mWebView.setOnOptListener(() -> this.mWebView.setVisibility(8));
        this.ivEmptyIcon = (ImageView)view.findViewById(R.id.live_show_product_empty_icon);
        this.tvEmptyDesc = (TextView)view.findViewById(R.id.live_show_product_empty_desc);
        this.btEmptyRefresh = (Button)view.findViewById(R.id.live_show_product_empty_refresh);
        this.ivSort = (ImageView)view.findViewById(R.id.iv_sort);
        this.tvSort = (TextView)view.findViewById(R.id.tv_sort);
        this.ivSearch = (ImageView)view.findViewById(R.id.iv_search);
        this.tvSearch = (TextView)view.findViewById(R.id.tv_search);
        this.ivMore = (ImageView)view.findViewById(R.id.iv_more);
        this.tvMore = (TextView)view.findViewById(R.id.tv_more);
        this.swShowShop = (Switch)view.findViewById(R.id.show_shop_sw);
        this.tvShowShop = (TextView)view.findViewById(R.id.show_shop_tv);
        this.ivSearch.setOnClickListener(v -> {
            this.flContainer.setVisibility(0);
            this.getChildFragmentManager().beginTransaction().replace(this.flContainer.getId(), (Fragment)new SearchFragment(this.productAdapter.getCallback())).commitAllowingStateLoss();
        });
        this.tvSearch.setOnClickListener(v -> this.ivSearch.performClick());
        if (this.liveRoom.isTeacherOrAssistant()) {
            ProductSettingFragment productSettingFragment = new ProductSettingFragment();
            productSettingFragment.setCloseListener((Function1<? super Fragment, Unit>)((Function1)fragment -> {
                this.moreContainer.setVisibility(8);
                this.getChildFragmentManager().beginTransaction().remove(fragment).commitAllowingStateLoss();
                return null;
            }));
            this.ivMore.setOnClickListener(v -> {
                this.moreContainer.setVisibility(0);
                this.getChildFragmentManager().beginTransaction().setCustomAnimations(R.anim.live_dialog_send_msg_enter, R.anim.live_dialog_send_msg_exit).replace(this.moreContainer.getId(), (Fragment)productSettingFragment).commitAllowingStateLoss();
            });
            this.tvMore.setOnClickListener(v -> this.ivMore.performClick());
            this.tabLayout.setVisibility(0);
            this.setTvTeaCount();
            this.tabLayout.addOnTabSelectedListener(this.listener);
            this.tabLayout.selectTab(this.tabLayout.getTabAt(0));
            this.tvStuCount.setVisibility(8);
            this.ivSort.setVisibility(0);
            this.tvSort.setVisibility(0);
            this.ivSort.setOnClickListener(v -> {
                this.flContainer.setVisibility(0);
                this.getChildFragmentManager().beginTransaction().replace(this.flContainer.getId(), (Fragment)new SortFragment(this.productAdapter.getCallback())).commitAllowingStateLoss();
            });
            this.tvSort.setOnClickListener(v -> this.ivSort.performClick());
            this.swShowShop.setVisibility(0);
            this.swShowShop.setSaveEnabled(false);
            this.swShowShop.setShowText(false);
            this.swShowShop.setOnCheckedChangeListener((buttonView, isChecked) -> {
                if (isChecked) {
                    this.tvShowShop.setText((CharSequence)this.getString(R.string.bjy_base_show_show_shop));
                    this.tvShowShop.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_window_main_text_color));
                } else {
                    this.tvShowShop.setText((CharSequence)this.getString(R.string.bjy_base_show_hide_shop));
                    this.tvShowShop.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_window_assistant_text_color));
                }
                if (this.liveRoom.getLiveShowVM().isProductVisible() != isChecked) {
                    this.liveRoom.getLiveShowVM().setProductVisible(isChecked);
                }
            });
            this.swShowShop.setChecked(this.liveRoom.getLiveShowVM().isProductVisible());
        } else {
            this.tabLayout.setVisibility(8);
            this.tvStuCount.setVisibility(0);
            this.ivSort.setVisibility(8);
            this.tvSort.setVisibility(8);
            this.ivMore.setVisibility(8);
            this.tvMore.setVisibility(8);
            this.swShowShop.setVisibility(8);
            this.tvShowShop.setVisibility(8);
        }
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutWrapManager(this.getContext()));
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.productAdapter);
        this.recyclerView.setOnTouchListener((v, event) -> {
            if (!this.recyclerView.canScrollVertically(2) && System.currentTimeMillis() - this.lastReqNextPageTime > 1000L) {
                this.liveRoom.getLiveShowVM().requestNextPage();
                this.lastReqNextPageTime = System.currentTimeMillis();
            }
            return v.onTouchEvent(event);
        });
        if (this.lastRecyclerPos != -1) {
            this.recyclerView.scrollBy(0, this.lastRecyclerPos);
            this.lastRecyclerPos = -1;
        }
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){
            boolean isSlidingToLast;

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                int totalItemCount;
                int lastVisibleItem;
                super.onScrollStateChanged(recyclerView, newState);
                LinearLayoutManager manager = (LinearLayoutManager)recyclerView.getLayoutManager();
                if (manager != null && newState == 0 && (lastVisibleItem = manager.findLastCompletelyVisibleItemPosition()) == (totalItemCount = manager.getItemCount()) - 1 && this.isSlidingToLast && System.currentTimeMillis() - ShopFragment.this.lastReqNextPageTime > 1000L) {
                    ShopFragment.this.liveRoom.getLiveShowVM().requestNextPage();
                    ShopFragment.this.lastReqNextPageTime = System.currentTimeMillis();
                }
            }

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                this.isSlidingToLast = dy > 0;
                ShopFragment.this.lastRecyclerPos = dy;
            }
        });
        if (this.liveRoom.isTeacherOrAssistant()) {
            this.updateProductList(this.generateTopExplainModelList(this.liveRoom.getLiveShowVM().getProductsOnSale()));
            this.setTvTeaCount();
        } else {
            this.updateProductList(this.generateTopExplainModelList(this.liveRoom.getLiveShowVM().getSellProductsAll()));
            this.setTvStuCount(this.liveRoom.getLiveShowVM().getProductCount());
        }
        if (!TextUtils.isEmpty((CharSequence)this.liveRoom.getPartnerConfig().productCustomRename)) {
            this.tvEmptyDesc.setText((CharSequence)("\u6682\u65e0" + this.liveRoom.getPartnerConfig().productCustomRename));
        }
        this.subscribe();
        if (this.routerViewModel.isSupportLiveShow()) {
            View shopContainer = view.findViewById(R.id.live_show_shop_container);
            shopContainer.setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)view.getContext(), (int)R.attr.base_theme_window_bg_color)).cornerRadius(UtilsKt.getDp((int)8)).build());
            if (!this.routerViewModel.isLiveEE()) {
                ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)shopContainer.getLayoutParams();
                layoutParams.width = UtilsKt.getDp((int)400);
                layoutParams.height = DisplayUtils.getScreenHeightPixels((Context)this.getContext()) - DisplayUtils.getStatusBarHeight((Activity)((Activity)this.getContext()));
                layoutParams.matchConstraintPercentHeight = 1.0f;
                layoutParams.topToTop = 0;
                layoutParams.startToStart = 0;
                layoutParams.endToEnd = 0;
                shopContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                ConstraintLayout.LayoutParams layoutParams1 = (ConstraintLayout.LayoutParams)this.flContainer.getLayoutParams();
                layoutParams1.width = UtilsKt.getDp((int)400);
                layoutParams.height = DisplayUtils.getScreenHeightPixels((Context)this.getContext()) - DisplayUtils.getStatusBarHeight((Activity)((Activity)this.getContext()));
                layoutParams1.matchConstraintPercentHeight = 1.0f;
                layoutParams1.topToTop = 0;
                layoutParams1.startToStart = 0;
                layoutParams1.endToEnd = 0;
                this.flContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams1);
            }
            View ivClose = view.findViewById(R.id.iv_close);
            if (!BaseUtilsKt.isAdmin(this.routerViewModel.liveRoom)) {
                this.tvSearch.setVisibility(8);
                ivClose.setVisibility(0);
                ConstraintLayout.LayoutParams searchLayoutParams = (ConstraintLayout.LayoutParams)this.ivSearch.getLayoutParams();
                searchLayoutParams.topMargin = 0;
                searchLayoutParams.bottomMargin = 0;
                searchLayoutParams.endToStart = R.id.iv_close;
                searchLayoutParams.topToTop = R.id.iv_close;
                searchLayoutParams.bottomToBottom = R.id.iv_close;
                searchLayoutParams.setMarginEnd(UtilsKt.getDp((int)8));
            }
            ivClose.setOnClickListener(v -> this.dismissAllowingStateLoss());
        }
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.getWindow().setSoftInputMode(48);
        return dialog;
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    private void subscribe() {
        this.disposables = new CompositeDisposable();
        this.disposables.add(RxUtils.clicks((View)this.btEmptyRefresh).throttleFirst(1000L, TimeUnit.MILLISECONDS).subscribe(v -> this.liveRoom.getLiveShowVM().refreshProductList()));
        this.disposables.add(this.liveRoom.getLiveShowVM().getObservableOfSellProducts().observeOn(AndroidSchedulers.mainThread()).subscribe(productModelList -> {
            if (this.liveRoom.isTeacherOrAssistant()) {
                this.updateProductList(this.tabLayout.getSelectedTabPosition() == 0 ? this.generateTopExplainModelList(this.liveRoom.getLiveShowVM().getProductsOnSale()) : this.liveRoom.getLiveShowVM().getProductsNotSale());
                this.setTvTeaCount();
            } else {
                this.updateProductList(this.generateTopExplainModelList((List<LPLiveProductModel>)productModelList));
            }
        }));
        this.disposables.add(this.liveRoom.getLiveShowVM().getObservableOfProductCount().observeOn(AndroidSchedulers.mainThread()).subscribe(count -> {
            if (this.liveRoom.isTeacherOrAssistant()) {
                this.setTvTeaCount();
            } else {
                this.setTvStuCount((int)count);
            }
        }));
        this.disposables.add(this.liveRoom.getLiveShowVM().getObservableOfProductVisible().observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            if (this.liveRoom.isTeacherOrAssistant()) {
                this.swShowShop.setChecked(aBoolean.booleanValue());
            } else if (!aBoolean.booleanValue()) {
                this.dismissAllowingStateLoss();
            }
        }));
        this.disposables.add(this.liveRoom.getLiveShowVM().getObservableOfProductExplain().observeOn(AndroidSchedulers.mainThread()).subscribe(lpLiveProductModel -> {
            if (this.tabLayout.getSelectedTabPosition() == 0 || !this.liveRoom.isTeacherOrAssistant()) {
                this.updateProductList(this.generateTopExplainModelList(this.liveRoom.getLiveShowVM().getProductsOnSale()));
            }
        }));
        this.disposables.add(this.liveRoom.getLiveShowVM().getObservableOfProductPriceVisible().filter(aBoolean -> this.routerViewModel.liveRoom.getCurrentUser().getType() == LPConstants.LPUserType.Student).observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> this.productAdapter.notifyDataSetChanged()));
        this.disposables.add(this.liveRoom.getLiveShowVM().getObservableOfSellProductCountChange().observeOn(AndroidSchedulers.mainThread()).subscribe(lpLiveProductModel -> this.productAdapter.updateSoldCountChange((LPLiveProductModel)lpLiveProductModel, true)));
        this.disposables.add(this.liveRoom.getLiveShowVM().getObservableOfSellProductInventoryChange().observeOn(AndroidSchedulers.mainThread()).subscribe(lpLiveProductInventoryModel -> this.productAdapter.updateSoldInventoryChange((LPLiveProductInventoryModel)lpLiveProductInventoryModel, true)));
    }

    private void updateProductList(List<LPLiveProductModel> productModels) {
        this.productAdapter.setData(productModels);
        boolean isEmpty = productModels.size() == 0;
        this.ivEmptyIcon.setVisibility(isEmpty ? 0 : 8);
        this.tvEmptyDesc.setVisibility(isEmpty ? 0 : 8);
        this.btEmptyRefresh.setVisibility(isEmpty ? 0 : 8);
        this.recyclerView.setVisibility(isEmpty ? 8 : 0);
        this.recyclerView.post(() -> {
            if (!this.recyclerView.canScrollVertically(2)) {
                this.liveRoom.getLiveShowVM().requestNextPage();
            }
        });
    }

    protected void init(Bundle savedInstanceState, Bundle arguments) {
        this.hideTitleBar();
    }

    protected void setWindowParams(WindowManager.LayoutParams windowParams) {
        if (this.getContext() == null) {
            return;
        }
        windowParams.width = -1;
        if (this.routerViewModel.isSupportLiveShow()) {
            if (this.routerViewModel.isLiveEE()) {
                windowParams.height = (int)(0.8 * (double)DisplayUtils.getScreenHeightPixels((Context)this.getContext()));
                windowParams.gravity = 0x800055;
            } else {
                windowParams.height = -1;
                windowParams.gravity = 17;
            }
            windowParams.dimAmount = 0.3f;
        } else {
            windowParams.height = DisplayUtils.getScreenHeightPixels((Context)this.getContext()) - DisplayUtils.getStatusBarHeight((Activity)((Activity)this.getContext()));
            windowParams.gravity = 0x800055;
            windowParams.windowAnimations = R.style.BJYBaseSendMsgDialogAnim;
        }
    }

    public void setLiveRoom(LiveRoom liveRoom2) {
        this.liveRoom = liveRoom2;
    }

    private void setTvTeaCount() {
        TabLayout.Tab tab1 = this.tabLayout.getTabAt(0);
        TabLayout.Tab tab2 = this.tabLayout.getTabAt(1);
        if (tab1 != null && tab2 != null) {
            tab1.setText((CharSequence)this.getString(R.string.bjy_base_show_on_sale, new Object[]{this.liveRoom.getLiveShowVM().getProductsOnSale().size()}));
            tab2.setText((CharSequence)this.getString(R.string.bjy_base_show_no_shelf, new Object[]{this.liveRoom.getLiveShowVM().getProductsNotSale().size()}));
        }
    }

    private void setTvStuCount(int count) {
        if (this.tvStuCount != null) {
            if (TextUtils.isEmpty((CharSequence)this.liveRoom.getPartnerConfig().productCustomRename)) {
                this.tvStuCount.setText((CharSequence)new StringBuilder("\u5171").append(count).append("\u4ef6\u5546\u54c1"));
            } else {
                this.tvStuCount.setText((CharSequence)new StringBuilder("\u5171").append(count).append("\u4ef6").append(this.liveRoom.getPartnerConfig().productCustomRename));
            }
        }
    }

    private List<LPLiveProductModel> generateTopExplainModelList(List<LPLiveProductModel> onSellList) {
        if (TextUtils.isEmpty((CharSequence)this.liveRoom.getLiveShowVM().getExplainProduct().getId())) {
            return onSellList;
        }
        LPLiveProductModel explainModel = this.liveRoom.getLiveShowVM().getExplainProduct();
        explainModel.setOnShelf(true);
        ArrayList<LPLiveProductModel> topList = new ArrayList<LPLiveProductModel>();
        topList.add(explainModel);
        for (LPLiveProductModel lp : onSellList) {
            if (Objects.equals(lp.getId(), explainModel.getId())) continue;
            topList.add(lp);
        }
        return topList;
    }

    private void openProductDetail(String url) {
        this.mWebView.resetUrl(url);
        this.mWebView.setVisibility(0);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.tabLayout.removeOnTabSelectedListener(this.listener);
        this.routerViewModel.getActionCloseShopFragment().setValue((Object)true);
        RxUtils.dispose((Disposable)this.disposables);
    }
}

