/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.chat;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.style.ImageSpan;
import androidx.annotation.NonNull;
import java.lang.ref.WeakReference;

public class CenterImageSpan
extends ImageSpan {
    private WeakReference<Drawable> mDrawableRef;

    public CenterImageSpan(@NonNull Drawable drawable2, int verticalAlignment) {
        super(drawable2, verticalAlignment);
    }

    public int getSize(Paint paint2, CharSequence text, int start2, int end, Paint.FontMetricsInt fontMetricsInt) {
        Drawable drawable2 = this.getDrawable();
        Rect rect = drawable2.getBounds();
        if (fontMetricsInt != null) {
            Paint.FontMetricsInt fmPaint = paint2.getFontMetricsInt();
            int fontHeight = fmPaint.descent - fmPaint.ascent;
            int drHeight = rect.bottom - rect.top;
            int centerY = fmPaint.ascent + fontHeight / 2;
            fontMetricsInt.top = fontMetricsInt.ascent = centerY - drHeight / 2;
            fontMetricsInt.descent = fontMetricsInt.bottom = centerY + drHeight / 2;
        }
        return rect.right;
    }

    public void draw(Canvas canvas, CharSequence text, int start2, int end, float x, int top, int y, int bottom, Paint paint2) {
        Drawable drawable2 = this.getCachedDrawable();
        canvas.save();
        Paint.FontMetricsInt fmPaint = paint2.getFontMetricsInt();
        int fontHeight = fmPaint.descent - fmPaint.ascent;
        int centerY = y + fmPaint.descent - fontHeight / 2;
        int transY = centerY - (drawable2.getBounds().bottom - drawable2.getBounds().top) / 2;
        canvas.translate(x, (float)transY);
        drawable2.draw(canvas);
        canvas.restore();
    }

    private Drawable getCachedDrawable() {
        WeakReference<Drawable> wr = this.mDrawableRef;
        Drawable d = null;
        if (wr != null) {
            d = (Drawable)wr.get();
        }
        if (d == null) {
            d = this.getDrawable();
            this.mDrawableRef = new WeakReference<Drawable>(d);
        }
        return d;
    }
}

