/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.chat.privatechat;

import android.content.Context;
import android.os.Bundle;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.livebase.base.BaseFragment;
import com.baijiayun.livebase.base.BasePresenter;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.LiveRoomBaseActivity;
import com.baijiayun.liveuibase.chat.privatechat.ChatUserAdapter;
import com.baijiayun.liveuibase.chat.privatechat.ChatUsersContract;
import com.baijiayun.liveuibase.chat.privatechat.ChatUsersPresenter;
import com.baijiayun.liveuibase.utils.LinearLayoutWrapManager;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;

public class ChatUsersDialogFragment
extends BaseFragment
implements ChatUsersContract.View {
    private RelativeLayout privateChatLabel;
    private RecyclerView recyclerView;
    private ChatUserAdapter adapter;
    private ChatUsersContract.Presenter presenter;
    private int visibleThreshold = 5;
    private int lastVisibleItem;
    private int totalItemCount;
    private IUserModel privateChatToUser;

    public int getLayoutId() {
        return R.layout.bjy_dialog_chat_users;
    }

    public void setPresenter(ChatUsersContract.Presenter presenter2) {
        super.setBasePresenter((BasePresenter)presenter2);
    }

    public void initPrivateChatLabel(IUserModel iUserModel) {
        this.privateChatToUser = iUserModel;
    }

    @Override
    public void notifyDataChanged() {
        this.adapter.notifyDataSetChanged();
    }

    protected void init(Bundle savedInstanceState) {
        super.init(savedInstanceState);
        this.presenter = new ChatUsersPresenter(this);
        RouterViewModel roomRouterListener = ((LiveRoomBaseActivity)this.getActivity()).getRouterListener();
        this.presenter.setRouter(roomRouterListener);
        this.presenter.loadMore();
        this.setPresenter(this.presenter);
        this.recyclerView = (RecyclerView)this.$.id(R.id.dialog_chat_user_recycler_view).view();
        this.privateChatLabel = (RelativeLayout)this.$.id(R.id.dialog_private_chat_container).view();
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutWrapManager((Context)this.getActivity()));
        this.adapter = new ChatUserAdapter(this.getContext(), this.presenter);
        this.adapter.setItemClickListener((position, user, view) -> {
            this.presenter.setPrivateChatUser(user);
            this.presenter.chooseOneToChat(UtilsKt.getEncodePhoneNumber((String)user.getName()), true);
        });
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        if (this.privateChatToUser != null) {
            this.showPrivateChatLabel(UtilsKt.getEncodePhoneNumber((String)this.privateChatToUser.getName()));
        }
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                LinearLayoutManager linearLayoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
                ChatUsersDialogFragment.this.totalItemCount = linearLayoutManager.getItemCount();
                ChatUsersDialogFragment.this.lastVisibleItem = linearLayoutManager.findLastVisibleItemPosition();
                if (!ChatUsersDialogFragment.this.presenter.isLoading() && ChatUsersDialogFragment.this.totalItemCount <= ChatUsersDialogFragment.this.lastVisibleItem + ChatUsersDialogFragment.this.visibleThreshold) {
                    ChatUsersDialogFragment.this.presenter.loadMore();
                }
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
            }
        });
    }

    @Override
    public void privateChatUserChanged(boolean isEmpty) {
        if (this.recyclerView == null) {
            return;
        }
        if (isEmpty) {
            this.recyclerView.setVisibility(8);
            LinearLayout noPrivateChatUser = (LinearLayout)this.$.id(R.id.no_online_chat).view();
            noPrivateChatUser.setVisibility(0);
        } else {
            if (this.recyclerView.getVisibility() == 0) {
                return;
            }
            LinearLayout noPrivateChatUser = (LinearLayout)this.$.id(R.id.no_online_chat).view();
            noPrivateChatUser.setVisibility(8);
            this.recyclerView.setVisibility(0);
        }
    }

    @Override
    public void showPrivateChatLabel(String chatName) {
        if (chatName == null) {
            this.privateChatLabel.setVisibility(8);
        } else {
            this.privateChatLabel.setVisibility(0);
            ((TextView)this.$.id(R.id.dialog_private_chat_status_content).view()).setText((CharSequence)this.getString(R.string.live_room_private_chat_with_name, new Object[]{chatName}));
            this.$.id(R.id.end_private_chat_btn).view().setOnClickListener(view -> {
                this.privateChatLabel.setVisibility(8);
                this.presenter.setPrivateChatUser(null);
                this.adapter.notifyDataSetChanged();
                this.showToast(this.getString(R.string.live_room_private_chat_cancel));
            });
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.presenter = null;
        if (this.recyclerView != null) {
            this.recyclerView.setAdapter(null);
        }
        this.recyclerView = null;
    }
}

